/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.server.core.internal;

import java.io.BufferedInputStream;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.eclipse.jst.server.core.internal.IMemento;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

public final class XMLMemento
implements IMemento {
    private Document factory;
    private Element element;

    private XMLMemento(Document doc, Element el) {
        this.factory = doc;
        this.element = el;
    }

    @Override
    public IMemento createChild(String type) {
        Element child = this.factory.createElement(type);
        this.element.appendChild(child);
        return new XMLMemento(this.factory, child);
    }

    /*
     * Loose catch block
     */
    private static XMLMemento createReadRoot(InputStream in) {
        block13: {
            block12: {
                Document document = null;
                DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
                DocumentBuilder parser = factory.newDocumentBuilder();
                document = parser.parse(new InputSource(in));
                Node node = document.getFirstChild();
                if (!(node instanceof Element)) break block12;
                XMLMemento xMLMemento = new XMLMemento(document, (Element)node);
                try {
                    in.close();
                }
                catch (Exception exception) {}
                return xMLMemento;
                catch (Exception exception) {
                    try {}
                    catch (Throwable throwable) {
                        try {
                            in.close();
                        }
                        catch (Exception exception2) {}
                        throw throwable;
                    }
                    try {
                        in.close();
                    }
                    catch (Exception exception3) {}
                    break block13;
                }
            }
            try {
                in.close();
            }
            catch (Exception exception) {}
        }
        return null;
    }

    public static XMLMemento createWriteRoot(String type) {
        try {
            Document document = DocumentBuilderFactory.newInstance().newDocumentBuilder().newDocument();
            Element element = document.createElement(type);
            document.appendChild(element);
            return new XMLMemento(document, element);
        }
        catch (ParserConfigurationException e) {
            throw new Error(e);
        }
    }

    @Override
    public IMemento getChild(String type) {
        NodeList nodes = this.element.getChildNodes();
        int size = nodes.getLength();
        if (size == 0) {
            return null;
        }
        int nX = 0;
        while (nX < size) {
            Element element2;
            Node node = nodes.item(nX);
            if (node instanceof Element && (element2 = (Element)node).getNodeName().equals(type)) {
                return new XMLMemento(this.factory, element2);
            }
            ++nX;
        }
        return null;
    }

    @Override
    public IMemento[] getChildren(String type) {
        NodeList nodes = this.element.getChildNodes();
        int size = nodes.getLength();
        if (size == 0) {
            return new IMemento[0];
        }
        ArrayList<Element> list = new ArrayList<Element>(size);
        int nX = 0;
        while (nX < size) {
            Element element2;
            Node node = nodes.item(nX);
            if (node instanceof Element && (element2 = (Element)node).getNodeName().equals(type)) {
                list.add(element2);
            }
            ++nX;
        }
        size = list.size();
        IMemento[] results = new IMemento[size];
        int x = 0;
        while (x < size) {
            results[x] = new XMLMemento(this.factory, (Element)list.get(x));
            ++x;
        }
        return results;
    }

    @Override
    public String getString(String key) {
        Attr attr = this.element.getAttributeNode(key);
        if (attr == null) {
            return null;
        }
        return attr.getValue();
    }

    public static IMemento loadMemento(String filename) throws IOException {
        XMLMemento xMLMemento;
        InputStream in = null;
        try {
            in = new BufferedInputStream(new FileInputStream(filename));
            xMLMemento = XMLMemento.createReadRoot(in);
        }
        catch (Throwable throwable) {
            try {
                if (in != null) {
                    in.close();
                }
            }
            catch (Exception exception) {}
            throw throwable;
        }
        try {
            if (in != null) {
                in.close();
            }
        }
        catch (Exception exception) {}
        return xMLMemento;
    }

    @Override
    public void putString(String key, String value) {
        if (value == null) {
            return;
        }
        this.element.setAttribute(key, value);
    }

    private void save(OutputStream os) throws IOException {
        StreamResult result = new StreamResult(os);
        DOMSource source = new DOMSource(this.factory);
        try {
            Transformer transformer = TransformerFactory.newInstance().newTransformer();
            transformer.setOutputProperty("indent", "yes");
            transformer.setOutputProperty("method", "xml");
            transformer.setOutputProperty("encoding", "UTF-8");
            transformer.setOutputProperty("{http://xml.apache.org/xalan}indent-amount", "2");
            transformer.transform(source, result);
        }
        catch (Exception e) {
            throw (IOException)new IOException().initCause(e);
        }
    }

    public void saveToFile(String filename) throws IOException {
        FileOutputStream w = null;
        try {
            try {
                w = new FileOutputStream(filename);
                this.save(w);
            }
            catch (IOException e) {
                throw e;
            }
            catch (Exception e) {
                throw new IOException(e.getLocalizedMessage());
            }
        }
        catch (Throwable throwable) {
            if (w != null) {
                try {
                    w.close();
                }
                catch (Exception exception) {}
            }
            throw throwable;
        }
        if (w != null) {
            try {
                w.close();
            }
            catch (Exception exception) {}
        }
    }
}

