/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.ui.internal.wizards.gen;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import org.eclipse.core.resources.WorkspaceJob;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;
import org.eclipse.jface.resource.ResourceManager;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.jpt.common.ui.JptCommonUiImages;
import org.eclipse.jpt.common.ui.internal.WorkbenchTools;
import org.eclipse.jpt.common.ui.internal.swt.widgets.DisplayTools;
import org.eclipse.jpt.common.ui.internal.swt.widgets.TableTools;
import org.eclipse.jpt.common.ui.internal.widgets.TableLayoutComposite;
import org.eclipse.jpt.common.utility.internal.StringMatcher;
import org.eclipse.jpt.common.utility.internal.collection.CollectionTools;
import org.eclipse.jpt.jpa.core.JpaProject;
import org.eclipse.jpt.jpa.db.ConnectionProfile;
import org.eclipse.jpt.jpa.db.Schema;
import org.eclipse.jpt.jpa.gen.internal.ORMGenCustomizer;
import org.eclipse.jpt.jpa.ui.JptJpaUiMessages;
import org.eclipse.jpt.jpa.ui.internal.JpaHelpContextIds;
import org.eclipse.jpt.jpa.ui.internal.wizards.gen.DatabaseGroup;
import org.eclipse.jpt.jpa.ui.internal.wizards.gen.GenerateEntitiesFromSchemaWizard;
import org.eclipse.jpt.jpa.ui.internal.wizards.gen.PromptJPAProjectWizardPage;
import org.eclipse.jpt.jpa.ui.wizards.gen.JptJpaUiWizardsEntityGenMessages;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;

public class TablesSelectorWizardPage
extends WizardPage {
    private static final int TABLE_COLUMN_INDEX = 0;
    private JpaProject jpaProject;
    private Schema schema;
    private ORMGenCustomizer customizer;
    private boolean updatePersistenceXml = true;
    private boolean isDynamic;
    private DatabaseGroup databaseGroup;
    private CheckboxTableViewer tableTable;
    private Button updatePersistenceXmlCheckBox;
    private Button refreshTablesButton;
    private Button selectAllButton;
    private Button deselectAllButton;
    private Text searchText;
    private TableFilter filter;
    private WorkspaceJob fetchTablesJob;
    protected final ResourceManager resourceManager;

    public TablesSelectorWizardPage(JpaProject jpaProject, ResourceManager resourceManager, boolean isDynamic) {
        super("TablesSelectorWizardPage");
        this.jpaProject = jpaProject;
        this.resourceManager = resourceManager;
        this.schema = jpaProject.getDefaultDbSchema();
        this.isDynamic = isDynamic;
        this.setTitle(JptJpaUiWizardsEntityGenMessages.GENERATE_ENTITIES_WIZARD_TABLE_SELECT_PAGE_SELECT_TABLE);
        this.setMessage(JptJpaUiWizardsEntityGenMessages.GENERATE_ENTITIES_WIZARD_TABLE_SELECT_PAGE_CHOOSE_ENTITY_TABLE);
    }

    public void createControl(Composite parent) {
        this.initializeDialogUnits((Control)parent);
        this.setPageComplete(true);
        this.setControl((Control)this.buildTopLevelControl(parent));
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
        this.doStatusUpdate();
        this.updateButtons();
    }

    public void dispose() {
        if (this.databaseGroup != null) {
            this.databaseGroup.dispose();
        }
        super.dispose();
    }

    public final void performHelp() {
        WorkbenchTools.displayHelp((String)this.getWizard().getHelpContextID());
    }

    public GenerateEntitiesFromSchemaWizard getWizard() {
        return (GenerateEntitiesFromSchemaWizard)super.getWizard();
    }

    public IWizardPage getPreviousPage() {
        IWizardPage previousPage = super.getPreviousPage();
        if (previousPage instanceof PromptJPAProjectWizardPage) {
            return previousPage.getPreviousPage();
        }
        return previousPage;
    }

    private Composite buildTopLevelControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        int nColumns = 3;
        GridLayout layout = new GridLayout();
        layout.numColumns = nColumns;
        composite.setLayout((Layout)layout);
        WorkbenchTools.setHelp((Control)composite, (String)JpaHelpContextIds.GENERATE_ENTITIES_WIZARD_SELECT_TABLES);
        this.databaseGroup = this.createDatabaseGroup(composite, 400);
        this.createTablesSelectionControl(composite, nColumns);
        if (!this.isDynamic) {
            this.updatePersistenceXmlCheckBox = this.buildUpdatePersistenceXmlCheckBox(composite);
            this.fillColumns((Control)this.updatePersistenceXmlCheckBox, 3);
        }
        new Label(composite, 0);
        this.buildRestoreDefaultsButton(composite);
        this.updateSelectionState(this.databaseGroup.getSelectedSchema());
        WorkbenchTools.setHelp((Control)this.tableTable.getControl(), (String)JpaHelpContextIds.DIALOG_GENERATE_ENTITIES_TABLES);
        return composite;
    }

    private void createTablesSelectionControl(Composite parent, int columns) {
        GridData gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.verticalAlignment = 1;
        Label tableLabel = new Label(parent, 0);
        tableLabel.setLayoutData((Object)gridData);
        tableLabel.setText(JptJpaUiWizardsEntityGenMessages.GENERATE_ENTITIES_WIZARD_TABLE_SELECT_PAGE_TABLES);
        this.searchText = this.buildSearchText(parent);
        new Label(parent, 0);
        new Label(parent, 0);
        TableLayoutComposite layout = new TableLayoutComposite(parent, 0);
        this.addColumnLayoutData(layout);
        this.filter = new TableFilter();
        this.tableTable = this.buildCheckboxTableViewer(this.buildTable((Composite)layout));
        this.tableTable.addFilter((ViewerFilter)this.filter);
        this.createButtonComposite(parent);
        this.initTablesSelectionControl(this.possibleTables());
    }

    private void createButtonComposite(Composite parent) {
        Composite buttonComposite = new Composite(parent, 0);
        GridLayout buttonLayout = new GridLayout(1, false);
        buttonLayout.marginHeight = 0;
        buttonLayout.marginWidth = 0;
        buttonComposite.setLayout((Layout)buttonLayout);
        GridData data = new GridData();
        data.horizontalAlignment = 4;
        data.verticalAlignment = 1;
        buttonComposite.setLayoutData((Object)data);
        this.selectAllButton = this.buildSelectAllButton(buttonComposite);
        this.deselectAllButton = this.buildDeselectAllButton(buttonComposite);
        this.refreshTablesButton = this.buildRefreshTablesButton(buttonComposite);
    }

    private DatabaseGroup createDatabaseGroup(Composite parent, int widthHint) {
        DatabaseGroup dbGroup = new DatabaseGroup(this.getContainer(), this.jpaProject, parent, this.resourceManager, widthHint);
        class DatabasePageListener
        implements DatabaseGroup.Listener {
            DatabasePageListener() {
            }

            @Override
            public void selectedConnectionProfileChanged(ConnectionProfile connectionProfile) {
                TablesSelectorWizardPage.this.jpaProject.getDataSource().setConnectionProfileName(connectionProfile.getName());
            }

            @Override
            public void selectedSchemaChanged(Schema schema) {
                if (schema == null) {
                    TablesSelectorWizardPage.this.updateTablesListViewer(Collections.EMPTY_LIST);
                } else {
                    TablesSelectorWizardPage.this.jpaProject.setUserOverrideDefaultSchema(schema.getIdentifier());
                    TablesSelectorWizardPage.this.setSchema(schema);
                    TablesSelectorWizardPage.this.updateButtons();
                    TablesSelectorWizardPage.this.updateSelectionState(schema);
                }
                TablesSelectorWizardPage.this.doStatusUpdate();
            }
        }
        dbGroup.addListener(new DatabasePageListener());
        dbGroup.init();
        return dbGroup;
    }

    private Schema getSchema() {
        return this.schema;
    }

    private void setSchema(Schema s) {
        this.schema = s;
    }

    private boolean connectionIsActive() {
        return this.databaseGroup.connectionIsActive();
    }

    private Collection<org.eclipse.jpt.jpa.db.Table> getTables(Schema schema) {
        if (this.fetchTablesJobIsRunning()) {
            return Collections.emptyList();
        }
        return CollectionTools.hashBag((Iterable)schema.getTables());
    }

    private Collection<org.eclipse.jpt.jpa.db.Table> possibleTables() {
        Schema schema = this.getSchema();
        if (schema != null && schema.getName() != null) {
            return this.getTables(schema);
        }
        return Collections.emptyList();
    }

    private void updateButtons() {
        if (this.selectAllButton != null) {
            this.selectAllButton.setEnabled(this.connectionIsActive());
        }
        if (this.refreshTablesButton != null) {
            this.refreshTablesButton.setEnabled(this.connectionIsActive());
        }
        if (this.deselectAllButton != null) {
            this.deselectAllButton.setEnabled(this.connectionIsActive());
        }
    }

    private boolean updatePersistenceXml() {
        return this.updatePersistenceXml;
    }

    private void setShouldUpdatePersistenceXml(boolean updatePersistenceXml) {
        this.updatePersistenceXml = updatePersistenceXml;
        this.doStatusUpdate();
    }

    private void restoreUpdatePersistenceXmlDefault() {
        this.updatePersistenceXmlCheckBox.setSelection(true);
        this.setShouldUpdatePersistenceXml(true);
    }

    private void selectAllTables() {
        this.tableTable.setAllChecked(true);
        this.doStatusUpdate();
    }

    private void deselectAllTables() {
        this.tableTable.setAllChecked(false);
        this.doStatusUpdate();
    }

    private void refreshTables() {
        this.schema.refresh();
        this.updateSelectionState(this.databaseGroup.getSelectedSchema());
    }

    private void initTablesSelectionControl(Collection<org.eclipse.jpt.jpa.db.Table> possibleTables) {
        this.tableTable.setInput(possibleTables);
    }

    private Table buildTable(Composite parent) {
        Table table = new Table(parent, 68388);
        TableColumn tableNameColumn = new TableColumn(table, 0, 0);
        tableNameColumn.setText(JptJpaUiWizardsEntityGenMessages.GENERATE_ENTITIES_WIZARD_TABLE_SELECT_PAGE_TABLE_COLUMN);
        tableNameColumn.setResizable(true);
        table.addKeyListener((KeyListener)this.buildTableKeyListener());
        GridData gridData = new GridData(1808);
        gridData.heightHint = TableTools.calculateHeightHint((Table)table, (int)20);
        gridData.widthHint = 250;
        gridData.grabExcessHorizontalSpace = true;
        gridData.grabExcessVerticalSpace = true;
        Color backgroundColor = new Color((Device)parent.getDisplay(), 255, 0, 0);
        parent.setLayoutData((Object)gridData);
        parent.setBackground(backgroundColor);
        backgroundColor.dispose();
        return table;
    }

    private CheckboxTableViewer buildCheckboxTableViewer(Table parent) {
        CheckboxTableViewer tableViewer = new CheckboxTableViewer(parent);
        tableViewer.setUseHashlookup(true);
        tableViewer.setLabelProvider(this.buildTableTableLabelProvider());
        tableViewer.setContentProvider(this.buildTableTableContentProvider());
        tableViewer.setSorter(this.buildTableViewerSorter());
        tableViewer.addPostSelectionChangedListener(this.buildTableSelectionChangedListener());
        return tableViewer;
    }

    private ViewerSorter buildTableViewerSorter() {
        return new ViewerSorter(){

            public int compare(Viewer viewer, Object e1, Object e2) {
                return ((org.eclipse.jpt.jpa.db.Table)e1).getName().compareTo(((org.eclipse.jpt.jpa.db.Table)e2).getName());
            }
        };
    }

    private Button buildUpdatePersistenceXmlCheckBox(Composite parent) {
        Button checkBox = new Button(parent, 32);
        checkBox.setText(JptJpaUiWizardsEntityGenMessages.GENERATE_ENTITIES_WIZARD_TABLE_SELECT_PAGE_UPDATE_PERSISTENCE_XML);
        checkBox.setSelection(this.updatePersistenceXml());
        checkBox.addSelectionListener(this.buildUpdatePersistenceXmlSelectionListener());
        return checkBox;
    }

    private Button buildRestoreDefaultsButton(Composite parent) {
        Button button = new Button(parent, 8);
        GridData gridData = new GridData();
        gridData.horizontalAlignment = 0x1000008;
        button.setLayoutData((Object)gridData);
        button.setText(JptJpaUiWizardsEntityGenMessages.GENERATE_ENTITIES_WIZARD_TABLE_SELECT_PAGE_RESTORE_DEFAULTS);
        button.addSelectionListener(this.buildRestoreDefaultsSelectionListener());
        return button;
    }

    private Button buildSelectAllButton(Composite parent) {
        Button button = this.buildSelectionButton(parent, JptJpaUiMessages.GENERAL_SELECT_ALL, this.resourceManager.createImage(JptCommonUiImages.SELECT_ALL_BUTTON));
        button.addSelectionListener(this.buildSelectAllSelectionListener());
        return button;
    }

    private Button buildDeselectAllButton(Composite parent) {
        Button button = this.buildSelectionButton(parent, JptJpaUiMessages.GENERAL_DESELECT_ALL, this.resourceManager.createImage(JptCommonUiImages.DESELECT_ALL_BUTTON));
        button.addSelectionListener(this.buildDeselectAllSelectionListener());
        return button;
    }

    private Button buildRefreshTablesButton(Composite parent) {
        Button button = this.buildSelectionButton(parent, JptJpaUiMessages.GENERAL_REFRESH, this.resourceManager.createImage(JptCommonUiImages.REFRESH_BUTTON));
        button.addSelectionListener(this.buildRefreshTablesSelectionListener());
        return button;
    }

    private Button buildSelectionButton(Composite parent, String toolTipText, Image buttonImage) {
        Button button = new Button(parent, 8);
        button.setToolTipText(toolTipText);
        button.setImage(buttonImage);
        GridData gridData = new GridData();
        gridData.horizontalAlignment = 4;
        button.setLayoutData((Object)gridData);
        return button;
    }

    private void addColumnLayoutData(TableLayoutComposite layout) {
        layout.addColumnData((ColumnLayoutData)new ColumnWeightData(50, true));
    }

    private void fillColumns(Control c, int columns) {
        GridData layoutData = new GridData();
        layoutData.horizontalSpan = columns;
        layoutData.verticalAlignment = 4;
        layoutData.horizontalAlignment = 4;
        layoutData.grabExcessHorizontalSpace = true;
        layoutData.grabExcessVerticalSpace = false;
        c.setLayoutData((Object)layoutData);
    }

    private IBaseLabelProvider buildTableTableLabelProvider() {
        return new TableTableLabelProvider();
    }

    private IContentProvider buildTableTableContentProvider() {
        return new TableTableContentProvider();
    }

    private Text buildSearchText(Composite parent) {
        GridData gridData = new GridData(768);
        Text text = new Text(parent, 2944);
        text.setMessage(JptJpaUiWizardsEntityGenMessages.GENERATE_ENTITIES_WIZARD_TABLE_SELECT_PAGE_TABLE_SEARCH);
        text.setLayoutData((Object)gridData);
        text.addSelectionListener(this.buildClearSearchTextSelectionListener());
        text.addKeyListener(this.buildSearchTextKeyListener());
        return text;
    }

    private void handleTablesListSelectionChanged(SelectionChangedEvent event) {
        this.doStatusUpdate();
    }

    private KeyAdapter buildTableKeyListener() {
        return new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                if (e.keyCode == 0x100000B && e.stateMask == 0) {
                    TablesSelectorWizardPage.this.editEntityNameIfPossible();
                    e.doit = false;
                }
            }
        };
    }

    private ISelectionChangedListener buildTableSelectionChangedListener() {
        return new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                TablesSelectorWizardPage.this.handleTablesListSelectionChanged(event);
            }
        };
    }

    private SelectionListener buildUpdatePersistenceXmlSelectionListener() {
        return new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                TablesSelectorWizardPage.this.setShouldUpdatePersistenceXml(TablesSelectorWizardPage.this.updatePersistenceXmlCheckBox.getSelection());
            }
        };
    }

    private SelectionListener buildRestoreDefaultsSelectionListener() {
        return new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                if (TablesSelectorWizardPage.this.customizer != null && TablesSelectorWizardPage.this.customizer.getFile() != null) {
                    if (TablesSelectorWizardPage.this.customizer.getFile().exists()) {
                        TablesSelectorWizardPage.this.customizer.getFile().delete();
                    }
                    TablesSelectorWizardPage.this.deselectAllTables();
                    TablesSelectorWizardPage.this.restoreUpdatePersistenceXmlDefault();
                }
            }
        };
    }

    private SelectionListener buildSelectAllSelectionListener() {
        return new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                TablesSelectorWizardPage.this.selectAllTables();
            }
        };
    }

    private SelectionListener buildDeselectAllSelectionListener() {
        return new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                TablesSelectorWizardPage.this.deselectAllTables();
            }
        };
    }

    private SelectionListener buildRefreshTablesSelectionListener() {
        return new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                TablesSelectorWizardPage.this.refreshTables();
            }
        };
    }

    private SelectionListener buildClearSearchTextSelectionListener() {
        return new SelectionAdapter(){

            public void widgetDefaultSelected(SelectionEvent e) {
                TablesSelectorWizardPage.this.filter.setPattern("");
                TablesSelectorWizardPage.this.tableTable.refresh();
            }
        };
    }

    private KeyListener buildSearchTextKeyListener() {
        return new KeyAdapter(){

            public void keyReleased(KeyEvent event) {
                TablesSelectorWizardPage.this.filter.setPattern(TablesSelectorWizardPage.this.searchText.getText());
                TablesSelectorWizardPage.this.tableTable.refresh();
            }
        };
    }

    public boolean hasTablesSelected() {
        return this.tableTable != null ? this.getSelectedTables().size() > 0 : false;
    }

    private void editEntityNameIfPossible() {
        Object[] selected = ((IStructuredSelection)this.tableTable.getSelection()).toArray();
        if (selected.length != 1) {
            return;
        }
    }

    private Collection<org.eclipse.jpt.jpa.db.Table> getSelectedTables() {
        ArrayList<org.eclipse.jpt.jpa.db.Table> selectedTables = new ArrayList<org.eclipse.jpt.jpa.db.Table>();
        Object[] objectArray = this.tableTable.getCheckedElements();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object selectedTable = objectArray[n2];
            selectedTables.add((org.eclipse.jpt.jpa.db.Table)selectedTable);
            ++n2;
        }
        return selectedTables;
    }

    private void updateTablesListViewer(Collection<org.eclipse.jpt.jpa.db.Table> possibleTables) {
        if (this.tableTable != null) {
            this.initTablesSelectionControl(possibleTables);
        }
    }

    private boolean tableInitialized() {
        return this.tableTable != null && this.tableTable.getTable().getItemCount() > 0;
    }

    private boolean fetchTablesJobIsRunning() {
        return this.fetchTablesJob != null;
    }

    private WorkspaceJob buildFetchTablesJob(final Schema schema) {
        final ArrayList tables = new ArrayList();
        WorkspaceJob workspaceJob = new WorkspaceJob(JptJpaUiWizardsEntityGenMessages.GENERATE_ENTITIES_WIZARD_TABLE_SELECT_PAGE_GET_TABLES_JOB_NAME){

            public IStatus runInWorkspace(IProgressMonitor monitor) {
                if (monitor.isCanceled()) {
                    return Status.CANCEL_STATUS;
                }
                SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (String)JptJpaUiWizardsEntityGenMessages.GENERATE_ENTITIES_WIZARD_TABLE_SELECT_PAGE_GET_TABLES_TASK_NAME, (int)75);
                try {
                    try {
                        subMonitor.beginTask(schema.getContainer().getName(), 100);
                        subMonitor.subTask(NLS.bind((String)JptJpaUiWizardsEntityGenMessages.GENERATE_ENTITIES_WIZARD_TABLE_SELECT_PAGE_GET_TABLES_SUB_TASK_NAME, (Object)schema.getName()));
                        subMonitor.worked(20);
                        tables.addAll(CollectionTools.hashBag((Iterable)schema.getTables()));
                        subMonitor.worked(95);
                    }
                    catch (OperationCanceledException operationCanceledException) {
                        IStatus iStatus = Status.CANCEL_STATUS;
                        subMonitor.done();
                        return iStatus;
                    }
                }
                finally {
                    subMonitor.done();
                }
                return Status.OK_STATUS;
            }
        };
        workspaceJob.addJobChangeListener((IJobChangeListener)new JobChangeAdapter(){

            public void done(IJobChangeEvent event) {
                DisplayTools.asyncExec((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        TablesSelectorWizardPage.this.updateTablesListViewer(tables);
                    }
                });
                event.getJob().removeJobChangeListener((IJobChangeListener)this);
                TablesSelectorWizardPage.this.fetchTablesJob = null;
            }
        });
        return workspaceJob;
    }

    private void doStatusUpdate() {
        if (!this.hasTablesSelected()) {
            this.setPageComplete(false);
        } else {
            this.setPageComplete(true);
            Collection<org.eclipse.jpt.jpa.db.Table> ret = this.getSelectedTables();
            ArrayList<String> tableNames = new ArrayList<String>();
            for (org.eclipse.jpt.jpa.db.Table t : ret) {
                tableNames.add(t.getName());
            }
            Schema schema = this.getSchema();
            if (schema == null) {
                return;
            }
            this.customizer.setSchema(schema);
            this.customizer.setTableNames(tableNames);
            this.customizer.setUpdatePersistenceXml(this.updatePersistenceXml);
        }
    }

    private void updateSelectionState(Schema schema) {
        if (schema == null) {
            return;
        }
        this.jpaProject.setUserOverrideDefaultSchema(schema.getIdentifier());
        if (!this.fetchTablesJobIsRunning() && !this.tableInitialized()) {
            this.fetchTablesJob = this.buildFetchTablesJob(schema);
            this.fetchTablesJob.schedule();
        } else {
            this.updateTablesListViewer(this.getTables(schema));
        }
        this.customizer = this.getWizard().createORMGenCustomizer(schema);
        if (this.tableTable != null && this.customizer != null) {
            this.restoreWizardState();
        }
        this.doStatusUpdate();
    }

    private boolean restoreWizardState() {
        List preSelectedTableNames;
        boolean pageComplete = false;
        if (this.updatePersistenceXmlCheckBox != null) {
            this.updatePersistenceXmlCheckBox.setSelection(this.customizer.updatePersistenceXml());
        }
        if ((preSelectedTableNames = this.customizer.getTableNames()) != null && preSelectedTableNames.size() > 0) {
            HashSet<String> set = new HashSet<String>();
            for (String s : preSelectedTableNames) {
                set.add(s);
            }
            TableItem[] items = this.tableTable.getTable().getItems();
            int i = 0;
            while (i < items.length) {
                TableItem item = items[i];
                org.eclipse.jpt.jpa.db.Table element = (org.eclipse.jpt.jpa.db.Table)item.getData();
                if (element != null) {
                    boolean check = set.contains(element.getName());
                    if (item.getChecked() != check) {
                        item.setChecked(check);
                        pageComplete = true;
                    }
                }
                ++i;
            }
        }
        return pageComplete;
    }

    private class TableFilter
    extends ViewerFilter {
        private String pattern;
        private StringMatcher matcher;
        private static final String ALL = "*";

        private TableFilter() {
        }

        public boolean select(Viewer viewer, Object parentElement, Object element) {
            org.eclipse.jpt.jpa.db.Table table = (org.eclipse.jpt.jpa.db.Table)element;
            if (this.pattern == null || this.pattern.length() == 0) {
                return true;
            }
            if (TablesSelectorWizardPage.this.tableTable.getChecked((Object)table)) {
                return true;
            }
            return this.matcher.match(table.getName());
        }

        protected void setPattern(String newPattern) {
            if (newPattern == null || newPattern.trim().length() == 0) {
                this.matcher = new StringMatcher(ALL, true, false);
            } else {
                this.pattern = String.valueOf(newPattern) + ALL;
                this.matcher = new StringMatcher(this.pattern, true, false);
            }
        }
    }

    private class TableTableContentProvider
    implements IStructuredContentProvider {
        TableTableContentProvider() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }

        public void dispose() {
        }

        public Object[] getElements(Object inputElement) {
            return ((Collection)inputElement).toArray();
        }
    }

    private class TableTableLabelProvider
    extends LabelProvider
    implements ITableLabelProvider {
        TableTableLabelProvider() {
        }

        public String getText(Object element) {
            return ((org.eclipse.jpt.jpa.db.Table)element).getName();
        }

        public Image getColumnImage(Object element, int columnIndex) {
            return null;
        }

        public String getColumnText(Object element, int columnIndex) {
            if (element == null) {
                return null;
            }
            switch (columnIndex) {
                case 0: {
                    return ((org.eclipse.jpt.jpa.db.Table)element).getName();
                }
            }
            throw new IllegalArgumentException("invalid column index: " + columnIndex);
        }
    }
}

