/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.chromium.debug.core.model;

import java.util.Collection;
import org.eclipse.wst.jsdt.chromium.JsVariable;
import org.eclipse.wst.jsdt.chromium.util.BasicUtil;
import org.eclipse.wst.jsdt.chromium.util.JavaScriptExpressionBuilder;

public class ExpressionTracker {
    static final ScopeAndVariableFactory STACK_FRAME_FACTORY = new ScopeAndVariableFactory(){
        private final Node liveScopeNode = new Node(){

            @Override
            public String calculateQualifiedName() {
                return null;
            }

            @Override
            public String calculateParentQualifiedName() {
                return null;
            }

            @Override
            public Node createVariableNode(JsVariable jsVariable, boolean isInternal) {
                return ExpressionTracker.defaultCreateVariable(jsVariable, isInternal, null);
            }
        };

        @Override
        public Node createVariableNode(JsVariable jsVariable, boolean isInternal) {
            return ExpressionTracker.defaultCreateVariable(jsVariable, isInternal, null);
        }

        @Override
        public Node createScopeNode() {
            return this.liveScopeNode;
        }
    };
    static final ScopeAndVariableFactory FUNCTION_SCOPE_FACTORY = new ScopeAndVariableFactory(){

        @Override
        public Node createVariableNode(JsVariable jsVariable, boolean isInternal) {
            return NO_EXPRESSION_NODE;
        }

        @Override
        public Node createScopeNode() {
            return NO_EXPRESSION_NODE;
        }
    };
    static final Node NO_EXPRESSION_NODE = new Node(){

        @Override
        public String calculateQualifiedName() {
            return null;
        }

        @Override
        public String calculateParentQualifiedName() {
            return null;
        }

        @Override
        public Node createVariableNode(JsVariable jsVariable, boolean isInternal) {
            return NO_EXPRESSION_NODE;
        }
    };

    public static Node createExpressionNode(String expression) {
        return new ExpressionNodeImpl(expression);
    }

    private static Node defaultCreateVariable(JsVariable jsVariable, boolean isInternal, JavaScriptExpressionBuilder.VariableAccess parentNode) {
        if (isInternal && BasicUtil.containsSafe((Collection)JavaScriptExpressionBuilder.SEMI_INTERNAL_PROPERTY_NAMES, (Object)jsVariable.getName())) {
            isInternal = false;
        }
        if (isInternal) {
            return NO_EXPRESSION_NODE;
        }
        JavaScriptExpressionBuilder.ExpressionComponentFormatter nameComponenetBuilder = parentNode == null ? JavaScriptExpressionBuilder.SHORT_NAME : JavaScriptExpressionBuilder.OBJECT_PROPERTY_NAME_BUILDER;
        return new DefaultNodeImpl(jsVariable, parentNode, nameComponenetBuilder);
    }

    private static class DefaultNodeImpl
    implements Node,
    JavaScriptExpressionBuilder.VariableAccess {
        private final JsVariable jsVariable;
        private final JavaScriptExpressionBuilder.VariableAccess parentNode;
        private final JavaScriptExpressionBuilder.ExpressionComponentFormatter qualifiedNameBuilder;

        public DefaultNodeImpl(JsVariable jsVariable, JavaScriptExpressionBuilder.VariableAccess parentNode, JavaScriptExpressionBuilder.ExpressionComponentFormatter qualifiedNameBuilder) {
            this.jsVariable = jsVariable;
            this.parentNode = parentNode;
            this.qualifiedNameBuilder = qualifiedNameBuilder;
        }

        public JavaScriptExpressionBuilder.VariableAccess getParent() {
            return this.parentNode;
        }

        public String getShortName() {
            return this.jsVariable.getName();
        }

        public JavaScriptExpressionBuilder.ExpressionComponentFormatter getVariableFormatter() {
            return this.qualifiedNameBuilder;
        }

        @Override
        public String calculateQualifiedName() {
            return JavaScriptExpressionBuilder.buildQualifiedName((JavaScriptExpressionBuilder.VariableAccess)this);
        }

        @Override
        public String calculateParentQualifiedName() {
            if (this.parentNode == null) {
                return null;
            }
            return JavaScriptExpressionBuilder.buildQualifiedName((JavaScriptExpressionBuilder.VariableAccess)this.parentNode);
        }

        @Override
        public Node createVariableNode(JsVariable jsVariable, boolean isInternal) {
            return ExpressionTracker.defaultCreateVariable(jsVariable, isInternal, this);
        }
    }

    private static class ExpressionNodeImpl
    implements Node,
    JavaScriptExpressionBuilder.VariableAccess {
        private final String expression;

        ExpressionNodeImpl(String expression) {
            this.expression = expression;
        }

        public String getShortName() {
            return this.expression;
        }

        public JavaScriptExpressionBuilder.ExpressionComponentFormatter getVariableFormatter() {
            return JavaScriptExpressionBuilder.SHORT_NAME_PAREN;
        }

        public JavaScriptExpressionBuilder.VariableAccess getParent() {
            return null;
        }

        @Override
        public String calculateQualifiedName() {
            return JavaScriptExpressionBuilder.buildQualifiedName((JavaScriptExpressionBuilder.VariableAccess)this);
        }

        @Override
        public String calculateParentQualifiedName() {
            return null;
        }

        @Override
        public Node createVariableNode(JsVariable jsVariable, boolean isInternal) {
            return ExpressionTracker.defaultCreateVariable(jsVariable, isInternal, this);
        }
    }

    static interface Node {
        public String calculateQualifiedName();

        public String calculateParentQualifiedName();

        public Node createVariableNode(JsVariable var1, boolean var2);
    }

    static interface ScopeAndVariableFactory {
        public Node createVariableNode(JsVariable var1, boolean var2);

        public Node createScopeNode();
    }
}

