/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.core.search;

import java.util.regex.Pattern;
import org.eclipse.wst.jsdt.core.IField;
import org.eclipse.wst.jsdt.core.IFunction;
import org.eclipse.wst.jsdt.core.IImportDeclaration;
import org.eclipse.wst.jsdt.core.IJavaScriptElement;
import org.eclipse.wst.jsdt.core.IMember;
import org.eclipse.wst.jsdt.core.IType;
import org.eclipse.wst.jsdt.core.JavaScriptModelException;
import org.eclipse.wst.jsdt.core.Signature;
import org.eclipse.wst.jsdt.core.compiler.CharOperation;
import org.eclipse.wst.jsdt.core.compiler.InvalidInputException;
import org.eclipse.wst.jsdt.internal.compiler.parser.Scanner;
import org.eclipse.wst.jsdt.internal.compiler.parser.ScannerHelper;
import org.eclipse.wst.jsdt.internal.core.LocalVariable;
import org.eclipse.wst.jsdt.internal.core.search.indexing.IIndexConstants;
import org.eclipse.wst.jsdt.internal.core.search.matching.AndPattern;
import org.eclipse.wst.jsdt.internal.core.search.matching.ConstructorPattern;
import org.eclipse.wst.jsdt.internal.core.search.matching.FieldPattern;
import org.eclipse.wst.jsdt.internal.core.search.matching.InternalSearchPattern;
import org.eclipse.wst.jsdt.internal.core.search.matching.LocalVariablePattern;
import org.eclipse.wst.jsdt.internal.core.search.matching.MethodPattern;
import org.eclipse.wst.jsdt.internal.core.search.matching.OrPattern;
import org.eclipse.wst.jsdt.internal.core.search.matching.PackageDeclarationPattern;
import org.eclipse.wst.jsdt.internal.core.search.matching.PackageReferencePattern;
import org.eclipse.wst.jsdt.internal.core.search.matching.SuperTypeReferencePattern;
import org.eclipse.wst.jsdt.internal.core.search.matching.TypeDeclarationPattern;
import org.eclipse.wst.jsdt.internal.core.search.matching.TypeReferencePattern;
import org.eclipse.wst.jsdt.internal.core.util.QualificationHelpers;

public abstract class SearchPattern
extends InternalSearchPattern {
    public static final int R_EXACT_MATCH = 0;
    public static final int R_PREFIX_MATCH = 1;
    public static final int R_PATTERN_MATCH = 2;
    public static final int R_REGEXP_MATCH = 4;
    public static final int R_CASE_SENSITIVE = 8;
    public static final int R_ERASURE_MATCH = 16;
    public static final int R_EQUIVALENT_MATCH = 32;
    public static final int R_FULL_MATCH = 64;
    public static final int R_CAMELCASE_MATCH = 128;
    private static final int MODE_MASK = 7;
    private int matchRule;

    public SearchPattern(int matchRule) {
        this.matchRule = matchRule;
        if ((matchRule & 0x30) == 0) {
            this.matchRule |= 0x40;
        }
    }

    public static final boolean camelCaseMatch(String pattern, String name) {
        if (pattern == null) {
            return true;
        }
        if (name == null) {
            return false;
        }
        return SearchPattern.camelCaseMatch(pattern, 0, pattern.length(), name, 0, name.length());
    }

    public static final boolean camelCaseMatch(String pattern, int patternStart, int patternEnd, String name, int nameStart, int nameEnd) {
        if (name == null) {
            return false;
        }
        if (pattern == null) {
            return true;
        }
        if (patternEnd < 0) {
            patternEnd = pattern.length();
        }
        if (nameEnd < 0) {
            nameEnd = name.length();
        }
        if (patternEnd <= patternStart) {
            return nameEnd <= nameStart;
        }
        if (nameEnd <= nameStart) {
            return false;
        }
        if (name.charAt(nameStart) != pattern.charAt(patternStart)) {
            return false;
        }
        int iPattern = patternStart;
        int iName = nameStart;
        block0: while (true) {
            char nameChar;
            ++iName;
            if (++iPattern == patternEnd) {
                return true;
            }
            if (iName == nameEnd) {
                return false;
            }
            char patternChar = pattern.charAt(iPattern);
            if (patternChar == name.charAt(iName)) continue;
            if (patternChar < '\u0080' ? (ScannerHelper.OBVIOUS_IDENT_CHAR_NATURES[patternChar] & 0x20) == 0 : Character.isJavaIdentifierPart(patternChar) && !Character.isUpperCase(patternChar)) {
                return false;
            }
            while (true) {
                if (iName == nameEnd) {
                    return false;
                }
                nameChar = name.charAt(iName);
                if (nameChar < '\u0080') {
                    if ((ScannerHelper.OBVIOUS_IDENT_CHAR_NATURES[nameChar] & 0x94) != 0) {
                        ++iName;
                        continue;
                    }
                    if (patternChar == nameChar) continue block0;
                    return false;
                }
                if (!Character.isJavaIdentifierPart(nameChar) || Character.isUpperCase(nameChar)) break;
                ++iName;
            }
            if (patternChar != nameChar) break;
        }
        return false;
    }

    public static SearchPattern createAndPattern(SearchPattern leftPattern, SearchPattern rightPattern) {
        return new AndPattern(leftPattern, rightPattern);
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    private static SearchPattern createFieldPattern(String patternString, int limitTo, int matchRule, boolean isVar) {
        scanner = new Scanner(false, true, false, 0x2F0000L, null, null, true);
        scanner.setSource(patternString.toCharArray());
        lastToken = -1;
        declaringType = null;
        fieldName = null;
        type = null;
        mode = 1;
        try {
            token = scanner.getNextToken();
            if (true) ** GOTO lbl47
        }
        catch (InvalidInputException v0) {
            return null;
        }
        do {
            block2 : switch (mode) {
                case 1: {
                    switch (token) {
                        case 31: {
                            if (declaringType == null) {
                                if (fieldName == null) {
                                    return null;
                                }
                                declaringType = fieldName;
                            } else {
                                tokenSource = scanner.getCurrentTokenString();
                                declaringType = String.valueOf(declaringType) + tokenSource + fieldName;
                            }
                            fieldName = null;
                            break block2;
                        }
                        case 1000: {
                            if (1000 == lastToken || 31 == lastToken) break block2;
                            mode = 2;
                            break block2;
                        }
                    }
                    if (fieldName == null) {
                        fieldName = scanner.getCurrentTokenString();
                        break;
                    }
                    fieldName = String.valueOf(fieldName) + scanner.getCurrentTokenString();
                    break;
                }
                case 2: {
                    switch (token) {
                        case 1000: {
                            break block2;
                        }
                    }
                    type = type == null ? scanner.getCurrentTokenString() : String.valueOf(type) + scanner.getCurrentTokenString();
                }
            }
            lastToken = token;
            try {
                token = scanner.getNextToken();
            }
            catch (InvalidInputException v1) {
                return null;
            }
lbl47:
            // 2 sources

        } while (token != 70);
        if (fieldName == null) {
            return null;
        }
        fieldNameChars = fieldName.toCharArray();
        if (fieldNameChars.length == 1 && fieldNameChars[0] == '*') {
            fieldNameChars = null;
        }
        declaringTypeQualification = null;
        declaringTypeSimpleName = null;
        typeQualification /* !! */  = null;
        typeSimpleName = null;
        if (declaringType != null) {
            declaringTypePart = declaringType.toCharArray();
            lastDotPosition = CharOperation.lastIndexOf('.', declaringTypePart);
            if (lastDotPosition >= 0) {
                declaringTypeQualification = CharOperation.subarray(declaringTypePart, 0, lastDotPosition);
                if (declaringTypeQualification.length == 1 && declaringTypeQualification[0] == '*') {
                    declaringTypeQualification = null;
                }
                declaringTypeSimpleName = CharOperation.subarray(declaringTypePart, lastDotPosition + 1, declaringTypePart.length);
            } else {
                declaringTypeSimpleName = declaringTypePart;
            }
            if (declaringTypeSimpleName.length == 1 && declaringTypeSimpleName[0] == '*') {
                declaringTypeSimpleName = null;
            }
        }
        if (type != null) {
            typePart = type.toCharArray();
            lastDotPosition = CharOperation.lastIndexOf('.', typePart);
            if (lastDotPosition >= 0) {
                typeQualification /* !! */  = CharOperation.subarray(typePart, 0, lastDotPosition);
                typeQualification /* !! */  = (char[])(typeQualification /* !! */ .length == 1 && typeQualification /* !! */ [0] == '*' ? null : CharOperation.concat(IIndexConstants.ONE_STAR, typeQualification /* !! */ ));
                typeSimpleName = CharOperation.subarray(typePart, lastDotPosition + 1, typePart.length);
            } else {
                typeSimpleName = typePart;
            }
            if (typeSimpleName.length == 1 && typeSimpleName[0] == '*') {
                typeSimpleName = null;
            }
        }
        findDeclarations = false;
        readAccess = false;
        writeAccess = false;
        switch (limitTo) {
            case 0: {
                findDeclarations = true;
                break;
            }
            case 2: 
            case 4: {
                readAccess = true;
                break;
            }
            case 5: {
                writeAccess = true;
                break;
            }
            case 3: {
                findDeclarations = true;
                readAccess = true;
                writeAccess = true;
            }
        }
        return new FieldPattern(findDeclarations, readAccess, writeAccess, isVar, fieldNameChars, declaringTypeQualification, declaringTypeSimpleName, typeQualification /* !! */ , typeSimpleName, matchRule, null);
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    private static SearchPattern createMethodOrConstructorPattern(String patternString, int limitTo, int matchRule, boolean isConstructor, boolean isFunction) {
        scanner = new Scanner(false, true, false, 0x2F0000L, null, null, true);
        scanner.setSource(patternString.toCharArray());
        lastToken = -1;
        declaringType = null;
        selector = null;
        parameterType = null;
        parameterTypes = null;
        typeArgumentsString = null;
        parameterCount = -1;
        returnType = null;
        foundClosingParenthesis = false;
        mode = 1;
        argCount = 0;
        try {
            token = scanner.getNextToken();
            if (true) ** GOTO lbl166
        }
        catch (InvalidInputException v0) {
            return null;
        }
        do {
            block5 : switch (mode) {
                case 1: {
                    if (argCount == 0) {
                        switch (token) {
                            case 17: {
                                ++argCount;
                                if (selector == null || lastToken == 31) {
                                    if (typeArgumentsString != null) {
                                        return null;
                                    }
                                    typeArgumentsString = scanner.getCurrentTokenString();
                                    mode = 2;
                                    break block5;
                                }
                                declaringType = declaringType == null ? selector : String.valueOf(declaringType) + '.' + selector;
                                declaringType = String.valueOf(declaringType) + scanner.getCurrentTokenString();
                                selector = null;
                                break block5;
                            }
                            case 31: {
                                if (typeArgumentsString != null) {
                                    return null;
                                }
                                if (declaringType == null) {
                                    if (selector == null) {
                                        return null;
                                    }
                                    declaringType = selector;
                                } else if (selector != null) {
                                    declaringType = String.valueOf(declaringType) + scanner.getCurrentTokenString() + selector;
                                }
                                selector = null;
                                break block5;
                            }
                            case 8: {
                                parameterTypes = new String[5];
                                parameterCount = 0;
                                mode = 3;
                                break block5;
                            }
                            case 1000: {
                                switch (lastToken) {
                                    case 5: 
                                    case 7: 
                                    case 16: 
                                    case 31: 
                                    case 1000: {
                                        break block5;
                                    }
                                }
                                mode = 4;
                                break block5;
                            }
                        }
                        if (selector == null) {
                            selector = scanner.getCurrentTokenString();
                            break;
                        }
                        selector = String.valueOf(selector) + scanner.getCurrentTokenString();
                        break;
                    }
                    if (declaringType == null) {
                        return null;
                    }
                    switch (token) {
                        case 5: 
                        case 7: 
                        case 16: {
                            --argCount;
                            break;
                        }
                        case 17: {
                            ++argCount;
                        }
                    }
                    declaringType = String.valueOf(declaringType) + scanner.getCurrentTokenString();
                    break;
                }
                case 2: {
                    if (typeArgumentsString == null) {
                        return null;
                    }
                    typeArgumentsString = String.valueOf(typeArgumentsString) + scanner.getCurrentTokenString();
                    switch (token) {
                        case 5: 
                        case 7: 
                        case 16: {
                            if (--argCount != 0) break;
                            mode = 1;
                            break;
                        }
                        case 17: {
                            ++argCount;
                        }
                    }
                    break;
                }
                case 3: {
                    if (argCount == 0) {
                        switch (token) {
                            case 1000: {
                                break block5;
                            }
                            case 26: {
                                if (parameterType == null) {
                                    return null;
                                }
                                if (parameterTypes != null) {
                                    if (parameterTypes.length == parameterCount) {
                                        v1 = parameterTypes;
                                        parameterTypes = new String[parameterCount * 2];
                                        System.arraycopy(v1, 0, parameterTypes, 0, parameterCount);
                                    }
                                    parameterTypes[parameterCount++] = parameterType;
                                }
                                parameterType = null;
                                break block5;
                            }
                            case 52: {
                                foundClosingParenthesis = true;
                                if (parameterType != null && parameterTypes != null) {
                                    if (parameterTypes.length == parameterCount) {
                                        v2 = parameterTypes;
                                        parameterTypes = new String[parameterCount * 2];
                                        System.arraycopy(v2, 0, parameterTypes, 0, parameterCount);
                                    }
                                    parameterTypes[parameterCount++] = parameterType;
                                }
                                mode = isConstructor != false ? 2 : 4;
                                break block5;
                            }
                            case 17: {
                                ++argCount;
                                if (parameterType != null) break;
                                return null;
                            }
                        }
                        if (parameterType == null) {
                            parameterType = scanner.getCurrentTokenString();
                            break;
                        }
                        parameterType = String.valueOf(parameterType) + scanner.getCurrentTokenString();
                        break;
                    }
                    if (parameterType == null) {
                        return null;
                    }
                    switch (token) {
                        case 5: 
                        case 7: 
                        case 16: {
                            --argCount;
                            break;
                        }
                        case 17: {
                            ++argCount;
                        }
                    }
                    parameterType = String.valueOf(parameterType) + scanner.getCurrentTokenString();
                    break;
                }
                case 4: {
                    if (argCount == 0) {
                        switch (token) {
                            case 1000: {
                                break block5;
                            }
                            case 8: {
                                parameterTypes = new String[5];
                                parameterCount = 0;
                                mode = 3;
                                break block5;
                            }
                            case 17: {
                                ++argCount;
                                if (returnType != null) break;
                                return null;
                            }
                        }
                        if (returnType == null) {
                            returnType = scanner.getCurrentTokenString();
                            break;
                        }
                        returnType = String.valueOf(returnType) + scanner.getCurrentTokenString();
                        break;
                    }
                    if (returnType == null) {
                        return null;
                    }
                    switch (token) {
                        case 5: 
                        case 7: 
                        case 16: {
                            --argCount;
                            break;
                        }
                        case 17: {
                            ++argCount;
                        }
                    }
                    returnType = String.valueOf(returnType) + scanner.getCurrentTokenString();
                }
            }
            lastToken = token;
            try {
                token = scanner.getNextToken();
            }
            catch (InvalidInputException v3) {
                return null;
            }
lbl166:
            // 2 sources

        } while (token != 70);
        if (parameterCount > 0 && !foundClosingParenthesis) {
            return null;
        }
        if (argCount > 0) {
            return null;
        }
        selectorChars = null;
        if (isConstructor) {
            if (declaringType == null) {
                declaringType = selector;
            } else if (selector != null) {
                declaringType = String.valueOf(declaringType) + '.' + selector;
            }
        } else {
            if (selector == null) {
                return null;
            }
            selectorChars = selector.toCharArray();
            if (selectorChars.length == 1 && selectorChars[0] == '*') {
                selectorChars = null;
            }
        }
        declaringTypeQualification = null;
        declaringTypeSimpleName = null;
        returnTypeQualification /* !! */  = null;
        returnTypeSimpleName = null;
        parameterTypeQualifications = null;
        parameterTypeSimpleNames = null;
        parameterTypeSignatures = null;
        if (declaringType != null) {
            declaringTypePart = null;
            try {
                declaringTypePart = declaringType.toCharArray();
            }
            catch (IllegalArgumentException v4) {
                return null;
            }
            lastDotPosition = CharOperation.lastIndexOf('.', declaringTypePart);
            if (lastDotPosition >= 0) {
                declaringTypeQualification = CharOperation.subarray(declaringTypePart, 0, lastDotPosition);
                if (declaringTypeQualification.length == 1 && declaringTypeQualification[0] == '*') {
                    declaringTypeQualification = null;
                }
                declaringTypeSimpleName = CharOperation.subarray(declaringTypePart, lastDotPosition + 1, declaringTypePart.length);
            } else {
                declaringTypeSimpleName = declaringTypePart;
            }
            if (declaringTypeSimpleName.length == 1 && declaringTypeSimpleName[0] == '*') {
                declaringTypeSimpleName = null;
            }
        }
        if (parameterCount >= 0) {
            parameterTypeQualifications = new char[parameterCount][];
            parameterTypeSimpleNames = new char[parameterCount][];
            parameterTypeSignatures = new String[parameterCount];
            i = 0;
            while (i < parameterCount) {
                parameterTypePart = null;
                try {
                    if (parameterTypes != null) {
                        parameterTypeSignatures[i] = Signature.createTypeSignature(parameterTypes[i], false);
                        parameterTypePart = parameterTypes[i].toCharArray();
                    }
                }
                catch (IllegalArgumentException v5) {
                    return null;
                }
                v6 = lastDotPosition = parameterTypePart == null ? -1 : CharOperation.lastIndexOf('.', parameterTypePart);
                if (parameterTypePart != null && lastDotPosition >= 0) {
                    parameterTypeQualifications[i] = CharOperation.subarray(parameterTypePart, 0, lastDotPosition);
                    parameterTypeQualifications[i] = (char[])(parameterTypeQualifications[i].length == 1 && parameterTypeQualifications[i][0] == '*' ? null : CharOperation.concat(IIndexConstants.ONE_STAR, parameterTypeQualifications[i]));
                    parameterTypeSimpleNames[i] = CharOperation.subarray(parameterTypePart, lastDotPosition + 1, parameterTypePart.length);
                } else {
                    parameterTypeQualifications[i] = null;
                    parameterTypeSimpleNames[i] = parameterTypePart;
                }
                if (parameterTypeSimpleNames[i].length == 1 && parameterTypeSimpleNames[i][0] == '*') {
                    parameterTypeSimpleNames[i] = null;
                }
                ++i;
            }
        }
        if (returnType != null) {
            returnTypePart = null;
            try {
                returnTypePart = returnType.toCharArray();
            }
            catch (IllegalArgumentException v7) {
                return null;
            }
            lastDotPosition = CharOperation.lastIndexOf('.', returnTypePart);
            if (lastDotPosition >= 0) {
                returnTypeQualification /* !! */  = CharOperation.subarray(returnTypePart, 0, lastDotPosition);
                returnTypeQualification /* !! */  = (char[])(returnTypeQualification /* !! */ .length == 1 && returnTypeQualification /* !! */ [0] == '*' ? null : CharOperation.concat(IIndexConstants.ONE_STAR, returnTypeQualification /* !! */ ));
                returnTypeSimpleName = CharOperation.subarray(returnTypePart, lastDotPosition + 1, returnTypePart.length);
            } else {
                returnTypeSimpleName = returnTypePart;
            }
            if (returnTypeSimpleName.length == 1 && returnTypeSimpleName[0] == '*') {
                returnTypeSimpleName = null;
            }
        }
        findDeclarations = true;
        findReferences = true;
        switch (limitTo) {
            case 0: {
                findReferences = false;
                break;
            }
            case 2: {
                findDeclarations = false;
                break;
            }
        }
        if (isConstructor) {
            return new ConstructorPattern(patternString.toCharArray(), matchRule, findDeclarations, findReferences);
        }
        return new MethodPattern(findDeclarations, findReferences, isFunction, selectorChars, parameterTypeQualifications, parameterTypeSimpleNames, returnTypeQualification /* !! */ , returnTypeSimpleName, declaringTypeQualification, declaringTypeSimpleName, matchRule);
    }

    public static SearchPattern createOrPattern(SearchPattern leftPattern, SearchPattern rightPattern) {
        return new OrPattern(leftPattern, rightPattern);
    }

    private static SearchPattern createPackagePattern(String patternString, int limitTo, int matchRule) {
        switch (limitTo) {
            case 0: {
                return new PackageDeclarationPattern(patternString.toCharArray(), matchRule);
            }
            case 2: {
                return new PackageReferencePattern(patternString.toCharArray(), matchRule);
            }
            case 3: {
                return new OrPattern(new PackageDeclarationPattern(patternString.toCharArray(), matchRule), new PackageReferencePattern(patternString.toCharArray(), matchRule));
            }
        }
        return null;
    }

    public static SearchPattern createPattern(String stringPattern, int searchFor, int limitTo, int matchRule) {
        if (stringPattern == null || stringPattern.length() == 0) {
            return null;
        }
        if ((matchRule = SearchPattern.validateMatchRule(stringPattern, matchRule)) == -1) {
            return null;
        }
        limitTo &= 0xFFFFFFCF;
        switch (searchFor) {
            case 5: {
                return SearchPattern.createTypePattern(stringPattern, limitTo, matchRule, 'C');
            }
            case 0: {
                return SearchPattern.createTypePattern(stringPattern, limitTo, matchRule, '\u0000');
            }
            case 13: {
                return SearchPattern.createMethodOrConstructorPattern(stringPattern, limitTo, matchRule, false, true);
            }
            case 1: {
                return SearchPattern.createMethodOrConstructorPattern(stringPattern, limitTo, matchRule, false, false);
            }
            case 3: {
                return SearchPattern.createMethodOrConstructorPattern(stringPattern, limitTo, matchRule, true, false);
            }
            case 4: {
                return SearchPattern.createFieldPattern(stringPattern, limitTo, matchRule, false);
            }
            case 12: {
                return SearchPattern.createFieldPattern(stringPattern, limitTo, matchRule, true);
            }
            case 2: {
                return SearchPattern.createPackagePattern(stringPattern, limitTo, matchRule);
            }
        }
        return null;
    }

    public static SearchPattern createPattern(IJavaScriptElement element, int limitTo) {
        return SearchPattern.createPattern(element, limitTo, 24);
    }

    public static SearchPattern createPattern(IJavaScriptElement element, int limitTo, int matchRule) {
        InternalSearchPattern searchPattern = null;
        boolean ignoreDeclaringType = false;
        boolean ignoreReturnType = false;
        int maskedLimitTo = limitTo & 0xFFFFFFCF;
        if (maskedLimitTo == 0 || maskedLimitTo == 3) {
            ignoreDeclaringType = (limitTo & 0x10) != 0;
            ignoreReturnType = (limitTo & 0x20) != 0;
        }
        char[] declaringSimpleName = null;
        char[] declaringQualification = null;
        boolean isVar = false;
        boolean isFunction = false;
        switch (element.getElementType()) {
            case 8: {
                IField field = (IField)element;
                IType declaringClassForField = field.getDeclaringType();
                boolean bl = isVar = declaringClassForField == null;
                if (!ignoreDeclaringType && declaringClassForField != null) {
                    declaringSimpleName = declaringClassForField.getElementName().toCharArray();
                    declaringQualification = declaringClassForField.getPackageFragment().getElementName().toCharArray();
                    char[][] enclosingNames = SearchPattern.enclosingTypeNames(declaringClassForField);
                    if (enclosingNames.length > 0) {
                        declaringQualification = CharOperation.concat(declaringQualification, CharOperation.concatWith(enclosingNames, '.'), '.');
                    }
                }
                char[] name = field.getElementName().toCharArray();
                char[] typeSimpleName = null;
                char[] typeQualification = null;
                String typeSignature = null;
                if (!ignoreReturnType) {
                    try {
                        typeSignature = field.getTypeSignature();
                        char[] signature = typeSignature.toCharArray();
                        char[] typeErasure = Signature.toCharArray(signature);
                        int lastDot = CharOperation.lastIndexOf('.', typeErasure);
                        if (lastDot == -1) {
                            typeSimpleName = typeErasure;
                        } else {
                            typeSimpleName = CharOperation.subarray(typeErasure, lastDot + 1, typeErasure.length);
                            typeQualification = CharOperation.subarray(typeErasure, 0, lastDot);
                            if (!field.isBinary()) {
                                typeQualification = CharOperation.concat(IIndexConstants.ONE_STAR, typeQualification);
                            }
                        }
                    }
                    catch (JavaScriptModelException javaScriptModelException) {
                        return null;
                    }
                }
                boolean findDeclarations = false;
                boolean readAccess = false;
                boolean writeAccess = false;
                switch (maskedLimitTo) {
                    case 0: {
                        findDeclarations = true;
                        break;
                    }
                    case 2: 
                    case 4: {
                        readAccess = true;
                        break;
                    }
                    case 5: {
                        writeAccess = true;
                        break;
                    }
                    case 3: {
                        findDeclarations = true;
                        readAccess = true;
                        writeAccess = true;
                    }
                }
                searchPattern = new FieldPattern(findDeclarations, readAccess, writeAccess, isVar, name, declaringQualification, declaringSimpleName, typeQualification, typeSimpleName, matchRule, field);
                break;
            }
            case 13: {
                String elementName = element.getElementName();
                int lastDot = elementName.lastIndexOf(46);
                if (lastDot == -1) {
                    return null;
                }
                IImportDeclaration importDecl = (IImportDeclaration)element;
                if (importDecl.isOnDemand()) {
                    searchPattern = SearchPattern.createPackagePattern(elementName.substring(0, lastDot), maskedLimitTo, matchRule);
                    break;
                }
                searchPattern = SearchPattern.createTypePattern(elementName.substring(lastDot + 1).toCharArray(), elementName.substring(0, lastDot).toCharArray(), null, null, null, maskedLimitTo, matchRule);
                break;
            }
            case 14: {
                LocalVariable localVar = (LocalVariable)element;
                boolean findVarDeclarations = false;
                boolean findVarReadAccess = false;
                boolean findVarWriteAccess = false;
                switch (maskedLimitTo) {
                    case 0: {
                        findVarDeclarations = true;
                        break;
                    }
                    case 2: {
                        findVarReadAccess = true;
                        findVarWriteAccess = true;
                        break;
                    }
                    case 4: {
                        findVarReadAccess = true;
                        break;
                    }
                    case 5: {
                        findVarWriteAccess = true;
                        break;
                    }
                    case 3: {
                        findVarDeclarations = true;
                        findVarReadAccess = true;
                        findVarWriteAccess = true;
                    }
                }
                searchPattern = new LocalVariablePattern(findVarDeclarations, findVarReadAccess, findVarWriteAccess, localVar, matchRule);
                break;
            }
            case 9: {
                int lastDot;
                boolean isConstructor;
                IFunction method = (IFunction)element;
                try {
                    isConstructor = method.isConstructor();
                }
                catch (JavaScriptModelException javaScriptModelException) {
                    return null;
                }
                IType declaringClass = method.getDeclaringType();
                if (declaringClass != null) {
                    if (ignoreDeclaringType) {
                        if (isConstructor) {
                            declaringSimpleName = declaringClass.getElementName().toCharArray();
                        }
                    } else {
                        declaringSimpleName = declaringClass.getElementName().toCharArray();
                        declaringQualification = declaringClass.getPackageFragment().getElementName().toCharArray();
                        char[][] enclosingNames = SearchPattern.enclosingTypeNames(declaringClass);
                        if (enclosingNames.length > 0) {
                            declaringQualification = CharOperation.concat(declaringQualification, CharOperation.concatWith(enclosingNames, '.'), '.');
                        }
                    }
                } else {
                    isFunction = true;
                }
                char[] selector = method.getElementName().toCharArray();
                char[] returnSimpleName = null;
                char[] returnQualification = null;
                String returnSignature = null;
                if (!ignoreReturnType) {
                    try {
                        returnSignature = method.getReturnType();
                        char[] signature = returnSignature.toCharArray();
                        char[] returnErasure = Signature.toCharArray(signature);
                        lastDot = CharOperation.lastIndexOf('.', returnErasure);
                        if (lastDot == -1) {
                            returnSimpleName = returnErasure;
                        } else {
                            returnSimpleName = CharOperation.subarray(returnErasure, lastDot + 1, returnErasure.length);
                            returnQualification = CharOperation.subarray(returnErasure, 0, lastDot);
                            if (!method.isBinary()) {
                                CharOperation.concat(IIndexConstants.ONE_STAR, returnQualification);
                            }
                        }
                    }
                    catch (JavaScriptModelException javaScriptModelException) {
                        return null;
                    }
                }
                String[] parameterTypes = method.getParameterTypes();
                int paramCount = parameterTypes.length;
                char[][] parameterSimpleNames = new char[paramCount][];
                char[][] parameterQualifications = new char[paramCount][];
                String[] parameterSignatures = new String[paramCount];
                int i = 0;
                while (i < paramCount) {
                    parameterSignatures[i] = parameterTypes[i];
                    char[] signature = parameterSignatures[i].toCharArray();
                    char[] paramErasure = Signature.toCharArray(signature);
                    lastDot = CharOperation.lastIndexOf('.', paramErasure);
                    if (lastDot == -1) {
                        parameterSimpleNames[i] = paramErasure;
                        parameterQualifications[i] = null;
                    } else {
                        parameterSimpleNames[i] = CharOperation.subarray(paramErasure, lastDot + 1, paramErasure.length);
                        parameterQualifications[i] = CharOperation.subarray(paramErasure, 0, lastDot);
                        if (!method.isBinary()) {
                            CharOperation.concat(IIndexConstants.ONE_STAR, parameterQualifications[i]);
                        }
                    }
                    ++i;
                }
                boolean findMethodDeclarations = true;
                boolean findMethodReferences = true;
                switch (maskedLimitTo) {
                    case 0: {
                        findMethodReferences = false;
                        break;
                    }
                    case 2: {
                        findMethodDeclarations = false;
                        break;
                    }
                }
                if (isConstructor) {
                    searchPattern = new ConstructorPattern(findMethodDeclarations, findMethodReferences, parameterQualifications, parameterSimpleNames, declaringSimpleName, declaringQualification, matchRule);
                    break;
                }
                searchPattern = new MethodPattern(findMethodDeclarations, findMethodReferences, isFunction, selector, parameterQualifications, parameterSimpleNames, returnQualification, returnSimpleName, declaringQualification, declaringSimpleName, matchRule);
                break;
            }
            case 7: {
                IType type = (IType)element;
                searchPattern = SearchPattern.createTypePattern(type.getElementName().toCharArray(), type.getPackageFragment().getElementName().toCharArray(), ignoreDeclaringType ? null : SearchPattern.enclosingTypeNames(type), null, type, maskedLimitTo, matchRule);
                break;
            }
            case 4: {
                searchPattern = SearchPattern.createPackagePattern(element.getElementName(), maskedLimitTo, matchRule);
            }
        }
        if (searchPattern != null) {
            searchPattern.setFocus(element);
        }
        return searchPattern;
    }

    private static SearchPattern createTypePattern(char[] simpleName, char[] packageName, char[][] enclosingTypeNames, String typeSignature, IType type, int limitTo, int matchRule) {
        switch (limitTo) {
            case 0: {
                return new TypeDeclarationPattern(packageName, simpleName, enclosingTypeNames, matchRule);
            }
            case 2: {
                if (type != null) {
                    return new TypeReferencePattern(CharOperation.concatWith(packageName, enclosingTypeNames, '.'), simpleName, type, matchRule);
                }
                return new TypeReferencePattern(CharOperation.concatWith(packageName, enclosingTypeNames, '.'), simpleName, typeSignature, matchRule);
            }
            case 1: {
                return new SuperTypeReferencePattern(QualificationHelpers.createFullyQualifiedName(packageName, simpleName), matchRule);
            }
            case 3: {
                return new OrPattern(new TypeDeclarationPattern(packageName, simpleName, enclosingTypeNames, matchRule), type != null ? new TypeReferencePattern(CharOperation.concatWith(packageName, enclosingTypeNames, '.'), simpleName, type, matchRule) : new TypeReferencePattern(CharOperation.concatWith(packageName, enclosingTypeNames, '.'), simpleName, typeSignature, matchRule));
            }
        }
        return null;
    }

    private static SearchPattern createTypePattern(String patternString, int limitTo, int matchRule, char indexSuffix) {
        int token;
        Scanner scanner = new Scanner(false, true, false, 0x2F0000L, null, null, true);
        scanner.setSource(patternString.toCharArray());
        String type = null;
        try {
            token = scanner.getNextToken();
        }
        catch (InvalidInputException invalidInputException) {
            return null;
        }
        int argCount = 0;
        while (token != 70) {
            if (argCount == 0) {
                switch (token) {
                    case 1000: {
                        break;
                    }
                    case 17: {
                        ++argCount;
                    }
                    default: {
                        if (type == null) {
                            type = scanner.getCurrentTokenString();
                            break;
                        }
                        type = String.valueOf(type) + scanner.getCurrentTokenString();
                        break;
                    }
                }
            } else {
                switch (token) {
                    case 5: 
                    case 7: 
                    case 16: {
                        --argCount;
                        break;
                    }
                    case 17: {
                        ++argCount;
                    }
                }
                if (type == null) {
                    return null;
                }
                type = String.valueOf(type) + scanner.getCurrentTokenString();
            }
            try {
                token = scanner.getNextToken();
            }
            catch (InvalidInputException invalidInputException) {
                return null;
            }
        }
        if (type == null) {
            return null;
        }
        String typeSignature = null;
        char[] qualificationChars = null;
        char[] typeChars = null;
        char[] typePart = null;
        try {
            typeSignature = Signature.createTypeSignature(type, false);
            typePart = type.toCharArray();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return null;
        }
        int lastDotPosition = CharOperation.lastIndexOf('.', typePart);
        if (lastDotPosition >= 0) {
            qualificationChars = CharOperation.subarray(typePart, 0, lastDotPosition);
            if (qualificationChars.length == 1 && qualificationChars[0] == '*') {
                qualificationChars = null;
            }
            typeChars = CharOperation.subarray(typePart, lastDotPosition + 1, typePart.length);
        } else {
            typeChars = typePart;
        }
        if (typeChars.length == 1 && typeChars[0] == '*') {
            typeChars = null;
        }
        switch (limitTo) {
            case 0: {
                return new TypeDeclarationPattern(qualificationChars, typeChars, matchRule);
            }
            case 2: {
                return new TypeReferencePattern(qualificationChars, typeChars, typeSignature, matchRule);
            }
            case 1: {
                return new SuperTypeReferencePattern(QualificationHelpers.createFullyQualifiedName(qualificationChars, typeChars), matchRule);
            }
            case 3: {
                return new OrPattern(new TypeDeclarationPattern(qualificationChars, typeChars, matchRule), new TypeReferencePattern(qualificationChars, typeChars, matchRule));
            }
        }
        return null;
    }

    private static char[][] enclosingTypeNames(IType type) {
        IJavaScriptElement parent = type.getParent();
        switch (parent.getElementType()) {
            case 6: {
                IType declaringType = type.getDeclaringType();
                if (declaringType == null) {
                    return CharOperation.NO_CHAR_CHAR;
                }
                return CharOperation.arrayConcat(SearchPattern.enclosingTypeNames(declaringType), declaringType.getElementName().toCharArray());
            }
            case 5: {
                return CharOperation.NO_CHAR_CHAR;
            }
            case 8: 
            case 9: 
            case 10: {
                IType declaringClass = ((IMember)parent).getDeclaringType();
                if (declaringClass != null) {
                    return CharOperation.arrayConcat(SearchPattern.enclosingTypeNames(declaringClass), new char[][]{declaringClass.getElementName().toCharArray(), IIndexConstants.ONE_STAR});
                }
                return CharOperation.NO_CHAR_CHAR;
            }
            case 7: {
                return CharOperation.arrayConcat(SearchPattern.enclosingTypeNames((IType)parent), parent.getElementName().toCharArray());
            }
        }
        return null;
    }

    public void decodeIndexKey(char[] key) {
    }

    public abstract SearchPattern getBlankPattern();

    public char[] getIndexKey() {
        return null;
    }

    public char[][] getIndexCategories() {
        return CharOperation.NO_CHAR_CHAR;
    }

    public final int getMatchRule() {
        return this.matchRule;
    }

    public boolean matchesDecodedKey(SearchPattern decodedPattern) {
        return true;
    }

    public boolean matchesName(char[] pattern, char[] name) {
        if (pattern == null) {
            return true;
        }
        if (name != null) {
            boolean matchFirstChar;
            boolean emptyPattern;
            boolean isCaseSensitive = (this.matchRule & 8) != 0;
            boolean isCamelCase = (this.matchRule & 0x80) != 0;
            int matchMode = this.matchRule & 7;
            boolean bl = emptyPattern = pattern.length == 0;
            if (matchMode == 1 && emptyPattern) {
                return true;
            }
            boolean sameLength = pattern.length == name.length;
            boolean canBePrefix = name.length >= pattern.length;
            boolean bl2 = matchFirstChar = !isCaseSensitive || emptyPattern || name.length > 0 && pattern[0] == name[0];
            if (isCamelCase && matchFirstChar && CharOperation.camelCaseMatch(pattern, name)) {
                return true;
            }
            switch (matchMode) {
                case 0: 
                case 64: {
                    if (!isCamelCase) {
                        if (!sameLength || !matchFirstChar) break;
                        return CharOperation.equals(pattern, name, isCaseSensitive);
                    }
                }
                case 1: {
                    if (!canBePrefix || !matchFirstChar) break;
                    return CharOperation.prefixEquals(pattern, name, isCaseSensitive);
                }
                case 2: {
                    if (!isCaseSensitive) {
                        pattern = CharOperation.toLowerCase(pattern);
                    }
                    return CharOperation.match(pattern, name, isCaseSensitive);
                }
                case 4: {
                    int flags = 0;
                    if (!isCaseSensitive) {
                        flags = 2;
                    }
                    return Pattern.compile(new String(pattern), flags).matcher(new String(name)).matches();
                }
            }
        }
        return false;
    }

    public static boolean matchesQualificationPattern(char[] thisQualifiedName, char[] otherQualifiedName, boolean isCaseSensitive) {
        if (thisQualifiedName != null && SearchPattern.isPatternMatch(String.valueOf(thisQualifiedName)) && otherQualifiedName != null && otherQualifiedName.length > 0) {
            if (!isCaseSensitive) {
                thisQualifiedName = CharOperation.toLowerCase(thisQualifiedName);
            }
            return CharOperation.match(thisQualifiedName, otherQualifiedName, isCaseSensitive);
        }
        return false;
    }

    public static int validateMatchRule(String stringPattern, int matchRule) {
        if ((matchRule & 4) != 0 && ((matchRule & 2) != 0 || (matchRule & 1) != 0 || (matchRule & 0x80) != 0)) {
            return -1;
        }
        int starIndex = stringPattern.indexOf(42);
        int questionIndex = stringPattern.indexOf(63);
        matchRule = starIndex < 0 && questionIndex < 0 ? (matchRule &= 0xFFFFFFFD) : (matchRule |= 2);
        if ((matchRule & 2) != 0) {
            matchRule &= 0xFFFFFF7F;
            matchRule &= 0xFFFFFFFE;
        }
        if ((matchRule & 0x80) != 0) {
            int length = stringPattern.length();
            boolean validCamelCase = true;
            boolean uppercase = false;
            int i = 0;
            while (i < length && validCamelCase) {
                char ch = stringPattern.charAt(i);
                validCamelCase = ScannerHelper.isJavaIdentifierStart(ch);
                if (!uppercase) {
                    uppercase = ScannerHelper.isUpperCase(ch);
                }
                ++i;
            }
            boolean bl = validCamelCase = validCamelCase && uppercase;
            if (validCamelCase) {
                if ((matchRule & 1) != 0 && (matchRule & 8) != 0) {
                    matchRule &= 0xFFFFFFFE;
                    matchRule &= 0xFFFFFFF7;
                }
            } else if (((matchRule &= 0xFFFFFF7F) & 1) == 0) {
                matchRule |= 1;
                matchRule |= 8;
            }
        }
        return matchRule;
    }

    public static boolean isPatternMatch(String pattern) {
        return SearchPattern.validateMatchRule(pattern, 2) == 2;
    }

    public String toString() {
        return "SearchPattern";
    }
}

