/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xml.xpath.ui.internal.views;

import java.util.List;
import javax.xml.namespace.NamespaceContext;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathExpressionException;
import org.apache.xpath.jaxp.XPathFactoryImpl;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.ui.progress.IWorkbenchSiteProgressService;
import org.eclipse.wst.sse.core.internal.provisional.IModelStateListener;
import org.eclipse.wst.sse.core.internal.provisional.IStructuredModel;
import org.eclipse.wst.xml.core.internal.contentmodel.util.NamespaceInfo;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMDocument;
import org.eclipse.wst.xml.xpath.core.util.NodeListImpl;
import org.eclipse.wst.xml.xpath.core.util.SimpleXPathEngine;
import org.eclipse.wst.xml.xpath.core.util.XPath20Helper;
import org.eclipse.wst.xml.xpath.core.util.XPathCoreHelper;
import org.eclipse.wst.xml.xpath.ui.internal.Messages;
import org.eclipse.wst.xml.xpath.ui.internal.XPathUIPlugin;
import org.eclipse.wst.xml.xpath.ui.internal.views.DefaultNamespaceContext;
import org.eclipse.wst.xml.xpath.ui.internal.views.XPathView;
import org.eclipse.wst.xml.xpath2.api.ResultSequence;
import org.eclipse.wst.xml.xpath2.processor.DynamicError;
import org.eclipse.wst.xml.xpath2.processor.internal.DefaultResultSequence;
import org.eclipse.wst.xml.xpath2.processor.internal.types.AnyType;
import org.eclipse.wst.xml.xpath2.processor.internal.types.XSString;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class XPathComputer {
    private static final int UPDATE_DELAY = 500;
    private static final byte[] XPATH_LOCK = new byte[0];
    private boolean xpath20 = true;
    private XPathView xpathView;
    private IModelStateListener modelStateListener = new IModelStateListener(){

        public void modelAboutToBeChanged(IStructuredModel model) {
        }

        public void modelAboutToBeReinitialized(IStructuredModel structuredModel) {
        }

        public void modelChanged(IStructuredModel model) {
            XPathComputer.this.updateXPath();
            XPathComputer.this.compute();
        }

        public void modelDirtyStateChanged(IStructuredModel model, boolean isDirty) {
        }

        public void modelReinitialized(IStructuredModel structuredModel) {
        }

        public void modelResourceDeleted(IStructuredModel model) {
        }

        public void modelResourceMoved(IStructuredModel oldModel, IStructuredModel newModel) {
        }
    };
    private Node node;
    private IStructuredModel model;
    private String expression;
    private String text;
    private NodeList nodeList;
    private SimpleXPathEngine xpath2Engine;
    private SimpleXPathEngine xpath1Engine;

    public XPathComputer(XPathView xpathView) {
        this.xpathView = xpathView;
    }

    public void setModel(IStructuredModel model) {
        if (this.model != null) {
            this.model.removeModelStateListener(this.modelStateListener);
        }
        this.model = model;
        if (model != null) {
            model.addModelStateListener(this.modelStateListener);
            this.updateXPath();
        } else {
            this.node = null;
        }
    }

    private void updateXPath() {
        Document doc;
        Object o = this.model.getAdapter(Document.class);
        if (o instanceof Document && (doc = (Document)o) != null) {
            try {
                this.updateExpression();
            }
            catch (XPathExpressionException xPathExpressionException) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateExpression() throws XPathExpressionException {
        byte[] byArray = XPATH_LOCK;
        synchronized (XPATH_LOCK) {
            if (this.text != null) {
                SimpleXPathEngine engine = this.getCurrentEngine();
                if (this.node != null) {
                    IDOMDocument doc = this.node.getNodeType() == 9 ? (IDOMDocument)this.node : (IDOMDocument)this.node.getOwnerDocument();
                    this.updateNamespaces(engine, doc);
                }
                engine.parse(this.text);
                this.expression = this.text;
            } else {
                this.expression = null;
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    private SimpleXPathEngine getCurrentEngine() {
        this.xpath20 = XPathCoreHelper.getPreferences().getBoolean("XPATH2.0", false);
        if (this.xpath20) {
            if (this.xpath2Engine == null) {
                this.xpath2Engine = new XPath20Helper.XPath2Engine();
            }
            return this.xpath2Engine;
        }
        if (this.xpath1Engine == null) {
            this.xpath1Engine = new XPath10Engine();
        }
        return this.xpath1Engine;
    }

    public void setText(String text) throws XPathExpressionException {
        this.text = text;
        this.updateExpression();
    }

    public void setSelectedNode(Node node) {
        this.node = node;
    }

    /*
     * Enabled aggressive block sorting
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public void compute() {
        // MONITORENTER : org.eclipse.wst.xml.xpath.ui.internal.views.XPathComputer.XPATH_LOCK
        // MONITOREXIT : org.eclipse.wst.xml.xpath.ui.internal.views.XPathComputer.XPATH_LOCK
        Job refresh = new Job(Messages.XPathComputer_5){

            protected IStatus run(IProgressMonitor monitor) {
                return XPathComputer.this.doCompute();
            }
        };
        refresh.setSystem(true);
        refresh.setPriority(20);
        IWorkbenchSiteProgressService service = (IWorkbenchSiteProgressService)this.xpathView.getSite().getService(IWorkbenchSiteProgressService.class);
        service.schedule(refresh, 500L);
    }

    private IStatus doCompute() {
        IStatus status = this.executeXPath();
        this.xpathView.xpathRecomputed(this.nodeList, status);
        return status;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private IStatus executeXPath() {
        IStatus status = Status.CANCEL_STATUS;
        try {
            if (this.node == null) return status;
            byte[] byArray = XPATH_LOCK;
            synchronized (XPATH_LOCK) {
                SimpleXPathEngine engine = this.getCurrentEngine();
                if (engine.isValid()) return this.evaluateXPath(engine);
                engine.parse(this.text);
                return this.evaluateXPath(engine);
            }
        }
        catch (XPathExpressionException e) {
            return new Status(8, "org.eclipse.wst.xml.xpath.core", e.getMessage());
        }
    }

    protected IStatus evaluateXPath(SimpleXPathEngine engine) throws XPathExpressionException {
        IDOMDocument doc = null;
        doc = this.node.getNodeType() == 9 ? (IDOMDocument)this.node : (IDOMDocument)this.node.getOwnerDocument();
        this.updateNamespaces(engine, doc);
        try {
            this.nodeList = engine.execute(this.node);
            return Status.OK_STATUS;
        }
        catch (DynamicError de) {
            return new Status(8, "org.eclipse.wst.xml.xpath.core", String.valueOf(de.getMessage()) + " (" + de.code() + ")");
        }
        catch (Throwable t) {
            return new Status(4, "org.eclipse.wst.xml.xpath.core", t.getMessage());
        }
    }

    private void updateNamespaces(SimpleXPathEngine engine, IDOMDocument doc) {
        List<NamespaceInfo> namespaces = XPathUIPlugin.getDefault().getNamespaceInfo(doc);
        if (namespaces != null) {
            engine.setNamespaceContext((NamespaceContext)new DefaultNamespaceContext(namespaces));
        } else {
            engine.setNamespaceContext(null);
        }
    }

    public void dispose() {
        if (this.model != null) {
            this.model.removeModelStateListener(this.modelStateListener);
            this.model = null;
        }
    }

    public static class XPath10Engine
    implements SimpleXPathEngine {
        private XPathExpression goodXPath = null;
        private NamespaceContext namespaceContext;
        private XPath newXPath = new XPathFactoryImpl().newXPath();

        public void setNamespaceContext(NamespaceContext namespaceContext) {
            this.namespaceContext = namespaceContext;
        }

        public void parse(String expression) throws XPathExpressionException {
            this.goodXPath = null;
            if (this.namespaceContext != null) {
                this.newXPath.setNamespaceContext(this.namespaceContext);
            }
            this.goodXPath = this.newXPath.compile(expression);
        }

        public NodeList execute(Node contextNode) throws XPathExpressionException {
            try {
                return (NodeList)this.goodXPath.evaluate(contextNode, XPathConstants.NODESET);
            }
            catch (XPathExpressionException xee) {
                if (xee.getCause() != null && xee.getCause().getMessage().indexOf("Can not convert ") >= 0) {
                    String value = (String)this.goodXPath.evaluate(contextNode, XPathConstants.STRING);
                    return new NodeListImpl((ResultSequence)new DefaultResultSequence((AnyType)new XSString(value)));
                }
                throw xee;
            }
        }

        public boolean isValid() {
            return this.goodXPath != null;
        }
    }
}

