/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.chromium.internal.transport;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import java.net.SocketAddress;
import org.eclipse.wst.jsdt.chromium.ConnectionLogger;
import org.eclipse.wst.jsdt.chromium.util.SignalRelay;

public abstract class AbstractSocketWrapper<INPUT_WRAPPER, OUTPUT_WRAPPER> {
    private final Socket socket;
    private final INPUT_WRAPPER loggableInput;
    private final OUTPUT_WRAPPER loggableOutput;
    private final SignalRelay<ShutdownSignal> shutdownRelay = SignalRelay.create(new SignalRelay.Callback<ShutdownSignal>(){

        @Override
        public void onSignal(ShutdownSignal param, Exception cause) {
            try {
                this.closeImpl();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }

        private void closeImpl() throws IOException {
            try {
                AbstractSocketWrapper.this.socket.shutdownInput();
            }
            catch (IOException iOException) {}
            try {
                AbstractSocketWrapper.this.socket.shutdownOutput();
            }
            catch (IOException iOException) {}
            try {
                AbstractSocketWrapper.this.socket.close();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            AbstractSocketWrapper.this.socket.close();
        }
    });

    public AbstractSocketWrapper(SocketAddress endpoint, int connectionTimeoutMs, ConnectionLogger connectionLogger, WrapperFactory<INPUT_WRAPPER, OUTPUT_WRAPPER> factory) throws IOException {
        this.socket = new Socket();
        this.socket.connect(endpoint, connectionTimeoutMs);
        INPUT_WRAPPER originalLogReader = factory.wrapInputStream(this.socket.getInputStream());
        OUTPUT_WRAPPER originalLogWriter = factory.wrapOutputStream(this.socket.getOutputStream());
        if (connectionLogger == null) {
            this.loggableInput = originalLogReader;
            this.loggableOutput = originalLogWriter;
        } else {
            this.loggableInput = factory.wrapInputStream(originalLogReader, connectionLogger.getIncomingStreamListener());
            this.loggableOutput = factory.wrapOutputStream(originalLogWriter, connectionLogger.getOutgoingStreamListener());
            connectionLogger.setConnectionCloser(new ConnectionLogger.ConnectionCloser(){

                @Override
                public void closeConnection() {
                    AbstractSocketWrapper.this.shutdownRelay.sendSignal(null, new Exception("Close requested from logger UI"));
                }
            });
        }
    }

    public INPUT_WRAPPER getLoggableInput() {
        return this.loggableInput;
    }

    public OUTPUT_WRAPPER getLoggableOutput() {
        return this.loggableOutput;
    }

    public SignalRelay<ShutdownSignal> getShutdownRelay() {
        return this.shutdownRelay;
    }

    public static interface ShutdownSignal {
    }

    protected static interface WrapperFactory<IW, OW> {
        public IW wrapInputStream(InputStream var1);

        public OW wrapOutputStream(OutputStream var1);

        public IW wrapInputStream(IW var1, ConnectionLogger.StreamListener var2);

        public OW wrapOutputStream(OW var1, ConnectionLogger.StreamListener var2);
    }
}

