/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.javascript.jscomp.AbstractCompiler;
import com.google.javascript.jscomp.CompilerPass;
import com.google.javascript.jscomp.DiagnosticType;
import com.google.javascript.jscomp.NodeTraversal;
import com.google.javascript.jscomp.Scope;
import com.google.javascript.jscomp.Var;
import com.google.javascript.rhino.Node;
import javax.annotation.Nullable;

class ConstParamCheck
extends NodeTraversal.AbstractPostOrderCallback
implements CompilerPass {
    private static final String CONST_FUNCTION_NAME = "goog.string.Const.from";
    private static final String CONST_FUNCTION_NAME_COLLAPSED = "goog$string$Const$from";
    @VisibleForTesting
    static final DiagnosticType CONST_NOT_STRING_LITERAL_ERROR = DiagnosticType.error("JSC_CONSTANT_NOT_STRING_LITERAL_ERROR", "Function argument is not a string literal or a constant assigned from a string literal");
    @VisibleForTesting
    static final DiagnosticType CONST_NOT_ASSIGNED_STRING_LITERAL_ERROR = DiagnosticType.error("JSC_CONSTANT_NOT_ASSIGNED_STRING_LITERAL_ERROR", "Function argument is a variable {0} which is not a constant assigned from a string literal");
    private final AbstractCompiler compiler;

    public ConstParamCheck(AbstractCompiler compiler) {
        this.compiler = (AbstractCompiler)Preconditions.checkNotNull((Object)compiler);
    }

    @Override
    public void process(Node externs, Node root) {
        Preconditions.checkState((boolean)this.compiler.getLifeCycleStage().isNormalized());
        NodeTraversal.traverseEs6(this.compiler, root, this);
    }

    @Override
    public void visit(NodeTraversal traversal, Node node, Node parent) {
        if (node.getType() == 37) {
            Node name = node.getFirstChild();
            Node argument = name.getNext();
            if (argument == null) {
                return;
            }
            if (name.isName() && !name.matchesQualifiedName(CONST_FUNCTION_NAME_COLLAPSED)) {
                Scope scope = traversal.getScope();
                Var var = scope.getVar(name.getString());
                if (var == null) {
                    return;
                }
                name = var.getInitialValue();
                if (name == null) {
                    return;
                }
            }
            if (name.matchesQualifiedName(CONST_FUNCTION_NAME) || name.matchesQualifiedName(CONST_FUNCTION_NAME_COLLAPSED)) {
                this.checkArgumentConstant(traversal, argument);
            }
        }
    }

    private void checkArgumentConstant(NodeTraversal traversal, Node argument) {
        if (argument.isName()) {
            String name = argument.getString();
            Scope scope = traversal.getScope();
            Var var = scope.getVar(name);
            if (var == null || !var.isInferredConst()) {
                this.compiler.report(traversal.makeError(argument, CONST_NOT_STRING_LITERAL_ERROR, name));
                return;
            }
            Node valueNode = var.getInitialValue();
            if (!ConstParamCheck.isStringLiteralValue(valueNode)) {
                this.compiler.report(traversal.makeError(argument, CONST_NOT_ASSIGNED_STRING_LITERAL_ERROR, name));
            }
        } else if (!ConstParamCheck.isStringLiteralValue(argument)) {
            this.compiler.report(traversal.makeError(argument, CONST_NOT_STRING_LITERAL_ERROR, new String[0]));
        }
    }

    private static boolean isStringLiteralValue(@Nullable Node node) {
        if (node == null) {
            return false;
        }
        if (node.getType() == 40) {
            return true;
        }
        if (node.getType() == 21) {
            Preconditions.checkState((node.getChildCount() == 2 ? 1 : 0) != 0);
            Node left = node.getFirstChild();
            Node right = node.getLastChild();
            return ConstParamCheck.isStringLiteralValue(left) && ConstParamCheck.isStringLiteralValue(right);
        }
        return false;
    }
}

