/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xml.xpath2.processor.testsuite.schema;

import java.net.URL;
import java.util.Arrays;
import java.util.List;
import javax.xml.validation.Schema;
import org.apache.xerces.jaxp.validation.XMLSchemaFactory;
import org.apache.xerces.xs.XSModel;
import org.eclipse.wst.xml.xpath2.processor.DynamicError;
import org.eclipse.wst.xml.xpath2.processor.ResultSequence;
import org.eclipse.wst.xml.xpath2.processor.StaticError;
import org.eclipse.wst.xml.xpath2.processor.XPathParserException;
import org.eclipse.wst.xml.xpath2.processor.test.AbstractPsychoPathTest;
import org.xml.sax.SAXException;

public class UserDefinedSITest
extends AbstractPsychoPathTest {
    public void test_user_defined_1() throws Exception {
        String inputFile = "/TestSources/emptydoc.xml";
        String xqFile = "/Queries/XQuery/SchemaImport/UserDefinedSI/user-defined-1.xq";
        String resultFile = "/ExpectedTestResults/SchemaImport/UserDefinedSI/user-defined-1.txt";
        String expectedResult = this.getExpectedResult(resultFile);
        URL fileURL = this.bundle.getEntry(inputFile);
        Schema jaxpSchema = this.loadSchema();
        this.loadDOMDocument(fileURL, jaxpSchema);
        XSModel schema = this.getGrammar();
        this.setupDynamicContext(schema);
        this.addUserDefinedSimpleTypes(schema);
        String xpath = "myType:sizeType(1)";
        String actual = null;
        try {
            this.compileXPath(xpath);
            ResultSequence rs = this.evaluate(this.domDoc);
            actual = this.buildResultString(rs);
        }
        catch (XPathParserException ex) {
            actual = ex.code();
        }
        catch (StaticError ex) {
            ex.printStackTrace();
            actual = ex.code();
        }
        catch (DynamicError ex) {
            ex.printStackTrace();
            actual = ex.code();
        }
        UserDefinedSITest.assertEquals((String)("XPath Result Error " + xqFile + ":"), (String)expectedResult, (String)actual);
    }

    public void test_user_defined_2() throws Exception {
        String inputFile = "/TestSources/emptydoc.xml";
        List<String> expectedResult = Arrays.asList("FORG0001", "XQST0009", "XPST0017");
        URL fileURL = this.bundle.getEntry(inputFile);
        Schema jaxpSchema = this.loadSchema();
        this.loadDOMDocument(fileURL, jaxpSchema);
        XSModel schema = this.getGrammar();
        this.setupDynamicContext(schema);
        this.addUserDefinedSimpleTypes(schema);
        String xpath = "myType:sizeType(20)";
        String actual = null;
        try {
            this.compileXPath(xpath);
            ResultSequence rs = this.evaluate(this.domDoc);
            actual = this.buildResultString(rs);
        }
        catch (XPathParserException ex) {
            actual = ex.code();
        }
        catch (StaticError ex) {
            actual = ex.code();
        }
        catch (DynamicError ex) {
            actual = ex.code();
        }
        UserDefinedSITest.assertTrue((String)("Expected one of " + expectedResult + " but actual was: " + actual), (boolean)expectedResult.contains(actual));
    }

    public void test_user_defined_3() throws Exception {
        String inputFile = "/TestSources/emptydoc.xml";
        String xqFile = "/Queries/XQuery/SchemaImport/UserDefinedSI/user-defined-3.xq";
        String resultFile = "/ExpectedTestResults/SchemaImport/UserDefinedSI/user-defined-3.txt";
        String expectedResult = this.getExpectedResult(resultFile);
        URL fileURL = this.bundle.getEntry(inputFile);
        Schema jaxpSchema = this.loadSchema();
        this.loadDOMDocument(fileURL, jaxpSchema);
        XSModel schema = this.getGrammar();
        this.setupDynamicContext(schema);
        this.addUserDefinedSimpleTypes(schema);
        String xpath = "myType:sizeType(1) + myType:sizeType(2)";
        String actual = null;
        try {
            this.compileXPath(xpath);
            ResultSequence rs = this.evaluate(this.domDoc);
            actual = this.buildResultString(rs);
        }
        catch (XPathParserException ex) {
            actual = ex.code();
        }
        catch (StaticError ex) {
            actual = ex.code();
        }
        catch (DynamicError ex) {
            ex.printStackTrace();
            actual = ex.code();
        }
        UserDefinedSITest.assertEquals((String)("XPath Result Error " + xqFile + ":"), (String)expectedResult, (String)actual);
    }

    public void test_user_defined_4() throws Exception {
        String inputFile = "/TestSources/emptydoc.xml";
        String xqFile = "/Queries/XQuery/SchemaImport/UserDefinedSI/user-defined-4.xq";
        String resultFile = "/ExpectedTestResults/SchemaImport/UserDefinedSI/user-defined-4.txt";
        String expectedResult = this.getExpectedResult(resultFile);
        URL fileURL = this.bundle.getEntry(inputFile);
        Schema jaxpSchema = this.loadSchema();
        this.loadDOMDocument(fileURL, jaxpSchema);
        XSModel schema = this.getGrammar();
        this.setupDynamicContext(schema);
        this.addUserDefinedSimpleTypes(schema);
        String xpath = "myType:stringBased(\"valid value 4\")";
        String actual = null;
        try {
            this.compileXPath(xpath);
            ResultSequence rs = this.evaluate(this.domDoc);
            actual = this.buildResultString(rs);
        }
        catch (XPathParserException ex) {
            actual = ex.code();
        }
        catch (StaticError ex) {
            actual = ex.code();
        }
        catch (DynamicError ex) {
            actual = ex.code();
        }
        UserDefinedSITest.assertEquals((String)("XPath Result Error " + xqFile + ":"), (String)expectedResult, (String)actual);
    }

    public void test_user_defined_5() throws Exception {
        String inputFile = "/TestSources/emptydoc.xml";
        String xqFile = "/Queries/XQuery/SchemaImport/UserDefinedSI/user-defined-5.xq";
        String resultFile = "/ExpectedTestResults/SchemaImport/UserDefinedSI/user-defined-5.txt";
        String expectedResult = this.getExpectedResult(resultFile);
        URL fileURL = this.bundle.getEntry(inputFile);
        Schema jaxpSchema = this.loadSchema();
        this.loadDOMDocument(fileURL, jaxpSchema);
        XSModel schema = this.getGrammar();
        this.setupDynamicContext(schema);
        this.addUserDefinedSimpleTypes(schema);
        String xpath = this.extractXPathExpression(xqFile, inputFile);
        String actual = null;
        try {
            this.compileXPath(xpath);
            ResultSequence rs = this.evaluate(this.domDoc);
            actual = this.buildResultString(rs);
        }
        catch (XPathParserException ex) {
            actual = ex.code();
        }
        catch (StaticError ex) {
            actual = ex.code();
        }
        catch (DynamicError ex) {
            actual = ex.code();
        }
        UserDefinedSITest.assertEquals((String)("XPath Result Error " + xqFile + ":"), (String)expectedResult, (String)actual);
    }

    public void test_user_defined_6() throws Exception {
        String inputFile = "/TestSources/emptydoc.xml";
        String xqFile = "/Queries/XQuery/SchemaImport/UserDefinedSI/user-defined-6.xq";
        String resultFile = "/ExpectedTestResults/SchemaImport/UserDefinedSI/user-defined-6.txt";
        String expectedResult = this.getExpectedResult(resultFile);
        URL fileURL = this.bundle.getEntry(inputFile);
        Schema jaxpSchema = this.loadSchema();
        this.loadDOMDocument(fileURL, jaxpSchema);
        XSModel schema = this.getGrammar();
        this.setupDynamicContext(schema);
        this.addUserDefinedSimpleTypes(schema);
        String xpath = this.extractXPathExpression(xqFile, inputFile);
        String actual = null;
        try {
            this.compileXPath(xpath);
            ResultSequence rs = this.evaluate(this.domDoc);
            actual = this.buildResultString(rs);
        }
        catch (XPathParserException ex) {
            actual = ex.code();
        }
        catch (StaticError ex) {
            actual = ex.code();
        }
        catch (DynamicError ex) {
            actual = ex.code();
        }
        UserDefinedSITest.assertEquals((String)("XPath Result Error " + xqFile + ":"), (String)expectedResult, (String)actual);
    }

    public void test_user_defined_7() throws Exception {
        String inputFile = "/TestSources/emptydoc.xml";
        String xqFile = "/Queries/XQuery/SchemaImport/UserDefinedSI/user-defined-7.xq";
        String resultFile = "/ExpectedTestResults/SchemaImport/UserDefinedSI/user-defined-7.txt";
        String expectedResult = this.getExpectedResult(resultFile);
        URL fileURL = this.bundle.getEntry(inputFile);
        Schema jaxpSchema = this.loadSchema();
        this.loadDOMDocument(fileURL, jaxpSchema);
        XSModel schema = this.getGrammar();
        this.setupDynamicContext(schema);
        this.addUserDefinedSimpleTypes(schema);
        String xpath = this.extractXPathExpression(xqFile, inputFile);
        String actual = null;
        try {
            this.compileXPath(xpath);
            ResultSequence rs = this.evaluate(this.domDoc);
            actual = this.buildResultString(rs);
        }
        catch (XPathParserException ex) {
            actual = ex.code();
        }
        catch (StaticError ex) {
            actual = ex.code();
        }
        catch (DynamicError ex) {
            actual = ex.code();
        }
        UserDefinedSITest.assertEquals((String)("XPath Result Error " + xqFile + ":"), (String)expectedResult, (String)actual);
    }

    public void test_user_defined_8() throws Exception {
        String inputFile = "/TestSources/emptydoc.xml";
        String xqFile = "/Queries/XQuery/SchemaImport/UserDefinedSI/user-defined-8.xq";
        String resultFile = "/ExpectedTestResults/SchemaImport/UserDefinedSI/user-defined-8.txt";
        String expectedResult = this.getExpectedResult(resultFile);
        URL fileURL = this.bundle.getEntry(inputFile);
        Schema jaxpSchema = this.loadSchema();
        this.loadDOMDocument(fileURL, jaxpSchema);
        XSModel schema = this.getGrammar();
        this.setupDynamicContext(schema);
        this.addUserDefinedSimpleTypes(schema);
        String xpath = this.extractXPathExpression(xqFile, inputFile);
        String actual = null;
        try {
            this.compileXPath(xpath);
            ResultSequence rs = this.evaluate(this.domDoc);
            actual = this.buildResultString(rs);
        }
        catch (XPathParserException ex) {
            actual = ex.code();
        }
        catch (StaticError ex) {
            actual = ex.code();
        }
        catch (DynamicError ex) {
            actual = ex.code();
        }
        UserDefinedSITest.assertEquals((String)("XPath Result Error " + xqFile + ":"), (String)expectedResult, (String)actual);
    }

    public void test_user_defined_9() throws Exception {
        String inputFile = "/TestSources/emptydoc.xml";
        String xqFile = "/Queries/XQuery/SchemaImport/UserDefinedSI/user-defined-9.xq";
        String resultFile = "/ExpectedTestResults/SchemaImport/UserDefinedSI/user-defined-9.txt";
        String expectedResult = this.getExpectedResult(resultFile);
        URL fileURL = this.bundle.getEntry(inputFile);
        Schema jaxpSchema = this.loadSchema();
        this.loadDOMDocument(fileURL, jaxpSchema);
        XSModel schema = this.getGrammar();
        this.setupDynamicContext(schema);
        this.addUserDefinedSimpleTypes(schema);
        String xpath = this.extractXPathExpression(xqFile, inputFile);
        String actual = null;
        try {
            this.compileXPath(xpath);
            ResultSequence rs = this.evaluate(this.domDoc);
            actual = this.buildResultString(rs);
        }
        catch (XPathParserException ex) {
            actual = ex.code();
        }
        catch (StaticError ex) {
            actual = ex.code();
        }
        catch (DynamicError ex) {
            actual = ex.code();
        }
        UserDefinedSITest.assertEquals((String)("XPath Result Error " + xqFile + ":"), (String)expectedResult, (String)actual);
    }

    public void test_user_defined_10() throws Exception {
        String inputFile = "/TestSources/emptydoc.xml";
        String xqFile = "/Queries/XQuery/SchemaImport/UserDefinedSI/user-defined-10.xq";
        String resultFile = "/ExpectedTestResults/SchemaImport/UserDefinedSI/user-defined-10.txt";
        String expectedResult = this.getExpectedResult(resultFile);
        URL fileURL = this.bundle.getEntry(inputFile);
        Schema jaxpSchema = this.loadSchema();
        this.loadDOMDocument(fileURL, jaxpSchema);
        XSModel schema = this.getGrammar();
        this.setupDynamicContext(schema);
        this.addUserDefinedSimpleTypes(schema);
        String xpath = this.extractXPathExpression(xqFile, inputFile);
        String actual = null;
        try {
            this.compileXPath(xpath);
            ResultSequence rs = this.evaluate(this.domDoc);
            actual = this.buildResultString(rs);
        }
        catch (XPathParserException ex) {
            actual = ex.code();
        }
        catch (StaticError ex) {
            ex.printStackTrace();
            actual = ex.code();
        }
        catch (DynamicError ex) {
            actual = ex.code();
        }
        UserDefinedSITest.assertEquals((String)("XPath Result Error " + xqFile + ":"), (String)expectedResult, (String)actual);
    }

    private Schema loadSchema() throws SAXException {
        String schemaFile = "/TestSources/userdefined.xsd";
        XMLSchemaFactory schemaFactory = new XMLSchemaFactory();
        URL schemaURL = this.bundle.getEntry(schemaFile);
        Schema jaxpschema = schemaFactory.newSchema(schemaURL);
        return jaxpschema;
    }
}

