/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xml.ui.internal.dialogs;

import org.eclipse.core.runtime.IPath;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;
import org.eclipse.wst.xml.ui.internal.XMLUIMessages;
import org.eclipse.wst.xml.ui.internal.dialogs.EditEntityHelper;
import org.w3c.dom.DocumentType;

public class EditDoctypeDialog
extends Dialog {
    protected boolean computeSystemId;
    protected String[] doctypeData;
    protected boolean errorChecking;
    protected Label errorMessageLabel;
    protected Button okButton;
    protected Button publicIdBrowseButton;
    protected Text publicIdField;
    protected IPath resourceLocation;
    protected Text rootElementNameField;
    protected Button systemIdBrowseButton;
    protected Text systemIdField;

    public EditDoctypeDialog(Shell parentShell, DocumentType doctype) {
        this(parentShell, doctype.getName(), doctype.getPublicId(), doctype.getSystemId());
    }

    public EditDoctypeDialog(Shell parentShell, String name, String publicId, String systemId) {
        super(parentShell);
        this.setShellStyle(this.getShellStyle() | 0x10);
        this.doctypeData = new String[3];
        this.doctypeData[0] = name;
        this.doctypeData[1] = publicId;
        this.doctypeData[2] = systemId;
    }

    protected void buttonPressed(int buttonId) {
        this.doctypeData[0] = this.getModelValue(this.rootElementNameField.getText());
        this.doctypeData[1] = this.getModelValue(this.publicIdField.getText());
        this.doctypeData[2] = this.getModelValue(this.systemIdField.getText());
        super.buttonPressed(buttonId);
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.okButton = this.createButton(parent, 0, IDialogConstants.OK_LABEL, true);
        this.createButton(parent, 1, IDialogConstants.CANCEL_LABEL, false);
    }

    protected Control createContents(Composite parent) {
        Control control = super.createContents(parent);
        this.updateErrorMessage();
        return control;
    }

    protected Control createDialogArea(Composite parent) {
        Composite dialogControl = (Composite)super.createDialogArea(parent);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)dialogControl, "org.eclipse.wst.xml.ui.xcui0010");
        Composite composite = new Composite(dialogControl, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 3;
        layout.marginWidth = 0;
        composite.setLayout((Layout)layout);
        composite.setLayoutData((Object)new GridData(1808));
        ModifyListener modifyListener = new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                if (e.widget == EditDoctypeDialog.this.systemIdField) {
                    EditDoctypeDialog.this.computeSystemId = false;
                }
                EditDoctypeDialog.this.updateErrorMessage();
            }
        };
        Label rootElementNameLabel = new Label(composite, 0);
        rootElementNameLabel.setText(XMLUIMessages._UI_LABEL_ROOT_ELEMENT_NAME_COLON);
        this.rootElementNameField = new Text(composite, 2052);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)this.rootElementNameField, "org.eclipse.wst.xml.ui.xcui0020");
        GridData gd = new GridData(768);
        gd.widthHint = 200;
        this.rootElementNameField.setLayoutData((Object)gd);
        this.rootElementNameField.setText(this.getDisplayValue(this.doctypeData[0]));
        this.rootElementNameField.addModifyListener(modifyListener);
        Label placeHolder = new Label(composite, 0);
        placeHolder.setLayoutData((Object)new GridData());
        Label publicIdLabel = new Label(composite, 0);
        publicIdLabel.setText(XMLUIMessages._UI_LABEL_PUBLIC_ID_COLON);
        this.publicIdField = new Text(composite, 2052);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)this.publicIdField, "org.eclipse.wst.xml.ui.xcui0030");
        this.publicIdField.setLayoutData((Object)new GridData(768));
        this.publicIdField.setText(this.getDisplayValue(this.doctypeData[1]));
        SelectionAdapter selectionListener = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                EditEntityHelper helper = new EditEntityHelper();
                if (e.widget == EditDoctypeDialog.this.publicIdBrowseButton) {
                    helper.performBrowseForPublicId(EditDoctypeDialog.this.getShell(), EditDoctypeDialog.this.publicIdField, EditDoctypeDialog.this.computeSystemId ? EditDoctypeDialog.this.systemIdField : null);
                } else if (e.widget == EditDoctypeDialog.this.systemIdBrowseButton) {
                    helper.performBrowseForSystemId(EditDoctypeDialog.this.getShell(), EditDoctypeDialog.this.systemIdField, EditDoctypeDialog.this.resourceLocation);
                }
            }
        };
        this.publicIdBrowseButton = new Button(composite, 0);
        this.publicIdBrowseButton.setText(XMLUIMessages._UI_LABEL_BROWSE);
        this.publicIdBrowseButton.addSelectionListener((SelectionListener)selectionListener);
        Label systemIdLabel = new Label(composite, 0);
        systemIdLabel.setText(XMLUIMessages._UI_LABEL_SYSTEM_ID_COLON);
        this.systemIdField = new Text(composite, 2052);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)this.systemIdField, "org.eclipse.wst.xml.ui.xcui0050");
        this.systemIdField.setLayoutData((Object)new GridData(768));
        this.systemIdField.setText(this.getDisplayValue(this.doctypeData[2]));
        this.systemIdField.addModifyListener(modifyListener);
        this.systemIdBrowseButton = new Button(composite, 0);
        this.systemIdBrowseButton.setText(XMLUIMessages._UI_LABEL_BROWSE_1);
        this.systemIdBrowseButton.addSelectionListener((SelectionListener)selectionListener);
        this.errorMessageLabel = new Label(dialogControl, 0);
        this.errorMessageLabel.setText("");
        this.errorMessageLabel.setLayoutData((Object)new GridData(768));
        Color color = new Color((Device)this.errorMessageLabel.getDisplay(), 200, 0, 0);
        this.errorMessageLabel.setForeground(color);
        Dialog.applyDialogFont((Control)parent);
        return dialogControl;
    }

    protected Label createMessageArea(Composite composite) {
        Label label = new Label(composite, 0);
        return label;
    }

    protected String getDisplayValue(String string) {
        return string != null ? string : "";
    }

    public boolean getErrorChecking() {
        return this.errorChecking;
    }

    protected String getModelValue(String string) {
        String result = null;
        if (string != null && string.trim().length() > 0) {
            result = string;
        }
        return result;
    }

    public String getName() {
        return this.doctypeData[0];
    }

    public String getPublicId() {
        return this.doctypeData[1];
    }

    public String getSystemId() {
        return this.doctypeData[2];
    }

    public void setComputeSystemId(boolean computeSystemId) {
        this.computeSystemId = computeSystemId;
    }

    public void setErrorChecking(boolean errorChecking) {
        this.errorChecking = errorChecking;
    }

    public void setResourceLocation(IPath path) {
        this.resourceLocation = path;
    }

    public void updateErrorMessage() {
        if (this.errorChecking) {
            String errorMessage = null;
            if (this.getModelValue(this.systemIdField.getText()) == null) {
                errorMessage = XMLUIMessages._UI_WARNING_SYSTEM_ID_MUST_BE_SPECIFIED;
            } else if (this.getModelValue(this.rootElementNameField.getText()) == null) {
                errorMessage = XMLUIMessages._UI_WARNING_ROOT_ELEMENT_MUST_BE_SPECIFIED;
            }
            this.errorMessageLabel.setText(errorMessage != null ? errorMessage : "");
            this.okButton.setEnabled(errorMessage == null);
        }
    }
}

