/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.corext.refactoring.reorg;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.ChangeDescriptor;
import org.eclipse.ltk.core.refactoring.CompositeChange;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.core.refactoring.participants.CheckConditionsContext;
import org.eclipse.ltk.core.refactoring.participants.CopyProcessor;
import org.eclipse.ltk.core.refactoring.participants.RefactoringArguments;
import org.eclipse.ltk.core.refactoring.participants.RefactoringParticipant;
import org.eclipse.ltk.core.refactoring.participants.RefactoringProcessor;
import org.eclipse.ltk.core.refactoring.participants.ReorgExecutionLog;
import org.eclipse.ltk.core.refactoring.participants.SharableParticipants;
import org.eclipse.wst.jsdt.core.IJavaScriptElement;
import org.eclipse.wst.jsdt.core.JavaScriptModelException;
import org.eclipse.wst.jsdt.internal.corext.refactoring.JavaRefactoringArguments;
import org.eclipse.wst.jsdt.internal.corext.refactoring.RefactoringCoreMessages;
import org.eclipse.wst.jsdt.internal.corext.refactoring.changes.DynamicValidationStateChange;
import org.eclipse.wst.jsdt.internal.corext.refactoring.participants.JavaProcessors;
import org.eclipse.wst.jsdt.internal.corext.refactoring.participants.ResourceProcessors;
import org.eclipse.wst.jsdt.internal.corext.refactoring.reorg.INewNameQueries;
import org.eclipse.wst.jsdt.internal.corext.refactoring.reorg.IReorgDestinationValidator;
import org.eclipse.wst.jsdt.internal.corext.refactoring.reorg.IReorgPolicy;
import org.eclipse.wst.jsdt.internal.corext.refactoring.reorg.IReorgQueries;
import org.eclipse.wst.jsdt.internal.corext.refactoring.reorg.LoggedNewNameQueries;
import org.eclipse.wst.jsdt.internal.corext.refactoring.reorg.MonitoringNewNameQueries;
import org.eclipse.wst.jsdt.internal.corext.refactoring.reorg.NullReorgQueries;
import org.eclipse.wst.jsdt.internal.corext.refactoring.reorg.ParentChecker;
import org.eclipse.wst.jsdt.internal.corext.refactoring.reorg.ReorgPolicyFactory;
import org.eclipse.wst.jsdt.internal.corext.refactoring.reorg.ReorgUtils;
import org.eclipse.wst.jsdt.internal.corext.refactoring.tagging.ICommentProvider;
import org.eclipse.wst.jsdt.internal.corext.refactoring.tagging.IScriptableRefactoring;
import org.eclipse.wst.jsdt.internal.corext.util.Resources;

public final class JavaCopyProcessor
extends CopyProcessor
implements IReorgDestinationValidator,
IScriptableRefactoring,
ICommentProvider {
    public static final String IDENTIFIER = "org.eclipse.wst.jsdt.ui.CopyProcessor";
    private String fComment;
    private IReorgPolicy.ICopyPolicy fCopyPolicy;
    private ReorgExecutionLog fExecutionLog;
    private INewNameQueries fNewNameQueries;
    private IReorgQueries fReorgQueries;

    public JavaCopyProcessor(IReorgPolicy.ICopyPolicy copyPolicy) {
        this.fCopyPolicy = copyPolicy;
    }

    @Override
    public boolean canChildrenBeDestinations(IJavaScriptElement javaElement) {
        return this.fCopyPolicy.canChildrenBeDestinations(javaElement);
    }

    @Override
    public boolean canChildrenBeDestinations(IResource resource) {
        return this.fCopyPolicy.canChildrenBeDestinations(resource);
    }

    @Override
    public boolean canElementBeDestination(IJavaScriptElement javaElement) {
        return this.fCopyPolicy.canElementBeDestination(javaElement);
    }

    @Override
    public boolean canElementBeDestination(IResource resource) {
        return this.fCopyPolicy.canElementBeDestination(resource);
    }

    @Override
    public boolean canEnableComment() {
        return true;
    }

    public RefactoringStatus checkFinalConditions(IProgressMonitor pm, CheckConditionsContext context) throws CoreException {
        Assert.isNotNull((Object)this.fNewNameQueries, (String)"Missing new name queries");
        Assert.isNotNull((Object)this.fReorgQueries, (String)"Missing reorg queries");
        pm.beginTask("", 2);
        RefactoringStatus result = this.fCopyPolicy.checkFinalConditions((IProgressMonitor)new SubProgressMonitor(pm, 1), context, this.fReorgQueries);
        result.merge(context.check((IProgressMonitor)new SubProgressMonitor(pm, 1)));
        return result;
    }

    public RefactoringStatus checkInitialConditions(IProgressMonitor pm) throws CoreException {
        RefactoringStatus result = new RefactoringStatus();
        result.merge(RefactoringStatus.create((IStatus)Resources.checkInSync(ReorgUtils.getNotNulls(this.fCopyPolicy.getResources()))));
        IResource[] javaResources = ReorgUtils.getResources(this.fCopyPolicy.getJavaElements());
        result.merge(RefactoringStatus.create((IStatus)Resources.checkInSync(ReorgUtils.getNotNulls(javaResources))));
        return result;
    }

    public Change createChange(IProgressMonitor pm) throws CoreException {
        Assert.isNotNull((Object)this.fNewNameQueries);
        Assert.isTrue((this.fCopyPolicy.getJavaElementDestination() == null || this.fCopyPolicy.getResourceDestination() == null ? 1 : 0) != 0);
        Assert.isTrue((this.fCopyPolicy.getJavaElementDestination() != null || this.fCopyPolicy.getResourceDestination() != null ? 1 : 0) != 0);
        try {
            DynamicValidationStateChange result = new DynamicValidationStateChange(this.getChangeName()){

                public Object getAdapter(Class adapter) {
                    if (ReorgExecutionLog.class.equals((Object)adapter)) {
                        return JavaCopyProcessor.this.fExecutionLog;
                    }
                    return super.getAdapter(adapter);
                }

                public ChangeDescriptor getDescriptor() {
                    return JavaCopyProcessor.this.fCopyPolicy.getDescriptor();
                }

                @Override
                public Change perform(IProgressMonitor pm2) throws CoreException {
                    try {
                        super.perform(pm2);
                    }
                    catch (OperationCanceledException e) {
                        JavaCopyProcessor.this.fExecutionLog.markAsCanceled();
                        throw e;
                    }
                    return null;
                }
            };
            Change change = this.fCopyPolicy.createChange(pm, new MonitoringNewNameQueries(this.fNewNameQueries, this.fExecutionLog));
            if (change instanceof CompositeChange) {
                CompositeChange subComposite = (CompositeChange)change;
                result.merge(subComposite);
            } else {
                result.add(change);
            }
            DynamicValidationStateChange dynamicValidationStateChange = result;
            return dynamicValidationStateChange;
        }
        finally {
            pm.done();
        }
    }

    private String[] getAffectedProjectNatures() throws CoreException {
        String[] jNatures = JavaProcessors.computeAffectedNaturs(this.fCopyPolicy.getJavaElements());
        String[] rNatures = ResourceProcessors.computeAffectedNatures(this.fCopyPolicy.getResources());
        HashSet<String> result = new HashSet<String>();
        result.addAll(Arrays.asList(jNatures));
        result.addAll(Arrays.asList(rNatures));
        return result.toArray(new String[result.size()]);
    }

    private String getChangeName() {
        return RefactoringCoreMessages.JavaCopyProcessor_changeName;
    }

    @Override
    public String getComment() {
        return this.fComment;
    }

    public Object getCommonParentForInputElements() {
        return new ParentChecker(this.fCopyPolicy.getResources(), this.fCopyPolicy.getJavaElements()).getCommonParent();
    }

    public Object[] getElements() {
        IJavaScriptElement[] jElements = this.fCopyPolicy.getJavaElements();
        IResource[] resources = this.fCopyPolicy.getResources();
        ArrayList<Object> result = new ArrayList<Object>(jElements.length + resources.length);
        result.addAll(Arrays.asList(jElements));
        result.addAll(Arrays.asList(resources));
        return result.toArray();
    }

    public String getIdentifier() {
        return IDENTIFIER;
    }

    public IJavaScriptElement[] getJavaElements() {
        return this.fCopyPolicy.getJavaElements();
    }

    public String getProcessorName() {
        return RefactoringCoreMessages.JavaCopyProcessor_processorName;
    }

    public IResource[] getResources() {
        return this.fCopyPolicy.getResources();
    }

    @Override
    public RefactoringStatus initialize(RefactoringArguments arguments) {
        this.setReorgQueries(new NullReorgQueries());
        RefactoringStatus status = new RefactoringStatus();
        if (arguments instanceof JavaRefactoringArguments) {
            JavaRefactoringArguments extended = (JavaRefactoringArguments)arguments;
            this.fCopyPolicy = ReorgPolicyFactory.createCopyPolicy(status, extended);
            if (this.fCopyPolicy != null && !status.hasFatalError()) {
                ReorgExecutionLog log;
                status.merge(this.fCopyPolicy.initialize(arguments));
                if (!status.hasFatalError() && (log = ReorgPolicyFactory.loadReorgExecutionLog(status, extended)) != null && !status.hasFatalError()) {
                    this.setNewNameQueries(new LoggedNewNameQueries(log));
                }
            }
        } else {
            return RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.InitializableRefactoring_inacceptable_arguments);
        }
        return status;
    }

    public boolean isApplicable() throws CoreException {
        return this.fCopyPolicy.canEnable();
    }

    public RefactoringParticipant[] loadParticipants(RefactoringStatus status, SharableParticipants sharedParticipants) throws CoreException {
        RefactoringParticipant[] result = this.fCopyPolicy.loadParticipants(status, (RefactoringProcessor)this, this.getAffectedProjectNatures(), sharedParticipants);
        this.fExecutionLog = this.fCopyPolicy.getReorgExecutionLog();
        return result;
    }

    @Override
    public void setComment(String comment) {
        this.fComment = comment;
    }

    public RefactoringStatus setDestination(IJavaScriptElement destination) throws JavaScriptModelException {
        return this.fCopyPolicy.setDestination(destination);
    }

    public RefactoringStatus setDestination(IResource destination) throws JavaScriptModelException {
        return this.fCopyPolicy.setDestination(destination);
    }

    public void setNewNameQueries(INewNameQueries newNameQueries) {
        Assert.isNotNull((Object)newNameQueries);
        this.fNewNameQueries = newNameQueries;
    }

    public void setReorgQueries(IReorgQueries queries) {
        Assert.isNotNull((Object)queries);
        this.fReorgQueries = queries;
    }
}

