/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.common.utility.internal.command;

import org.eclipse.jpt.common.utility.command.InterruptibleCommand;
import org.eclipse.jpt.common.utility.internal.ObjectTools;

public class RepeatingInterruptibleCommand
implements InterruptibleCommand {
    private final int count;
    private final InterruptibleCommand command;

    public RepeatingInterruptibleCommand(InterruptibleCommand command, int count) {
        if (command == null) {
            throw new NullPointerException();
        }
        if (count <= 0) {
            throw new IndexOutOfBoundsException("invalid count: " + count);
        }
        this.command = command;
        this.count = count;
    }

    @Override
    public void execute() throws InterruptedException {
        int i = this.count;
        while (i-- > 0) {
            this.command.execute();
        }
    }

    public String toString() {
        return ObjectTools.toString((Object)this, this.command);
    }
}

