/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.core.tests.compiler.regression;

import java.util.Map;
import junit.framework.Test;
import org.eclipse.wst.jsdt.core.tests.compiler.regression.JavadocTest;

public class JavadocTestForMethod
extends JavadocTest {
    public JavadocTestForMethod(String name) {
        super(name);
    }

    public static Class javadocTestClass() {
        return JavadocTestForMethod.class;
    }

    public static Test suite() {
        return JavadocTestForMethod.buildAllCompliancesTestSuite(JavadocTestForMethod.javadocTestClass());
    }

    @Override
    protected Map getCompilerOptions() {
        Map options = super.getCompilerOptions();
        options.put("org.eclipse.wst.jsdt.core.compiler.problem.invalidJavadoc", "error");
        options.put("org.eclipse.wst.jsdt.core.compiler.problem.invalidJavadocTagsVisibility", "private");
        options.put("org.eclipse.wst.jsdt.core.compiler.problem.missingJavadocTags", "error");
        options.put("org.eclipse.wst.jsdt.core.compiler.problem.missingJavadocTagsVisibility", "private");
        options.put("org.eclipse.wst.jsdt.core.compiler.problem.rawTypeReference", "ignore");
        return options;
    }

    public void test001() {
        this.runNegativeTest(new String[]{"X.java", "\tfoo();\n  /** \n   * \n   * ** \f  ** ** ** @deprecated */\n\tfunction foo() { \n\t}\n"}, "----------\n1. WARNING in X.java (at line 1)\n\tfoo();\n\t^^^^^\nThe function foo() from the type X.java is deprecated\n----------\n");
    }

    public void test002() {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n\t/** @deprecated */\n\tint x;\n\t/**\n\t * @see #x\n\t */\n\tvoid foo() {\n\t}\n}\n", "Y.java", "/** @deprecated */\npublic class Y {\n\tint y;\n\t/**\n\t * @see X#x\n\t * @see Y\n\t * @see Y#y\n\t */\n\tvoid foo() {\n\t}\n}\n", "Z.java", "public class Z {\n\tint z;\n\t/**\n\t * @see X#x\n\t * @see Y\n\t * @see Y#y\n\t */\n\tvoid foo() {\n\t}\n}\n"}, "----------\n1. ERROR in Z.java (at line 4)\n\t* @see X#x\n\t         ^\nJavadoc: The field X.x is deprecated\n----------\n2. ERROR in Z.java (at line 5)\n\t* @see Y\n\t       ^\nJavadoc: The type Y is deprecated\n----------\n3. ERROR in Z.java (at line 6)\n\t* @see Y#y\n\t       ^\nJavadoc: The type Y is deprecated\n----------\n4. ERROR in Z.java (at line 6)\n\t* @see Y#y\n\t         ^\nJavadoc: The field Y.y is deprecated\n----------\n");
    }

    public void test003() {
        this.runNegativeTest(new String[]{"X.js", "\t\tfoo(2);\n  /** \n   * Valid tags with deprecation at end\n   *\n   * @param x Valid param tag\n   * @return Valid return tag\n   * @throws NullPointerException Valid throws tag\n   * @exception IllegalArgumentException Valid throws tag\n   * @see X Valid see tag\n   * @deprecated\n   */\n\tfunction foo( x) { \n\t\treturn \"\";\n\t}\n"}, "----------\n1. WARNING in X.js (at line 1)\n\tfoo(2);\n\t^^^^^^\nThe function foo(any) from the type X.js is deprecated\n----------\n");
    }

    public void test004() {
        this.runNegativeTest(new String[]{"X.js", "public class X {\n\t\n\t{\n\t\tnew Z().foo(2);\n\t}\n}\n", "Z.js", "public class Z {\n  /** \n   * Invalid javadoc tags with valid deprecation at end\n   *\n   * @param\n   * @return String\n   * @throws Unknown\n   * @see \"Invalid\n   * @see Unknown\n   * @param x\n   * @deprecated\n   */\n\tpublic String foo(int x) { \n\t\treturn \"\";\n\t}\n}\n"}, "----------\n1. WARNING in X.java (at line 4)\n\tnew Z().foo(2);\n\t^^^^^^^^^^^^^^\nThe method foo(int) from the type Z is deprecated\n----------\n----------\n1. ERROR in Z.java (at line 5)\n\t* @param\n\t   ^^^^^\nJavadoc: Missing parameter name\n----------\n2. ERROR in Z.java (at line 7)\n\t* @throws Unknown\n\t          ^^^^^^^\nJavadoc: Unknown cannot be resolved to a type\n----------\n3. ERROR in Z.java (at line 8)\n\t* @see \"Invalid\n\t       ^^^^^^^^\nJavadoc: Invalid reference\n----------\n4. ERROR in Z.java (at line 9)\n\t* @see Unknown\n\t       ^^^^^^^\nJavadoc: Unknown cannot be resolved to a type\n----------\n5. ERROR in Z.java (at line 10)\n\t* @param x\n\t   ^^^^^\nJavadoc: Unexpected tag\n----------\n6. ERROR in Z.java (at line 13)\n\tpublic String foo(int x) { \n\t                      ^\nJavadoc: Missing tag for parameter x\n----------\n");
    }

    public void test005() {
        this.runNegativeTest(new String[]{"X.js", "public class X {\n\t\n\t{\n\t\tnew Z().foo(2);\n\t}\n}\n", "Z.js", "public class Z {\n  /** \n   * Valid tags with deprecation at beginning\n   *\n   * @deprecated\n   * @param x Valid param tag\n   * @return Valid return tag\n   * @exception IllegalArgumentException Valid throws tag\n   * @throws NullPointerException Valid throws tag\n   * @see X Valid see tag\n   */\n\tpublic String foo(int x) { \n\t\treturn \"\";\n\t}\n}\n"}, "----------\n1. WARNING in X.java (at line 4)\n\tnew Z().foo(2);\n\t^^^^^^^^^^^^^^\nThe method foo(int) from the type Z is deprecated\n----------\n");
    }

    public void test006() {
        this.runNegativeTest(new String[]{"X.js", "public class X {\n\t\n\t{\n\t\tnew Z().foo(2);\n\t}\n}\n", "Z.js", "public class Z {\n  /** \n   * Invalid javadoc tags with valid deprecation at beginning\n   *\n   * @deprecated\n   * @param\n   * @return String\n   * @throws Unknown\n   * @exception IllegalArgumentException Valid throws tag\n   * @see \"Invalid\n   * @see Unknown\n   * @param x\n   */\n\tpublic String foo(int x) { \n\t\treturn \"\";\n\t}\n}\n"}, "----------\n1. WARNING in X.java (at line 4)\n\tnew Z().foo(2);\n\t^^^^^^^^^^^^^^\nThe method foo(int) from the type Z is deprecated\n----------\n----------\n1. ERROR in Z.java (at line 6)\n\t* @param\n\t   ^^^^^\nJavadoc: Missing parameter name\n----------\n2. ERROR in Z.java (at line 8)\n\t* @throws Unknown\n\t          ^^^^^^^\nJavadoc: Unknown cannot be resolved to a type\n----------\n3. ERROR in Z.java (at line 10)\n\t* @see \"Invalid\n\t       ^^^^^^^^\nJavadoc: Invalid reference\n----------\n4. ERROR in Z.java (at line 11)\n\t* @see Unknown\n\t       ^^^^^^^\nJavadoc: Unknown cannot be resolved to a type\n----------\n5. ERROR in Z.java (at line 12)\n\t* @param x\n\t   ^^^^^\nJavadoc: Unexpected tag\n----------\n6. ERROR in Z.java (at line 14)\n\tpublic String foo(int x) { \n\t                      ^\nJavadoc: Missing tag for parameter x\n----------\n");
    }

    public void test007() {
        this.runNegativeTest(new String[]{"X.js", "public class X {\n\t\n\t{\n\t\tnew Z().foo(2);\n\t}\n}\n", "Z.js", "public class Z {\n  /** \n   * Valid tags with deprecation in the middle\n   *\n   * @param x Valid param tag\n   * @return Valid return tag\n   * @deprecated\n   * @exception IllegalArgumentException Valid throws tag\n   * @throws NullPointerException Valid throws tag\n   * @see X Valid see tag\n   */\n\tpublic String foo(int x) { \n\t\treturn \"\";\n\t}\n}\n"}, "----------\n1. WARNING in X.java (at line 4)\n\tnew Z().foo(2);\n\t^^^^^^^^^^^^^^\nThe method foo(int) from the type Z is deprecated\n----------\n");
    }

    public void test008() {
        this.runNegativeTest(new String[]{"X.js", "public class X {\n\t\n\t{\n\t\tnew Z().foo(2);\n\t}\n}\n", "Z.js", "public class Z {\n  /** \n   * Invalid javadoc tags with valid deprecation in the middle\n   *\n   * @param\n   * @return String\n   * @throws Unknown\n   * @exception IllegalArgumentException Valid throws tag\n   * @see \"Invalid\n   * @deprecated\n   * @see Unknown\n   */\n\tpublic String foo(int x) { \n\t\treturn \"\";\n\t}\n}\n"}, "----------\n1. WARNING in X.java (at line 4)\n\tnew Z().foo(2);\n\t^^^^^^^^^^^^^^\nThe method foo(int) from the type Z is deprecated\n----------\n----------\n1. ERROR in Z.java (at line 5)\n\t* @param\n\t   ^^^^^\nJavadoc: Missing parameter name\n----------\n2. ERROR in Z.java (at line 7)\n\t* @throws Unknown\n\t          ^^^^^^^\nJavadoc: Unknown cannot be resolved to a type\n----------\n3. ERROR in Z.java (at line 9)\n\t* @see \"Invalid\n\t       ^^^^^^^^\nJavadoc: Invalid reference\n----------\n4. ERROR in Z.java (at line 11)\n\t* @see Unknown\n\t       ^^^^^^^\nJavadoc: Unknown cannot be resolved to a type\n----------\n5. ERROR in Z.java (at line 13)\n\tpublic String foo(int x) { \n\t                      ^\nJavadoc: Missing tag for parameter x\n----------\n");
    }

    public void test011() {
        this.runConformTest(new String[]{"X.js", "public class X {\n\t/**\n\t * Valid @param: no tags, no args\n\t * Valid @throws/@exception: no tags, no thrown exception\n\t */\n\tpublic void p_foo() {\n\t}\n}\n"});
    }

    public void test012() {
        this.runConformTest(new String[]{"X.js", "public class X {\n\tpublic void p_foo() {\n\t}\n}\n"});
    }

    public void test013() {
        this.runNegativeTest(new String[]{"X.js", "public class X {\n\t/**\n\t * Invalid @param declaration: no arguments, 2 declared tags\n\t * @param x\n\t * \t\t\tInvalid param: not an argument on 2 lines\n\t * @param x Invalid param: not an argument\n\t */\n\tpublic void p_foo() {\n\t}\n}\n"}, "----------\n1. ERROR in X.java (at line 4)\n\t* @param x\n\t         ^\nJavadoc: Parameter x is not declared\n----------\n2. ERROR in X.java (at line 6)\n\t* @param x Invalid param: not an argument\n\t         ^\nJavadoc: Parameter x is not declared\n----------\n");
    }

    public void test014() {
        this.runConformTest(new String[]{"X.js", "public class X {\n\t\n\t/**\n\t * Valid @param declaration: 3 arguments, 3 tags in right order\n\t * @param a Valid param\n\t * @param b Valid param \n\t * @param c Valid param\n\t */\n\tpublic void p_foo(int a, int b, int c) {\n\t}\n}\n"});
    }

    public void test015() {
        this.runNegativeTest(new String[]{"X.js", "public class X {\n\t/**\n\t * Invalid @param declaration: 3 arguments, 3 correct tags in right order + 2 additional\n\t * @param a Valid param\n\t * @param x Invalid param: not an argument\n\t * @param b Valid param \n\t * @param x Invalid param: not an argument\n\t * @param c Valid param\n\t */\n\tpublic void p_foo(char a, char b, char c) {\n\t}\n}\n"}, "----------\n1. ERROR in X.java (at line 5)\n\t* @param x Invalid param: not an argument\n\t         ^\nJavadoc: Parameter x is not declared\n----------\n2. ERROR in X.java (at line 7)\n\t* @param x Invalid param: not an argument\n\t         ^\nJavadoc: Parameter x is not declared\n----------\n");
    }

    public void test016() {
        this.runConformTest(new String[]{"X.js", "public class X {\n\t/**\n\t * Valid @param declaration: 3 arguments, 3 tags in wrong order\n\t * @param c Valid param, not well placed\n\t * @param b Valid param, not well placed \n\t * @param a Valid param, not well placed\n\t */\n\tpublic void p_foo(long a, long b, long c) {\n\t}\n}\n"});
    }

    public void test017() {
        this.runNegativeTest(new String[]{"X.js", "public class X {\n\t/**\n\t * Invalid @param declaration: 3 arguments, 3 correct tags in wrong order + 1 duplicate tag + 1 additional\n\t * @param c Valid param, not well placed\n\t * @param a Valid param, not well placed\n\t * @param b Valid param, not well placed \n\t * @param a Invalid param: duplicated\n\t * @param x Invalid param: not an argument\n\t */\n\tpublic void p_foo(float a, float b, float c) {\n\t}\n}\n"}, "----------\n1. ERROR in X.java (at line 7)\n\t* @param a Invalid param: duplicated\n\t         ^\nJavadoc: Duplicate tag for parameter\n----------\n2. ERROR in X.java (at line 8)\n\t* @param x Invalid param: not an argument\n\t         ^\nJavadoc: Parameter x is not declared\n----------\n");
    }

    public void test020() {
        this.runNegativeTest(new String[]{"X.js", "public class X {\n\t/**\n\t * Invalid @param: all arguments are not documented\n\t */\n\tpublic void p_foo(double a, double b, double c) {\n\t}\n}\n"}, "----------\n1. ERROR in X.java (at line 5)\n\tpublic void p_foo(double a, double b, double c) {\n\t                         ^\nJavadoc: Missing tag for parameter a\n----------\n2. ERROR in X.java (at line 5)\n\tpublic void p_foo(double a, double b, double c) {\n\t                                   ^\nJavadoc: Missing tag for parameter b\n----------\n3. ERROR in X.java (at line 5)\n\tpublic void p_foo(double a, double b, double c) {\n\t                                             ^\nJavadoc: Missing tag for parameter c\n----------\n");
    }

    public void test021() {
        this.runNegativeTest(new String[]{"X.js", "public class X {\n\t/**\n\t * Invalid @param: b and c arguments are not documented\n\t * @param a Valid param\n\t */\n\tpublic void p_foo(int a, char b, long c) {\n\t}\n}\n"}, "----------\n1. ERROR in X.java (at line 6)\n\tpublic void p_foo(int a, char b, long c) {\n\t                              ^\nJavadoc: Missing tag for parameter b\n----------\n2. ERROR in X.java (at line 6)\n\tpublic void p_foo(int a, char b, long c) {\n\t                                      ^\nJavadoc: Missing tag for parameter c\n----------\n");
    }

    public void test022() {
        this.runNegativeTest(new String[]{"X.js", "public class X {\n\t/**\n\t * Invalid @param: a and c arguments are not documented\n\t * @param b Valid param\n\t */\n\tpublic void p_foo(int a, char b, long c) {\n\t}\n}\n"}, "----------\n1. ERROR in X.java (at line 6)\n\tpublic void p_foo(int a, char b, long c) {\n\t                      ^\nJavadoc: Missing tag for parameter a\n----------\n2. ERROR in X.java (at line 6)\n\tpublic void p_foo(int a, char b, long c) {\n\t                                      ^\nJavadoc: Missing tag for parameter c\n----------\n");
    }

    public void test023() {
        this.runNegativeTest(new String[]{"X.js", "public class X {\n\t/**\n\t * Invalid @param: a and b arguments are not documented\n\t * @param c Valid param\n\t */\n\tpublic void p_foo(int a, char b, long c) {\n\t}\n}\n"}, "----------\n1. ERROR in X.java (at line 6)\n\tpublic void p_foo(int a, char b, long c) {\n\t                      ^\nJavadoc: Missing tag for parameter a\n----------\n2. ERROR in X.java (at line 6)\n\tpublic void p_foo(int a, char b, long c) {\n\t                              ^\nJavadoc: Missing tag for parameter b\n----------\n");
    }

    public void test024() {
        this.runNegativeTest(new String[]{"X.js", "public class X {\n\t/**\n\t * Invalid @param: c argument is not documented\n\t * @param a Valid param\n\t * @param b Valid param\n\t */\n\tpublic void p_foo(int a, char b, long c) {\n\t}\n}\n"}, "----------\n1. ERROR in X.java (at line 7)\n\tpublic void p_foo(int a, char b, long c) {\n\t                                      ^\nJavadoc: Missing tag for parameter c\n----------\n");
    }

    public void test025() {
        this.runNegativeTest(new String[]{"X.js", "public class X {\n\t/**\n\t * Invalid @param: a argument is not documented + b and c are not well placed\n\t * @param c Valid param\n\t * @param b Valid param\n\t */\n\tpublic void p_foo(int a, char b, long c) {\n\t}\n}\n"}, "----------\n1. ERROR in X.java (at line 7)\n\tpublic void p_foo(int a, char b, long c) {\n\t                      ^\nJavadoc: Missing tag for parameter a\n----------\n");
    }

    public void test026() {
        this.runNegativeTest(new String[]{"X.js", "public class X {\n\t/**\n\t * Invalid @param: b argument is not documented + a and c are not well placed\n\t * @param c Valid param\n\t * @param a Valid param\n\t */\n\tpublic void p_foo(int a, char b, long c) {\n\t}\n}\n"}, "----------\n1. ERROR in X.java (at line 7)\n\tpublic void p_foo(int a, char b, long c) {\n\t                              ^\nJavadoc: Missing tag for parameter b\n----------\n");
    }

    public void test030() {
        this.runNegativeTest(new String[]{"X.js", "public class X {\n\t/**\n\t * Invalid @param: mix of all possible errors (missing a, not argument tag and duplicated)\n\t * @param c Valid param\n\t * @param x Invalid param: not an argument\n\t * @param b Valid param\n\t * @param c Invalid param: duplicated\n\t */\n\tpublic void p_foo(double a, long b, int c) {\n\t}\n}\n"}, "----------\n1. ERROR in X.java (at line 5)\n\t* @param x Invalid param: not an argument\n\t         ^\nJavadoc: Parameter x is not declared\n----------\n2. ERROR in X.java (at line 7)\n\t* @param c Invalid param: duplicated\n\t         ^\nJavadoc: Duplicate tag for parameter\n----------\n3. ERROR in X.java (at line 9)\n\tpublic void p_foo(double a, long b, int c) {\n\t                         ^\nJavadoc: Missing tag for parameter a\n----------\n");
    }

    public void test031() {
        this.runNegativeTest(new String[]{"X.js", "public class X {\n\t/**\n\t * Invalid @param: missing parameter name\n\t * @param\n\t */\n\tpublic void p_foo(String a) {\n\t}\n}\n"}, "----------\n1. ERROR in X.java (at line 4)\n\t* @param\n\t   ^^^^^\nJavadoc: Missing parameter name\n----------\n2. ERROR in X.java (at line 6)\n\tpublic void p_foo(String a) {\n\t                         ^\nJavadoc: Missing tag for parameter a\n----------\n");
    }

    public void test032() {
        this.runNegativeTest(new String[]{"X.js", "public class X {\n\t/**\n\t * Invalid @param: missing parameter name + valid param \n\t * @param\n\t * @param x\n\t */\n\tpublic void p_foo(int x) {\n\t}\n}\n"}, "----------\n1. ERROR in X.java (at line 4)\n\t* @param\n\t   ^^^^^\nJavadoc: Missing parameter name\n----------\n");
    }

    public void test033() {
        this.runNegativeTest(new String[]{"X.js", "public class X {\n\t/**\n\t * Invalid @param: missing parameter names + valid params \n\t * @param h\n\t * @param\n\t * @param h\n\t * @param\n\t */\n\tpublic void p_foo(java.util.Hashtable h, float f) {\n\t}\n}\n"}, "----------\n1. ERROR in X.java (at line 5)\n\t* @param\n\t   ^^^^^\nJavadoc: Missing parameter name\n----------\n2. ERROR in X.java (at line 6)\n\t* @param h\n\t         ^\nJavadoc: Duplicate tag for parameter\n----------\n3. ERROR in X.java (at line 7)\n\t* @param\n\t   ^^^^^\nJavadoc: Missing parameter name\n----------\n4. ERROR in X.java (at line 9)\n\tpublic void p_foo(java.util.Hashtable h, float f) {\n\t                                               ^\nJavadoc: Missing tag for parameter f\n----------\n");
    }

    public void test034() {
        this.runNegativeTest(new String[]{"X.js", "public class X {\n\t/**\n\t * Invalid @param: missing parameter name + valid param \n\t * @param *\n\t * @param ?\n\t */\n\tpublic void p_foo(int x) {\n\t}\n}\n"}, "----------\n1. ERROR in X.java (at line 4)\n\t* @param *\n\t         ^\nJavadoc: Invalid param tag name\n----------\n2. ERROR in X.java (at line 5)\n\t* @param ?\n\t         ^\nJavadoc: Invalid param tag name\n----------\n3. ERROR in X.java (at line 7)\n\tpublic void p_foo(int x) {\n\t                      ^\nJavadoc: Missing tag for parameter x\n----------\n");
    }

    public void test035() {
        this.runNegativeTest(new String[]{"X.js", "public class X {\n\t/**\n\t * Valid @param but compiler errors\n\t * @param a Valid param\n\t * @param b Valid param\n\t * @param c Valid param\n\t */\n\tpublic void p_foo(inr a, int b, int c) {\n\t}\n}\n"}, "----------\n1. ERROR in X.java (at line 8)\n\tpublic void p_foo(inr a, int b, int c) {\n\t                  ^^^\ninr cannot be resolved to a type\n----------\n");
    }

    public void test036() {
        this.runNegativeTest(new String[]{"X.js", "public class X {\n\t/**\n\t * Invalid @param + compiler errors\n\t * @param b Valid param\n\t * @param b Valid param\n\t * @param c Valid param\n\t */\n\tpublic void p_foo(inr a, inx b, inq c) {\n\t}\n}\n"}, "----------\n1. ERROR in X.java (at line 8)\n\tpublic void p_foo(inr a, inx b, inq c) {\n\t                  ^^^\ninr cannot be resolved to a type\n----------\n2. ERROR in X.java (at line 8)\n\tpublic void p_foo(inr a, inx b, inq c) {\n\t                         ^^^\ninx cannot be resolved to a type\n----------\n3. ERROR in X.java (at line 8)\n\tpublic void p_foo(inr a, inx b, inq c) {\n\t                                ^^^\ninq cannot be resolved to a type\n----------\n");
    }

    public void test037() {
        this.runNegativeTest(new String[]{"X.js", "public class X {\n\t/**\n\t * Invalid @param: class reference instead of param name\n\t * @param java.lang.Hashtable\n\t */\n\tpublic void p_foo(int x) {\n\t}\n}\n"}, "----------\n1. ERROR in X.java (at line 4)\n\t* @param java.lang.Hashtable\n\t         ^^^^^^^^^^^^^^^^^^^\nJavadoc: Invalid param tag name\n----------\n2. ERROR in X.java (at line 6)\n\tpublic void p_foo(int x) {\n\t                      ^\nJavadoc: Missing tag for parameter x\n----------\n");
    }

    public void test038() {
        this.runNegativeTest(new String[]{"X.js", "import java.util.Hashtable;\npublic class X {\n\t/**\n\t * Invalid @param: class reference instead of param name + unused import\n\t * @param Hashtable\n\t */\n\tpublic void p_foo(int x) {\n\t}\n}\n"}, "----------\n1. ERROR in X.java (at line 5)\n\t* @param Hashtable\n\t         ^^^^^^^^^\nJavadoc: Parameter Hashtable is not declared\n----------\n2. ERROR in X.java (at line 7)\n\tpublic void p_foo(int x) {\n\t                      ^\nJavadoc: Missing tag for parameter x\n----------\n");
    }

    public void test050() {
        this.runConformTest(new String[]{"X.js", "public class X {\n\t/**\n\t * Valid @throws tags: documented exception are unchecked\n\t * @throws IllegalArgumentException Valid unchecked exception (java.lang.Runtime subclass)\n\t * @exception NullPointerException Valid unchecked exception (java.lang.Runtime subclass)\n\t * @throws java.awt.AWTError Valid unchecked exception (java.lang.Error subclass)\n\t * @exception OutOfMemoryError Valid unchecked exception (java.lang.Runtime subclass)\n\t */\n\tpublic void t_foo() {\n\t}\n}\n"});
    }

    public void test051() {
        this.runNegativeTest(new String[]{"X.js", "public class X {\n\t/**\n\t * @throws IllegalArgumenException.. Invalid exception: invalid class name\n\t * @exception IllegalArgumen..Exception.. Invalid exception: invalid class name\n\t */\n\tpublic void t_foo() {\n\t}\n}\n"}, "----------\n1. ERROR in X.java (at line 3)\n\t* @throws IllegalArgumenException.. Invalid exception: invalid class name\n\t         ^^^^^^^^^^^^^^^^^^^^^^^^^^\nJavadoc: Invalid class name\n----------\n2. ERROR in X.java (at line 4)\n\t* @exception IllegalArgumen..Exception.. Invalid exception: invalid class name\n\t            ^^^^^^^^^^^^^^^^^\nJavadoc: Invalid class name\n----------\n");
    }

    public void test052() {
        this.runNegativeTest(new String[]{"X.js", "public class X {\n\t/**\n\t * @throws java.awt.AWTexception Invalid exception: unknown type\n\t * @throws IOException Invalid exception: unknown type\n\t */\n\tpublic void t_foo() {\n\t}\n}\n"}, "----------\n1. ERROR in X.java (at line 3)\n\t* @throws java.awt.AWTexception Invalid exception: unknown type\n\t          ^^^^^^^^^^^^^^^^^^^^^\nJavadoc: java.awt.AWTexception cannot be resolved to a type\n----------\n2. ERROR in X.java (at line 4)\n\t* @throws IOException Invalid exception: unknown type\n\t          ^^^^^^^^^^^\nJavadoc: IOException cannot be resolved to a type\n----------\n");
    }

    public void test053() {
        this.runNegativeTest(new String[]{"X.js", "import java.io.FileNotFoundException;\npublic class X {\n\t/**\n\t * @throws java.io.EOFException Invalid exception: known exception but neither thrown nor unchecked\n\t * @throws FileNotFoundException Invalid exception: known exception but neither thrown nor unchecked\n\t */\n\tpublic void t_foo() {\n\t}\n}\n"}, "----------\n1. ERROR in X.java (at line 4)\n\t* @throws java.io.EOFException Invalid exception: known exception but neither thrown nor unchecked\n\t          ^^^^^^^^^^^^^^^^^^^^\nJavadoc: Exception EOFException is not declared\n----------\n2. ERROR in X.java (at line 5)\n\t* @throws FileNotFoundException Invalid exception: known exception but neither thrown nor unchecked\n\t          ^^^^^^^^^^^^^^^^^^^^^\nJavadoc: Exception FileNotFoundException is not declared\n----------\n");
    }

    public void test055() {
        this.runNegativeTest(new String[]{"X.js", "public class X {\n\t/**\n\t * Valid @throws tags: documented exception are unchecked but method throws an unknown exception\n\t * @throws IllegalArgumentException Valid unchecked exception (java.lang.Runtime subclass)\n\t * @exception NullPointerException Valid unchecked exception (java.lang.Runtime subclass)\n\t * @throws java.awt.AWTError Valid unchecked exception (java.lang.Error subclass)\n\t * @exception OutOfMemoryError Valid unchecked exception (java.lang.Runtime subclass)\n\t */\n\tpublic void t_foo() throws InvalidException {\n\t}\n}\n"}, "----------\n1. ERROR in X.java (at line 9)\n\tpublic void t_foo() throws InvalidException {\n\t                           ^^^^^^^^^^^^^^^^\nInvalidException cannot be resolved to a type\n----------\n");
    }

    public void test056() {
        this.runNegativeTest(new String[]{"X.js", "public class X {\n\t/**\n\t * @throws IllegalArgumenException._ Invalid exception: invalid class name\n\t * @exception IllegalArgumen.*.Exception.. Invalid exception: invalid class name\n\t */\n\tpublic void t_foo() throws InvalidException {\n\t}\n}\n"}, "----------\n1. ERROR in X.java (at line 3)\n\t* @throws IllegalArgumenException._ Invalid exception: invalid class name\n\t          ^^^^^^^^^^^^^^^^^^^^^^^^^\nJavadoc: IllegalArgumenException cannot be resolved to a type\n----------\n2. ERROR in X.java (at line 4)\n\t* @exception IllegalArgumen.*.Exception.. Invalid exception: invalid class name\n\t            ^^^^^^^^^^^^^^^^^\nJavadoc: Invalid class name\n----------\n3. ERROR in X.java (at line 6)\n\tpublic void t_foo() throws InvalidException {\n\t                           ^^^^^^^^^^^^^^^^\nInvalidException cannot be resolved to a type\n----------\n");
    }

    public void test057() {
        this.runNegativeTest(new String[]{"X.js", "public class X {\n\t/**\n\t * @throws java.awt.AWTexception Invalid exception: unknown type\n\t * @throws IOException Invalid exception: unknown type\n\t */\n\tpublic void t_foo() throws InvalidException {\n\t}\n}\n"}, "----------\n1. ERROR in X.java (at line 3)\n\t* @throws java.awt.AWTexception Invalid exception: unknown type\n\t          ^^^^^^^^^^^^^^^^^^^^^\nJavadoc: java.awt.AWTexception cannot be resolved to a type\n----------\n2. ERROR in X.java (at line 4)\n\t* @throws IOException Invalid exception: unknown type\n\t          ^^^^^^^^^^^\nJavadoc: IOException cannot be resolved to a type\n----------\n3. ERROR in X.java (at line 6)\n\tpublic void t_foo() throws InvalidException {\n\t                           ^^^^^^^^^^^^^^^^\nInvalidException cannot be resolved to a type\n----------\n");
    }

    public void test058() {
        this.runNegativeTest(new String[]{"X.js", "import java.io.FileNotFoundException;\npublic class X {\n\t/**\n\t * @throws java.io.EOFException Invalid exception: known exception but neither thrown nor unchecked\n\t * @throws FileNotFoundException Invalid exception: known exception but neither thrown nor unchecked\n\t */\n\tpublic void t_foo() throws InvalidException {\n\t}\n}\n"}, "----------\n1. ERROR in X.java (at line 4)\n\t* @throws java.io.EOFException Invalid exception: known exception but neither thrown nor unchecked\n\t          ^^^^^^^^^^^^^^^^^^^^\nJavadoc: Exception EOFException is not declared\n----------\n2. ERROR in X.java (at line 5)\n\t* @throws FileNotFoundException Invalid exception: known exception but neither thrown nor unchecked\n\t          ^^^^^^^^^^^^^^^^^^^^^\nJavadoc: Exception FileNotFoundException is not declared\n----------\n3. ERROR in X.java (at line 7)\n\tpublic void t_foo() throws InvalidException {\n\t                           ^^^^^^^^^^^^^^^^\nInvalidException cannot be resolved to a type\n----------\n");
    }

    public void test060() {
        this.runNegativeTest(new String[]{"X.js", "public class X {\n\t/**\n\t * Invalid @throws tags: documented exception are unchecked but thrown exception is not documented\n\t * @throws IllegalArgumentException Valid unchecked exception (java.lang.Runtime subclass)\n\t * @exception NullPointerException Valid unchecked exception (java.lang.Runtime subclass)\n\t * @throws java.awt.AWTError Valid unchecked exception (java.lang.Error subclass)\n\t * @exception OutOfMemoryError Valid unchecked exception (java.lang.Runtime subclass)\n\t */\n\tpublic void t_foo() throws IllegalAccessException {\n\t}\n}\n"}, "----------\n1. ERROR in X.java (at line 9)\n\tpublic void t_foo() throws IllegalAccessException {\n\t                           ^^^^^^^^^^^^^^^^^^^^^^\nJavadoc: Missing tag for declared exception IllegalAccessException\n----------\n");
    }

    public void test061() {
        this.runNegativeTest(new String[]{"X.js", "public class X {\n\t/**\n\t * @throws /IllegalArgumenException.. Invalid exception: invalid class name\n\t * @exception .IllegalArgumen..Exception.. Invalid exception: invalid class name\n\t */\n\tpublic void t_foo() throws IllegalAccessException {\n\t}\n}\n"}, "----------\n1. ERROR in X.java (at line 3)\n\t* @throws /IllegalArgumenException.. Invalid exception: invalid class name\n\t   ^^^^^^\nJavadoc: Missing class name\n----------\n2. ERROR in X.java (at line 4)\n\t* @exception .IllegalArgumen..Exception.. Invalid exception: invalid class name\n\t            ^^\nJavadoc: Invalid class name\n----------\n3. ERROR in X.java (at line 6)\n\tpublic void t_foo() throws IllegalAccessException {\n\t                           ^^^^^^^^^^^^^^^^^^^^^^\nJavadoc: Missing tag for declared exception IllegalAccessException\n----------\n");
    }

    public void test062() {
        this.runNegativeTest(new String[]{"X.js", "public class X {\n\t/**\n\t * @throws java.awt.AWTexception Invalid exception: unknown type\n\t * @throws IOException Invalid exception: unknown type\n\t */\n\tpublic void t_foo() throws IllegalAccessException {\n\t}\n}\n"}, "----------\n1. ERROR in X.java (at line 3)\n\t* @throws java.awt.AWTexception Invalid exception: unknown type\n\t          ^^^^^^^^^^^^^^^^^^^^^\nJavadoc: java.awt.AWTexception cannot be resolved to a type\n----------\n2. ERROR in X.java (at line 4)\n\t* @throws IOException Invalid exception: unknown type\n\t          ^^^^^^^^^^^\nJavadoc: IOException cannot be resolved to a type\n----------\n3. ERROR in X.java (at line 6)\n\tpublic void t_foo() throws IllegalAccessException {\n\t                           ^^^^^^^^^^^^^^^^^^^^^^\nJavadoc: Missing tag for declared exception IllegalAccessException\n----------\n");
    }

    public void test063() {
        this.runNegativeTest(new String[]{"X.js", "import java.io.FileNotFoundException;\npublic class X {\n\t/**\n\t * @throws java.io.EOFException Invalid exception: known exception but neither thrown nor unchecked\n\t * @throws FileNotFoundException Invalid exception: known exception but neither thrown nor unchecked\n\t * @throws IOException Invalid exception: unknown type\n\t */\n\tpublic void t_foo() throws IllegalAccessException {\n\t}\n}\n"}, "----------\n1. ERROR in X.java (at line 4)\n\t* @throws java.io.EOFException Invalid exception: known exception but neither thrown nor unchecked\n\t          ^^^^^^^^^^^^^^^^^^^^\nJavadoc: Exception EOFException is not declared\n----------\n2. ERROR in X.java (at line 5)\n\t* @throws FileNotFoundException Invalid exception: known exception but neither thrown nor unchecked\n\t          ^^^^^^^^^^^^^^^^^^^^^\nJavadoc: Exception FileNotFoundException is not declared\n----------\n3. ERROR in X.java (at line 6)\n\t* @throws IOException Invalid exception: unknown type\n\t          ^^^^^^^^^^^\nJavadoc: IOException cannot be resolved to a type\n----------\n4. ERROR in X.java (at line 8)\n\tpublic void t_foo() throws IllegalAccessException {\n\t                           ^^^^^^^^^^^^^^^^^^^^^^\nJavadoc: Missing tag for declared exception IllegalAccessException\n----------\n");
    }

    public void test065() {
        this.runNegativeTest(new String[]{"X.js", "public class X {\n\t/**\n\t * Invalid @throws tags: documented exception are unchecked but some thrown exception are invalid\n\t * @throws IllegalAccessException Valid unchecked exception (java.lang.Runtime subclass)\n\t * @throws IllegalArgumentException Valid unchecked exception (java.lang.Runtime subclass)\n\t * @exception NullPointerException Valid unchecked exception (java.lang.Runtime subclass)\n\t * @throws java.awt.AWTError Valid unchecked exception (java.lang.Error subclass)\n\t * @exception OutOfMemoryError Valid unchecked exception (java.lang.Runtime subclass)\n\t */\n\tpublic void t_foo() throws\n\t\tIllegalAccessException, \n\t\tInvalidException, \n\t\tString, \n\t\tIllegalArgumentException\n\t{}\n}\n"}, "----------\n1. ERROR in X.java (at line 12)\n\tInvalidException, \n\t^^^^^^^^^^^^^^^^\nInvalidException cannot be resolved to a type\n----------\n2. ERROR in X.java (at line 13)\n\tString, \n\t^^^^^^\nNo exception of type String can be thrown; an exception type must be a subclass of Throwable\n----------\n");
    }

    public void test066() {
        this.runNegativeTest(new String[]{"X.js", "public class X {\n\t/**\n\t * @throws %IllegalArgumenException Invalid exception: invalid class name\n\t * @exception (IllegalArgumen Invalid exception: invalid class name\n\t * @exception \"IllegalArgumen Invalid exception: invalid class name\n\t */\n\tpublic void t_foo() throws\n\t\tIllegalAccessException, \n\t\tInvalidException, \n\t\tString, \n\t\tIllegalArgumentException\n\t{}\n}\n"}, "----------\n1. ERROR in X.java (at line 3)\n\t* @throws %IllegalArgumenException Invalid exception: invalid class name\n\t   ^^^^^^\nJavadoc: Missing class name\n----------\n2. ERROR in X.java (at line 4)\n\t* @exception (IllegalArgumen Invalid exception: invalid class name\n\t   ^^^^^^^^^\nJavadoc: Missing class name\n----------\n3. ERROR in X.java (at line 5)\n\t* @exception \"IllegalArgumen Invalid exception: invalid class name\n\t   ^^^^^^^^^\nJavadoc: Missing class name\n----------\n4. ERROR in X.java (at line 8)\n\tIllegalAccessException, \n\t^^^^^^^^^^^^^^^^^^^^^^\nJavadoc: Missing tag for declared exception IllegalAccessException\n----------\n5. ERROR in X.java (at line 9)\n\tInvalidException, \n\t^^^^^^^^^^^^^^^^\nInvalidException cannot be resolved to a type\n----------\n6. ERROR in X.java (at line 10)\n\tString, \n\t^^^^^^\nNo exception of type String can be thrown; an exception type must be a subclass of Throwable\n----------\n7. ERROR in X.java (at line 11)\n\tIllegalArgumentException\n\t^^^^^^^^^^^^^^^^^^^^^^^^\nJavadoc: Missing tag for declared exception IllegalArgumentException\n----------\n");
    }

    public void test067() {
        this.runNegativeTest(new String[]{"X.js", "public class X {\n\t/**\n\t * @throws java.awt.AWTexception Invalid exception: unknown type\n\t * @throws IOException Invalid exception: unknown type\n\t */\n\tpublic void t_foo() throws\n\t\tIllegalAccessException, \n\t\tInvalidException, \n\t\tString, \n\t\tIllegalArgumentException\n\t{}\n}\n"}, "----------\n1. ERROR in X.java (at line 3)\n\t* @throws java.awt.AWTexception Invalid exception: unknown type\n\t          ^^^^^^^^^^^^^^^^^^^^^\nJavadoc: java.awt.AWTexception cannot be resolved to a type\n----------\n2. ERROR in X.java (at line 4)\n\t* @throws IOException Invalid exception: unknown type\n\t          ^^^^^^^^^^^\nJavadoc: IOException cannot be resolved to a type\n----------\n3. ERROR in X.java (at line 7)\n\tIllegalAccessException, \n\t^^^^^^^^^^^^^^^^^^^^^^\nJavadoc: Missing tag for declared exception IllegalAccessException\n----------\n4. ERROR in X.java (at line 8)\n\tInvalidException, \n\t^^^^^^^^^^^^^^^^\nInvalidException cannot be resolved to a type\n----------\n5. ERROR in X.java (at line 9)\n\tString, \n\t^^^^^^\nNo exception of type String can be thrown; an exception type must be a subclass of Throwable\n----------\n6. ERROR in X.java (at line 10)\n\tIllegalArgumentException\n\t^^^^^^^^^^^^^^^^^^^^^^^^\nJavadoc: Missing tag for declared exception IllegalArgumentException\n----------\n");
    }

    public void test068() {
        this.runNegativeTest(new String[]{"X.js", "import java.io.FileNotFoundException;\npublic class X {\n\t/**\n\t * @throws java.io.EOFException Invalid exception: known exception but neither thrown nor unchecked\n\t * @throws FileNotFoundException Invalid exception: known exception but neither thrown nor unchecked\n\t */\n\tpublic void t_foo() throws\n\t\tIllegalAccessException, \n\t\tInvalidException, \n\t\tString, \n\t\tIllegalArgumentException\n\t{}\n}\n"}, "----------\n1. ERROR in X.java (at line 4)\n\t* @throws java.io.EOFException Invalid exception: known exception but neither thrown nor unchecked\n\t          ^^^^^^^^^^^^^^^^^^^^\nJavadoc: Exception EOFException is not declared\n----------\n2. ERROR in X.java (at line 5)\n\t* @throws FileNotFoundException Invalid exception: known exception but neither thrown nor unchecked\n\t          ^^^^^^^^^^^^^^^^^^^^^\nJavadoc: Exception FileNotFoundException is not declared\n----------\n3. ERROR in X.java (at line 8)\n\tIllegalAccessException, \n\t^^^^^^^^^^^^^^^^^^^^^^\nJavadoc: Missing tag for declared exception IllegalAccessException\n----------\n4. ERROR in X.java (at line 9)\n\tInvalidException, \n\t^^^^^^^^^^^^^^^^\nInvalidException cannot be resolved to a type\n----------\n5. ERROR in X.java (at line 10)\n\tString, \n\t^^^^^^\nNo exception of type String can be thrown; an exception type must be a subclass of Throwable\n----------\n6. ERROR in X.java (at line 11)\n\tIllegalArgumentException\n\t^^^^^^^^^^^^^^^^^^^^^^^^\nJavadoc: Missing tag for declared exception IllegalArgumentException\n----------\n");
    }

    public void test069() {
        this.runNegativeTest(new String[]{"X.js", "import java.io.FileNotFoundException;\npublic class X {\n\t/**\n\t */\n\tpublic void t_foo() throws\n\t\tIllegalAccessException, \n\t\tInvalidException, \n\t\tString, \n\t\tjava.io.EOFException, \n\t\tFileNotFoundException, \n\t\tIOException, \n\t\tIllegalArgumentException\n\t{}\n}\n"}, "----------\n1. ERROR in X.java (at line 6)\n\tIllegalAccessException, \n\t^^^^^^^^^^^^^^^^^^^^^^\nJavadoc: Missing tag for declared exception IllegalAccessException\n----------\n2. ERROR in X.java (at line 7)\n\tInvalidException, \n\t^^^^^^^^^^^^^^^^\nInvalidException cannot be resolved to a type\n----------\n3. ERROR in X.java (at line 8)\n\tString, \n\t^^^^^^\nNo exception of type String can be thrown; an exception type must be a subclass of Throwable\n----------\n4. ERROR in X.java (at line 9)\n\tjava.io.EOFException, \n\t^^^^^^^^^^^^^^^^^^^^\nJavadoc: Missing tag for declared exception EOFException\n----------\n5. ERROR in X.java (at line 10)\n\tFileNotFoundException, \n\t^^^^^^^^^^^^^^^^^^^^^\nJavadoc: Missing tag for declared exception FileNotFoundException\n----------\n6. ERROR in X.java (at line 11)\n\tIOException, \n\t^^^^^^^^^^^\nIOException cannot be resolved to a type\n----------\n7. ERROR in X.java (at line 12)\n\tIllegalArgumentException\n\t^^^^^^^^^^^^^^^^^^^^^^^^\nJavadoc: Missing tag for declared exception IllegalArgumentException\n----------\n");
    }

    public void test070() {
        this.runConformTest(new String[]{"X.js", "public class X {\n\t/**\n\t * Valid return declaration\n\t *\n\t * @return Return an int\n\t */\n\tpublic int s_foo() {\n\t  return 0;\n\t}\n}\n"});
    }

    public void test071() {
        this.runConformTest(new String[]{"X.js", "public class X {\n\t/**\n\t * Valid empty return declaration\n\t *\n\t * @return string\n\t */\n\tpublic String s_foo() {\n\t  return \"\";\n\t}\n}\n"});
    }

    public void test072() {
        this.runConformTest(new String[]{"X.js", "public class X {\n\t/**\n\t * Valid return declaration\n\t *\n\t * @return Vector A list of things\n\t */\n\tpublic java.util.Vector s_foo() {\n\t  return new java.util.Vector();\n\t}\n}\n"});
    }

    public void test073() {
        this.runNegativeTest(new String[]{"X.js", "public class X {\n\t/**\n\t * Missing return declaration\n\t */\n\tpublic Object[] s_foo() {\n\t  return new Object[0];\n\t}\n}\n"}, "----------\n1. ERROR in X.java (at line 5)\n\tpublic Object[] s_foo() {\n\t       ^^^^^^^^\nJavadoc: Missing tag for return type\n----------\n");
    }

    public void test074() {
        this.runNegativeTest(new String[]{"X.js", "public class X {\n\t/**\n\t * Invalid return declaration\n\t *\n\t * @return double\n\t * @return Dimension\n\t */\n\tpublic double s_foo() {\n\t  return 3.14;\n\t}\n}\n"}, "----------\n1. ERROR in X.java (at line 6)\n\t* @return Dimension\n\t   ^^^^^^\nJavadoc: Duplicate tag for return type\n----------\n");
    }

    public void test075() {
        this.runNegativeTest(new String[]{"X.js", "public class X {\n\t/**\n\t * Invalid return declaration\n\t *\n\t * @return Invalid return on void method\n\t */\n\tpublic void s_foo() {\n\t}\n}\n"}, "----------\n1. ERROR in X.java (at line 5)\n\t* @return Invalid return on void method\n\t   ^^^^^^\nJavadoc: Unexpected tag\n----------\n");
    }

    public void test076() {
        this.runNegativeTest(new String[]{"X.js", "public class X {\n\t/**\n\t * Invalid return declaration\n\t *\n\t * @return Invalid return on void method\n\t * @return\n\t * @return Invalid return on void method\n\t */\n\tpublic void s_foo() {\n\t}\n}\n"}, "----------\n1. ERROR in X.java (at line 5)\n\t* @return Invalid return on void method\n\t   ^^^^^^\nJavadoc: Unexpected tag\n----------\n2. ERROR in X.java (at line 6)\n\t* @return\n\t   ^^^^^^\nJavadoc: Duplicate tag for return type\n----------\n3. ERROR in X.java (at line 7)\n\t* @return Invalid return on void method\n\t   ^^^^^^\nJavadoc: Duplicate tag for return type\n----------\n");
    }

    public void test080() {
        this.runNegativeTest(new String[]{"X.js", "public class X {\n\t/**\n\t * Invalid string references \n\t *\n\t * @see \"\n\t * @see \"unterminated string\n\t * @see \"invalid string\"\"\n\t * @see \"invalid\" no text allowed after the string\n\t */\n\tpublic void s_foo() {\n\t}\n}\n"}, "----------\n1. ERROR in X.java (at line 5)\n\t* @see \"\n\t       ^\nJavadoc: Invalid reference\n----------\n2. ERROR in X.java (at line 6)\n\t* @see \"unterminated string\n\t       ^^^^^^^^^^^^^^^^^^^^\nJavadoc: Invalid reference\n----------\n3. ERROR in X.java (at line 7)\n\t* @see \"invalid string\"\"\n\t                       ^\nJavadoc: Unexpected text\n----------\n4. ERROR in X.java (at line 8)\n\t* @see \"invalid\" no text allowed after the string\n\t                ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^\nJavadoc: Unexpected text\n----------\n");
    }

    public void test081() {
        this.runConformTest(new String[]{"X.js", "public class X {\n\t/**\n\t * Valid string references \n\t *\n\t * @see \"Valid normal string\"\n\t * @see \"Valid \\\"string containing\\\" \\\"double-quote\\\"\"\n\t */\n\tpublic void s_foo() {\n\t}\n}\n"});
    }

    public void test085() {
        this.runNegativeTest(new String[]{"X.js", "public class X {\n\t/**\n\t * Invalid URL link references \n\t *\n\t * @see <\n\t * @see <a\n\t * @see <a hre\n\t * @see <a href\n\t * @see <a href=\n\t * @see <a href=\"\n\t * @see <a href=\"invalid\n\t * @see <a href=\"invalid\"\n\t * @see <a href=\"invalid\">\n\t * @see <a href=\"invalid\">invalid\n\t * @see <a href=\"invalid\">invalid<\n\t * @see <a href=\"invalid\">invalid</\n\t * @see <a href=\"invalid\">invalid</a\n\t * @see <a href=\"invalid\">invalid</a> no text allowed after the href\n\t */\n\tpublic void s_foo() {\n\t}\n}\n"}, "----------\n1. ERROR in X.java (at line 5)\n\t* @see <\n\t       ^\nJavadoc: Malformed link reference\n----------\n2. ERROR in X.java (at line 6)\n\t* @see <a\n\t       ^^\nJavadoc: Malformed link reference\n----------\n3. ERROR in X.java (at line 7)\n\t* @see <a hre\n\t       ^^^^^^\nJavadoc: Malformed link reference\n----------\n4. ERROR in X.java (at line 8)\n\t* @see <a href\n\t       ^^^^^^^\nJavadoc: Malformed link reference\n----------\n5. ERROR in X.java (at line 9)\n\t* @see <a href=\n\t       ^^^^^^^^\nJavadoc: Malformed link reference\n----------\n6. ERROR in X.java (at line 10)\n\t* @see <a href=\"\n\t       ^^^^^^^^^\nJavadoc: Malformed link reference\n----------\n7. ERROR in X.java (at line 11)\n\t* @see <a href=\"invalid\n\t       ^^^^^^^^^^^^^^^^\nJavadoc: Malformed link reference\n----------\n8. ERROR in X.java (at line 12)\n\t* @see <a href=\"invalid\"\n\t       ^^^^^^^^^^^^^^^^^\nJavadoc: Malformed link reference\n----------\n9. ERROR in X.java (at line 13)\n\t* @see <a href=\"invalid\">\n\t       ^^^^^^^^^^^^^^^^^^\nJavadoc: Malformed link reference\n----------\n10. ERROR in X.java (at line 14)\n\t* @see <a href=\"invalid\">invalid\n\t       ^^^^^^^^^^^^^^^^^^^^^^^^^\nJavadoc: Malformed link reference\n----------\n11. ERROR in X.java (at line 15)\n\t* @see <a href=\"invalid\">invalid<\n\t                                ^\nJavadoc: Malformed link reference\n----------\n12. ERROR in X.java (at line 16)\n\t* @see <a href=\"invalid\">invalid</\n\t                                ^^\nJavadoc: Malformed link reference\n----------\n13. ERROR in X.java (at line 17)\n\t* @see <a href=\"invalid\">invalid</a\n\t                                ^^^\nJavadoc: Malformed link reference\n----------\n14. ERROR in X.java (at line 18)\n\t* @see <a href=\"invalid\">invalid</a> no text allowed after the href\n\t                                 ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^\nJavadoc: Unexpected text\n----------\n");
    }

    public void test086() {
        this.runConformTest(new String[]{"X.js", "public class X {\n\t/**\n\t * Valid URL references \n\t *\n\t * @see <a href=\"http://java.sun.com/j2se/1.4.2/docs/tooldocs/windows/javadoc.html\">Valid URL link reference</a>\n\t * @see <A HREF = \"http://java.sun.com/j2se/1.4.2/docs/tooldocs/windows/javadoc.html\">Valid URL link reference</A>\n\t * @see <a hReF = \"http://java.sun.com/j2se/1.4.2/docs/tooldocs/windows/javadoc.html\">Valid URL link reference</A>\n\t */\n\tpublic void s_foo() {\n\t}\n}\n"});
    }

    public void test087() {
        this.runNegativeTest(new String[]{"X.js", "public class X {\n\t/**\n\t * Invalid URL references \n\t *\n\t * @see <a xref=\"http://java.sun.com/j2se/1.4.2/docs/tooldocs/windows/javadoc.html\">Invalid URL link reference</a>\n\t * @see <b href=\"http://java.sun.com/j2se/1.4.2/docs/tooldocs/windows/javadoc.html\">Invalid URL link reference</a>\n\t * @see <a href=\"http://java.sun.com/j2se/1.4.2/docs/tooldocs/windows/javadoc.html\">Invalid URL link reference</b>\n\t */\n\tpublic void s_foo() {\n\t}\n}\n"}, "----------\n1. ERROR in X.java (at line 5)\n\t* @see <a xref=\"http://java.sun.com/j2se/1.4.2/docs/tooldocs/windows/javadoc.html\">Invalid URL link reference</a>\n\t       ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^\nJavadoc: Malformed link reference\n----------\n2. ERROR in X.java (at line 6)\n\t* @see <b href=\"http://java.sun.com/j2se/1.4.2/docs/tooldocs/windows/javadoc.html\">Invalid URL link reference</a>\n\t       ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^\nJavadoc: Malformed link reference\n----------\n3. ERROR in X.java (at line 7)\n\t* @see <a href=\"http://java.sun.com/j2se/1.4.2/docs/tooldocs/windows/javadoc.html\">Invalid URL link reference</b>\n\t                                                                                                             ^^^^\nJavadoc: Malformed link reference\n----------\n");
    }

    public void test090() {
        this.runConformReferenceTest(new String[]{"test/X.js", "package test;\npublic class X {\n\t/**\n\t * Valid local classes references \n\t *\n\t * @see Visibility Valid ref: local class \n\t * @see Visibility.VcPublic Valid ref: visible inner class of local class \n\t * @see Visibility.AvcPublic Valid ref: visible inherited inner class of local class \n\t * @see test.Visibility Valid ref: local class \n\t * @see test.Visibility.VcPublic Valid ref: visible inner class of local class \n\t * @see test.Visibility.AvcPublic Valid ref: visible inherited inner class of local class \n\t */\n\tpublic void s_foo() {\n\t}\n}\n"});
    }

    public void test091() {
        this.runNegativeReferenceTest(new String[]{"test/X.js", "package test;\npublic class X {\n\t/**\n\t * Invalid local classes references \n\t *\n\t * @see Visibility.VcPrivate Invalid ref: non visible inner class of local class \n\t * @see Visibility.AvcPrivate Invalid ref: non visible inherited inner class of local class \n\t * @see test.Visibility.VcPrivate Invalid ref: non visible inner class of local class \n\t * @see test.Visibility.AvcPrivate Invalid ref: non visible inherited inner class of local class \n\t * @see Unknown Invalid ref: unknown class \n\t */\n\tpublic void s_foo() {\n\t}\n}\n"}, "----------\n1. ERROR in test\\X.java (at line 6)\n\t* @see Visibility.VcPrivate Invalid ref: non visible inner class of local class \n\t       ^^^^^^^^^^^^^^^^^^^^\nJavadoc: The type Visibility.VcPrivate is not visible\n----------\n2. ERROR in test\\X.java (at line 7)\n\t* @see Visibility.AvcPrivate Invalid ref: non visible inherited inner class of local class \n\t       ^^^^^^^^^^^^^^^^^^^^^\nJavadoc: The type Visibility.AvcPrivate is not visible\n----------\n3. ERROR in test\\X.java (at line 8)\n\t* @see test.Visibility.VcPrivate Invalid ref: non visible inner class of local class \n\t       ^^^^^^^^^^^^^^^^^^^^^^^^^\nJavadoc: The type test.Visibility.VcPrivate is not visible\n----------\n4. ERROR in test\\X.java (at line 9)\n\t* @see test.Visibility.AvcPrivate Invalid ref: non visible inherited inner class of local class \n\t       ^^^^^^^^^^^^^^^^^^^^^^^^^^\nJavadoc: The type test.Visibility.AvcPrivate is not visible\n----------\n5. ERROR in test\\X.java (at line 10)\n\t* @see Unknown Invalid ref: unknown class \n\t       ^^^^^^^\nJavadoc: Unknown cannot be resolved to a type\n----------\n");
    }

    public void test092() {
        this.runConformReferenceTest(new String[]{"test/X.js", "package test;\nimport test.copy.*;\npublic class X {\n\t/**\n\t * Valid external classes references \n\t *\n\t * @see VisibilityPublic Valid ref: visible class through import => no warning on import\n\t * @see VisibilityPublic.VpPublic Valid ref: visible inner class in visible class \n\t */\n\tpublic void s_foo() {\n\t}\n}\n"});
    }

    public void test093() {
        this.runNegativeReferenceTest(new String[]{"test/X.js", "package test;\nimport test.copy.*;\npublic class X {\n\t/**\n\t * Invalid external classes references \n\t *\n\t * @see VisibilityPackage Invalid ref: non visible class \n\t * @see VisibilityPackage.VpPrivate Invalid ref: non visible inner class in non visible class \n\t * @see VisibilityPackage.VpPublic Invalid ref: visible inner class in non visible class \n\t * @see VisibilityPublic.VpPrivate Invalid ref: non visible inner class in visible class \n\t */\n\tpublic void s_foo() {\n\t}\n}\n"}, "----------\n1. ERROR in test\\X.java (at line 7)\n\t* @see VisibilityPackage Invalid ref: non visible class \n\t       ^^^^^^^^^^^^^^^^^\nJavadoc: The type VisibilityPackage is not visible\n----------\n2. ERROR in test\\X.java (at line 8)\n\t* @see VisibilityPackage.VpPrivate Invalid ref: non visible inner class in non visible class \n\t       ^^^^^^^^^^^^^^^^^^^^^^^^^^^\nJavadoc: The type VisibilityPackage is not visible\n----------\n3. ERROR in test\\X.java (at line 9)\n\t* @see VisibilityPackage.VpPublic Invalid ref: visible inner class in non visible class \n\t       ^^^^^^^^^^^^^^^^^^^^^^^^^^\nJavadoc: The type VisibilityPackage is not visible\n----------\n4. ERROR in test\\X.java (at line 10)\n\t* @see VisibilityPublic.VpPrivate Invalid ref: non visible inner class in visible class \n\t       ^^^^^^^^^^^^^^^^^^^^^^^^^^\nJavadoc: The type VisibilityPublic.VpPrivate is not visible\n----------\n");
    }

    public void test094() {
        this.runConformReferenceTest(new String[]{"test/X.js", "package test;\npublic class X {\n\t/**\n\t * Valid external classes references \n\t *\n\t * @see test.copy.VisibilityPublic Valid ref: visible class through import => no warning on import\n\t * @see test.copy.VisibilityPublic.VpPublic Valid ref: visible inner class in visible class \n\t */\n\tpublic void s_foo() {\n\t}\n}\n"});
    }

    public void test095() {
        this.runNegativeReferenceTest(new String[]{"test/X.js", "package test;\npublic class X {\n\t/**\n\t * Invalid external classes references \n\t *\n\t * @see test.copy.VisibilityPackage Invalid ref: non visible class \n\t * @see test.copy.VisibilityPackage.VpPrivate Invalid ref: non visible inner class in non visible class \n\t * @see test.copy.VisibilityPackage.VpPublic Invalid ref: visible inner class in non visible class \n\t * @see test.copy.VisibilityPublic.VpPrivate Invalid ref: non visible inner class in visible class \n\t */\n\tpublic void s_foo() {\n\t}\n}\n"}, "----------\n1. ERROR in test\\X.java (at line 6)\n\t* @see test.copy.VisibilityPackage Invalid ref: non visible class \n\t       ^^^^^^^^^^^^^^^^^^^^^^^^^^^\nJavadoc: The type test.copy.VisibilityPackage is not visible\n----------\n2. ERROR in test\\X.java (at line 7)\n\t* @see test.copy.VisibilityPackage.VpPrivate Invalid ref: non visible inner class in non visible class \n\t       ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^\nJavadoc: The type test.copy.VisibilityPackage is not visible\n----------\n3. ERROR in test\\X.java (at line 8)\n\t* @see test.copy.VisibilityPackage.VpPublic Invalid ref: visible inner class in non visible class \n\t       ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^\nJavadoc: The type test.copy.VisibilityPackage is not visible\n----------\n4. ERROR in test\\X.java (at line 9)\n\t* @see test.copy.VisibilityPublic.VpPrivate Invalid ref: non visible inner class in visible class \n\t       ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^\nJavadoc: The type test.copy.VisibilityPublic.VpPrivate is not visible\n----------\n");
    }

    public void test100() {
        this.runConformReferenceTest(new String[]{"test/X.js", "package test;\npublic class X {\n\tint x;\n\t/**\n\t * Valid local class field references\n\t *\n\t * @see #x Valid ref: visible field\n\t * @see Visibility#vf_public Valid ref: visible field\n\t * @see Visibility.VcPublic#vf_public Valid ref: visible field in visible inner class\n\t */\n\tpublic void s_foo() {\n\t}\n}\n"});
    }

    public void test101() {
        this.runNegativeReferenceTest(new String[]{"test/X.js", "package test;\npublic class X {\n\t/**\n\t * Invalid local class field references\n\t *\n\t * @see Visibility#unknown Invalid ref: non existent field\n\t * @see Visibility#vf_private Invalid ref: non visible field\n\t * @see Visibility.VcPrivate#unknown Invalid ref: non visible inner class (non existent field)\n\t * @see Visibility.VcPrivate#vf_private Invalid ref: non visible inner class (non visible field)\n\t * @see Visibility.VcPrivate#vf_public Invalid ref: non visible inner class (public field)\n\t * @see Visibility.VcPublic#unknown Invalid ref: non existent field in visible inner class\n\t * @see Visibility.VcPublic#vf_private Invalid ref: non visible field in visible inner class\n\t */\n\tpublic void s_foo() {\n\t}\n}\n"}, "----------\n1. ERROR in test\\X.java (at line 6)\n\t* @see Visibility#unknown Invalid ref: non existent field\n\t                  ^^^^^^^\nJavadoc: unknown cannot be resolved or is not a field\n----------\n2. ERROR in test\\X.java (at line 7)\n\t* @see Visibility#vf_private Invalid ref: non visible field\n\t                  ^^^^^^^^^^\nJavadoc: The field vf_private is not visible\n----------\n3. ERROR in test\\X.java (at line 8)\n\t* @see Visibility.VcPrivate#unknown Invalid ref: non visible inner class (non existent field)\n\t       ^^^^^^^^^^^^^^^^^^^^\nJavadoc: The type Visibility.VcPrivate is not visible\n----------\n4. ERROR in test\\X.java (at line 9)\n\t* @see Visibility.VcPrivate#vf_private Invalid ref: non visible inner class (non visible field)\n\t       ^^^^^^^^^^^^^^^^^^^^\nJavadoc: The type Visibility.VcPrivate is not visible\n----------\n5. ERROR in test\\X.java (at line 10)\n\t* @see Visibility.VcPrivate#vf_public Invalid ref: non visible inner class (public field)\n\t       ^^^^^^^^^^^^^^^^^^^^\nJavadoc: The type Visibility.VcPrivate is not visible\n----------\n6. ERROR in test\\X.java (at line 11)\n\t* @see Visibility.VcPublic#unknown Invalid ref: non existent field in visible inner class\n\t                           ^^^^^^^\nJavadoc: unknown cannot be resolved or is not a field\n----------\n7. ERROR in test\\X.java (at line 12)\n\t* @see Visibility.VcPublic#vf_private Invalid ref: non visible field in visible inner class\n\t                           ^^^^^^^^^^\nJavadoc: The field vf_private is not visible\n----------\n");
    }

    public void test102() {
        this.runConformReferenceTest(new String[]{"test/X.js", "package test;\npublic class X {\n\t/**\n\t * Valid super class field references in the same package\n\t *\n\t * @see Visibility#avf_public Valid ref: visible inherited field\n\t * @see Visibility.AvcPublic#avf_public Valid ref: visible field of inherited visible inner class\n\t */\n\tpublic void s_foo() {\n\t}\n}\n"});
    }

    public void test103() {
        this.runNegativeReferenceTest(new String[]{"test/X.js", "package test;\npublic class X {\n\t/**\n\t * Invalid super class field references in the same package\n\t *\n\t * @see Visibility#avf_private Invalid ref: non visible inherited field\n\t * @see Visibility.AvcPrivate#avf_private Invalid ref: inherited non visible inner class (non visible field)\n\t * @see Visibility.AvcPrivate#avf_public Invalid ref: inherited non visible inner class (visible field)\n\t * @see Visibility.AvcPublic#avf_private Invalid ref: non visible field of inherited visible inner class\n\t */\n\tpublic void s_foo() {\n\t}\n}\n"}, "----------\n1. ERROR in test\\X.java (at line 6)\n\t* @see Visibility#avf_private Invalid ref: non visible inherited field\n\t                  ^^^^^^^^^^^\nJavadoc: The field avf_private is not visible\n----------\n2. ERROR in test\\X.java (at line 7)\n\t* @see Visibility.AvcPrivate#avf_private Invalid ref: inherited non visible inner class (non visible field)\n\t       ^^^^^^^^^^^^^^^^^^^^^\nJavadoc: The type Visibility.AvcPrivate is not visible\n----------\n3. ERROR in test\\X.java (at line 8)\n\t* @see Visibility.AvcPrivate#avf_public Invalid ref: inherited non visible inner class (visible field)\n\t       ^^^^^^^^^^^^^^^^^^^^^\nJavadoc: The type Visibility.AvcPrivate is not visible\n----------\n4. ERROR in test\\X.java (at line 9)\n\t* @see Visibility.AvcPublic#avf_private Invalid ref: non visible field of inherited visible inner class\n\t                            ^^^^^^^^^^^\nJavadoc: The field avf_private is not visible\n----------\n");
    }

    public void test104() {
        this.runNegativeReferenceTest(new String[]{"test/X.js", "package test;\nimport test.copy.*;\npublic class X {\n\t/**\n\t * Invalid other package non visible class fields references\n\t *\n\t * @see VisibilityPackage#unknown Invalid ref: non visible class (non existent field)\n\t * @see VisibilityPackage#vf_private Invalid ref: non visible class (non existent field)\n\t * @see VisibilityPackage#vf_public Invalid ref: non visible class (visible field)\n\t * @see VisibilityPackage.VpPrivate#unknown Invalid ref: non visible class and non visible inner class (non existent field)\n\t * @see VisibilityPackage.VpPrivate#vf_private Invalid ref: non visible class and non visible inner class (non visible field)\n\t * @see VisibilityPackage.VpPrivate#vf_public Invalid ref: non visible class and non visible inner class (visible field)\n\t * @see VisibilityPackage.VpPublic#unknown Invalid ref: non visible class and visible inner class (non existent field)\n\t * @see VisibilityPackage.VpPublic#vf_private Invalid ref: non visible class and visible inner class (non visible field)\n\t * @see VisibilityPackage.VpPublic#vf_public Invalid ref: non visible class and visible inner class (visible field)\n\t */\n\tpublic void s_foo() {\n\t}\n}\n"}, "----------\n1. ERROR in test\\X.java (at line 7)\n\t* @see VisibilityPackage#unknown Invalid ref: non visible class (non existent field)\n\t       ^^^^^^^^^^^^^^^^^\nJavadoc: The type VisibilityPackage is not visible\n----------\n2. ERROR in test\\X.java (at line 8)\n\t* @see VisibilityPackage#vf_private Invalid ref: non visible class (non existent field)\n\t       ^^^^^^^^^^^^^^^^^\nJavadoc: The type VisibilityPackage is not visible\n----------\n3. ERROR in test\\X.java (at line 9)\n\t* @see VisibilityPackage#vf_public Invalid ref: non visible class (visible field)\n\t       ^^^^^^^^^^^^^^^^^\nJavadoc: The type VisibilityPackage is not visible\n----------\n4. ERROR in test\\X.java (at line 10)\n\t* @see VisibilityPackage.VpPrivate#unknown Invalid ref: non visible class and non visible inner class (non existent field)\n\t       ^^^^^^^^^^^^^^^^^^^^^^^^^^^\nJavadoc: The type VisibilityPackage is not visible\n----------\n5. ERROR in test\\X.java (at line 11)\n\t* @see VisibilityPackage.VpPrivate#vf_private Invalid ref: non visible class and non visible inner class (non visible field)\n\t       ^^^^^^^^^^^^^^^^^^^^^^^^^^^\nJavadoc: The type VisibilityPackage is not visible\n----------\n6. ERROR in test\\X.java (at line 12)\n\t* @see VisibilityPackage.VpPrivate#vf_public Invalid ref: non visible class and non visible inner class (visible field)\n\t       ^^^^^^^^^^^^^^^^^^^^^^^^^^^\nJavadoc: The type VisibilityPackage is not visible\n----------\n7. ERROR in test\\X.java (at line 13)\n\t* @see VisibilityPackage.VpPublic#unknown Invalid ref: non visible class and visible inner class (non existent field)\n\t       ^^^^^^^^^^^^^^^^^^^^^^^^^^\nJavadoc: The type VisibilityPackage is not visible\n----------\n8. ERROR in test\\X.java (at line 14)\n\t* @see VisibilityPackage.VpPublic#vf_private Invalid ref: non visible class and visible inner class (non visible field)\n\t       ^^^^^^^^^^^^^^^^^^^^^^^^^^\nJavadoc: The type VisibilityPackage is not visible\n----------\n9. ERROR in test\\X.java (at line 15)\n\t* @see VisibilityPackage.VpPublic#vf_public Invalid ref: non visible class and visible inner class (visible field)\n\t       ^^^^^^^^^^^^^^^^^^^^^^^^^^\nJavadoc: The type VisibilityPackage is not visible\n----------\n");
    }

    public void test105() {
        this.runNegativeReferenceTest(new String[]{"test/X.js", "package test;\npublic class X {\n\t/**\n\t * Invalid other package non visible class fields references\n\t *\n\t * @see test.copy.VisibilityPackage#unknown Invalid ref: non visible class (non existent field)\n\t * @see test.copy.VisibilityPackage#vf_private Invalid ref: non visible class (non existent field)\n\t * @see test.copy.VisibilityPackage#vf_public Invalid ref: non visible class (visible field)\n\t * @see test.copy.VisibilityPackage.VpPrivate#unknown Invalid ref: non visible class and non visible inner class (non existent field)\n\t * @see test.copy.VisibilityPackage.VpPrivate#vf_private Invalid ref: non visible class and non visible inner class (non visible field)\n\t * @see test.copy.VisibilityPackage.VpPrivate#vf_public Invalid ref: non visible class and non visible inner class (visible field)\n\t * @see test.copy.VisibilityPackage.VpPublic#unknown Invalid ref: non visible class and visible inner class (non existent field)\n\t * @see test.copy.VisibilityPackage.VpPublic#vf_private Invalid ref: non visible class and visible inner class (non visible field)\n\t * @see test.copy.VisibilityPackage.VpPublic#vf_public Invalid ref: non visible class and visible inner class (visible field)\n\t */\n\tpublic void s_foo() {\n\t}\n}\n"}, "----------\n1. ERROR in test\\X.java (at line 6)\n\t* @see test.copy.VisibilityPackage#unknown Invalid ref: non visible class (non existent field)\n\t       ^^^^^^^^^^^^^^^^^^^^^^^^^^^\nJavadoc: The type test.copy.VisibilityPackage is not visible\n----------\n2. ERROR in test\\X.java (at line 7)\n\t* @see test.copy.VisibilityPackage#vf_private Invalid ref: non visible class (non existent field)\n\t       ^^^^^^^^^^^^^^^^^^^^^^^^^^^\nJavadoc: The type test.copy.VisibilityPackage is not visible\n----------\n3. ERROR in test\\X.java (at line 8)\n\t* @see test.copy.VisibilityPackage#vf_public Invalid ref: non visible class (visible field)\n\t       ^^^^^^^^^^^^^^^^^^^^^^^^^^^\nJavadoc: The type test.copy.VisibilityPackage is not visible\n----------\n4. ERROR in test\\X.java (at line 9)\n\t* @see test.copy.VisibilityPackage.VpPrivate#unknown Invalid ref: non visible class and non visible inner class (non existent field)\n\t       ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^\nJavadoc: The type test.copy.VisibilityPackage is not visible\n----------\n5. ERROR in test\\X.java (at line 10)\n\t* @see test.copy.VisibilityPackage.VpPrivate#vf_private Invalid ref: non visible class and non visible inner class (non visible field)\n\t       ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^\nJavadoc: The type test.copy.VisibilityPackage is not visible\n----------\n6. ERROR in test\\X.java (at line 11)\n\t* @see test.copy.VisibilityPackage.VpPrivate#vf_public Invalid ref: non visible class and non visible inner class (visible field)\n\t       ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^\nJavadoc: The type test.copy.VisibilityPackage is not visible\n----------\n7. ERROR in test\\X.java (at line 12)\n\t* @see test.copy.VisibilityPackage.VpPublic#unknown Invalid ref: non visible class and visible inner class (non existent field)\n\t       ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^\nJavadoc: The type test.copy.VisibilityPackage is not visible\n----------\n8. ERROR in test\\X.java (at line 13)\n\t* @see test.copy.VisibilityPackage.VpPublic#vf_private Invalid ref: non visible class and visible inner class (non visible field)\n\t       ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^\nJavadoc: The type test.copy.VisibilityPackage is not visible\n----------\n9. ERROR in test\\X.java (at line 14)\n\t* @see test.copy.VisibilityPackage.VpPublic#vf_public Invalid ref: non visible class and visible inner class (visible field)\n\t       ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^\nJavadoc: The type test.copy.VisibilityPackage is not visible\n----------\n");
    }

    public void test106() {
        this.runNegativeReferenceTest(new String[]{"test/X.js", "package test;\npublic class X {\n\t/**\n\t * Invalid other package non visible class fields references\n\t *\n\t * @see VisibilityPublic#unknown Invalid ref to non existent field of other package class\n\t * @see VisibilityPublic#vf_private Invalid ref to not visible field of other package class\n\t * @see VisibilityPublic#vf_public Valid ref to not visible field of other package class\n\t * @see VisibilityPublic.VpPrivate#unknown Invalid ref to a non visible other package private inner class (non existent field)\n\t * @see VisibilityPublic.VpPrivate#vf_private Invalid ref to a non visible other package private inner class (non visible field)\n\t * @see VisibilityPublic.VpPrivate#vf_public Invalid ref to a non visible other package private inner class (public field)\n\t * @see VisibilityPublic.VpPublic#unknown Invalid ref to non existent field of other package public inner class\n\t * @see VisibilityPublic.VpPublic#vf_private Invalid ref to not visible field of other package public inner class\n\t * @see VisibilityPublic.VpPublic#vf_public Valid ref to not visible field of other package public inner class\n\t */\n\tpublic void s_foo() {\n\t}\n}\n"}, "----------\n1. ERROR in test\\X.java (at line 6)\n\t* @see VisibilityPublic#unknown Invalid ref to non existent field of other package class\n\t       ^^^^^^^^^^^^^^^^\nJavadoc: VisibilityPublic cannot be resolved to a type\n----------\n2. ERROR in test\\X.java (at line 7)\n\t* @see VisibilityPublic#vf_private Invalid ref to not visible field of other package class\n\t       ^^^^^^^^^^^^^^^^\nJavadoc: VisibilityPublic cannot be resolved to a type\n----------\n3. ERROR in test\\X.java (at line 8)\n\t* @see VisibilityPublic#vf_public Valid ref to not visible field of other package class\n\t       ^^^^^^^^^^^^^^^^\nJavadoc: VisibilityPublic cannot be resolved to a type\n----------\n4. ERROR in test\\X.java (at line 9)\n\t* @see VisibilityPublic.VpPrivate#unknown Invalid ref to a non visible other package private inner class (non existent field)\n\t       ^^^^^^^^^^^^^^^^^^^^^^^^^^\nJavadoc: VisibilityPublic cannot be resolved to a type\n----------\n5. ERROR in test\\X.java (at line 10)\n\t* @see VisibilityPublic.VpPrivate#vf_private Invalid ref to a non visible other package private inner class (non visible field)\n\t       ^^^^^^^^^^^^^^^^^^^^^^^^^^\nJavadoc: VisibilityPublic cannot be resolved to a type\n----------\n6. ERROR in test\\X.java (at line 11)\n\t* @see VisibilityPublic.VpPrivate#vf_public Invalid ref to a non visible other package private inner class (public field)\n\t       ^^^^^^^^^^^^^^^^^^^^^^^^^^\nJavadoc: VisibilityPublic cannot be resolved to a type\n----------\n7. ERROR in test\\X.java (at line 12)\n\t* @see VisibilityPublic.VpPublic#unknown Invalid ref to non existent field of other package public inner class\n\t       ^^^^^^^^^^^^^^^^^^^^^^^^^\nJavadoc: VisibilityPublic cannot be resolved to a type\n----------\n8. ERROR in test\\X.java (at line 13)\n\t* @see VisibilityPublic.VpPublic#vf_private Invalid ref to not visible field of other package public inner class\n\t       ^^^^^^^^^^^^^^^^^^^^^^^^^\nJavadoc: VisibilityPublic cannot be resolved to a type\n----------\n9. ERROR in test\\X.java (at line 14)\n\t* @see VisibilityPublic.VpPublic#vf_public Valid ref to not visible field of other package public inner class\n\t       ^^^^^^^^^^^^^^^^^^^^^^^^^\nJavadoc: VisibilityPublic cannot be resolved to a type\n----------\n");
    }

    public void test107() {
        this.runConformReferenceTest(new String[]{"test/X.js", "package test;\nimport test.copy.*;\npublic class X {\n\t/**\n\t * Invalid other package non visible class fields references\n\t *\n\t * @see VisibilityPublic#vf_public Valid ref to not visible field of other package class\n\t * @see VisibilityPublic.VpPublic#vf_public Valid ref to not visible field of other package public inner class\n\t */\n\tpublic void s_foo() {\n\t}\n}\n"});
    }

    public void test108() {
        this.runNegativeReferenceTest(new String[]{"test/X.js", "package test;\nimport test.copy.*;\npublic class X {\n\t/**\n\t * Invalid other package non visible class fields references\n\t *\n\t * @see VisibilityPublic#unknown Invalid ref to non existent field of other package class\n\t * @see VisibilityPublic#vf_private Invalid ref to not visible field of other package class\n\t * @see VisibilityPublic.VpPrivate#unknown Invalid ref to a non visible other package private inner class (non existent field)\n\t * @see VisibilityPublic.VpPrivate#vf_private Invalid ref to a non visible other package private inner class (non visible field)\n\t * @see VisibilityPublic.VpPrivate#vf_public Invalid ref to a non visible other package private inner class (public field)\n\t * @see VisibilityPublic.VpPublic#unknown Invalid ref to non existent field of other package public inner class\n\t * @see VisibilityPublic.VpPublic#vf_private Invalid ref to not visible field of other package public inner class\n\t */\n\tpublic void s_foo() {\n\t}\n}\n"}, "----------\n1. ERROR in test\\X.java (at line 7)\n\t* @see VisibilityPublic#unknown Invalid ref to non existent field of other package class\n\t                        ^^^^^^^\nJavadoc: unknown cannot be resolved or is not a field\n----------\n2. ERROR in test\\X.java (at line 8)\n\t* @see VisibilityPublic#vf_private Invalid ref to not visible field of other package class\n\t                        ^^^^^^^^^^\nJavadoc: The field vf_private is not visible\n----------\n3. ERROR in test\\X.java (at line 9)\n\t* @see VisibilityPublic.VpPrivate#unknown Invalid ref to a non visible other package private inner class (non existent field)\n\t       ^^^^^^^^^^^^^^^^^^^^^^^^^^\nJavadoc: The type VisibilityPublic.VpPrivate is not visible\n----------\n4. ERROR in test\\X.java (at line 10)\n\t* @see VisibilityPublic.VpPrivate#vf_private Invalid ref to a non visible other package private inner class (non visible field)\n\t       ^^^^^^^^^^^^^^^^^^^^^^^^^^\nJavadoc: The type VisibilityPublic.VpPrivate is not visible\n----------\n5. ERROR in test\\X.java (at line 11)\n\t* @see VisibilityPublic.VpPrivate#vf_public Invalid ref to a non visible other package private inner class (public field)\n\t       ^^^^^^^^^^^^^^^^^^^^^^^^^^\nJavadoc: The type VisibilityPublic.VpPrivate is not visible\n----------\n6. ERROR in test\\X.java (at line 12)\n\t* @see VisibilityPublic.VpPublic#unknown Invalid ref to non existent field of other package public inner class\n\t                                 ^^^^^^^\nJavadoc: unknown cannot be resolved or is not a field\n----------\n7. ERROR in test\\X.java (at line 13)\n\t* @see VisibilityPublic.VpPublic#vf_private Invalid ref to not visible field of other package public inner class\n\t                                 ^^^^^^^^^^\nJavadoc: The field vf_private is not visible\n----------\n");
    }

    public void test109() {
        this.runConformReferenceTest(new String[]{"test/X.js", "package test;\npublic class X {\n\t/**\n\t * Invalid other package non visible class fields references\n\t *\n\t * @see test.copy.VisibilityPublic#vf_public Valid ref to not visible field of other package class\n\t * @see test.copy.VisibilityPublic.VpPublic#vf_public Valid ref to not visible field of other package public inner class\n\t */\n\tpublic void s_foo() {\n\t}\n}\n"});
    }

    public void test110() {
        this.runNegativeReferenceTest(new String[]{"test/X.js", "package test;\npublic class X {\n\t/**\n\t * Invalid other package non visible class fields references\n\t *\n\t * @see test.copy.VisibilityPublic#unknown Invalid ref to non existent field of other package class\n\t * @see test.copy.VisibilityPublic#vf_private Invalid ref to not visible field of other package class\n\t * @see test.copy.VisibilityPublic.VpPrivate#unknown Invalid ref to a non visible other package private inner class (non existent field)\n\t * @see test.copy.VisibilityPublic.VpPrivate#vf_private Invalid ref to a non visible other package private inner class (non visible field)\n\t * @see test.copy.VisibilityPublic.VpPrivate#vf_public Invalid ref to a non visible other package private inner class (public field)\n\t * @see test.copy.VisibilityPublic.VpPublic#unknown Invalid ref to non existent field of other package public inner class\n\t * @see test.copy.VisibilityPublic.VpPublic#vf_private Invalid ref to not visible field of other package public inner class\n\t */\n\tpublic void s_foo() {\n\t}\n}\n"}, "----------\n1. ERROR in test\\X.java (at line 6)\n\t* @see test.copy.VisibilityPublic#unknown Invalid ref to non existent field of other package class\n\t                                  ^^^^^^^\nJavadoc: unknown cannot be resolved or is not a field\n----------\n2. ERROR in test\\X.java (at line 7)\n\t* @see test.copy.VisibilityPublic#vf_private Invalid ref to not visible field of other package class\n\t                                  ^^^^^^^^^^\nJavadoc: The field vf_private is not visible\n----------\n3. ERROR in test\\X.java (at line 8)\n\t* @see test.copy.VisibilityPublic.VpPrivate#unknown Invalid ref to a non visible other package private inner class (non existent field)\n\t       ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^\nJavadoc: The type test.copy.VisibilityPublic.VpPrivate is not visible\n----------\n4. ERROR in test\\X.java (at line 9)\n\t* @see test.copy.VisibilityPublic.VpPrivate#vf_private Invalid ref to a non visible other package private inner class (non visible field)\n\t       ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^\nJavadoc: The type test.copy.VisibilityPublic.VpPrivate is not visible\n----------\n5. ERROR in test\\X.java (at line 10)\n\t* @see test.copy.VisibilityPublic.VpPrivate#vf_public Invalid ref to a non visible other package private inner class (public field)\n\t       ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^\nJavadoc: The type test.copy.VisibilityPublic.VpPrivate is not visible\n----------\n6. ERROR in test\\X.java (at line 11)\n\t* @see test.copy.VisibilityPublic.VpPublic#unknown Invalid ref to non existent field of other package public inner class\n\t                                           ^^^^^^^\nJavadoc: unknown cannot be resolved or is not a field\n----------\n7. ERROR in test\\X.java (at line 12)\n\t* @see test.copy.VisibilityPublic.VpPublic#vf_private Invalid ref to not visible field of other package public inner class\n\t                                           ^^^^^^^^^^\nJavadoc: The field vf_private is not visible\n----------\n");
    }

    public void test115() {
        this.runConformTest(new String[]{"X.js", "import java.util.Vector;\npublic class X {\n\t/**\n\t * Valid local methods references with array\n\t * \n\t * @see #smr_foo(char[] array, int[][] matrix, String[][][] dim, Vector[][][][] extra) Valid local method reference\n\t * @see #smr_foo(char[], int[][], String[][][], Vector[][][][]) Valid local method reference\n\t * @see #smr_foo(char[],int[][],java.lang.String[][][],java.util.Vector[][][][]) Valid local method reference\n\t */  \n\tpublic void s_foo() {\n\t}\n\n\t// Empty methods definition for reference\n\tpublic void smr_foo(char[] array, int[][] matrix, String[][][] dim, Vector[][][][] extra) {\n\t}\n}\n"});
    }

    public void test116() {
        this.runNegativeTest(new String[]{"X.js", "import java.util.Vector;\npublic class X {\n\t/**\n\t * Invalid local methods references with array (wrong brackets peer)\n\t * \n\t * @see #smr_foo(char[ , int[][], String[][][], Vector[][][][]) Invalid ref: invalid arguments declaration\n\t * @see #smr_foo(char] , int[][], String[][][], Vector[][][][]) Invalid ref: invalid arguments declaration\n\t * @see #smr_foo(char[] , int[][, String[][][], Vector[][][][]) Invalid ref: invalid arguments declaration\n\t * @see #smr_foo(char[] , int[]], String[][][], Vector[][][][]) Invalid ref: invalid arguments declaration\n\t * @see #smr_foo(char[] , int[[], String[][][], Vector[][][][]) Invalid ref: invalid arguments declaration\n\t * @see #smr_foo(char[] , int][], String[][][], Vector[][][][]) Invalid ref: invalid arguments declaration\n\t * @see #smr_foo(char[] , int[][], String[][][, Vector[][][][]) Invalid ref: invalid arguments declaration\n\t * @see #smr_foo(char[] , int[][], String[][]], Vector[][][][]) Invalid ref: invalid arguments declaration\n\t * @see #smr_foo(char[] , int[][], String[][[], Vector[][][][]) Invalid ref: invalid arguments declaration\n\t * @see #smr_foo(char[] , int[][], String[]][], Vector[][][][]) Invalid ref: invalid arguments declaration\n\t * @see #smr_foo(char[] , int[][], String[[][], Vector[][][][]) Invalid ref: invalid arguments declaration\n\t * @see #smr_foo(char[] , int[][], String][][], Vector[][][][]) Invalid ref: invalid arguments declaration\n\t * @see #smr_foo(char[] , int[][], String[][][], Vector[][][][) Invalid ref: invalid arguments declaration\n\t * @see #smr_foo(char[] , int[][], String[][][], Vector[][][]]) Invalid ref: invalid arguments declaration\n\t * @see #smr_foo(char[] , int[][], String[][][], Vector[][][[]) Invalid ref: invalid arguments declaration\n\t * @see #smr_foo(char[] , int[][], String[][][], Vector[][]][]) Invalid ref: invalid arguments declaration\n\t * @see #smr_foo(char[] , int[][], String[][][], Vector[][[][]) Invalid ref: invalid arguments declaration\n\t * @see #smr_foo(char[] , int[][], String[][][], Vector[]][][]) Invalid ref: invalid arguments declaration\n\t * @see #smr_foo(char[] , int[][], String[][][], Vector[[][][]) Invalid ref: invalid arguments declaration\n\t * @see #smr_foo(char[] , int[][], String[][][], Vector][][][]) Invalid ref: invalid arguments declaration\n\t */  \n\tpublic void s_foo() {\n\t}\n\n\t// Empty methods definition for reference\n\tpublic void smr_foo(char[] array, int[][] matrix, String[][][] dim, Vector[][][][] extra) {\n\t}\n}\n"}, "----------\n1. ERROR in X.java (at line 6)\n\t* @see #smr_foo(char[ , int[][], String[][][], Vector[][][][]) Invalid ref: invalid arguments declaration\n\t               ^^^^^^^^\nJavadoc: Invalid parameters declaration\n----------\n2. ERROR in X.java (at line 7)\n\t* @see #smr_foo(char] , int[][], String[][][], Vector[][][][]) Invalid ref: invalid arguments declaration\n\t               ^^^^^^\nJavadoc: Invalid parameters declaration\n----------\n3. ERROR in X.java (at line 8)\n\t* @see #smr_foo(char[] , int[][, String[][][], Vector[][][][]) Invalid ref: invalid arguments declaration\n\t               ^^^^^^^^^^^^^^^^^\nJavadoc: Invalid parameters declaration\n----------\n4. ERROR in X.java (at line 9)\n\t* @see #smr_foo(char[] , int[]], String[][][], Vector[][][][]) Invalid ref: invalid arguments declaration\n\t               ^^^^^^^^^^^^^^^^\nJavadoc: Invalid parameters declaration\n----------\n5. ERROR in X.java (at line 10)\n\t* @see #smr_foo(char[] , int[[], String[][][], Vector[][][][]) Invalid ref: invalid arguments declaration\n\t               ^^^^^^^^^^^^^^^\nJavadoc: Invalid parameters declaration\n----------\n6. ERROR in X.java (at line 11)\n\t* @see #smr_foo(char[] , int][], String[][][], Vector[][][][]) Invalid ref: invalid arguments declaration\n\t               ^^^^^^^^^^^^^^\nJavadoc: Invalid parameters declaration\n----------\n7. ERROR in X.java (at line 12)\n\t* @see #smr_foo(char[] , int[][], String[][][, Vector[][][][]) Invalid ref: invalid arguments declaration\n\t               ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^\nJavadoc: Invalid parameters declaration\n----------\n8. ERROR in X.java (at line 13)\n\t* @see #smr_foo(char[] , int[][], String[][]], Vector[][][][]) Invalid ref: invalid arguments declaration\n\t               ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^\nJavadoc: Invalid parameters declaration\n----------\n9. ERROR in X.java (at line 14)\n\t* @see #smr_foo(char[] , int[][], String[][[], Vector[][][][]) Invalid ref: invalid arguments declaration\n\t               ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^\nJavadoc: Invalid parameters declaration\n----------\n10. ERROR in X.java (at line 15)\n\t* @see #smr_foo(char[] , int[][], String[]][], Vector[][][][]) Invalid ref: invalid arguments declaration\n\t               ^^^^^^^^^^^^^^^^^^^^^^^^^^^^\nJavadoc: Invalid parameters declaration\n----------\n11. ERROR in X.java (at line 16)\n\t* @see #smr_foo(char[] , int[][], String[[][], Vector[][][][]) Invalid ref: invalid arguments declaration\n\t               ^^^^^^^^^^^^^^^^^^^^^^^^^^^\nJavadoc: Invalid parameters declaration\n----------\n12. ERROR in X.java (at line 17)\n\t* @see #smr_foo(char[] , int[][], String][][], Vector[][][][]) Invalid ref: invalid arguments declaration\n\t               ^^^^^^^^^^^^^^^^^^^^^^^^^^\nJavadoc: Invalid parameters declaration\n----------\n13. ERROR in X.java (at line 18)\n\t* @see #smr_foo(char[] , int[][], String[][][], Vector[][][][) Invalid ref: invalid arguments declaration\n\t               ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^\nJavadoc: Invalid parameters declaration\n----------\n14. ERROR in X.java (at line 19)\n\t* @see #smr_foo(char[] , int[][], String[][][], Vector[][][]]) Invalid ref: invalid arguments declaration\n\t               ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^\nJavadoc: Invalid parameters declaration\n----------\n15. ERROR in X.java (at line 20)\n\t* @see #smr_foo(char[] , int[][], String[][][], Vector[][][[]) Invalid ref: invalid arguments declaration\n\t               ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^\nJavadoc: Invalid parameters declaration\n----------\n16. ERROR in X.java (at line 21)\n\t* @see #smr_foo(char[] , int[][], String[][][], Vector[][]][]) Invalid ref: invalid arguments declaration\n\t               ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^\nJavadoc: Invalid parameters declaration\n----------\n17. ERROR in X.java (at line 22)\n\t* @see #smr_foo(char[] , int[][], String[][][], Vector[][[][]) Invalid ref: invalid arguments declaration\n\t               ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^\nJavadoc: Invalid parameters declaration\n----------\n18. ERROR in X.java (at line 23)\n\t* @see #smr_foo(char[] , int[][], String[][][], Vector[]][][]) Invalid ref: invalid arguments declaration\n\t               ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^\nJavadoc: Invalid parameters declaration\n----------\n19. ERROR in X.java (at line 24)\n\t* @see #smr_foo(char[] , int[][], String[][][], Vector[[][][]) Invalid ref: invalid arguments declaration\n\t               ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^\nJavadoc: Invalid parameters declaration\n----------\n20. ERROR in X.java (at line 25)\n\t* @see #smr_foo(char[] , int[][], String[][][], Vector][][][]) Invalid ref: invalid arguments declaration\n\t               ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^\nJavadoc: Invalid parameters declaration\n----------\n");
    }

    public void test117() {
        this.runNegativeTest(new String[]{"X.js", "import java.util.Vector;\npublic class X {\n\t/**\n\t * Invalid local methods references with array (non applicable arrays)\n\t * \n\t * @see #smr_foo(char , int[][], String[][][], Vector[][][][]) Invalid ref: invalid arguments declaration\n\t * @see #smr_foo(char[] , int[], String[][][], Vector[][][][]) Invalid ref: invalid arguments declaration\n\t * @see #smr_foo(char[] , int, String[][][], Vector[][][][]) Invalid ref: invalid arguments declaration\n\t * @see #smr_foo(char[] , int[][], String[][], Vector[][][][]) Invalid ref: invalid arguments declaration\n\t * @see #smr_foo(char[] , int[][], String[], Vector[][][][]) Invalid ref: invalid arguments declaration\n\t * @see #smr_foo(char[] , int[][], String, Vector[][][][]) Invalid ref: invalid arguments declaration\n\t * @see #smr_foo(char[] , int[][], String[][][], Vector[][][]) Invalid ref: invalid arguments declaration\n\t * @see #smr_foo(char[] , int[][], String[][][], Vector[][]) Invalid ref: invalid arguments declaration\n\t * @see #smr_foo(char[] , int[][], String[][][], Vector[]) Invalid ref: invalid arguments declaration\n\t * @see #smr_foo(char[] , int[][], String[][][], Vector) Invalid ref: invalid arguments declaration\n\t */  \n\tpublic void s_foo() {\n\t}\n\n\t// Empty methods definition for reference\n\tpublic void smr_foo(char[] array, int[][] matrix, String[][][] dim, Vector[][][][] extra) {\n\t}\n}\n"}, "----------\n1. ERROR in X.java (at line 6)\n\t* @see #smr_foo(char , int[][], String[][][], Vector[][][][]) Invalid ref: invalid arguments declaration\n\t        ^^^^^^^\nJavadoc: The method smr_foo(char[], int[][], String[][][], Vector[][][][]) in the type X is not applicable for the arguments (char, int[][], String[][][], Vector[][][][])\n----------\n2. ERROR in X.java (at line 7)\n\t* @see #smr_foo(char[] , int[], String[][][], Vector[][][][]) Invalid ref: invalid arguments declaration\n\t        ^^^^^^^\nJavadoc: The method smr_foo(char[], int[][], String[][][], Vector[][][][]) in the type X is not applicable for the arguments (char[], int[], String[][][], Vector[][][][])\n----------\n3. ERROR in X.java (at line 8)\n\t* @see #smr_foo(char[] , int, String[][][], Vector[][][][]) Invalid ref: invalid arguments declaration\n\t        ^^^^^^^\nJavadoc: The method smr_foo(char[], int[][], String[][][], Vector[][][][]) in the type X is not applicable for the arguments (char[], int, String[][][], Vector[][][][])\n----------\n4. ERROR in X.java (at line 9)\n\t* @see #smr_foo(char[] , int[][], String[][], Vector[][][][]) Invalid ref: invalid arguments declaration\n\t        ^^^^^^^\nJavadoc: The method smr_foo(char[], int[][], String[][][], Vector[][][][]) in the type X is not applicable for the arguments (char[], int[][], String[][], Vector[][][][])\n----------\n5. ERROR in X.java (at line 10)\n\t* @see #smr_foo(char[] , int[][], String[], Vector[][][][]) Invalid ref: invalid arguments declaration\n\t        ^^^^^^^\nJavadoc: The method smr_foo(char[], int[][], String[][][], Vector[][][][]) in the type X is not applicable for the arguments (char[], int[][], String[], Vector[][][][])\n----------\n6. ERROR in X.java (at line 11)\n\t* @see #smr_foo(char[] , int[][], String, Vector[][][][]) Invalid ref: invalid arguments declaration\n\t        ^^^^^^^\nJavadoc: The method smr_foo(char[], int[][], String[][][], Vector[][][][]) in the type X is not applicable for the arguments (char[], int[][], String, Vector[][][][])\n----------\n7. ERROR in X.java (at line 12)\n\t* @see #smr_foo(char[] , int[][], String[][][], Vector[][][]) Invalid ref: invalid arguments declaration\n\t        ^^^^^^^\nJavadoc: The method smr_foo(char[], int[][], String[][][], Vector[][][][]) in the type X is not applicable for the arguments (char[], int[][], String[][][], Vector[][][])\n----------\n8. ERROR in X.java (at line 13)\n\t* @see #smr_foo(char[] , int[][], String[][][], Vector[][]) Invalid ref: invalid arguments declaration\n\t        ^^^^^^^\nJavadoc: The method smr_foo(char[], int[][], String[][][], Vector[][][][]) in the type X is not applicable for the arguments (char[], int[][], String[][][], Vector[][])\n----------\n9. ERROR in X.java (at line 14)\n\t* @see #smr_foo(char[] , int[][], String[][][], Vector[]) Invalid ref: invalid arguments declaration\n\t        ^^^^^^^\nJavadoc: The method smr_foo(char[], int[][], String[][][], Vector[][][][]) in the type X is not applicable for the arguments (char[], int[][], String[][][], Vector[])\n----------\n10. ERROR in X.java (at line 15)\n\t* @see #smr_foo(char[] , int[][], String[][][], Vector) Invalid ref: invalid arguments declaration\n\t        ^^^^^^^\nJavadoc: The method smr_foo(char[], int[][], String[][][], Vector[][][][]) in the type X is not applicable for the arguments (char[], int[][], String[][][], Vector)\n----------\n");
    }

    public void test118() {
        this.runNegativeTest(new String[]{"X.js", "import java.util.Vector;\npublic class X {\n\t/**\n\t * Invalid local methods references with array (non applicable arrays)\n\t * \n\t * @see #smr_foo(char[1] , int[][], String[][][], Vector[][][][]) Invalid ref: invalid arguments declaration\n\t * @see #smr_foo(char[] , int[2][], String[][][], Vector[][][][]) Invalid ref: invalid arguments declaration\n\t * @see #smr_foo(char[] , int[][3], String[][][], Vector[][][][]) Invalid ref: invalid arguments declaration\n\t * @see #smr_foo(char[] , int[][], String[4][][], Vector[][][][]) Invalid ref: invalid arguments declaration\n\t * @see #smr_foo(char[] , int[][], String[][5][], Vector[][][][]) Invalid ref: invalid arguments declaration\n\t * @see #smr_foo(char[] , int[][], String[][][6], Vector[][][][]) Invalid ref: invalid arguments declaration\n\t * @see #smr_foo(char[] , int[][], String[][][], Vector[7][][][]) Invalid ref: invalid arguments declaration\n\t * @see #smr_foo(char[] , int[][], String[][][], Vector[][8][][]) Invalid ref: invalid arguments declaration\n\t * @see #smr_foo(char[] , int[][], String[][][], Vector[][][9][]) Invalid ref: invalid arguments declaration\n\t * @see #smr_foo(char[] , int[][], String[][][], Vector[][][][10]) Invalid ref: invalid arguments declaration\n\t */  \n\tpublic void s_foo() {\n\t}\n\n\t// Empty methods definition for reference\n\tpublic void smr_foo(char[] array, int[][] matrix, String[][][] dim, Vector[][][][] extra) {\n\t}\n}\n"}, "----------\n1. ERROR in X.java (at line 6)\n\t* @see #smr_foo(char[1] , int[][], String[][][], Vector[][][][]) Invalid ref: invalid arguments declaration\n\t               ^^^^^^^\nJavadoc: Invalid parameters declaration\n----------\n2. ERROR in X.java (at line 7)\n\t* @see #smr_foo(char[] , int[2][], String[][][], Vector[][][][]) Invalid ref: invalid arguments declaration\n\t               ^^^^^^^^^^^^^^^\nJavadoc: Invalid parameters declaration\n----------\n3. ERROR in X.java (at line 8)\n\t* @see #smr_foo(char[] , int[][3], String[][][], Vector[][][][]) Invalid ref: invalid arguments declaration\n\t               ^^^^^^^^^^^^^^^^^\nJavadoc: Invalid parameters declaration\n----------\n4. ERROR in X.java (at line 9)\n\t* @see #smr_foo(char[] , int[][], String[4][][], Vector[][][][]) Invalid ref: invalid arguments declaration\n\t               ^^^^^^^^^^^^^^^^^^^^^^^^^^^\nJavadoc: Invalid parameters declaration\n----------\n5. ERROR in X.java (at line 10)\n\t* @see #smr_foo(char[] , int[][], String[][5][], Vector[][][][]) Invalid ref: invalid arguments declaration\n\t               ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^\nJavadoc: Invalid parameters declaration\n----------\n6. ERROR in X.java (at line 11)\n\t* @see #smr_foo(char[] , int[][], String[][][6], Vector[][][][]) Invalid ref: invalid arguments declaration\n\t               ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^\nJavadoc: Invalid parameters declaration\n----------\n7. ERROR in X.java (at line 12)\n\t* @see #smr_foo(char[] , int[][], String[][][], Vector[7][][][]) Invalid ref: invalid arguments declaration\n\t               ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^\nJavadoc: Invalid parameters declaration\n----------\n8. ERROR in X.java (at line 13)\n\t* @see #smr_foo(char[] , int[][], String[][][], Vector[][8][][]) Invalid ref: invalid arguments declaration\n\t               ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^\nJavadoc: Invalid parameters declaration\n----------\n9. ERROR in X.java (at line 14)\n\t* @see #smr_foo(char[] , int[][], String[][][], Vector[][][9][]) Invalid ref: invalid arguments declaration\n\t               ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^\nJavadoc: Invalid parameters declaration\n----------\n10. ERROR in X.java (at line 15)\n\t* @see #smr_foo(char[] , int[][], String[][][], Vector[][][][10]) Invalid ref: invalid arguments declaration\n\t               ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^\nJavadoc: Invalid parameters declaration\n----------\n");
    }

    public void test120() {
        this.runConformTest(new String[]{"X.js", "import java.util.Vector;\npublic class X {\n\t/**\n\t * Valid local methods references\n\t * \n\t * @see #smr_foo() Valid local method reference\n\t * @see #smr_foo(boolean, int, byte, short, char, long, float, double) Valid local method reference\n\t * @see #smr_foo(boolean,int,byte,short,char,long,float,double) Valid local method reference\n\t * @see #smr_foo(boolean b, int i, byte y, short s, char c, long l, float f, double d) Valid local method reference\n\t * @see #smr_foo(boolean a1,int a2,byte a3,short a4,char a5,long a6,float a7,double a8) Valid local method reference\n\t * @see #smr_foo(String, String, int) Valid local method reference\n\t * @see #smr_foo(java.lang.String, String, int) Valid local method reference   \n\t * @see #smr_foo(String, java.lang.String, int) Valid local method reference   \n\t * @see #smr_foo(java.lang.String, java.lang.String, int) Valid local method reference   \n\t * @see #smr_foo(String x,String y,int z) Valid local method reference   \n\t * @see #smr_foo(java.lang.String x,String y, int z) Valid local method reference   \n\t * @see #smr_foo(String x,java.lang.String y,int z) Valid local method reference   \n\t * @see #smr_foo(java.lang.String x,java.lang.String y,int z) Valid local method reference   \n\t * @see #smr_foo(java.util.Hashtable,java.util.Vector,boolean) Valid local method reference\n\t * @see #smr_foo(java.util.Hashtable,Vector,boolean) Valid local method reference\n\t * @see #smr_foo(java.util.Hashtable a, java.util.Vector b, boolean c) Valid local method reference\n\t * @see #smr_foo(java.util.Hashtable a, Vector b, boolean c) Valid local method reference\n\t */  \n\tpublic void s_foo() {\n\t}\n\n\t// Empty methods definition for reference\n\tpublic void smr_foo() {\n\t}\n\tpublic void smr_foo(boolean b, int i, byte y, short s, char c, long l, float f, double d) {\n\t}\n\tpublic void smr_foo(String str1, java.lang.String str2, int i) {\n\t}\n\tpublic void smr_foo(java.util.Hashtable h, java.util.Vector v, boolean b) {\n\t}\n}\n"});
    }

    public void test121() {
        this.runNegativeTest(new String[]{"X.js", "public class X {\n\t/**\n\t * Invalid local methods references\n\t * \n\t * @see #unknown() Invalid ref: undefined local method reference\n\t * @see #smrfoo() Invalid ref: undefined local method reference\n\t * @see #smr_FOO() Invalid ref: undefined local method reference\n\t */  \n\tpublic void s_foo() {\n\t}\n\n\t// Empty methods definition for reference\n\tpublic void smr_foo() {\n\t}\n}\n"}, "----------\n1. ERROR in X.java (at line 5)\n\t* @see #unknown() Invalid ref: undefined local method reference\n\t        ^^^^^^^\nJavadoc: The method unknown() is undefined for the type X\n----------\n2. ERROR in X.java (at line 6)\n\t* @see #smrfoo() Invalid ref: undefined local method reference\n\t        ^^^^^^\nJavadoc: The method smrfoo() is undefined for the type X\n----------\n3. ERROR in X.java (at line 7)\n\t* @see #smr_FOO() Invalid ref: undefined local method reference\n\t        ^^^^^^^\nJavadoc: The method smr_FOO() is undefined for the type X\n----------\n");
    }

    public void test122() {
        this.runNegativeTest(new String[]{"X.js", "public class X {\n\t/**\n\t * Invalid local methods references\n\t * \n\t * @see #smr_foo(boolean, int, byte, short, char, long, float) Invalid ref: local method not applicable\n\t * @see #smr_foo(boolean, int, byte, short, char, long) Invalid ref: local method not applicable\n\t * @see #smr_foo(boolean, int, byte, short, char) Invalid ref: local method not applicable\n\t * @see #smr_foo(boolean, int, byte, short) Invalid ref: local method not applicable\n\t * @see #smr_foo(boolean, int, byte) Invalid ref: local method not applicable\n\t * @see #smr_foo(boolean, int) Invalid ref: local method not applicable\n\t * @see #smr_foo(boolean) Invalid ref: local method not applicable\n\t */  \n\tpublic void s_foo() {\n\t}\n\n\t// Empty methods definition for reference\n\tpublic void smr_foo(boolean b, int i, byte y, short s, char c, long l, float f, double d) {\n\t}\n}\n"}, "----------\n1. ERROR in X.java (at line 5)\n\t* @see #smr_foo(boolean, int, byte, short, char, long, float) Invalid ref: local method not applicable\n\t        ^^^^^^^\nJavadoc: The method smr_foo(boolean, int, byte, short, char, long, float, double) in the type X is not applicable for the arguments (boolean, int, byte, short, char, long, float)\n----------\n2. ERROR in X.java (at line 6)\n\t* @see #smr_foo(boolean, int, byte, short, char, long) Invalid ref: local method not applicable\n\t        ^^^^^^^\nJavadoc: The method smr_foo(boolean, int, byte, short, char, long, float, double) in the type X is not applicable for the arguments (boolean, int, byte, short, char, long)\n----------\n3. ERROR in X.java (at line 7)\n\t* @see #smr_foo(boolean, int, byte, short, char) Invalid ref: local method not applicable\n\t        ^^^^^^^\nJavadoc: The method smr_foo(boolean, int, byte, short, char, long, float, double) in the type X is not applicable for the arguments (boolean, int, byte, short, char)\n----------\n4. ERROR in X.java (at line 8)\n\t* @see #smr_foo(boolean, int, byte, short) Invalid ref: local method not applicable\n\t        ^^^^^^^\nJavadoc: The method smr_foo(boolean, int, byte, short, char, long, float, double) in the type X is not applicable for the arguments (boolean, int, byte, short)\n----------\n5. ERROR in X.java (at line 9)\n\t* @see #smr_foo(boolean, int, byte) Invalid ref: local method not applicable\n\t        ^^^^^^^\nJavadoc: The method smr_foo(boolean, int, byte, short, char, long, float, double) in the type X is not applicable for the arguments (boolean, int, byte)\n----------\n6. ERROR in X.java (at line 10)\n\t* @see #smr_foo(boolean, int) Invalid ref: local method not applicable\n\t        ^^^^^^^\nJavadoc: The method smr_foo(boolean, int, byte, short, char, long, float, double) in the type X is not applicable for the arguments (boolean, int)\n----------\n7. ERROR in X.java (at line 11)\n\t* @see #smr_foo(boolean) Invalid ref: local method not applicable\n\t        ^^^^^^^\nJavadoc: The method smr_foo(boolean, int, byte, short, char, long, float, double) in the type X is not applicable for the arguments (boolean)\n----------\n");
    }

    public void test123() {
        this.runNegativeTest(new String[]{"X.js", "public class X {\n\t/**\n\t * Invalid local methods references\n\t * \n\t * @see #smr_foo(int, String, String) Invalid ref: local method not applicable\n\t * @see #smr_foo(String, int, String) Invalid ref: local method not applicable\n\t * @see #smr_foo(String, String) Invalid ref: local method not applicable\n\t * @see #smr_foo(String) Invalid ref: local method not applicable\n\t */  \n\tpublic void s_foo() {\n\t}\n\n\t// Empty methods definition for reference\n\tpublic void smr_foo(String str1, java.lang.String str2, int i) {\n\t}\n}\n"}, "----------\n1. ERROR in X.java (at line 5)\n\t* @see #smr_foo(int, String, String) Invalid ref: local method not applicable\n\t        ^^^^^^^\nJavadoc: The method smr_foo(String, String, int) in the type X is not applicable for the arguments (int, String, String)\n----------\n2. ERROR in X.java (at line 6)\n\t* @see #smr_foo(String, int, String) Invalid ref: local method not applicable\n\t        ^^^^^^^\nJavadoc: The method smr_foo(String, String, int) in the type X is not applicable for the arguments (String, int, String)\n----------\n3. ERROR in X.java (at line 7)\n\t* @see #smr_foo(String, String) Invalid ref: local method not applicable\n\t        ^^^^^^^\nJavadoc: The method smr_foo(String, String, int) in the type X is not applicable for the arguments (String, String)\n----------\n4. ERROR in X.java (at line 8)\n\t* @see #smr_foo(String) Invalid ref: local method not applicable\n\t        ^^^^^^^\nJavadoc: The method smr_foo(String, String, int) in the type X is not applicable for the arguments (String)\n----------\n");
    }

    public void test124() {
        this.runNegativeTest(new String[]{"X.js", "public class X {\n\t/**\n\t * Invalid local methods references\n\t * \n\t * @see #smr_foo(java.util.Hashtable,java.util.Vector) Invalid ref: local method not applicable\n\t * @see #smr_foo(java.util.Hashtable,boolean,java.util.Vector) Invalid ref: local method not applicable\n\t * @see #smr_foo(boolean,java.util.Hashtable,java.util.Vector) Invalid ref: local method not applicable\n\t * @see #smr_foo(java.util.Hashtable) Invalid ref: local method not applicable\n\t * @see #smr_foo(java.util.Vector) Invalid ref: local method not applicable\n\t */  \n\tpublic void s_foo() {\n\t}\n\n\t// Empty methods definition for reference\n\tpublic void smr_foo(java.util.Hashtable h, java.util.Vector v, boolean b) {\n\t}\n}\n"}, "----------\n1. ERROR in X.java (at line 5)\n\t* @see #smr_foo(java.util.Hashtable,java.util.Vector) Invalid ref: local method not applicable\n\t        ^^^^^^^\nJavadoc: The method smr_foo(Hashtable, Vector, boolean) in the type X is not applicable for the arguments (Hashtable, Vector)\n----------\n2. ERROR in X.java (at line 6)\n\t* @see #smr_foo(java.util.Hashtable,boolean,java.util.Vector) Invalid ref: local method not applicable\n\t        ^^^^^^^\nJavadoc: The method smr_foo(Hashtable, Vector, boolean) in the type X is not applicable for the arguments (Hashtable, boolean, Vector)\n----------\n3. ERROR in X.java (at line 7)\n\t* @see #smr_foo(boolean,java.util.Hashtable,java.util.Vector) Invalid ref: local method not applicable\n\t        ^^^^^^^\nJavadoc: The method smr_foo(Hashtable, Vector, boolean) in the type X is not applicable for the arguments (boolean, Hashtable, Vector)\n----------\n4. ERROR in X.java (at line 8)\n\t* @see #smr_foo(java.util.Hashtable) Invalid ref: local method not applicable\n\t        ^^^^^^^\nJavadoc: The method smr_foo(Hashtable, Vector, boolean) in the type X is not applicable for the arguments (Hashtable)\n----------\n5. ERROR in X.java (at line 9)\n\t* @see #smr_foo(java.util.Vector) Invalid ref: local method not applicable\n\t        ^^^^^^^\nJavadoc: The method smr_foo(Hashtable, Vector, boolean) in the type X is not applicable for the arguments (Vector)\n----------\n");
    }

    public void test125() {
        this.runNegativeTest(new String[]{"X.js", "public class X {\n\t/**\n\t * Invalid local methods references\n\t * \n\t * @see #smr_foo(boolean,int i,byte y,short s,char c,long l,float f,double d) Invalid reference: mixed argument declaration\n\t * @see #smr_foo(boolean b,int, byte y, short s, char c, long l, float f, double d) Invalid reference: mixed argument declaration\n\t * @see #smr_foo(boolean b,int i,byte,short s,char c,long l,float f,double d) Invalid reference: mixed argument declaration\n\t * @see #smr_foo(boolean b,int i,byte y,short,char c,long l,float f,double d) Invalid reference: mixed argument declaration\n\t * @see #smr_foo(boolean b,int i,byte y,short s,char,long l,float f,double d) Invalid reference: mixed argument declaration\n\t * @see #smr_foo(boolean b,int i,byte y,short s,char c,long,float f,double d) Invalid reference: mixed argument declaration\n\t * @see #smr_foo(boolean b,int i,byte y,short s,char c,long l,float,double d) Invalid reference: mixed argument declaration\n\t * @see #smr_foo(boolean b,int i,byte y,short s,char c,long l,float f,double) Invalid reference: mixed argument declaration\n\t */  \n\tpublic void s_foo() {\n\t}\n\n\t// Empty methods definition for reference\n\tpublic void smr_foo(boolean b, int i, byte y, short s, char c, long l, float f, double d) {\n\t}\n}\n"}, "----------\n1. ERROR in X.java (at line 5)\n\t* @see #smr_foo(boolean,int i,byte y,short s,char c,long l,float f,double d) Invalid reference: mixed argument declaration\n\t               ^^^^^^^^^^^^^^\nJavadoc: Invalid parameters declaration\n----------\n2. ERROR in X.java (at line 6)\n\t* @see #smr_foo(boolean b,int, byte y, short s, char c, long l, float f, double d) Invalid reference: mixed argument declaration\n\t               ^^^^^^^^^^^^^^^\nJavadoc: Invalid parameters declaration\n----------\n3. ERROR in X.java (at line 7)\n\t* @see #smr_foo(boolean b,int i,byte,short s,char c,long l,float f,double d) Invalid reference: mixed argument declaration\n\t               ^^^^^^^^^^^^^^^^^^^^^^\nJavadoc: Invalid parameters declaration\n----------\n4. ERROR in X.java (at line 8)\n\t* @see #smr_foo(boolean b,int i,byte y,short,char c,long l,float f,double d) Invalid reference: mixed argument declaration\n\t               ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^\nJavadoc: Invalid parameters declaration\n----------\n5. ERROR in X.java (at line 9)\n\t* @see #smr_foo(boolean b,int i,byte y,short s,char,long l,float f,double d) Invalid reference: mixed argument declaration\n\t               ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^\nJavadoc: Invalid parameters declaration\n----------\n6. ERROR in X.java (at line 10)\n\t* @see #smr_foo(boolean b,int i,byte y,short s,char c,long,float f,double d) Invalid reference: mixed argument declaration\n\t               ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^\nJavadoc: Invalid parameters declaration\n----------\n7. ERROR in X.java (at line 11)\n\t* @see #smr_foo(boolean b,int i,byte y,short s,char c,long l,float,double d) Invalid reference: mixed argument declaration\n\t               ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^\nJavadoc: Invalid parameters declaration\n----------\n8. ERROR in X.java (at line 12)\n\t* @see #smr_foo(boolean b,int i,byte y,short s,char c,long l,float f,double) Invalid reference: mixed argument declaration\n\t               ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^\nJavadoc: Invalid parameters declaration\n----------\n");
    }

    public void test126() {
        this.runNegativeTest(new String[]{"X.js", "public class X {\n\t/**\n\t * Invalid local methods references\n\t * \n\t * @see #smr_foo(String,String y,int z) Invalid reference: mixed argument declaration\n\t * @see #smr_foo(java.lang.String x,String, int z) Invalid reference: mixed argument declaration\n\t * @see #smr_foo(String x,java.lang.String y,int) Invalid reference: mixed argument declaration\n\t * @see #smr_foo(java.lang.String,java.lang.String,int z) Invalid reference: mixed argument declaration\n\t */  \n\tpublic void s_foo() {\n\t}\n\n\t// Empty methods definition for reference\n\tpublic void smr_foo(String str1, java.lang.String str2, int i) {\n\t}\n}\n"}, "----------\n1. ERROR in X.java (at line 5)\n\t* @see #smr_foo(String,String y,int z) Invalid reference: mixed argument declaration\n\t               ^^^^^^^^^^^^^^^^\nJavadoc: Invalid parameters declaration\n----------\n2. ERROR in X.java (at line 6)\n\t* @see #smr_foo(java.lang.String x,String, int z) Invalid reference: mixed argument declaration\n\t               ^^^^^^^^^^^^^^^^^^^^^^^^^^^\nJavadoc: Invalid parameters declaration\n----------\n3. ERROR in X.java (at line 7)\n\t* @see #smr_foo(String x,java.lang.String y,int) Invalid reference: mixed argument declaration\n\t               ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^\nJavadoc: Invalid parameters declaration\n----------\n4. ERROR in X.java (at line 8)\n\t* @see #smr_foo(java.lang.String,java.lang.String,int z) Invalid reference: mixed argument declaration\n\t               ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^\nJavadoc: Invalid parameters declaration\n----------\n");
    }

    public void test127() {
        this.runNegativeTest(new String[]{"X.js", "import java.util.Vector;\npublic class X {\n\t/**\n\t * Invalid local methods references\n\t * \n\t * @see #smr_foo(Hashtable,java.util.Vector,boolean) Invalid reference: unresolved argument type\n\t * @see #smr_foo(Hashtable,Vector,boolean) Invalid reference: unresolved argument type\n\t * @see #smr_foo(Hashtable a, java.util.Vector b, boolean c) Invalid reference: unresolved argument type\n\t * @see #smr_foo(Hashtable a, Vector b, boolean c) Invalid reference: unresolved argument type\n\t * @see #smr_foo(java.util.Hashtable a, java.util.Vector b, boolean) Invalid reference: mixed argument declaration\n\t * @see #smr_foo(java.util.Hashtable, Vector, boolean c) Invalid reference: mixed argument declaration\n\t * @see #smr_foo(Hashtable a, java.util.Vector, boolean c) Invalid reference: mixed argument declaration\n\t * @see #smr_foo(Hashtable, Vector b, boolean c) Invalid reference: mixed argument declaration\n\t */  \n\tpublic void s_foo() {\n\t}\n\n\t// Empty methods definition for reference\n\tpublic void smr_foo(java.util.Hashtable h, java.util.Vector v, boolean b) {\n\t}\n}\n"}, "----------\n1. ERROR in X.java (at line 6)\n\t* @see #smr_foo(Hashtable,java.util.Vector,boolean) Invalid reference: unresolved argument type\n\t                ^^^^^^^^^\nJavadoc: Hashtable cannot be resolved to a type\n----------\n2. ERROR in X.java (at line 7)\n\t* @see #smr_foo(Hashtable,Vector,boolean) Invalid reference: unresolved argument type\n\t                ^^^^^^^^^\nJavadoc: Hashtable cannot be resolved to a type\n----------\n3. ERROR in X.java (at line 8)\n\t* @see #smr_foo(Hashtable a, java.util.Vector b, boolean c) Invalid reference: unresolved argument type\n\t                ^^^^^^^^^\nJavadoc: Hashtable cannot be resolved to a type\n----------\n4. ERROR in X.java (at line 9)\n\t* @see #smr_foo(Hashtable a, Vector b, boolean c) Invalid reference: unresolved argument type\n\t                ^^^^^^^^^\nJavadoc: Hashtable cannot be resolved to a type\n----------\n5. ERROR in X.java (at line 10)\n\t* @see #smr_foo(java.util.Hashtable a, java.util.Vector b, boolean) Invalid reference: mixed argument declaration\n\t               ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^\nJavadoc: Invalid parameters declaration\n----------\n6. ERROR in X.java (at line 11)\n\t* @see #smr_foo(java.util.Hashtable, Vector, boolean c) Invalid reference: mixed argument declaration\n\t               ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^\nJavadoc: Invalid parameters declaration\n----------\n7. ERROR in X.java (at line 12)\n\t* @see #smr_foo(Hashtable a, java.util.Vector, boolean c) Invalid reference: mixed argument declaration\n\t               ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^\nJavadoc: Invalid parameters declaration\n----------\n8. ERROR in X.java (at line 13)\n\t* @see #smr_foo(Hashtable, Vector b, boolean c) Invalid reference: mixed argument declaration\n\t               ^^^^^^^^^^^^^^^^^^^^\nJavadoc: Invalid parameters declaration\n----------\n");
    }

    public void test130() {
        this.runConformTest(new String[]{"X.js", "import java.util.Vector;\npublic class X {\n\t/**\n\t * Valid local methods references\n\t * \n\t * @see X#smr_foo() Valid local method reference\n\t * @see X#smr_foo(boolean, int, byte, short, char, long, float, double) Valid local method reference\n\t * @see X#smr_foo(boolean,int,byte,short,char,long,float,double) Valid local method reference\n\t * @see X#smr_foo(boolean b, int i, byte y, short s, char c, long l, float f, double d) Valid local method reference\n\t * @see X#smr_foo(boolean a1,int a2,byte a3,short a4,char a5,long a6,float a7,double a8) Valid local method reference\n\t * @see X#smr_foo(String, String, int) Valid local method reference\n\t * @see X#smr_foo(java.lang.String, String, int) Valid local method reference   \n\t * @see X#smr_foo(String, java.lang.String, int) Valid local method reference   \n\t * @see X#smr_foo(java.lang.String, java.lang.String, int) Valid local method reference   \n\t * @see X#smr_foo(String x,String y,int z) Valid local method reference   \n\t * @see X#smr_foo(java.lang.String x,String y, int z) Valid local method reference   \n\t * @see X#smr_foo(String x,java.lang.String y,int z) Valid local method reference   \n\t * @see X#smr_foo(java.lang.String x,java.lang.String y,int z) Valid local method reference   \n\t * @see X#smr_foo(java.util.Hashtable,java.util.Vector,boolean) Valid local method reference\n\t * @see X#smr_foo(java.util.Hashtable,Vector,boolean) Valid local method reference\n\t * @see X#smr_foo(java.util.Hashtable a, java.util.Vector b, boolean c) Valid local method reference\n\t * @see X#smr_foo(java.util.Hashtable a, Vector b, boolean c) Valid local method reference\n\t */  \n\tpublic void s_foo() {\n\t}\n\n\t// Empty methods definition for reference\n\tpublic void smr_foo() {\n\t}\n\tpublic void smr_foo(boolean b, int i, byte y, short s, char c, long l, float f, double d) {\n\t}\n\tpublic void smr_foo(String str1, java.lang.String str2, int i) {\n\t}\n\tpublic void smr_foo(java.util.Hashtable h, java.util.Vector v, boolean b) {\n\t}\n}\n"});
    }

    public void test131() {
        this.runNegativeTest(new String[]{"X.js", "public class X {\n\t/**\n\t * Invalid local methods references\n\t * \n\t * @see X#unknown() Invalid ref: undefined local method reference\n\t * @see X#smrfoo() Invalid ref: undefined local method reference\n\t * @see X#smr_FOO() Invalid ref: undefined local method reference\n\t */  \n\tpublic void s_foo() {\n\t}\n\n\t// Empty methods definition for reference\n\tpublic void smr_foo() {\n\t}\n}\n"}, "----------\n1. ERROR in X.java (at line 5)\n\t* @see X#unknown() Invalid ref: undefined local method reference\n\t         ^^^^^^^\nJavadoc: The method unknown() is undefined for the type X\n----------\n2. ERROR in X.java (at line 6)\n\t* @see X#smrfoo() Invalid ref: undefined local method reference\n\t         ^^^^^^\nJavadoc: The method smrfoo() is undefined for the type X\n----------\n3. ERROR in X.java (at line 7)\n\t* @see X#smr_FOO() Invalid ref: undefined local method reference\n\t         ^^^^^^^\nJavadoc: The method smr_FOO() is undefined for the type X\n----------\n");
    }

    public void test132() {
        this.runNegativeTest(new String[]{"X.js", "import java.util.Vector;\npublic class X {\n\t/**\n\t * Invalid local methods references\n\t * \n\t * @see X#smr_foo(Object) Invalid ref: local method not applicable\n\t * @see X#smr_foo(int, byte, short, char, long, float, double) Invalid ref: local method not applicable\n\t * @see X#smr_foo(String, int) Invalid ref: local method not applicable\n\t * @see X#smr_foo(String) Invalid ref: local method not applicable\n\t * @see X#smr_foo(java.util.Hashtable,Vector) Invalid ref: local method not applicable\n\t */  \n\tpublic void s_foo() {\n\t}\n\n\t// Empty methods definition for reference\n\tpublic void smr_foo() {\n\t}\n\tpublic void smr_foo(boolean b, int i, byte y, short s, char c, long l, float f, double d) {\n\t}\n\tpublic void smr_foo(String str1, java.lang.String str2, int i) {\n\t}\n\tpublic void smr_foo(java.util.Hashtable h, java.util.Vector v, boolean b) {\n\t}\n}\n"}, "----------\n1. ERROR in X.java (at line 6)\n\t* @see X#smr_foo(Object) Invalid ref: local method not applicable\n\t         ^^^^^^^\nJavadoc: The method smr_foo() in the type X is not applicable for the arguments (Object)\n----------\n2. ERROR in X.java (at line 7)\n\t* @see X#smr_foo(int, byte, short, char, long, float, double) Invalid ref: local method not applicable\n\t         ^^^^^^^\nJavadoc: The method smr_foo(boolean, int, byte, short, char, long, float, double) in the type X is not applicable for the arguments (int, byte, short, char, long, float, double)\n----------\n3. ERROR in X.java (at line 8)\n\t* @see X#smr_foo(String, int) Invalid ref: local method not applicable\n\t         ^^^^^^^\nJavadoc: The method smr_foo(String, String, int) in the type X is not applicable for the arguments (String, int)\n----------\n4. ERROR in X.java (at line 9)\n\t* @see X#smr_foo(String) Invalid ref: local method not applicable\n\t         ^^^^^^^\nJavadoc: The method smr_foo(String, String, int) in the type X is not applicable for the arguments (String)\n----------\n5. ERROR in X.java (at line 10)\n\t* @see X#smr_foo(java.util.Hashtable,Vector) Invalid ref: local method not applicable\n\t         ^^^^^^^\nJavadoc: The method smr_foo(Hashtable, Vector, boolean) in the type X is not applicable for the arguments (Hashtable, Vector)\n----------\n");
    }

    public void test133() {
        this.runNegativeTest(new String[]{"X.js", "import java.util.Vector;\npublic class X {\n\t/**\n\t * Invalid local methods references\n\t * \n\t * @see X#smr_foo(boolean,int i,byte,short s,char,long l,float,double d) Invalid reference: mixed argument declaration\n\t * @see X#smr_foo(String,String y,int) Invalid reference: mixed argument declaration\n\t * @see X#smr_foo(Hashtable,Vector,boolean) Invalid reference: unresolved argument type\n\t * @see X#smr_foo(Hashtable,Vector,boolean b) Invalid reference: mixed argument declaration\n\t */  \n\tpublic void s_foo() {\n\t}\n\n\t// Empty methods definition for reference\n\tpublic void smr_foo(boolean b, int i, byte y, short s, char c, long l, float f, double d) {\n\t}\n\tpublic void smr_foo(String str1, java.lang.String str2, int i) {\n\t}\n\tpublic void smr_foo(java.util.Hashtable h, java.util.Vector v, boolean b) {\n\t}\n}\n"}, "----------\n1. ERROR in X.java (at line 6)\n\t* @see X#smr_foo(boolean,int i,byte,short s,char,long l,float,double d) Invalid reference: mixed argument declaration\n\t                ^^^^^^^^^^^^^^\nJavadoc: Invalid parameters declaration\n----------\n2. ERROR in X.java (at line 7)\n\t* @see X#smr_foo(String,String y,int) Invalid reference: mixed argument declaration\n\t                ^^^^^^^^^^^^^^^^\nJavadoc: Invalid parameters declaration\n----------\n3. ERROR in X.java (at line 8)\n\t* @see X#smr_foo(Hashtable,Vector,boolean) Invalid reference: unresolved argument type\n\t                 ^^^^^^^^^\nJavadoc: Hashtable cannot be resolved to a type\n----------\n4. ERROR in X.java (at line 9)\n\t* @see X#smr_foo(Hashtable,Vector,boolean b) Invalid reference: mixed argument declaration\n\t                ^^^^^^^^^^^^^^^^^^^^^^^^^^^\nJavadoc: Invalid parameters declaration\n----------\n");
    }

    public void test135() {
        this.runConformTest(new String[]{"test/deep/qualified/name/p/X.js", "package test.deep.qualified.name.p;\nimport java.util.Vector;\npublic class X {\n\t/**\n\t * Valid local methods references\n\t * \n\t * @see test.deep.qualified.name.p.X#smr_foo() Valid local method reference\n\t * @see test.deep.qualified.name.p.X#smr_foo(boolean, int, byte, short, char, long, float, double) Valid local method reference\n\t * @see test.deep.qualified.name.p.X#smr_foo(boolean,int,byte,short,char,long,float,double) Valid local method reference\n\t * @see test.deep.qualified.name.p.X#smr_foo(boolean b, int i, byte y, short s, char c, long l, float f, double d) Valid local method reference\n\t * @see test.deep.qualified.name.p.X#smr_foo(boolean a1,int a2,byte a3,short a4,char a5,long a6,float a7,double a8) Valid local method reference\n\t * @see test.deep.qualified.name.p.X#smr_foo(String, String, int) Valid local method reference\n\t * @see test.deep.qualified.name.p.X#smr_foo(java.lang.String, String, int) Valid local method reference   \n\t * @see test.deep.qualified.name.p.X#smr_foo(String, java.lang.String, int) Valid local method reference   \n\t * @see test.deep.qualified.name.p.X#smr_foo(java.lang.String, java.lang.String, int) Valid local method reference   \n\t * @see test.deep.qualified.name.p.X#smr_foo(String x,String y,int z) Valid local method reference   \n\t * @see test.deep.qualified.name.p.X#smr_foo(java.lang.String x,String y, int z) Valid local method reference   \n\t * @see test.deep.qualified.name.p.X#smr_foo(String x,java.lang.String y,int z) Valid local method reference   \n\t * @see test.deep.qualified.name.p.X#smr_foo(java.lang.String x,java.lang.String y,int z) Valid local method reference   \n\t * @see test.deep.qualified.name.p.X#smr_foo(java.util.Hashtable,java.util.Vector,boolean) Valid local method reference\n\t * @see test.deep.qualified.name.p.X#smr_foo(java.util.Hashtable,Vector,boolean) Valid local method reference\n\t * @see test.deep.qualified.name.p.X#smr_foo(java.util.Hashtable a, java.util.Vector b, boolean c) Valid local method reference\n\t * @see test.deep.qualified.name.p.X#smr_foo(java.util.Hashtable a, Vector b, boolean c) Valid local method reference\n\t */  \n\tpublic void s_foo() {\n\t}\n\n\t// Empty methods definition for reference\n\tpublic void smr_foo() {\n\t}\n\tpublic void smr_foo(boolean b, int i, byte y, short s, char c, long l, float f, double d) {\n\t}\n\tpublic void smr_foo(String str1, java.lang.String str2, int i) {\n\t}\n\tpublic void smr_foo(java.util.Hashtable h, java.util.Vector v, boolean b) {\n\t}\n}\n"});
    }

    public void test136() {
        this.runNegativeTest(new String[]{"test/deep/qualified/name/p/X.js", "package test.deep.qualified.name.p;\npublic class X {\n\t/**\n\t * Invalid local methods references\n\t * \n\t * @see test.deep.qualified.name.p.X#unknown() Invalid ref: undefined local method reference\n\t * @see test.deep.qualified.name.p.X#smrfoo() Invalid ref: undefined local method reference\n\t * @see test.deep.qualified.name.p.X#smr_FOO() Invalid ref: undefined local method reference\n\t */  \n\tpublic void s_foo() {\n\t}\n\n\t// Empty methods definition for reference\n\tpublic void smr_foo() {\n\t}\n}\n"}, "----------\n1. ERROR in test\\deep\\qualified\\name\\p\\X.java (at line 6)\n\t* @see test.deep.qualified.name.p.X#unknown() Invalid ref: undefined local method reference\n\t                                    ^^^^^^^\nJavadoc: The method unknown() is undefined for the type X\n----------\n2. ERROR in test\\deep\\qualified\\name\\p\\X.java (at line 7)\n\t* @see test.deep.qualified.name.p.X#smrfoo() Invalid ref: undefined local method reference\n\t                                    ^^^^^^\nJavadoc: The method smrfoo() is undefined for the type X\n----------\n3. ERROR in test\\deep\\qualified\\name\\p\\X.java (at line 8)\n\t* @see test.deep.qualified.name.p.X#smr_FOO() Invalid ref: undefined local method reference\n\t                                    ^^^^^^^\nJavadoc: The method smr_FOO() is undefined for the type X\n----------\n");
    }

    public void test137() {
        this.runNegativeTest(new String[]{"test/deep/qualified/name/p/X.js", "package test.deep.qualified.name.p;\nimport java.util.Vector;\npublic class X {\n\t/**\n\t * Invalid local methods references\n\t * \n\t * @see test.deep.qualified.name.p.X#smr_foo(Object) Invalid ref: local method not applicable\n\t * @see test.deep.qualified.name.p.X#smr_foo(int, byte, short, char, long, float, double) Invalid ref: local method not applicable\n\t * @see test.deep.qualified.name.p.X#smr_foo(String, int) Invalid ref: local method not applicable\n\t * @see test.deep.qualified.name.p.X#smr_foo(String) Invalid ref: local method not applicable\n\t * @see test.deep.qualified.name.p.X#smr_foo(java.util.Hashtable,Vector) Invalid ref: local method not applicable\n\t */  \n\tpublic void s_foo() {\n\t}\n\n\t// Empty methods definition for reference\n\tpublic void smr_foo() {\n\t}\n\tpublic void smr_foo(boolean b, int i, byte y, short s, char c, long l, float f, double d) {\n\t}\n\tpublic void smr_foo(String str1, java.lang.String str2, int i) {\n\t}\n\tpublic void smr_foo(java.util.Hashtable h, java.util.Vector v, boolean b) {\n\t}\n}\n"}, "----------\n1. ERROR in test\\deep\\qualified\\name\\p\\X.java (at line 7)\n\t* @see test.deep.qualified.name.p.X#smr_foo(Object) Invalid ref: local method not applicable\n\t                                    ^^^^^^^\nJavadoc: The method smr_foo() in the type X is not applicable for the arguments (Object)\n----------\n2. ERROR in test\\deep\\qualified\\name\\p\\X.java (at line 8)\n\t* @see test.deep.qualified.name.p.X#smr_foo(int, byte, short, char, long, float, double) Invalid ref: local method not applicable\n\t                                    ^^^^^^^\nJavadoc: The method smr_foo(boolean, int, byte, short, char, long, float, double) in the type X is not applicable for the arguments (int, byte, short, char, long, float, double)\n----------\n3. ERROR in test\\deep\\qualified\\name\\p\\X.java (at line 9)\n\t* @see test.deep.qualified.name.p.X#smr_foo(String, int) Invalid ref: local method not applicable\n\t                                    ^^^^^^^\nJavadoc: The method smr_foo(String, String, int) in the type X is not applicable for the arguments (String, int)\n----------\n4. ERROR in test\\deep\\qualified\\name\\p\\X.java (at line 10)\n\t* @see test.deep.qualified.name.p.X#smr_foo(String) Invalid ref: local method not applicable\n\t                                    ^^^^^^^\nJavadoc: The method smr_foo(String, String, int) in the type X is not applicable for the arguments (String)\n----------\n5. ERROR in test\\deep\\qualified\\name\\p\\X.java (at line 11)\n\t* @see test.deep.qualified.name.p.X#smr_foo(java.util.Hashtable,Vector) Invalid ref: local method not applicable\n\t                                    ^^^^^^^\nJavadoc: The method smr_foo(Hashtable, Vector, boolean) in the type X is not applicable for the arguments (Hashtable, Vector)\n----------\n");
    }

    public void test138() {
        this.runNegativeTest(new String[]{"test/deep/qualified/name/p/X.js", "package test.deep.qualified.name.p;\nimport java.util.Vector;\npublic class X {\n\t/**\n\t * Invalid local methods references\n\t * \n\t * @see test.deep.qualified.name.p.X#smr_foo(boolean,int i,byte,short s,char,long l,float,double d) Invalid reference: mixed argument declaration\n\t * @see test.deep.qualified.name.p.X#smr_foo(String,String y,int) Invalid reference: mixed argument declaration\n\t * @see test.deep.qualified.name.p.X#smr_foo(Hashtable,Vector,boolean b) Invalid reference: mixed argument declaration\n\t * @see test.deep.qualified.name.p.X#smr_foo(Hashtable,Vector,boolean b) Invalid reference: mixed argument declaration\n\t */  \n\tpublic void s_foo() {\n\t}\n\n\t// Empty methods definition for reference\n\tpublic void smr_foo(boolean b, int i, byte y, short s, char c, long l, float f, double d) {\n\t}\n\tpublic void smr_foo(String str1, java.lang.String str2, int i) {\n\t}\n\tpublic void smr_foo(java.util.Hashtable h, java.util.Vector v, boolean b) {\n\t}\n}\n"}, "----------\n1. ERROR in test\\deep\\qualified\\name\\p\\X.java (at line 7)\n\t* @see test.deep.qualified.name.p.X#smr_foo(boolean,int i,byte,short s,char,long l,float,double d) Invalid reference: mixed argument declaration\n\t                                           ^^^^^^^^^^^^^^\nJavadoc: Invalid parameters declaration\n----------\n2. ERROR in test\\deep\\qualified\\name\\p\\X.java (at line 8)\n\t* @see test.deep.qualified.name.p.X#smr_foo(String,String y,int) Invalid reference: mixed argument declaration\n\t                                           ^^^^^^^^^^^^^^^^\nJavadoc: Invalid parameters declaration\n----------\n3. ERROR in test\\deep\\qualified\\name\\p\\X.java (at line 9)\n\t* @see test.deep.qualified.name.p.X#smr_foo(Hashtable,Vector,boolean b) Invalid reference: mixed argument declaration\n\t                                           ^^^^^^^^^^^^^^^^^^^^^^^^^^^\nJavadoc: Invalid parameters declaration\n----------\n4. ERROR in test\\deep\\qualified\\name\\p\\X.java (at line 10)\n\t* @see test.deep.qualified.name.p.X#smr_foo(Hashtable,Vector,boolean b) Invalid reference: mixed argument declaration\n\t                                           ^^^^^^^^^^^^^^^^^^^^^^^^^^^\nJavadoc: Invalid parameters declaration\n----------\n");
    }

    public void test140() {
        this.runConformReferenceTest(new String[]{"test/X.js", "package test;\npublic class X {\n\t/**\n\t * Valid package class methods references\n\t * \n\t * @see Visibility#vm_public() Valid ref: visible method\n\t * @see Visibility.VcPublic#vm_public() Valid ref: visible method in visible inner class\n\t * @see test.Visibility#vm_public() Valid ref: visible method\n\t * @see test.Visibility.VcPublic#vm_public() Valid ref: visible method in visible inner class\n\t */  \n\tpublic void s_foo() {\n\t}\n}\n"});
    }

    public void test141() {
        this.runNegativeReferenceTest(new String[]{"test/X.js", "package test;\npublic class X {\n\t/**\n\t * Invalid package class methods references (non-existence)\n\t * \n\t * @see Visibility#unknown() Invalid ref: non-existent method\n\t * @see Visibility.VcPublic#unknown() Invalid ref: non existent method in visible inner class\n\t * @see Unknown#vm_public() Invalid ref: non-existent class\n\t * @see Visibility.Unknown#vm_public() Invalid ref: non existent inner class\n\t */  \n\tpublic void s_foo() {\n\t}\n}\n"}, "----------\n1. ERROR in test\\X.java (at line 6)\n\t* @see Visibility#unknown() Invalid ref: non-existent method\n\t                  ^^^^^^^\nJavadoc: The method unknown() is undefined for the type Visibility\n----------\n2. ERROR in test\\X.java (at line 7)\n\t* @see Visibility.VcPublic#unknown() Invalid ref: non existent method in visible inner class\n\t                           ^^^^^^^\nJavadoc: The method unknown() is undefined for the type Visibility.VcPublic\n----------\n3. ERROR in test\\X.java (at line 8)\n\t* @see Unknown#vm_public() Invalid ref: non-existent class\n\t       ^^^^^^^\nJavadoc: Unknown cannot be resolved to a type\n----------\n4. ERROR in test\\X.java (at line 9)\n\t* @see Visibility.Unknown#vm_public() Invalid ref: non existent inner class\n\t       ^^^^^^^^^^^^^^^^^^\nJavadoc: Visibility.Unknown cannot be resolved to a type\n----------\n");
    }

    public void test142() {
        this.runNegativeReferenceTest(new String[]{"test/X.js", "package test;\npublic class X {\n\t/**\n\t * Invalid package class methods references (non-visible)\n\t * \n\t * @see Visibility#vm_private() Invalid ref: non-visible method\n\t * @see Visibility.VcPrivate#unknown() Invalid ref: non visible inner class (non existent method)\n\t * @see Visibility.VcPrivate#vm_private() Invalid ref: non visible inner class (non visible method)\n\t * @see Visibility.VcPrivate#vm_private(boolean, String) Invalid ref: non visible inner class (non applicable method)\n\t * @see Visibility.VcPrivate#vm_public() Invalid ref: non visible inner class (visible method)\n\t * @see Visibility.VcPrivate#vm_public(Object, float) Invalid ref: non visible inner class (non applicable visible method)\n\t * @see Visibility.VcPublic#vm_private() Invalid ref: non visible method in visible inner class\n\t */  \n\tpublic void s_foo() {\n\t}\n}\n"}, "----------\n1. ERROR in test\\X.java (at line 6)\n\t* @see Visibility#vm_private() Invalid ref: non-visible method\n\t                  ^^^^^^^^^^\nJavadoc: The method vm_private() from the type Visibility is not visible\n----------\n2. ERROR in test\\X.java (at line 7)\n\t* @see Visibility.VcPrivate#unknown() Invalid ref: non visible inner class (non existent method)\n\t       ^^^^^^^^^^^^^^^^^^^^\nJavadoc: The type Visibility.VcPrivate is not visible\n----------\n3. ERROR in test\\X.java (at line 8)\n\t* @see Visibility.VcPrivate#vm_private() Invalid ref: non visible inner class (non visible method)\n\t       ^^^^^^^^^^^^^^^^^^^^\nJavadoc: The type Visibility.VcPrivate is not visible\n----------\n4. ERROR in test\\X.java (at line 9)\n\t* @see Visibility.VcPrivate#vm_private(boolean, String) Invalid ref: non visible inner class (non applicable method)\n\t       ^^^^^^^^^^^^^^^^^^^^\nJavadoc: The type Visibility.VcPrivate is not visible\n----------\n5. ERROR in test\\X.java (at line 10)\n\t* @see Visibility.VcPrivate#vm_public() Invalid ref: non visible inner class (visible method)\n\t       ^^^^^^^^^^^^^^^^^^^^\nJavadoc: The type Visibility.VcPrivate is not visible\n----------\n6. ERROR in test\\X.java (at line 11)\n\t* @see Visibility.VcPrivate#vm_public(Object, float) Invalid ref: non visible inner class (non applicable visible method)\n\t       ^^^^^^^^^^^^^^^^^^^^\nJavadoc: The type Visibility.VcPrivate is not visible\n----------\n7. ERROR in test\\X.java (at line 12)\n\t* @see Visibility.VcPublic#vm_private() Invalid ref: non visible method in visible inner class\n\t                           ^^^^^^^^^^\nJavadoc: The method vm_private() from the type Visibility.VcPublic is not visible\n----------\n");
    }

    public void test143() {
        this.runNegativeReferenceTest(new String[]{"test/X.js", "package test;\npublic class X {\n\t/**\n\t * Invalid package class methods references (non-applicable)\n\t * \n\t * @see Visibility#vm_private(int) Invalid ref: non-applicable method\n\t * @see Visibility#vm_public(String) Invalid ref: non-applicable method\n\t * @see Visibility.VcPublic#vm_private(Integer, byte) Invalid ref: non applicable method in visible inner class\n\t * @see Visibility.VcPublic#vm_public(Double z, Boolean x) Invalid ref: non applicable method in visible inner class\n\t */  \n\tpublic void s_foo() {\n\t}\n}\n"}, "----------\n1. ERROR in test\\X.java (at line 6)\n\t* @see Visibility#vm_private(int) Invalid ref: non-applicable method\n\t                  ^^^^^^^^^^\nJavadoc: The method vm_private() in the type Visibility is not applicable for the arguments (int)\n----------\n2. ERROR in test\\X.java (at line 7)\n\t* @see Visibility#vm_public(String) Invalid ref: non-applicable method\n\t                  ^^^^^^^^^\nJavadoc: The method vm_public() in the type Visibility is not applicable for the arguments (String)\n----------\n3. ERROR in test\\X.java (at line 8)\n\t* @see Visibility.VcPublic#vm_private(Integer, byte) Invalid ref: non applicable method in visible inner class\n\t                           ^^^^^^^^^^\nJavadoc: The method vm_private() in the type Visibility.VcPublic is not applicable for the arguments (Integer, byte)\n----------\n4. ERROR in test\\X.java (at line 9)\n\t* @see Visibility.VcPublic#vm_public(Double z, Boolean x) Invalid ref: non applicable method in visible inner class\n\t                           ^^^^^^^^^\nJavadoc: The method vm_public() in the type Visibility.VcPublic is not applicable for the arguments (Double, Boolean)\n----------\n");
    }

    public void test144() {
        this.runNegativeReferenceTest(new String[]{"test/X.js", "package test;\npublic class X {\n\t/**\n\t * Invalid package class methods references (invalid arguments)\n\t * \n\t * @see Visibility#vm_private(,) Invalid ref: invalid argument declaration\n\t * @see Visibility#vm_public(,String) Invalid ref: invalid argument declaration\n\t * @see Visibility.VcPrivate#vm_private(char, double d) Invalid ref: invalid argument declaration\n\t * @see Visibility.VcPrivate#vm_public(#) Invalid ref: invalid argument declaration\n\t * @see Visibility.VcPublic#vm_private(a a a) Invalid ref: invalid argument declaration\n\t * @see Visibility.VcPublic#vm_public(####) Invalid ref: Invalid ref: invalid argument declaration\n\t */  \n\tpublic void s_foo() {\n\t}\n}\n"}, "----------\n1. ERROR in test\\X.java (at line 6)\n\t* @see Visibility#vm_private(,) Invalid ref: invalid argument declaration\n\t                            ^^\nJavadoc: Invalid parameters declaration\n----------\n2. ERROR in test\\X.java (at line 7)\n\t* @see Visibility#vm_public(,String) Invalid ref: invalid argument declaration\n\t                           ^^\nJavadoc: Invalid parameters declaration\n----------\n3. ERROR in test\\X.java (at line 8)\n\t* @see Visibility.VcPrivate#vm_private(char, double d) Invalid ref: invalid argument declaration\n\t                                      ^^^^^^^^^^^^^^^\nJavadoc: Invalid parameters declaration\n----------\n4. ERROR in test\\X.java (at line 9)\n\t* @see Visibility.VcPrivate#vm_public(#) Invalid ref: invalid argument declaration\n\t                                     ^^\nJavadoc: Invalid parameters declaration\n----------\n5. ERROR in test\\X.java (at line 10)\n\t* @see Visibility.VcPublic#vm_private(a a a) Invalid ref: invalid argument declaration\n\t                                     ^^^^^^\nJavadoc: Invalid parameters declaration\n----------\n6. ERROR in test\\X.java (at line 11)\n\t* @see Visibility.VcPublic#vm_public(####) Invalid ref: Invalid ref: invalid argument declaration\n\t                                    ^^\nJavadoc: Invalid parameters declaration\n----------\n");
    }

    public void test145() {
        this.runConformReferenceTest(new String[]{"test/X.js", "package test;\npublic class X {\n\t/**\n\t * Valid package super class methods references\n\t * \n\t * @see Visibility#avm_public() Valid ref: visible inherited method\n\t * @see Visibility.AvcPublic#avm_public() Valid ref: visible inherited method in visible inner class\n\t * @see test.Visibility#avm_public() Valid ref: visible inherited method\n\t * @see test.Visibility.AvcPublic#avm_public() Valid ref: visible inherited method in visible inner class\n\t */  \n\tpublic void s_foo() {\n\t}\n}\n"});
    }

    public void test146() {
        this.runNegativeReferenceTest(new String[]{"test/X.js", "package test;\npublic class X {\n\t/**\n\t * Invalid package super class methods references (non-visible)\n\t * \n\t * @see Visibility#avm_private() Invalid ref: non-visible inherited method\n\t * @see Visibility.AvcPrivate#unknown() Invalid ref: non visible inherited inner class (non existent method)\n\t * @see Visibility.AvcPrivate#avm_private() Invalid ref: non visible inherited inner class (non visible method)\n\t * @see Visibility.AvcPrivate#avm_private(boolean, String) Invalid ref: non visible inherited inner class (non applicable method)\n\t * @see Visibility.AvcPrivate#avm_public() Invalid ref: non visible inherited inner class (visible method)\n\t * @see Visibility.AvcPrivate#avm_public(Object, float) Invalid ref: non visible inherited inner class (non applicable visible method)\n\t * @see Visibility.AvcPublic#avm_private() Invalid ref: non visible inherited method in visible inherited inner class\n\t */  \n\tpublic void s_foo() {\n\t}\n}\n"}, "----------\n1. ERROR in test\\X.java (at line 6)\n\t* @see Visibility#avm_private() Invalid ref: non-visible inherited method\n\t                  ^^^^^^^^^^^\nJavadoc: The method avm_private() from the type AbstractVisibility is not visible\n----------\n2. ERROR in test\\X.java (at line 7)\n\t* @see Visibility.AvcPrivate#unknown() Invalid ref: non visible inherited inner class (non existent method)\n\t       ^^^^^^^^^^^^^^^^^^^^^\nJavadoc: The type Visibility.AvcPrivate is not visible\n----------\n3. ERROR in test\\X.java (at line 8)\n\t* @see Visibility.AvcPrivate#avm_private() Invalid ref: non visible inherited inner class (non visible method)\n\t       ^^^^^^^^^^^^^^^^^^^^^\nJavadoc: The type Visibility.AvcPrivate is not visible\n----------\n4. ERROR in test\\X.java (at line 9)\n\t* @see Visibility.AvcPrivate#avm_private(boolean, String) Invalid ref: non visible inherited inner class (non applicable method)\n\t       ^^^^^^^^^^^^^^^^^^^^^\nJavadoc: The type Visibility.AvcPrivate is not visible\n----------\n5. ERROR in test\\X.java (at line 10)\n\t* @see Visibility.AvcPrivate#avm_public() Invalid ref: non visible inherited inner class (visible method)\n\t       ^^^^^^^^^^^^^^^^^^^^^\nJavadoc: The type Visibility.AvcPrivate is not visible\n----------\n6. ERROR in test\\X.java (at line 11)\n\t* @see Visibility.AvcPrivate#avm_public(Object, float) Invalid ref: non visible inherited inner class (non applicable visible method)\n\t       ^^^^^^^^^^^^^^^^^^^^^\nJavadoc: The type Visibility.AvcPrivate is not visible\n----------\n7. ERROR in test\\X.java (at line 12)\n\t* @see Visibility.AvcPublic#avm_private() Invalid ref: non visible inherited method in visible inherited inner class\n\t                            ^^^^^^^^^^^\nJavadoc: The method avm_private() from the type AbstractVisibility.AvcPublic is not visible\n----------\n");
    }

    public void test147() {
        this.runNegativeReferenceTest(new String[]{"test/X.js", "package test;\npublic class X {\n\t/**\n\t * Invalid package super class methods references (non-applicable)\n\t * \n\t * @see Visibility#avm_private(int) Invalid ref: non-applicable inherited method\n\t * @see Visibility#avm_public(String) Invalid ref: non-applicable inherited method\n\t * @see Visibility.AvcPublic#avm_private(Integer, byte) Invalid ref: non applicable inherited method in visible inner class\n\t * @see Visibility.AvcPublic#avm_public(Double z, Boolean x) Invalid ref: non applicable inherited method in visible inner class\n\t */  \n\tpublic void s_foo() {\n\t}\n}\n"}, "----------\n1. ERROR in test\\X.java (at line 6)\n\t* @see Visibility#avm_private(int) Invalid ref: non-applicable inherited method\n\t                  ^^^^^^^^^^^\nJavadoc: The method avm_private() in the type AbstractVisibility is not applicable for the arguments (int)\n----------\n2. ERROR in test\\X.java (at line 7)\n\t* @see Visibility#avm_public(String) Invalid ref: non-applicable inherited method\n\t                  ^^^^^^^^^^\nJavadoc: The method avm_public() in the type AbstractVisibility is not applicable for the arguments (String)\n----------\n3. ERROR in test\\X.java (at line 8)\n\t* @see Visibility.AvcPublic#avm_private(Integer, byte) Invalid ref: non applicable inherited method in visible inner class\n\t                            ^^^^^^^^^^^\nJavadoc: The method avm_private() in the type AbstractVisibility.AvcPublic is not applicable for the arguments (Integer, byte)\n----------\n4. ERROR in test\\X.java (at line 9)\n\t* @see Visibility.AvcPublic#avm_public(Double z, Boolean x) Invalid ref: non applicable inherited method in visible inner class\n\t                            ^^^^^^^^^^\nJavadoc: The method avm_public() in the type AbstractVisibility.AvcPublic is not applicable for the arguments (Double, Boolean)\n----------\n");
    }

    public void test148() {
        this.runNegativeReferenceTest(new String[]{"test/X.js", "package test;\npublic class X {\n\t/**\n\t * Invalid package super class methods references (invalid arguments)\n\t * \n\t * @see Visibility#avm_private(,,,,) Invalid ref: invalid argument declaration\n\t * @see Visibility#avm_public(String,,,) Invalid ref: invalid argument declaration\n\t * @see Visibility.AvcPrivate#avm_private(char c, double) Invalid ref: invalid argument declaration\n\t * @see Visibility.AvcPrivate#avm_public(*) Invalid ref: invalid argument declaration\n\t * @see Visibility.AvcPublic#avm_private(a a a) Invalid ref: invalid argument declaration\n\t * @see Visibility.AvcPublic#avm_public(*****) Invalid ref: invalid argument declaration\n\t */  \n\tpublic void s_foo() {\n\t}\n}\n"}, "----------\n1. ERROR in test\\X.java (at line 6)\n\t* @see Visibility#avm_private(,,,,) Invalid ref: invalid argument declaration\n\t                             ^^\nJavadoc: Invalid parameters declaration\n----------\n2. ERROR in test\\X.java (at line 7)\n\t* @see Visibility#avm_public(String,,,) Invalid ref: invalid argument declaration\n\t                            ^^^^^^^^^\nJavadoc: Invalid parameters declaration\n----------\n3. ERROR in test\\X.java (at line 8)\n\t* @see Visibility.AvcPrivate#avm_private(char c, double) Invalid ref: invalid argument declaration\n\t                                        ^^^^^^^^^^^^^^^^\nJavadoc: Invalid parameters declaration\n----------\n4. ERROR in test\\X.java (at line 9)\n\t* @see Visibility.AvcPrivate#avm_public(*) Invalid ref: invalid argument declaration\n\t                                       ^^\nJavadoc: Invalid parameters declaration\n----------\n5. ERROR in test\\X.java (at line 10)\n\t* @see Visibility.AvcPublic#avm_private(a a a) Invalid ref: invalid argument declaration\n\t                                       ^^^^^^\nJavadoc: Invalid parameters declaration\n----------\n6. ERROR in test\\X.java (at line 11)\n\t* @see Visibility.AvcPublic#avm_public(*****) Invalid ref: invalid argument declaration\n\t                                      ^^\nJavadoc: Invalid parameters declaration\n----------\n");
    }

    public void test150() {
        this.runNegativeReferenceTest(new String[]{"test/X.js", "package test;\nimport test.copy.*;\npublic class X {\n\t/**\n\t * Invalid other package non visible class methods references (non existent/visible arguments)\n\t * \n\t * @see VisibilityPackage#unknown() Invalid ref: non visible class (non existent method)\n\t * @see VisibilityPackage#vm_private() Invalid ref: non visible class (non visible method)\n\t * @see VisibilityPackage#vm_private(boolean) Invalid ref: non visible class (non existent method)\n\t * @see VisibilityPackage#vm_public() Invalid ref: non visible class (visible method)\n\t * @see VisibilityPackage#vm_public(long,long,long,int) Invalid ref: non visible class (visible method)\n\t * @see VisibilityPackage.VpPrivate#unknown() Invalid ref: non visible class and non visible inner class (non existent method)\n\t * @see VisibilityPackage.VpPrivate#vm_private() Invalid ref: non visible class and non visible inner class (non visible method)\n\t * @see VisibilityPackage.VpPrivate#vm_private(boolean, String) Invalid ref: non visible class and non visible inner class (non applicable method)\n\t * @see VisibilityPackage.VpPrivate#vm_public() Invalid ref: non visible class and non visible inner class (visible method)\n\t * @see VisibilityPackage.VpPrivate#vm_public(Object, float) Invalid ref: non visible class and non visible inner class (non applicable visible method)\n\t * @see VisibilityPackage.VpPublic#unknown() Invalid ref: non visible class and visible inner class (non existent method)\n\t * @see VisibilityPackage.VpPublic#vm_private() Invalid ref: non visible class and visible inner class (non visible method)\n\t * @see VisibilityPackage.VpPublic#vm_private(boolean, String) Invalid ref: non visible class and visible inner class (non applicable method)\n\t * @see VisibilityPackage.VpPublic#vm_public() Invalid ref: non visible class and visible inner class (visible method)\n\t * @see VisibilityPackage.VpPublic#vm_public(Object, float) Invalid ref: non visible class and visible inner class (non applicable visible method)\n\t */  \n\tpublic void s_foo() {\n\t}\n}\n"}, "----------\n1. ERROR in test\\X.java (at line 7)\n\t* @see VisibilityPackage#unknown() Invalid ref: non visible class (non existent method)\n\t       ^^^^^^^^^^^^^^^^^\nJavadoc: The type VisibilityPackage is not visible\n----------\n2. ERROR in test\\X.java (at line 8)\n\t* @see VisibilityPackage#vm_private() Invalid ref: non visible class (non visible method)\n\t       ^^^^^^^^^^^^^^^^^\nJavadoc: The type VisibilityPackage is not visible\n----------\n3. ERROR in test\\X.java (at line 9)\n\t* @see VisibilityPackage#vm_private(boolean) Invalid ref: non visible class (non existent method)\n\t       ^^^^^^^^^^^^^^^^^\nJavadoc: The type VisibilityPackage is not visible\n----------\n4. ERROR in test\\X.java (at line 10)\n\t* @see VisibilityPackage#vm_public() Invalid ref: non visible class (visible method)\n\t       ^^^^^^^^^^^^^^^^^\nJavadoc: The type VisibilityPackage is not visible\n----------\n5. ERROR in test\\X.java (at line 11)\n\t* @see VisibilityPackage#vm_public(long,long,long,int) Invalid ref: non visible class (visible method)\n\t       ^^^^^^^^^^^^^^^^^\nJavadoc: The type VisibilityPackage is not visible\n----------\n6. ERROR in test\\X.java (at line 12)\n\t* @see VisibilityPackage.VpPrivate#unknown() Invalid ref: non visible class and non visible inner class (non existent method)\n\t       ^^^^^^^^^^^^^^^^^^^^^^^^^^^\nJavadoc: The type VisibilityPackage is not visible\n----------\n7. ERROR in test\\X.java (at line 13)\n\t* @see VisibilityPackage.VpPrivate#vm_private() Invalid ref: non visible class and non visible inner class (non visible method)\n\t       ^^^^^^^^^^^^^^^^^^^^^^^^^^^\nJavadoc: The type VisibilityPackage is not visible\n----------\n8. ERROR in test\\X.java (at line 14)\n\t* @see VisibilityPackage.VpPrivate#vm_private(boolean, String) Invalid ref: non visible class and non visible inner class (non applicable method)\n\t       ^^^^^^^^^^^^^^^^^^^^^^^^^^^\nJavadoc: The type VisibilityPackage is not visible\n----------\n9. ERROR in test\\X.java (at line 15)\n\t* @see VisibilityPackage.VpPrivate#vm_public() Invalid ref: non visible class and non visible inner class (visible method)\n\t       ^^^^^^^^^^^^^^^^^^^^^^^^^^^\nJavadoc: The type VisibilityPackage is not visible\n----------\n10. ERROR in test\\X.java (at line 16)\n\t* @see VisibilityPackage.VpPrivate#vm_public(Object, float) Invalid ref: non visible class and non visible inner class (non applicable visible method)\n\t       ^^^^^^^^^^^^^^^^^^^^^^^^^^^\nJavadoc: The type VisibilityPackage is not visible\n----------\n11. ERROR in test\\X.java (at line 17)\n\t* @see VisibilityPackage.VpPublic#unknown() Invalid ref: non visible class and visible inner class (non existent method)\n\t       ^^^^^^^^^^^^^^^^^^^^^^^^^^\nJavadoc: The type VisibilityPackage is not visible\n----------\n12. ERROR in test\\X.java (at line 18)\n\t* @see VisibilityPackage.VpPublic#vm_private() Invalid ref: non visible class and visible inner class (non visible method)\n\t       ^^^^^^^^^^^^^^^^^^^^^^^^^^\nJavadoc: The type VisibilityPackage is not visible\n----------\n13. ERROR in test\\X.java (at line 19)\n\t* @see VisibilityPackage.VpPublic#vm_private(boolean, String) Invalid ref: non visible class and visible inner class (non applicable method)\n\t       ^^^^^^^^^^^^^^^^^^^^^^^^^^\nJavadoc: The type VisibilityPackage is not visible\n----------\n14. ERROR in test\\X.java (at line 20)\n\t* @see VisibilityPackage.VpPublic#vm_public() Invalid ref: non visible class and visible inner class (visible method)\n\t       ^^^^^^^^^^^^^^^^^^^^^^^^^^\nJavadoc: The type VisibilityPackage is not visible\n----------\n15. ERROR in test\\X.java (at line 21)\n\t* @see VisibilityPackage.VpPublic#vm_public(Object, float) Invalid ref: non visible class and visible inner class (non applicable visible method)\n\t       ^^^^^^^^^^^^^^^^^^^^^^^^^^\nJavadoc: The type VisibilityPackage is not visible\n----------\n");
    }

    public void test151() {
        this.runNegativeReferenceTest(new String[]{"test/X.js", "package test;\nimport test.copy.VisibilityPackage;\npublic class X {\n\t/**\n\t * Invalid other package non visible class methods references (invalid arguments)\n\t * \n\t * @see VisibilityPackage#vm_private(boolean-) Invalid ref: invalid argument declaration\n\t * @see VisibilityPackage#vm_public(long, int() Invalid ref: invalid argument declaration\n\t * @see VisibilityPackage.VpPrivate#vm_private(char, a double d()) Invalid ref: invalid argument declaration\n\t * @see VisibilityPackage.VpPrivate#vm_public(()) Invalid ref: invalid argument declaration\n\t * @see VisibilityPackage.VpPublic#vm_private(char double) Invalid ref: invalid argument declaration\n\t * @see VisibilityPackage.VpPublic#vm_public((((() Invalid ref: invalid argument declaration\n\t */  \n\tpublic void s_foo() {\n\t}\n}\n"}, "----------\n1. ERROR in test\\X.java (at line 2)\n\timport test.copy.VisibilityPackage;\n\t       ^^^^^^^^^^^^^^^^^^^^^^^^^^^\nThe type test.copy.VisibilityPackage is not visible\n----------\n2. ERROR in test\\X.java (at line 7)\n\t* @see VisibilityPackage#vm_private(boolean-) Invalid ref: invalid argument declaration\n\t                                   ^^^^^^^^^\nJavadoc: Invalid parameters declaration\n----------\n3. ERROR in test\\X.java (at line 8)\n\t* @see VisibilityPackage#vm_public(long, int() Invalid ref: invalid argument declaration\n\t                                  ^^^^^^^^^^^\nJavadoc: Invalid parameters declaration\n----------\n4. ERROR in test\\X.java (at line 9)\n\t* @see VisibilityPackage.VpPrivate#vm_private(char, a double d()) Invalid ref: invalid argument declaration\n\t                                             ^^^^^^^^^^^^^^^\nJavadoc: Invalid parameters declaration\n----------\n5. ERROR in test\\X.java (at line 10)\n\t* @see VisibilityPackage.VpPrivate#vm_public(()) Invalid ref: invalid argument declaration\n\t                                            ^^\nJavadoc: Invalid parameters declaration\n----------\n6. ERROR in test\\X.java (at line 11)\n\t* @see VisibilityPackage.VpPublic#vm_private(char double) Invalid ref: invalid argument declaration\n\t                                            ^^^^^^^^^^^^\nJavadoc: Invalid parameters declaration\n----------\n7. ERROR in test\\X.java (at line 12)\n\t* @see VisibilityPackage.VpPublic#vm_public((((() Invalid ref: invalid argument declaration\n\t                                           ^^\nJavadoc: Invalid parameters declaration\n----------\n");
    }

    public void test152() {
        this.runNegativeReferenceTest(new String[]{"test/X.js", "package test;\npublic class X {\n\t/**\n\t * Invalid other fully qualified name package non visible class methods references (non existent/visible arguments)\n\t * \n\t * @see test.copy.VisibilityPackage#unknown() Invalid ref: non visible class (non existent method)\n\t * @see test.copy.VisibilityPackage#vm_private() Invalid ref: non visible class (non visible method)\n\t * @see test.copy.VisibilityPackage#vm_private(boolean) Invalid ref: non visible class (non existent method)\n\t * @see test.copy.VisibilityPackage#vm_public() Invalid ref: non visible class (visible method)\n\t * @see test.copy.VisibilityPackage#vm_public(long,long,long,int) Invalid ref: non visible class (visible method)\n\t * @see test.copy.VisibilityPackage.VpPrivate#unknown() Invalid ref: non visible class and non visible inner class (non existent method)\n\t * @see test.copy.VisibilityPackage.VpPrivate#vm_private() Invalid ref: non visible class and non visible inner class (non visible method)\n\t * @see test.copy.VisibilityPackage.VpPrivate#vm_private(boolean, String) Invalid ref: non visible class and non visible inner class (non applicable method)\n\t * @see test.copy.VisibilityPackage.VpPrivate#vm_public() Invalid ref: non visible class and non visible inner class (visible method)\n\t * @see test.copy.VisibilityPackage.VpPrivate#vm_public(Object, float) Invalid ref: non visible class and non visible inner class (non applicable visible method)\n\t * @see test.copy.VisibilityPackage.VpPublic#unknown() Invalid ref: non visible class and visible inner class (non existent method)\n\t * @see test.copy.VisibilityPackage.VpPublic#vm_private() Invalid ref: non visible class and visible inner class (non visible method)\n\t * @see test.copy.VisibilityPackage.VpPublic#vm_private(boolean, String) Invalid ref: non visible class and visible inner class (non applicable method)\n\t * @see test.copy.VisibilityPackage.VpPublic#vm_public() Invalid ref: non visible class and visible inner class (visible method)\n\t * @see test.copy.VisibilityPackage.VpPublic#vm_public(Object, float) Invalid ref: non visible class and visible inner class (non applicable visible method)\n\t */  \n\tpublic void s_foo() {\n\t}\n}\n"}, "----------\n1. ERROR in test\\X.java (at line 6)\n\t* @see test.copy.VisibilityPackage#unknown() Invalid ref: non visible class (non existent method)\n\t       ^^^^^^^^^^^^^^^^^^^^^^^^^^^\nJavadoc: The type test.copy.VisibilityPackage is not visible\n----------\n2. ERROR in test\\X.java (at line 7)\n\t* @see test.copy.VisibilityPackage#vm_private() Invalid ref: non visible class (non visible method)\n\t       ^^^^^^^^^^^^^^^^^^^^^^^^^^^\nJavadoc: The type test.copy.VisibilityPackage is not visible\n----------\n3. ERROR in test\\X.java (at line 8)\n\t* @see test.copy.VisibilityPackage#vm_private(boolean) Invalid ref: non visible class (non existent method)\n\t       ^^^^^^^^^^^^^^^^^^^^^^^^^^^\nJavadoc: The type test.copy.VisibilityPackage is not visible\n----------\n4. ERROR in test\\X.java (at line 9)\n\t* @see test.copy.VisibilityPackage#vm_public() Invalid ref: non visible class (visible method)\n\t       ^^^^^^^^^^^^^^^^^^^^^^^^^^^\nJavadoc: The type test.copy.VisibilityPackage is not visible\n----------\n5. ERROR in test\\X.java (at line 10)\n\t* @see test.copy.VisibilityPackage#vm_public(long,long,long,int) Invalid ref: non visible class (visible method)\n\t       ^^^^^^^^^^^^^^^^^^^^^^^^^^^\nJavadoc: The type test.copy.VisibilityPackage is not visible\n----------\n6. ERROR in test\\X.java (at line 11)\n\t* @see test.copy.VisibilityPackage.VpPrivate#unknown() Invalid ref: non visible class and non visible inner class (non existent method)\n\t       ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^\nJavadoc: The type test.copy.VisibilityPackage is not visible\n----------\n7. ERROR in test\\X.java (at line 12)\n\t* @see test.copy.VisibilityPackage.VpPrivate#vm_private() Invalid ref: non visible class and non visible inner class (non visible method)\n\t       ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^\nJavadoc: The type test.copy.VisibilityPackage is not visible\n----------\n8. ERROR in test\\X.java (at line 13)\n\t* @see test.copy.VisibilityPackage.VpPrivate#vm_private(boolean, String) Invalid ref: non visible class and non visible inner class (non applicable method)\n\t       ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^\nJavadoc: The type test.copy.VisibilityPackage is not visible\n----------\n9. ERROR in test\\X.java (at line 14)\n\t* @see test.copy.VisibilityPackage.VpPrivate#vm_public() Invalid ref: non visible class and non visible inner class (visible method)\n\t       ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^\nJavadoc: The type test.copy.VisibilityPackage is not visible\n----------\n10. ERROR in test\\X.java (at line 15)\n\t* @see test.copy.VisibilityPackage.VpPrivate#vm_public(Object, float) Invalid ref: non visible class and non visible inner class (non applicable visible method)\n\t       ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^\nJavadoc: The type test.copy.VisibilityPackage is not visible\n----------\n11. ERROR in test\\X.java (at line 16)\n\t* @see test.copy.VisibilityPackage.VpPublic#unknown() Invalid ref: non visible class and visible inner class (non existent method)\n\t       ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^\nJavadoc: The type test.copy.VisibilityPackage is not visible\n----------\n12. ERROR in test\\X.java (at line 17)\n\t* @see test.copy.VisibilityPackage.VpPublic#vm_private() Invalid ref: non visible class and visible inner class (non visible method)\n\t       ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^\nJavadoc: The type test.copy.VisibilityPackage is not visible\n----------\n13. ERROR in test\\X.java (at line 18)\n\t* @see test.copy.VisibilityPackage.VpPublic#vm_private(boolean, String) Invalid ref: non visible class and visible inner class (non applicable method)\n\t       ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^\nJavadoc: The type test.copy.VisibilityPackage is not visible\n----------\n14. ERROR in test\\X.java (at line 19)\n\t* @see test.copy.VisibilityPackage.VpPublic#vm_public() Invalid ref: non visible class and visible inner class (visible method)\n\t       ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^\nJavadoc: The type test.copy.VisibilityPackage is not visible\n----------\n15. ERROR in test\\X.java (at line 20)\n\t* @see test.copy.VisibilityPackage.VpPublic#vm_public(Object, float) Invalid ref: non visible class and visible inner class (non applicable visible method)\n\t       ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^\nJavadoc: The type test.copy.VisibilityPackage is not visible\n----------\n");
    }

    public void test153() {
        this.runNegativeReferenceTest(new String[]{"test/X.js", "package test;\npublic class X {\n\t/**\n\t * Invalid other fully qualified name package non visible class methods references (invalid arguments)\n\t * \n\t * @see test.copy.VisibilityPackage#vm_private(boolean-) Invalid ref: invalid argument declaration\n\t * @see test.copy.VisibilityPackage#vm_public(long, int() Invalid ref: invalid argument declaration\n\t * @see test.copy.VisibilityPackage.VpPrivate#vm_private(char, a double d()) Invalid ref: invalid argument declaration\n\t * @see test.copy.VisibilityPackage.VpPrivate#vm_public(()) Invalid ref: invalid argument declaration\n\t * @see test.copy.VisibilityPackage.VpPublic#vm_private(char double) Invalid ref: invalid argument declaration\n\t * @see test.copy.VisibilityPackage.VpPublic#vm_public((((() Invalid ref: invalid argument declaration\n\t */  \n\tpublic void s_foo() {\n\t}\n}\n"}, "----------\n1. ERROR in test\\X.java (at line 6)\n\t* @see test.copy.VisibilityPackage#vm_private(boolean-) Invalid ref: invalid argument declaration\n\t                                             ^^^^^^^^^\nJavadoc: Invalid parameters declaration\n----------\n2. ERROR in test\\X.java (at line 7)\n\t* @see test.copy.VisibilityPackage#vm_public(long, int() Invalid ref: invalid argument declaration\n\t                                            ^^^^^^^^^^^\nJavadoc: Invalid parameters declaration\n----------\n3. ERROR in test\\X.java (at line 8)\n\t* @see test.copy.VisibilityPackage.VpPrivate#vm_private(char, a double d()) Invalid ref: invalid argument declaration\n\t                                                       ^^^^^^^^^^^^^^^\nJavadoc: Invalid parameters declaration\n----------\n4. ERROR in test\\X.java (at line 9)\n\t* @see test.copy.VisibilityPackage.VpPrivate#vm_public(()) Invalid ref: invalid argument declaration\n\t                                                      ^^\nJavadoc: Invalid parameters declaration\n----------\n5. ERROR in test\\X.java (at line 10)\n\t* @see test.copy.VisibilityPackage.VpPublic#vm_private(char double) Invalid ref: invalid argument declaration\n\t                                                      ^^^^^^^^^^^^\nJavadoc: Invalid parameters declaration\n----------\n6. ERROR in test\\X.java (at line 11)\n\t* @see test.copy.VisibilityPackage.VpPublic#vm_public((((() Invalid ref: invalid argument declaration\n\t                                                     ^^\nJavadoc: Invalid parameters declaration\n----------\n");
    }

    public void test154() {
        this.runConformReferenceTest(new String[]{"test/X.js", "package test;\nimport test.copy.VisibilityPublic;\npublic class X {\n\t/**\n\t * Valid other package visible class methods references \n\t * \n\t * @see VisibilityPublic#vm_public() Valid ref to not visible method of other package class\n\t * @see VisibilityPublic.VpPublic#vm_public() Valid ref to visible method of other package public inner class\n\t */\n\tpublic void s_foo() {\n\t}\n}\n"});
    }

    public void test155() {
        this.runNegativeReferenceTest(new String[]{"test/X.js", "package test;\nimport test.copy.VisibilityPublic;\npublic class X {\n\t/**\n\t * Invalid other package visible class methods references (non-existent)\n\t * \n\t * @see VisibilityPublic#unknown() Invalid ref: non existent method\n\t * @see VisibilityPublic.VpPublic#unknown() Invalid ref: non existent method of visible inner class\n\t */\n\tpublic void s_foo() {\n\t}\n}\n"}, "----------\n1. ERROR in test\\X.java (at line 7)\n\t* @see VisibilityPublic#unknown() Invalid ref: non existent method\n\t                        ^^^^^^^\nJavadoc: The method unknown() is undefined for the type VisibilityPublic\n----------\n2. ERROR in test\\X.java (at line 8)\n\t* @see VisibilityPublic.VpPublic#unknown() Invalid ref: non existent method of visible inner class\n\t                                 ^^^^^^^\nJavadoc: The method unknown() is undefined for the type VisibilityPublic.VpPublic\n----------\n");
    }

    public void test156() {
        this.runNegativeReferenceTest(new String[]{"test/X.js", "package test;\nimport test.copy.VisibilityPublic;\npublic class X {\n\t/**\n\t * Invalid other package visible class methods references (non-visible)\n\t * \n\t * @see VisibilityPublic#vm_private() Invalid ref: non visible method in visible class\n\t * @see VisibilityPublic#vm_public() Valid ref: visible method in visible class\n\t * @see VisibilityPublic.VpPrivate#unknown() Invalid ref: non visible inner class (non existent method)\n\t * @see VisibilityPublic.VpPrivate#vm_private() Invalid ref: non visible inner class in visible class and (non visible method)\n\t * @see VisibilityPublic.VpPrivate#vm_private(boolean, String) Invalid ref: non visible inner class in visible class (non applicable method)\n\t * @see VisibilityPublic.VpPrivate#vm_public() Invalid ref: non visible inner class in visible class (visible method)\n\t * @see VisibilityPublic.VpPrivate#vm_public(Object, float) Invalid ref: non visible inner class in visible class (non applicable visible method)\n\t * @see VisibilityPublic.VpPublic#vm_private() Invalid ref: non visible method in visible inner class\n\t */\n\tpublic void s_foo() {\n\t}\n}\n"}, "----------\n1. ERROR in test\\X.java (at line 7)\n\t* @see VisibilityPublic#vm_private() Invalid ref: non visible method in visible class\n\t                        ^^^^^^^^^^\nJavadoc: The method vm_private() from the type VisibilityPublic is not visible\n----------\n2. ERROR in test\\X.java (at line 9)\n\t* @see VisibilityPublic.VpPrivate#unknown() Invalid ref: non visible inner class (non existent method)\n\t       ^^^^^^^^^^^^^^^^^^^^^^^^^^\nJavadoc: The type VisibilityPublic.VpPrivate is not visible\n----------\n3. ERROR in test\\X.java (at line 10)\n\t* @see VisibilityPublic.VpPrivate#vm_private() Invalid ref: non visible inner class in visible class and (non visible method)\n\t       ^^^^^^^^^^^^^^^^^^^^^^^^^^\nJavadoc: The type VisibilityPublic.VpPrivate is not visible\n----------\n4. ERROR in test\\X.java (at line 11)\n\t* @see VisibilityPublic.VpPrivate#vm_private(boolean, String) Invalid ref: non visible inner class in visible class (non applicable method)\n\t       ^^^^^^^^^^^^^^^^^^^^^^^^^^\nJavadoc: The type VisibilityPublic.VpPrivate is not visible\n----------\n5. ERROR in test\\X.java (at line 12)\n\t* @see VisibilityPublic.VpPrivate#vm_public() Invalid ref: non visible inner class in visible class (visible method)\n\t       ^^^^^^^^^^^^^^^^^^^^^^^^^^\nJavadoc: The type VisibilityPublic.VpPrivate is not visible\n----------\n6. ERROR in test\\X.java (at line 13)\n\t* @see VisibilityPublic.VpPrivate#vm_public(Object, float) Invalid ref: non visible inner class in visible class (non applicable visible method)\n\t       ^^^^^^^^^^^^^^^^^^^^^^^^^^\nJavadoc: The type VisibilityPublic.VpPrivate is not visible\n----------\n7. ERROR in test\\X.java (at line 14)\n\t* @see VisibilityPublic.VpPublic#vm_private() Invalid ref: non visible method in visible inner class\n\t                                 ^^^^^^^^^^\nJavadoc: The method vm_private() from the type VisibilityPublic.VpPublic is not visible\n----------\n");
    }

    public void test157() {
        this.runNegativeReferenceTest(new String[]{"test/X.js", "package test;\nimport test.copy.VisibilityPublic;\npublic class X {\n\t/**\n\t * Invalid other package visible class methods references (non-applicable)\n\t * \n\t * @see VisibilityPublic#vm_private(boolean) Invalid ref: non applicable method in visible class\n\t * @see VisibilityPublic#vm_public(long,long,long,int) Invalid ref: non applicable method in visible class\n\t * @see VisibilityPublic.VpPublic#vm_private(boolean, String) Invalid ref: non applicable method in visible inner class\n\t * @see VisibilityPublic.VpPublic#vm_public(Object, float) Invalid ref: visible inner class (non applicable visible method)\n\t */\n\tpublic void s_foo() {\n\t}\n}\n"}, "----------\n1. ERROR in test\\X.java (at line 7)\n\t* @see VisibilityPublic#vm_private(boolean) Invalid ref: non applicable method in visible class\n\t                        ^^^^^^^^^^\nJavadoc: The method vm_private() in the type VisibilityPublic is not applicable for the arguments (boolean)\n----------\n2. ERROR in test\\X.java (at line 8)\n\t* @see VisibilityPublic#vm_public(long,long,long,int) Invalid ref: non applicable method in visible class\n\t                        ^^^^^^^^^\nJavadoc: The method vm_public() in the type VisibilityPublic is not applicable for the arguments (long, long, long, int)\n----------\n3. ERROR in test\\X.java (at line 9)\n\t* @see VisibilityPublic.VpPublic#vm_private(boolean, String) Invalid ref: non applicable method in visible inner class\n\t                                 ^^^^^^^^^^\nJavadoc: The method vm_private() in the type VisibilityPublic.VpPublic is not applicable for the arguments (boolean, String)\n----------\n4. ERROR in test\\X.java (at line 10)\n\t* @see VisibilityPublic.VpPublic#vm_public(Object, float) Invalid ref: visible inner class (non applicable visible method)\n\t                                 ^^^^^^^^^\nJavadoc: The method vm_public() in the type VisibilityPublic.VpPublic is not applicable for the arguments (Object, float)\n----------\n");
    }

    public void test158() {
        this.runNegativeReferenceTest(new String[]{"test/X.js", "package test;\nimport test.copy.VisibilityPublic;\npublic class X {\n\t/**\n\t * Invalid other package visible class methods references (non-existent)\n\t * \n\t * @see VisibilityPublic#vm_private(\"boolean\") Invalid ref: invalid argument declaration\n\t * @see VisibilityPublic#vm_public(long, \"int) Invalid ref: invalid argument definition\n\t * @see VisibilityPublic.VpPrivate#vm_private(double d()) Invalid ref: invalid argument declaration\n\t * @see VisibilityPublic.VpPrivate#vm_public(\") Invalid ref: invalid argument declaration\n\t * @see VisibilityPublic.VpPublic#vm_private(d()) Invalid ref: invalid argument declaration\n\t * @see VisibilityPublic.VpPublic#vm_public(205) Invalid ref: invalid argument declaration\n\t */\n\tpublic void s_foo() {\n\t}\n}\n"}, "----------\n1. ERROR in test\\X.java (at line 7)\n\t* @see VisibilityPublic#vm_private(\"boolean\") Invalid ref: invalid argument declaration\n\t                                  ^^^^^^^^^^\nJavadoc: Invalid parameters declaration\n----------\n2. ERROR in test\\X.java (at line 8)\n\t* @see VisibilityPublic#vm_public(long, \"int) Invalid ref: invalid argument definition\n\t                                 ^^^^^^^^\nJavadoc: Invalid parameters declaration\n----------\n3. ERROR in test\\X.java (at line 9)\n\t* @see VisibilityPublic.VpPrivate#vm_private(double d()) Invalid ref: invalid argument declaration\n\t                                            ^^^^^^^^^^\nJavadoc: Invalid parameters declaration\n----------\n4. ERROR in test\\X.java (at line 10)\n\t* @see VisibilityPublic.VpPrivate#vm_public(\") Invalid ref: invalid argument declaration\n\t                                           ^^\nJavadoc: Invalid parameters declaration\n----------\n5. ERROR in test\\X.java (at line 11)\n\t* @see VisibilityPublic.VpPublic#vm_private(d()) Invalid ref: invalid argument declaration\n\t                                           ^^^\nJavadoc: Invalid parameters declaration\n----------\n6. ERROR in test\\X.java (at line 12)\n\t* @see VisibilityPublic.VpPublic#vm_public(205) Invalid ref: invalid argument declaration\n\t                                          ^^^^\nJavadoc: Invalid parameters declaration\n----------\n");
    }

    public void test159() {
        this.runConformReferenceTest(new String[]{"test/X.js", "package test;\npublic class X {\n\t/**\n\t * Valid other package visible class methods references \n\t * \n\t * @see test.copy.VisibilityPublic#vm_public() Valid ref to not visible method of other package class\n\t * @see test.copy.VisibilityPublic.VpPublic#vm_public() Valid ref to visible method of other package public inner class\n\t */\n\tpublic void s_foo() {\n\t}\n}\n"});
    }

    public void test160() {
        this.runNegativeReferenceTest(new String[]{"test/X.js", "package test;\npublic class X {\n\t/**\n\t * Invalid other package visible class methods references (non-existent)\n\t * \n\t * @see test.copy.VisibilityPublic#unknown() Invalid ref: non existent method\n\t * @see test.copy.VisibilityPublic.VpPublic#unknown() Invalid ref: non existent method of visible inner class\n\t */\n\tpublic void s_foo() {\n\t}\n}\n"}, "----------\n1. ERROR in test\\X.java (at line 6)\n\t* @see test.copy.VisibilityPublic#unknown() Invalid ref: non existent method\n\t                                  ^^^^^^^\nJavadoc: The method unknown() is undefined for the type VisibilityPublic\n----------\n2. ERROR in test\\X.java (at line 7)\n\t* @see test.copy.VisibilityPublic.VpPublic#unknown() Invalid ref: non existent method of visible inner class\n\t                                           ^^^^^^^\nJavadoc: The method unknown() is undefined for the type VisibilityPublic.VpPublic\n----------\n");
    }

    public void test161() {
        this.runNegativeReferenceTest(new String[]{"test/X.js", "package test;\npublic class X {\n\t/**\n\t * Invalid other package visible class methods references (non-visible)\n\t * \n\t * @see test.copy.VisibilityPublic#vm_private() Invalid ref: non visible method in visible class\n\t * @see test.copy.VisibilityPublic#vm_public() Valid ref: visible method in visible class\n\t * @see test.copy.VisibilityPublic.VpPrivate#unknown() Invalid ref: non visible inner class (non existent method)\n\t * @see test.copy.VisibilityPublic.VpPrivate#vm_private() Invalid ref: non visible inner class in visible class and (non visible method)\n\t * @see test.copy.VisibilityPublic.VpPrivate#vm_private(boolean, String) Invalid ref: non visible inner class in visible class (non applicable method)\n\t * @see test.copy.VisibilityPublic.VpPrivate#vm_public() Invalid ref: non visible inner class in visible class (visible method)\n\t * @see test.copy.VisibilityPublic.VpPrivate#vm_public(Object, float) Invalid ref: non visible inner class in visible class (non applicable visible method)\n\t * @see test.copy.VisibilityPublic.VpPublic#vm_private() Invalid ref: non visible method in visible inner class\n\t */\n\tpublic void s_foo() {\n\t}\n}\n"}, "----------\n1. ERROR in test\\X.java (at line 6)\n\t* @see test.copy.VisibilityPublic#vm_private() Invalid ref: non visible method in visible class\n\t                                  ^^^^^^^^^^\nJavadoc: The method vm_private() from the type VisibilityPublic is not visible\n----------\n2. ERROR in test\\X.java (at line 8)\n\t* @see test.copy.VisibilityPublic.VpPrivate#unknown() Invalid ref: non visible inner class (non existent method)\n\t       ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^\nJavadoc: The type test.copy.VisibilityPublic.VpPrivate is not visible\n----------\n3. ERROR in test\\X.java (at line 9)\n\t* @see test.copy.VisibilityPublic.VpPrivate#vm_private() Invalid ref: non visible inner class in visible class and (non visible method)\n\t       ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^\nJavadoc: The type test.copy.VisibilityPublic.VpPrivate is not visible\n----------\n4. ERROR in test\\X.java (at line 10)\n\t* @see test.copy.VisibilityPublic.VpPrivate#vm_private(boolean, String) Invalid ref: non visible inner class in visible class (non applicable method)\n\t       ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^\nJavadoc: The type test.copy.VisibilityPublic.VpPrivate is not visible\n----------\n5. ERROR in test\\X.java (at line 11)\n\t* @see test.copy.VisibilityPublic.VpPrivate#vm_public() Invalid ref: non visible inner class in visible class (visible method)\n\t       ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^\nJavadoc: The type test.copy.VisibilityPublic.VpPrivate is not visible\n----------\n6. ERROR in test\\X.java (at line 12)\n\t* @see test.copy.VisibilityPublic.VpPrivate#vm_public(Object, float) Invalid ref: non visible inner class in visible class (non applicable visible method)\n\t       ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^\nJavadoc: The type test.copy.VisibilityPublic.VpPrivate is not visible\n----------\n7. ERROR in test\\X.java (at line 13)\n\t* @see test.copy.VisibilityPublic.VpPublic#vm_private() Invalid ref: non visible method in visible inner class\n\t                                           ^^^^^^^^^^\nJavadoc: The method vm_private() from the type VisibilityPublic.VpPublic is not visible\n----------\n");
    }

    public void test162() {
        this.runNegativeReferenceTest(new String[]{"test/X.js", "package test;\npublic class X {\n\t/**\n\t * Invalid other package visible class methods references (non-applicable)\n\t * \n\t * @see test.copy.VisibilityPublic#vm_private(boolean) Invalid ref: non applicable method in visible class\n\t * @see test.copy.VisibilityPublic#vm_public(long,long,long,int) Invalid ref: non applicable method in visible class\n\t * @see test.copy.VisibilityPublic.VpPublic#vm_private(boolean, String) Invalid ref: non applicable method in visible inner class\n\t * @see test.copy.VisibilityPublic.VpPublic#vm_public(Object, float) Invalid ref: visible inner class (non applicable visible method)\n\t */\n\tpublic void s_foo() {\n\t}\n}\n"}, "----------\n1. ERROR in test\\X.java (at line 6)\n\t* @see test.copy.VisibilityPublic#vm_private(boolean) Invalid ref: non applicable method in visible class\n\t                                  ^^^^^^^^^^\nJavadoc: The method vm_private() in the type VisibilityPublic is not applicable for the arguments (boolean)\n----------\n2. ERROR in test\\X.java (at line 7)\n\t* @see test.copy.VisibilityPublic#vm_public(long,long,long,int) Invalid ref: non applicable method in visible class\n\t                                  ^^^^^^^^^\nJavadoc: The method vm_public() in the type VisibilityPublic is not applicable for the arguments (long, long, long, int)\n----------\n3. ERROR in test\\X.java (at line 8)\n\t* @see test.copy.VisibilityPublic.VpPublic#vm_private(boolean, String) Invalid ref: non applicable method in visible inner class\n\t                                           ^^^^^^^^^^\nJavadoc: The method vm_private() in the type VisibilityPublic.VpPublic is not applicable for the arguments (boolean, String)\n----------\n4. ERROR in test\\X.java (at line 9)\n\t* @see test.copy.VisibilityPublic.VpPublic#vm_public(Object, float) Invalid ref: visible inner class (non applicable visible method)\n\t                                           ^^^^^^^^^\nJavadoc: The method vm_public() in the type VisibilityPublic.VpPublic is not applicable for the arguments (Object, float)\n----------\n");
    }

    public void test163() {
        this.runNegativeReferenceTest(new String[]{"test/X.js", "package test;\nimport test.copy.VisibilityPublic;\npublic class X {\n\t/**\n\t * Invalid other package visible class methods references (non-existent)\n\t * \n\t * @see test.copy.VisibilityPublic#vm_private(\"\") Invalid ref: invalid argument declaration\n\t * @see test.copy.VisibilityPublic#vm_public(\"\"\") Invalid ref: invalid argument definition\n\t * @see test.copy.VisibilityPublic.VpPrivate#vm_private(String d()) Invalid ref: invalid argument declaration\n\t * @see test.copy.VisibilityPublic.VpPrivate#vm_public([) Invalid ref: invalid argument declaration\n\t * @see test.copy.VisibilityPublic.VpPublic#vm_private([]) Invalid ref: invalid argument declaration\n\t * @see test.copy.VisibilityPublic.VpPublic#vm_public(char[], int[],]) Invalid ref: invalid argument declaration\n\t */\n\tpublic void s_foo() {\n\t}\n}\n"}, "----------\n1. ERROR in test\\X.java (at line 7)\n\t* @see test.copy.VisibilityPublic#vm_private(\"\") Invalid ref: invalid argument declaration\n\t                                            ^^^\nJavadoc: Invalid parameters declaration\n----------\n2. ERROR in test\\X.java (at line 8)\n\t* @see test.copy.VisibilityPublic#vm_public(\"\"\") Invalid ref: invalid argument definition\n\t                                           ^^^\nJavadoc: Invalid parameters declaration\n----------\n3. ERROR in test\\X.java (at line 9)\n\t* @see test.copy.VisibilityPublic.VpPrivate#vm_private(String d()) Invalid ref: invalid argument declaration\n\t                                                      ^^^^^^^^^^\nJavadoc: Invalid parameters declaration\n----------\n4. ERROR in test\\X.java (at line 10)\n\t* @see test.copy.VisibilityPublic.VpPrivate#vm_public([) Invalid ref: invalid argument declaration\n\t                                                     ^^\nJavadoc: Invalid parameters declaration\n----------\n5. ERROR in test\\X.java (at line 11)\n\t* @see test.copy.VisibilityPublic.VpPublic#vm_private([]) Invalid ref: invalid argument declaration\n\t                                                     ^^\nJavadoc: Invalid parameters declaration\n----------\n6. ERROR in test\\X.java (at line 12)\n\t* @see test.copy.VisibilityPublic.VpPublic#vm_public(char[], int[],]) Invalid ref: invalid argument declaration\n\t                                                    ^^^^^^^^^^^^^^^^\nJavadoc: Invalid parameters declaration\n----------\n");
    }
}

