/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsf.facesconfig.tests.read;

import java.util.List;
import org.eclipse.jst.jsf.facesconfig.emf.ApplicationExtensionType;
import org.eclipse.jst.jsf.facesconfig.emf.ApplicationType;
import org.eclipse.jst.jsf.facesconfig.emf.BaseNameType;
import org.eclipse.jst.jsf.facesconfig.emf.DescriptionType;
import org.eclipse.jst.jsf.facesconfig.emf.DisplayNameType;
import org.eclipse.jst.jsf.facesconfig.emf.DynamicElement;
import org.eclipse.jst.jsf.facesconfig.emf.ELResolverType;
import org.eclipse.jst.jsf.facesconfig.emf.IconType;
import org.eclipse.jst.jsf.facesconfig.emf.ResourceBundleType;
import org.eclipse.jst.jsf.facesconfig.emf.VarType;
import org.eclipse.jst.jsf.facesconfig.tests.read.ReadApplicationTestCase;
import org.eclipse.jst.jsf.facesconfig.tests.util.FacesConfigModelUtil;
import org.eclipse.jst.jsf.facesconfig.util.FacesConfigArtifactEdit;
import org.eclipse.jst.jsf.test.util.ConfigurableTestCase;

public class ReadApplicationTestCase_1_2
extends ReadApplicationTestCase {
    public ReadApplicationTestCase_1_2(String name) {
        super(name);
    }

    @Override
    protected void initialize(ConfigurableTestCase.TestConfiguration testConfiguration) {
        if (this._testConfiguration == null) {
            this._facesConfigFile = "WEB-INF/faces-config_1_2.xml";
            this._facesVersion = "1.2";
        } else {
            super.initialize(testConfiguration);
        }
    }

    public void testELResolver() {
        FacesConfigArtifactEdit edit = null;
        try {
            edit = this.getArtifactEditForRead();
            ReadApplicationTestCase_1_2.assertNotNull((Object)edit.getFacesConfig());
            ApplicationType application1 = this.getApplication1(edit);
            ELResolverType elResolverType = (ELResolverType)FacesConfigModelUtil.findEObjectElementById((List)application1.getELResolver(), "el-resolver-id");
            ReadApplicationTestCase_1_2.assertNotNull((Object)elResolverType);
            ReadApplicationTestCase_1_2.assertEquals((String)"com.test.MyELResolver", (String)elResolverType.getTextContent().trim());
        }
        finally {
            if (edit != null) {
                edit.dispose();
            }
        }
    }

    public void testResourceBundle() {
        FacesConfigArtifactEdit edit = null;
        try {
            edit = this.getArtifactEditForRead();
            ReadApplicationTestCase_1_2.assertNotNull((Object)edit.getFacesConfig());
            ApplicationType application1 = this.getApplication1(edit);
            ResourceBundleType resourceBundle = (ResourceBundleType)FacesConfigModelUtil.findEObjectElementById((List)application1.getResourceBundle(), "resourceBundleId1");
            ReadApplicationTestCase_1_2.assertNotNull((Object)resourceBundle);
            DescriptionType descType = (DescriptionType)FacesConfigModelUtil.findEObjectElementById((List)resourceBundle.getDescription(), "resourceBundleDesc");
            ReadApplicationTestCase_1_2.assertEquals((String)"Resource Bundle description blah", (String)descType.getTextContent());
            DisplayNameType displayNameType = (DisplayNameType)FacesConfigModelUtil.findEObjectElementById((List)resourceBundle.getDisplayName(), "resourceBundleDisplayName");
            ReadApplicationTestCase_1_2.assertEquals((String)"Resource Bundle display name blah", (String)displayNameType.getTextContent());
            IconType iconType = (IconType)FacesConfigModelUtil.findEObjectElementById((List)resourceBundle.getIcon(), "resourceBundleId");
            ReadApplicationTestCase_1_2.assertEquals((String)"resourceBundle-smallIcon", (String)iconType.getSmallIcon().getTextContent());
            ReadApplicationTestCase_1_2.assertEquals((String)"resourceBundle-largeIcon", (String)iconType.getLargeIcon().getTextContent());
            BaseNameType baseName = resourceBundle.getBaseName();
            ReadApplicationTestCase_1_2.assertNotNull((Object)baseName);
            ReadApplicationTestCase_1_2.assertEquals((String)"com.test.Bundle", (String)baseName.getTextContent());
            VarType var = resourceBundle.getVar();
            ReadApplicationTestCase_1_2.assertNotNull((Object)var);
            ReadApplicationTestCase_1_2.assertEquals((String)"bundleVar", (String)var.getTextContent());
        }
        finally {
            if (edit != null) {
                edit.dispose();
            }
        }
    }

    public void testApplicationExtension() {
        FacesConfigArtifactEdit edit = null;
        try {
            edit = this.getArtifactEditForRead();
            ReadApplicationTestCase_1_2.assertNotNull((Object)edit.getFacesConfig());
            ApplicationType application1 = this.getApplication1(edit);
            ApplicationExtensionType applicationExt = (ApplicationExtensionType)FacesConfigModelUtil.findEObjectElementById((List)application1.getApplicationExtension(), "applicatinExtension1");
            ReadApplicationTestCase_1_2.assertNotNull((Object)applicationExt);
            ReadApplicationTestCase_1_2.assertEquals((int)1, (int)applicationExt.getChildNodes().size());
            DynamicElement element = (DynamicElement)applicationExt.getChildNodes().get(0);
            ReadApplicationTestCase_1_2.assertEquals((String)"some-extension-data", (String)element.getName());
        }
        finally {
            if (edit != null) {
                edit.dispose();
            }
        }
    }
}

