/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.common.utility.internal;

import java.lang.reflect.Field;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.eclipse.jpt.common.utility.internal.ArrayTools;
import org.eclipse.jpt.common.utility.internal.CharArrayTools;
import org.eclipse.jpt.common.utility.internal.CharacterTools;
import org.eclipse.jpt.common.utility.internal.ClassTools;
import org.eclipse.jpt.common.utility.internal.StringTools;
import org.eclipse.jpt.common.utility.internal.comparator.ComparatorAdapter;
import org.eclipse.jpt.common.utility.internal.iterable.IterableTools;

public final class StringBuilderTools {
    private static final ComparatorAdapter<Field> FIELD_COMPARATOR = new FieldComparator();
    public static final String EMPTY_JSON_STRING_LITERAL = "\"\"";

    public static char[] convertToCharArray(StringBuilder sb) {
        int len = sb.length();
        char[] result = new char[len];
        sb.getChars(0, len, result, 0);
        return result;
    }

    public static void reverse(StringBuilder sb, String string) {
        int i = string.length();
        while (i-- > 0) {
            sb.append(string.charAt(i));
        }
    }

    public static void reverse(StringBuilder sb, char[] string) {
        int i = string.length;
        while (i-- > 0) {
            sb.append(string[i]);
        }
    }

    public static void center(StringBuilder sb, String string, int length) {
        StringBuilderTools.center(sb, string, length, ' ');
    }

    public static void center(StringBuilder sb, char[] string, int length) {
        StringBuilderTools.center(sb, string, length, ' ');
    }

    public static void center(StringBuilder sb, String string, int length, char c) {
        if (length == 0) {
            return;
        }
        int stringLength = string.length();
        if (stringLength == length) {
            sb.append(string);
        } else if (stringLength > length) {
            int begin = stringLength - length >> 1;
            sb.append(string, begin, begin + length);
        } else {
            int begin = length - stringLength >> 1;
            StringBuilderTools.fill(sb, begin, c);
            sb.append(string);
            StringBuilderTools.fill(sb, length - (begin + stringLength), c);
        }
    }

    public static void center(StringBuilder sb, char[] string, int length, char c) {
        if (length == 0) {
            return;
        }
        int stringLength = string.length;
        if (stringLength == length) {
            sb.append(string);
        } else if (stringLength > length) {
            int begin = stringLength - length >> 1;
            sb.append(string, begin, length);
        } else {
            int begin = length - stringLength >> 1;
            StringBuilderTools.fill(sb, begin, c);
            sb.append(string);
            StringBuilderTools.fill(sb, length - (begin + stringLength), c);
        }
    }

    public static void pad(StringBuilder sb, String string, int length) {
        StringBuilderTools.pad(sb, string, length, ' ');
    }

    public static void pad(StringBuilder sb, char[] string, int length) {
        StringBuilderTools.pad(sb, string, length, ' ');
    }

    public static void pad(StringBuilder sb, String string, int length, char c) {
        int stringLength = string.length();
        if (stringLength > length) {
            throw new IllegalArgumentException("String is too long: " + stringLength + " > " + length);
        }
        if (stringLength == length) {
            sb.append(string);
        } else {
            StringBuilderTools.pad_(sb, string, stringLength, length, c);
        }
    }

    public static void pad(StringBuilder sb, char[] string, int length, char c) {
        int stringLength = string.length;
        if (stringLength > length) {
            throw new IllegalArgumentException("String is too long: " + stringLength + " > " + length);
        }
        if (stringLength == length) {
            sb.append(string);
        } else {
            StringBuilderTools.pad_(sb, string, stringLength, length, c);
        }
    }

    public static void fit(StringBuilder sb, String string, int length) {
        StringBuilderTools.fit(sb, string, length, ' ');
    }

    public static void fit(StringBuilder sb, char[] string, int length) {
        StringBuilderTools.fit(sb, string, length, ' ');
    }

    public static void fit(StringBuilder sb, String string, int length, char c) {
        if (length == 0) {
            return;
        }
        int stringLength = string.length();
        if (stringLength == length) {
            sb.append(string);
        } else if (stringLength > length) {
            sb.append(string, 0, length);
        } else {
            StringBuilderTools.pad_(sb, string, stringLength, length, c);
        }
    }

    public static void fit(StringBuilder sb, char[] string, int length, char c) {
        if (length == 0) {
            return;
        }
        int stringLength = string.length;
        if (stringLength == length) {
            sb.append(string);
        } else if (stringLength > length) {
            sb.append(string, 0, length);
        } else {
            StringBuilderTools.pad_(sb, string, stringLength, length, c);
        }
    }

    private static void pad_(StringBuilder sb, String string, int stringLength, int length, char c) {
        sb.append(string);
        StringBuilderTools.fill(sb, stringLength, length, c);
    }

    private static void pad_(StringBuilder sb, char[] string, int stringLength, int length, char c) {
        sb.append(string);
        StringBuilderTools.fill(sb, stringLength, length, c);
    }

    private static void fill(StringBuilder sb, int stringLength, int length, char c) {
        StringBuilderTools.fill(sb, length - stringLength, c);
    }

    private static void fill(StringBuilder sb, int length, char c) {
        sb.append(ArrayTools.fill(new char[length], c));
    }

    public static void zeroPad(StringBuilder sb, String string, int length) {
        StringBuilderTools.frontPad(sb, string, length, '0');
    }

    public static void zeroPad(StringBuilder sb, char[] string, int length) {
        StringBuilderTools.frontPad(sb, string, length, '0');
    }

    public static void frontPad(StringBuilder sb, String string, int length, char c) {
        int stringLength = string.length();
        if (stringLength > length) {
            throw new IllegalArgumentException("String is too long: " + stringLength + " > " + length);
        }
        if (stringLength == length) {
            sb.append(string);
        } else {
            StringBuilderTools.frontPad_(sb, string, stringLength, length, c);
        }
    }

    public static void frontPad(StringBuilder sb, char[] string, int length, char c) {
        int stringLength = string.length;
        if (stringLength > length) {
            throw new IllegalArgumentException("String is too long: " + stringLength + " > " + length);
        }
        if (stringLength == length) {
            sb.append(string);
        } else {
            StringBuilderTools.frontPad_(sb, string, stringLength, length, c);
        }
    }

    public static void zeroFit(StringBuilder sb, String string, int length) {
        StringBuilderTools.frontFit(sb, string, length, '0');
    }

    public static void zeroFit(StringBuilder sb, char[] string, int length) {
        StringBuilderTools.frontFit(sb, string, length, '0');
    }

    public static void frontFit(StringBuilder sb, String string, int length, char c) {
        if (length == 0) {
            return;
        }
        int stringLength = string.length();
        if (stringLength == length) {
            sb.append(string);
        } else if (stringLength > length) {
            sb.append(string, stringLength - length, stringLength);
        } else {
            StringBuilderTools.frontPad_(sb, string, stringLength, length, c);
        }
    }

    public static void frontFit(StringBuilder sb, char[] string, int length, char c) {
        if (length == 0) {
            return;
        }
        int stringLength = string.length;
        if (stringLength == length) {
            sb.append(string);
        } else if (stringLength > length) {
            sb.append(string, stringLength - length, length);
        } else {
            StringBuilderTools.frontPad_(sb, string, stringLength, length, c);
        }
    }

    private static void frontPad_(StringBuilder sb, String string, int stringLength, int length, char c) {
        StringBuilderTools.fill(sb, stringLength, length, c);
        sb.append(string);
    }

    private static void frontPad_(StringBuilder sb, char[] string, int stringLength, int length, char c) {
        StringBuilderTools.fill(sb, stringLength, length, c);
        sb.append(string);
    }

    public static void repeat(StringBuilder sb, String string, int length) {
        if (length == 0) {
            return;
        }
        int stringLength = string.length();
        if (stringLength == length) {
            sb.append(string);
        } else if (stringLength > length) {
            sb.append(string, 0, length);
        } else {
            StringBuilderTools.repeat(sb, string, length, stringLength);
        }
    }

    static void repeat(StringBuilder sb, String string, int length, int stringLength) {
        do {
            sb.append(string);
        } while (stringLength <= (length -= stringLength));
        if (length > 0) {
            sb.append(string, 0, length);
        }
    }

    public static void repeat(StringBuilder sb, char[] string, int length) {
        if (length == 0) {
            return;
        }
        int stringLength = string.length;
        if (stringLength == length) {
            sb.append(string);
        } else if (stringLength > length) {
            sb.append(string, 0, length);
        } else {
            StringBuilderTools.repeat(sb, string, length, stringLength);
        }
    }

    static void repeat(StringBuilder sb, char[] string, int length, int stringLength) {
        do {
            sb.append(string);
        } while (stringLength <= (length -= stringLength));
        if (length > 0) {
            sb.append(string, 0, length);
        }
    }

    public static void separate(StringBuilder sb, String string, char separator, int segmentSize) {
        if (segmentSize <= 0) {
            throw new IllegalArgumentException("segment size must be positive: " + segmentSize);
        }
        int stringLength = string.length();
        if (stringLength <= segmentSize) {
            sb.append(string);
        } else {
            sb.ensureCapacity(sb.length() + stringLength + stringLength / segmentSize);
            StringBuilderTools.separate(sb, string, separator, segmentSize, stringLength);
        }
    }

    private static void separate(StringBuilder sb, String string, char separator, int segmentSize, int stringLength) {
        int segCount = 0;
        int i = 0;
        while (i < stringLength) {
            char c = string.charAt(i);
            if (segCount == segmentSize) {
                sb.append(separator);
                segCount = 0;
            }
            ++segCount;
            sb.append(c);
            ++i;
        }
    }

    public static void separate(StringBuilder sb, char[] string, char separator, int segmentSize) {
        if (segmentSize <= 0) {
            throw new IllegalArgumentException("segment size must be positive: " + segmentSize);
        }
        int stringLength = string.length;
        if (stringLength <= segmentSize) {
            sb.append(string);
        } else {
            sb.ensureCapacity(sb.length() + stringLength + stringLength / segmentSize);
            StringBuilderTools.separate(sb, string, separator, segmentSize, stringLength);
        }
    }

    private static void separate(StringBuilder sb, char[] string, char separator, int segmentSize, int stringLength) {
        int segCount = 0;
        int i = 0;
        while (i < stringLength) {
            char c = string[i];
            if (segCount == segmentSize) {
                sb.append(separator);
                segCount = 0;
            }
            ++segCount;
            sb.append(c);
            ++i;
        }
    }

    public static void quote(StringBuilder sb, String string) {
        StringBuilderTools.delimit(sb, string, '\"');
    }

    public static void quote(StringBuilder sb, char[] string) {
        StringBuilderTools.delimit(sb, string, '\"');
    }

    public static void delimit(StringBuilder sb, String string, char delimiter) {
        int stringLength = string.length();
        sb.ensureCapacity(sb.length() + stringLength + 2);
        StringBuilderTools.delimit(sb, string, delimiter, stringLength);
    }

    static void delimit(StringBuilder sb, String string, char delimiter, int stringLength) {
        sb.append(delimiter);
        int i = 0;
        while (i < stringLength) {
            char c = string.charAt(i);
            if (c == delimiter) {
                sb.append(c);
            }
            sb.append(c);
            ++i;
        }
        sb.append(delimiter);
    }

    public static void delimit(StringBuilder sb, char[] string, char delimiter) {
        int stringLength = string.length;
        sb.ensureCapacity(sb.length() + stringLength + 2);
        StringBuilderTools.delimit(sb, string, delimiter, stringLength);
    }

    static void delimit(StringBuilder sb, char[] string, char delimiter, int stringLength) {
        sb.append(delimiter);
        int i = 0;
        while (i < stringLength) {
            char c = string[i];
            if (c == delimiter) {
                sb.append(c);
            }
            sb.append(c);
            ++i;
        }
        sb.append(delimiter);
    }

    public static void delimit(StringBuilder sb, String string, String delimiter) {
        int delimiterLength = delimiter.length();
        switch (delimiterLength) {
            case 0: {
                sb.append(string);
                break;
            }
            case 1: {
                StringBuilderTools.delimit(sb, string, delimiter.charAt(0));
                break;
            }
            default: {
                StringBuilderTools.delimit(sb, string, delimiter, delimiterLength);
            }
        }
    }

    private static void delimit(StringBuilder sb, String string, String delimiter, int delimiterLength) {
        sb.append(delimiter, 0, delimiterLength);
        sb.append(string);
        sb.append(delimiter, 0, delimiterLength);
    }

    public static void delimit(StringBuilder sb, char[] string, char[] delimiter) {
        int delimiterLength = delimiter.length;
        switch (delimiterLength) {
            case 0: {
                sb.append(string);
                break;
            }
            case 1: {
                StringBuilderTools.delimit(sb, string, delimiter[0]);
                break;
            }
            default: {
                StringBuilderTools.delimit(sb, string, delimiter, delimiterLength);
            }
        }
    }

    private static void delimit(StringBuilder sb, char[] string, char[] delimiter, int delimiterLength) {
        sb.append(delimiter, 0, delimiterLength);
        sb.append(string);
        sb.append(delimiter, 0, delimiterLength);
    }

    public static void undelimit(StringBuilder sb, String string) {
        int stringLength = string.length();
        int resultLength = stringLength - 2;
        if (resultLength < 0) {
            throw new IllegalArgumentException("invalid string: \"" + string + '\"');
        }
        if (resultLength == 0) {
            return;
        }
        StringBuilderTools.undelimit_(sb, string, stringLength);
    }

    static void undelimit_(StringBuilder sb, String string, int stringLength) {
        char delimiter;
        char c = delimiter = string.charAt(0);
        char next = string.charAt(1);
        int i = 1;
        int last = stringLength - 1;
        do {
            c = next;
            sb.append(c);
            next = string.charAt(++i);
            if (c != delimiter) continue;
            if (next != delimiter || i == last) {
                return;
            }
            next = string.charAt(++i);
        } while (i != last);
    }

    public static void undelimit(StringBuilder sb, char[] string) {
        int stringLength = string.length;
        int resultLength = stringLength - 2;
        if (resultLength < 0) {
            throw new IllegalArgumentException("invalid string: \"" + String.valueOf(string) + '\"');
        }
        if (resultLength == 0) {
            return;
        }
        StringBuilderTools.undelimit_(sb, string, stringLength);
    }

    static void undelimit_(StringBuilder sb, char[] string, int stringLength) {
        char delimiter;
        char c = delimiter = string[0];
        char next = string[1];
        int i = 1;
        int last = stringLength - 1;
        do {
            c = next;
            sb.append(c);
            next = string[++i];
            if (c != delimiter) continue;
            if (next != delimiter || i == last) {
                return;
            }
            next = string[++i];
        } while (i != last);
    }

    public static void undelimit(StringBuilder sb, String string, int count) {
        if (count == 0) {
            sb.append(string);
            return;
        }
        int resultLength = string.length() - 2 * count;
        if (resultLength < 0) {
            throw new IllegalArgumentException("invalid string: \"" + string + '\"');
        }
        if (resultLength == 0) {
            return;
        }
        sb.append(string, count, count + resultLength);
    }

    public static void undelimit(StringBuilder sb, char[] string, int count) {
        if (count == 0) {
            sb.append(string);
            return;
        }
        int resultLength = string.length - 2 * count;
        if (resultLength < 0) {
            throw new IllegalArgumentException("invalid string: \"" + String.valueOf(string) + '\"');
        }
        if (resultLength == 0) {
            return;
        }
        sb.append(string, count, resultLength);
    }

    public static void removeFirstOccurrence(StringBuilder sb, String string, char c) {
        int index = string.indexOf(c);
        if (index == -1) {
            sb.append(string);
        } else {
            StringBuilderTools.removeCharAtIndex(sb, string, index);
        }
    }

    private static void removeCharAtIndex(StringBuilder sb, String string, int index) {
        int stringLength = string.length();
        if (index == 0) {
            sb.append(string, 1, stringLength);
        } else {
            sb.append(string, 0, index);
            if (index != stringLength - 1) {
                sb.append(string, index + 1, stringLength);
            }
        }
    }

    public static void removeFirstOccurrence(StringBuilder sb, char[] string, char c) {
        int index = ArrayTools.indexOf(string, c);
        if (index == -1) {
            sb.append(string);
        } else {
            StringBuilderTools.removeCharAtIndex(sb, string, index);
        }
    }

    private static void removeCharAtIndex(StringBuilder sb, char[] string, int index) {
        int last = string.length - 1;
        if (index == 0) {
            sb.append(string, 1, last);
        } else if (index == last) {
            sb.append(string, 0, last);
        } else {
            sb.append(string, 0, index);
            sb.append(string, index + 1, last - index);
        }
    }

    public static void removeAllOccurrences(StringBuilder sb, String string, char c) {
        int first = string.indexOf(c);
        if (first == -1) {
            sb.append(string);
        } else {
            int stringLength = string.length();
            sb.ensureCapacity(sb.length() + stringLength);
            StringBuilderTools.removeAllOccurrences(sb, string, c, first, stringLength);
        }
    }

    static void removeAllOccurrences(StringBuilder sb, String string, char c, int first, int stringLength) {
        sb.append(string, 0, first);
        int i = first;
        while (i < stringLength) {
            char d = string.charAt(i);
            if (d != c) {
                sb.append(d);
            }
            ++i;
        }
    }

    public static void removeAllOccurrences(StringBuilder sb, char[] string, char c) {
        int first = ArrayTools.indexOf(string, c);
        if (first == -1) {
            sb.append(string);
        } else {
            int stringLength = string.length;
            sb.ensureCapacity(sb.length() + stringLength);
            StringBuilderTools.removeAllOccurrences(sb, string, c, first, stringLength);
        }
    }

    static void removeAllOccurrences(StringBuilder sb, char[] string, char c, int first, int stringLength) {
        sb.append(string, 0, first);
        int i = first;
        while (i < stringLength) {
            char d = string[i];
            if (d != c) {
                sb.append(d);
            }
            ++i;
        }
    }

    public static void removeAllSpaces(StringBuilder sb, String string) {
        StringBuilderTools.removeAllOccurrences(sb, string, ' ');
    }

    public static void removeAllSpaces(StringBuilder sb, char[] string) {
        StringBuilderTools.removeAllOccurrences(sb, string, ' ');
    }

    public static void removeAllWhitespace(StringBuilder sb, String string) {
        int first = StringTools.indexOfWhitespace(string);
        if (first == -1) {
            sb.append(string);
        } else {
            int stringLength = string.length();
            sb.ensureCapacity(sb.length() + stringLength);
            StringBuilderTools.removeAllWhitespace(sb, string, first, stringLength);
        }
    }

    static void removeAllWhitespace(StringBuilder sb, String string, int first, int stringLength) {
        sb.append(string, 0, first);
        int i = first;
        while (i < stringLength) {
            char c = string.charAt(i);
            if (!Character.isWhitespace(c)) {
                sb.append(c);
            }
            ++i;
        }
    }

    public static void removeAllWhitespace(StringBuilder sb, char[] string) {
        int first = CharArrayTools.indexOfWhitespace(string);
        if (first == -1) {
            sb.append(string);
        } else {
            int stringLength = string.length;
            sb.ensureCapacity(sb.length() + stringLength);
            StringBuilderTools.removeAllWhitespace(sb, string, first, stringLength);
        }
    }

    static void removeAllWhitespace(StringBuilder sb, char[] string, int first, int stringLength) {
        sb.append(string, 0, first);
        int i = first;
        while (i < stringLength) {
            char c = string[i];
            if (!Character.isWhitespace(c)) {
                sb.append(c);
            }
            ++i;
        }
    }

    public static void compressWhitespace(StringBuilder sb, String string) {
        int first = StringTools.indexOfWhitespace(string);
        if (first == -1) {
            sb.append(string);
        } else {
            int stringLength = string.length();
            sb.ensureCapacity(sb.length() + stringLength);
            StringBuilderTools.compressWhitespace(sb, string, first, stringLength);
        }
    }

    static void compressWhitespace(StringBuilder sb, String string, int first, int stringLength) {
        sb.append(string, 0, first);
        int i = first;
        char c = string.charAt(i);
        block0: while (true) {
            sb.append(' ');
            while (++i < stringLength) {
                c = string.charAt(i);
                if (Character.isWhitespace(c)) continue;
                do {
                    sb.append(c);
                    if (++i >= stringLength) break block0;
                } while (!Character.isWhitespace(c = string.charAt(i)));
                continue block0;
            }
            break;
        }
    }

    public static void compressWhitespace(StringBuilder sb, char[] string) {
        int first = CharArrayTools.indexOfWhitespace(string);
        if (first == -1) {
            sb.append(string);
        } else {
            int stringLength = string.length;
            sb.ensureCapacity(sb.length() + stringLength);
            StringBuilderTools.compressWhitespace(sb, string, first, stringLength);
        }
    }

    static void compressWhitespace(StringBuilder sb, char[] string, int first, int stringLength) {
        sb.append(string, 0, first);
        int i = first;
        char c = string[i];
        block0: while (true) {
            sb.append(' ');
            while (++i < stringLength) {
                c = string[i];
                if (Character.isWhitespace(c)) continue;
                do {
                    sb.append(c);
                    if (++i >= stringLength) break block0;
                } while (!Character.isWhitespace(c = string[i]));
                continue block0;
            }
            break;
        }
    }

    public static void capitalize(StringBuilder sb, String string) {
        if (string.length() == 0) {
            return;
        }
        if (Character.isUpperCase(string.charAt(0))) {
            sb.append(string);
        } else {
            StringBuilderTools.capitalize_(sb, string);
        }
    }

    private static void capitalize_(StringBuilder sb, String string) {
        sb.append(Character.toUpperCase(string.charAt(0)));
        sb.append(string, 1, string.length());
    }

    public static void capitalize(StringBuilder sb, char[] string) {
        if (string.length == 0) {
            return;
        }
        if (Character.isUpperCase(string[0])) {
            sb.append(string);
        } else {
            StringBuilderTools.capitalize_(sb, string);
        }
    }

    private static void capitalize_(StringBuilder sb, char[] string) {
        sb.append(Character.toUpperCase(string[0]));
        sb.append(string, 1, string.length - 1);
    }

    public static void uncapitalize(StringBuilder sb, String string) {
        int stringLength = string.length();
        if (StringTools.needNotBeUncapitalized(string, stringLength)) {
            sb.append(string);
        } else {
            StringBuilderTools.uncapitalize(sb, string, stringLength);
        }
    }

    private static void uncapitalize(StringBuilder sb, String string, int stringLength) {
        sb.append(Character.toLowerCase(string.charAt(0)));
        sb.append(string, 1, stringLength);
    }

    public static void uncapitalize(StringBuilder sb, char[] string) {
        int stringLength = string.length;
        if (CharArrayTools.needNotBeUncapitalized(string, stringLength)) {
            sb.append(string);
        } else {
            StringBuilderTools.uncapitalize(sb, string, stringLength);
        }
    }

    private static void uncapitalize(StringBuilder sb, char[] string, int stringLength) {
        sb.append(Character.toLowerCase(string[0]));
        sb.append(string, 1, stringLength - 1);
    }

    public static void convertToHexString(StringBuilder sb, byte[] bytes) {
        int bytesLength = bytes.length;
        if (bytesLength != 0) {
            sb.ensureCapacity(sb.length() + (bytesLength << 1));
            StringBuilderTools.convertToHexString(sb, bytes, bytesLength);
        }
    }

    static void convertToHexString(StringBuilder sb, byte[] bytes, int bytesLength) {
        char[] digits = CharacterTools.DIGITS;
        int i = 0;
        while (i < bytesLength) {
            int b = bytes[i] & 0xFF;
            sb.append(digits[b >> 4]);
            sb.append(digits[b & 0xF]);
            ++i;
        }
    }

    public static void convertCamelCaseToAllCaps(StringBuilder sb, String camelCaseString) {
        int stringLength = camelCaseString.length();
        if (stringLength != 0) {
            sb.ensureCapacity(sb.length() + stringLength + stringLength / 4);
            StringBuilderTools.convertCamelCaseToAllCaps_(sb, camelCaseString, stringLength);
        }
    }

    static void convertCamelCaseToAllCaps_(StringBuilder sb, String camelCaseString, int stringLength) {
        char prev = '\u0000';
        char c = '\u0000';
        char next = camelCaseString.charAt(0);
        int i = 1;
        while (i <= stringLength) {
            c = next;
            char c2 = next = i == stringLength ? (char)'\u0000' : camelCaseString.charAt(i);
            if (StringTools.camelCaseWordBreak(prev, c, next)) {
                sb.append('_');
            }
            sb.append(Character.toUpperCase(c));
            prev = c;
            ++i;
        }
    }

    public static void convertCamelCaseToAllCaps(StringBuilder sb, char[] camelCaseString) {
        int stringLength = camelCaseString.length;
        if (stringLength != 0) {
            sb.ensureCapacity(sb.length() + stringLength + stringLength / 4);
            StringBuilderTools.convertCamelCaseToAllCaps_(sb, camelCaseString, stringLength);
        }
    }

    static void convertCamelCaseToAllCaps_(StringBuilder sb, char[] camelCaseString, int stringLength) {
        char prev = '\u0000';
        char c = '\u0000';
        char next = camelCaseString[0];
        int i = 1;
        while (i <= stringLength) {
            c = next;
            char c2 = next = i == stringLength ? (char)'\u0000' : camelCaseString[i];
            if (StringTools.camelCaseWordBreak(prev, c, next)) {
                sb.append('_');
            }
            sb.append(Character.toUpperCase(c));
            prev = c;
            ++i;
        }
    }

    public static void convertCamelCaseToAllCaps(StringBuilder sb, String camelCaseString, int maxLength) {
        int stringLength;
        if (maxLength != 0 && (stringLength = camelCaseString.length()) != 0) {
            sb.ensureCapacity(sb.length() + maxLength);
            StringBuilderTools.convertCamelCaseToAllCaps(sb, camelCaseString, maxLength, stringLength);
        }
    }

    static void convertCamelCaseToAllCaps(StringBuilder sb, String camelCaseString, int maxLength, int stringLength) {
        char prev = '\u0000';
        char c = '\u0000';
        char next = camelCaseString.charAt(0);
        int i = 1;
        while (i <= stringLength) {
            c = next;
            char c2 = next = i == stringLength ? (char)'\u0000' : camelCaseString.charAt(i);
            if (StringTools.camelCaseWordBreak(prev, c, next)) {
                sb.append('_');
                if (sb.length() == maxLength) {
                    return;
                }
            }
            sb.append(Character.toUpperCase(c));
            if (sb.length() == maxLength) {
                return;
            }
            prev = c;
            ++i;
        }
    }

    public static void convertCamelCaseToAllCaps(StringBuilder sb, char[] camelCaseString, int maxLength) {
        int stringLength;
        if (maxLength != 0 && (stringLength = camelCaseString.length) != 0) {
            sb.ensureCapacity(sb.length() + maxLength);
            StringBuilderTools.convertCamelCaseToAllCaps(sb, camelCaseString, maxLength, stringLength);
        }
    }

    static void convertCamelCaseToAllCaps(StringBuilder sb, char[] camelCaseString, int maxLength, int stringLength) {
        char prev = '\u0000';
        char c = '\u0000';
        char next = camelCaseString[0];
        int i = 1;
        while (i <= stringLength) {
            c = next;
            char c2 = next = i == stringLength ? (char)'\u0000' : camelCaseString[i];
            if (StringTools.camelCaseWordBreak(prev, c, next)) {
                sb.append('_');
                if (sb.length() == maxLength) {
                    return;
                }
            }
            sb.append(Character.toUpperCase(c));
            if (sb.length() == maxLength) {
                return;
            }
            prev = c;
            ++i;
        }
    }

    public static void convertAllCapsToCamelCase(StringBuilder sb, String allCapsString) {
        StringBuilderTools.convertAllCapsToCamelCase(sb, allCapsString, true);
    }

    public static void convertAllCapsToCamelCase(StringBuilder sb, char[] allCapsString) {
        StringBuilderTools.convertAllCapsToCamelCase(sb, allCapsString, true);
    }

    public static void convertAllCapsToCamelCase(StringBuilder sb, String allCapsString, boolean capitalizeFirstLetter) {
        int stringLength = allCapsString.length();
        if (stringLength != 0) {
            sb.ensureCapacity(sb.length() + stringLength);
            StringBuilderTools.convertAllCapsToCamelCase(sb, allCapsString, capitalizeFirstLetter, stringLength);
        }
    }

    static void convertAllCapsToCamelCase(StringBuilder sb, String allCapsString, boolean capitalizeFirstLetter, int stringLength) {
        char prev = '\u0000';
        char c = '\u0000';
        boolean first = true;
        int i = 0;
        while (i < stringLength) {
            prev = c;
            c = allCapsString.charAt(i);
            if (c != '_') {
                if (first) {
                    first = false;
                    sb.append(capitalizeFirstLetter ? Character.toUpperCase(c) : Character.toLowerCase(c));
                } else {
                    sb.append(prev == '_' ? Character.toUpperCase(c) : Character.toLowerCase(c));
                }
            }
            ++i;
        }
    }

    public static void convertAllCapsToCamelCase(StringBuilder sb, char[] allCapsString, boolean capitalizeFirstLetter) {
        int stringLength = allCapsString.length;
        if (stringLength != 0) {
            sb.ensureCapacity(sb.length() + stringLength);
            StringBuilderTools.convertAllCapsToCamelCase(sb, allCapsString, capitalizeFirstLetter, stringLength);
        }
    }

    static void convertAllCapsToCamelCase(StringBuilder sb, char[] allCapsString, boolean capitalizeFirstLetter, int stringLength) {
        char prev = '\u0000';
        char c = '\u0000';
        boolean first = true;
        int i = 0;
        while (i < stringLength) {
            prev = c;
            c = allCapsString[i];
            if (c != '_') {
                if (first) {
                    first = false;
                    sb.append(capitalizeFirstLetter ? Character.toUpperCase(c) : Character.toLowerCase(c));
                } else {
                    sb.append(prev == '_' ? Character.toUpperCase(c) : Character.toLowerCase(c));
                }
            }
            ++i;
        }
    }

    public static void convertToJavaStringLiteral(StringBuilder sb, String string) {
        int stringLength = string.length();
        if (stringLength == 0) {
            sb.append(EMPTY_JSON_STRING_LITERAL);
        } else {
            sb.ensureCapacity(sb.length() + stringLength + 6);
            StringBuilderTools.convertToJavaStringLiteral(sb, string, stringLength);
        }
    }

    static void convertToJavaStringLiteral(StringBuilder sb, String string, int stringLength) {
        sb.append('\"');
        StringBuilderTools.convertToJavaStringLiteralContent(sb, string, stringLength);
        sb.append('\"');
    }

    public static void convertToJavaStringLiteralContent(StringBuilder sb, String string) {
        int stringLength = string.length();
        if (stringLength != 0) {
            sb.ensureCapacity(sb.length() + stringLength + 6);
            StringBuilderTools.convertToJavaStringLiteralContent(sb, string, stringLength);
        }
    }

    static void convertToJavaStringLiteralContent(StringBuilder sb, String string, int stringLength) {
        int i = 0;
        while (i < stringLength) {
            StringBuilderTools.convertToJavaStringLiteral(sb, string.charAt(i));
            ++i;
        }
    }

    public static void convertToJavaStringLiteral(StringBuilder sb, char[] string) {
        int stringLength = string.length;
        if (stringLength == 0) {
            sb.append(EMPTY_JSON_STRING_LITERAL);
        } else {
            sb.ensureCapacity(sb.length() + stringLength + 6);
            StringBuilderTools.convertToJavaStringLiteral(sb, string, stringLength);
        }
    }

    static void convertToJavaStringLiteral(StringBuilder sb, char[] string, int stringLength) {
        sb.append('\"');
        StringBuilderTools.convertToJavaStringLiteralContent(sb, string, stringLength);
        sb.append('\"');
    }

    public static void convertToJavaStringLiteralContent(StringBuilder sb, char[] string) {
        int stringLength = string.length;
        if (stringLength != 0) {
            sb.ensureCapacity(sb.length() + stringLength + 6);
            StringBuilderTools.convertToJavaStringLiteralContent(sb, string, stringLength);
        }
    }

    static void convertToJavaStringLiteralContent(StringBuilder sb, char[] string, int stringLength) {
        int i = 0;
        while (i < stringLength) {
            StringBuilderTools.convertToJavaStringLiteral(sb, string[i]);
            ++i;
        }
    }

    private static void convertToJavaStringLiteral(StringBuilder sb, char c) {
        switch (c) {
            case '\b': {
                sb.append("\\b");
                break;
            }
            case '\t': {
                sb.append("\\t");
                break;
            }
            case '\n': {
                sb.append("\\n");
                break;
            }
            case '\f': {
                sb.append("\\f");
                break;
            }
            case '\r': {
                sb.append("\\r");
                break;
            }
            case '\"': {
                sb.append("\\\"");
                break;
            }
            case '\\': {
                sb.append("\\\\");
                break;
            }
            default: {
                sb.append(c);
            }
        }
    }

    public static void convertToXmlAttributeValue(StringBuilder sb, String string) {
        int stringLength = string.length();
        if (stringLength == 0) {
            sb.append(EMPTY_JSON_STRING_LITERAL);
        } else {
            sb.ensureCapacity(sb.length() + stringLength + 12);
            StringBuilderTools.convertToXmlAttributeValue(sb, string, stringLength);
        }
    }

    static void convertToXmlAttributeValue(StringBuilder sb, String string, int stringLength) {
        int index = string.indexOf(34);
        if (index == -1) {
            StringBuilderTools.convertToDoubleQuotedXmlAttributeValue(sb, string, stringLength);
        } else {
            index = string.indexOf(39);
            if (index == -1) {
                StringBuilderTools.convertToSingleQuotedXmlAttributeValue(sb, string, stringLength);
            } else {
                StringBuilderTools.convertToDoubleQuotedXmlAttributeValue(sb, string, stringLength);
            }
        }
    }

    static void convertToDoubleQuotedXmlAttributeValue(StringBuilder sb, String string, int stringLength) {
        sb.append('\"');
        StringBuilderTools.convertToDoubleQuotedXmlAttributeValueContent(sb, string, stringLength);
        sb.append('\"');
    }

    static void convertToSingleQuotedXmlAttributeValue(StringBuilder sb, String string, int stringLength) {
        sb.append('\'');
        StringBuilderTools.convertToSingleQuotedXmlAttributeValueContent(sb, string, stringLength);
        sb.append('\'');
    }

    public static void convertToDoubleQuotedXmlAttributeValue(StringBuilder sb, String string) {
        StringBuilderTools.convertToDoubleQuotedXmlAttributeValue(sb, string, string.length());
    }

    public static void convertToDoubleQuotedXmlAttributeValueContent(StringBuilder sb, String string) {
        int stringLength = string.length();
        if (stringLength != 0) {
            sb.ensureCapacity(sb.length() + stringLength + 10);
            StringBuilderTools.convertToDoubleQuotedXmlAttributeValueContent(sb, string, stringLength);
        }
    }

    static void convertToDoubleQuotedXmlAttributeValueContent(StringBuilder sb, String string, int stringLength) {
        int i = 0;
        while (i < stringLength) {
            StringBuilderTools.convertToDoubleQuotedXmlAttributeValueContent(sb, string.charAt(i));
            ++i;
        }
    }

    public static void convertToSingleQuotedXmlAttributeValue(StringBuilder sb, String string) {
        StringBuilderTools.convertToSingleQuotedXmlAttributeValue(sb, string, string.length());
    }

    public static void convertToSingleQuotedXmlAttributeValueContent(StringBuilder sb, String string) {
        int stringLength = string.length();
        if (stringLength != 0) {
            sb.ensureCapacity(sb.length() + stringLength + 10);
            StringBuilderTools.convertToSingleQuotedXmlAttributeValueContent(sb, string, stringLength);
        }
    }

    static void convertToSingleQuotedXmlAttributeValueContent(StringBuilder sb, String string, int stringLength) {
        int i = 0;
        while (i < stringLength) {
            StringBuilderTools.convertToSingleQuotedXmlAttributeValueContent(sb, string.charAt(i));
            ++i;
        }
    }

    public static void convertToXmlAttributeValue(StringBuilder sb, char[] string) {
        int stringLength = string.length;
        if (stringLength == 0) {
            sb.append(EMPTY_JSON_STRING_LITERAL);
        } else {
            sb.ensureCapacity(sb.length() + stringLength + 12);
            StringBuilderTools.convertToXmlAttributeValue(sb, string, stringLength);
        }
    }

    static void convertToXmlAttributeValue(StringBuilder sb, char[] string, int stringLength) {
        int index = ArrayTools.indexOf(string, '\"');
        if (index == -1) {
            StringBuilderTools.convertToDoubleQuotedXmlAttributeValue(sb, string, stringLength);
        } else {
            index = ArrayTools.indexOf(string, '\'');
            if (index == -1) {
                StringBuilderTools.convertToSingleQuotedXmlAttributeValue(sb, string, stringLength);
            } else {
                StringBuilderTools.convertToDoubleQuotedXmlAttributeValue(sb, string, stringLength);
            }
        }
    }

    static void convertToDoubleQuotedXmlAttributeValue(StringBuilder sb, char[] string, int stringLength) {
        sb.append('\"');
        StringBuilderTools.convertToDoubleQuotedXmlAttributeValueContent(sb, string, stringLength);
        sb.append('\"');
    }

    static void convertToSingleQuotedXmlAttributeValue(StringBuilder sb, char[] string, int stringLength) {
        sb.append('\'');
        StringBuilderTools.convertToSingleQuotedXmlAttributeValueContent(sb, string, stringLength);
        sb.append('\'');
    }

    public static void convertToDoubleQuotedXmlAttributeValue(StringBuilder sb, char[] string) {
        StringBuilderTools.convertToDoubleQuotedXmlAttributeValue(sb, string, string.length);
    }

    public static void convertToDoubleQuotedXmlAttributeValueContent(StringBuilder sb, char[] string) {
        int stringLength = string.length;
        if (stringLength != 0) {
            sb.ensureCapacity(sb.length() + stringLength + 10);
            StringBuilderTools.convertToDoubleQuotedXmlAttributeValueContent(sb, string, stringLength);
        }
    }

    static void convertToDoubleQuotedXmlAttributeValueContent(StringBuilder sb, char[] string, int stringLength) {
        int i = 0;
        while (i < stringLength) {
            StringBuilderTools.convertToDoubleQuotedXmlAttributeValueContent(sb, string[i]);
            ++i;
        }
    }

    public static void convertToSingleQuotedXmlAttributeValue(StringBuilder sb, char[] string) {
        StringBuilderTools.convertToSingleQuotedXmlAttributeValue(sb, string, string.length);
    }

    public static void convertToSingleQuotedXmlAttributeValueContent(StringBuilder sb, char[] string) {
        int stringLength = string.length;
        if (stringLength != 0) {
            sb.ensureCapacity(sb.length() + stringLength + 10);
            StringBuilderTools.convertToSingleQuotedXmlAttributeValueContent(sb, string, stringLength);
        }
    }

    static void convertToSingleQuotedXmlAttributeValueContent(StringBuilder sb, char[] string, int stringLength) {
        int i = 0;
        while (i < stringLength) {
            StringBuilderTools.convertToSingleQuotedXmlAttributeValueContent(sb, string[i]);
            ++i;
        }
    }

    private static void convertToDoubleQuotedXmlAttributeValueContent(StringBuilder sb, char c) {
        switch (c) {
            case '\"': {
                sb.append("&quot;");
                break;
            }
            case '&': {
                sb.append("&amp;");
                break;
            }
            case '<': {
                sb.append("&lt;");
                break;
            }
            default: {
                sb.append(c);
            }
        }
    }

    private static void convertToSingleQuotedXmlAttributeValueContent(StringBuilder sb, char c) {
        switch (c) {
            case '\'': {
                sb.append("&apos;");
                break;
            }
            case '&': {
                sb.append("&amp;");
                break;
            }
            case '<': {
                sb.append("&lt;");
                break;
            }
            default: {
                sb.append(c);
            }
        }
    }

    public static void convertToXmlElementText(StringBuilder sb, String string) {
        int stringLength = string.length();
        if (stringLength != 0) {
            sb.ensureCapacity(sb.length() + stringLength + 8);
            StringBuilderTools.convertToXmlElementText(sb, string, stringLength);
        }
    }

    static void convertToXmlElementText(StringBuilder sb, String string, int stringLength) {
        int i = 0;
        while (i < stringLength) {
            StringBuilderTools.convertToXmlElementText(sb, string.charAt(i));
            ++i;
        }
    }

    public static void convertToXmlElementText(StringBuilder sb, char[] string) {
        int stringLength = string.length;
        if (stringLength != 0) {
            sb.ensureCapacity(sb.length() + stringLength + 8);
            StringBuilderTools.convertToXmlElementText(sb, string, stringLength);
        }
    }

    static void convertToXmlElementText(StringBuilder sb, char[] string, int stringLength) {
        int i = 0;
        while (i < stringLength) {
            StringBuilderTools.convertToXmlElementText(sb, string[i]);
            ++i;
        }
    }

    private static void convertToXmlElementText(StringBuilder sb, char c) {
        switch (c) {
            case '&': {
                sb.append("&amp;");
                break;
            }
            case '<': {
                sb.append("&lt;");
                break;
            }
            default: {
                sb.append(c);
            }
        }
    }

    public static void convertToXmlElementCDATA(StringBuilder sb, String string) {
        int stringLength = string.length();
        if (stringLength == 0) {
            sb.append("<![CDATA[]]>");
        } else {
            sb.ensureCapacity(sb.length() + stringLength + "<![CDATA[]]>".length() + 6);
            StringBuilderTools.convertToXmlElementCDATA(sb, string, stringLength);
        }
    }

    static void convertToXmlElementCDATA(StringBuilder sb, String string, int stringLength) {
        sb.append("<![CDATA[");
        StringBuilderTools.convertToXmlElementCDATAContent(sb, string, stringLength);
        sb.append("]]>");
    }

    public static void convertToXmlElementCDATAContent(StringBuilder sb, String string) {
        int stringLength = string.length();
        if (stringLength != 0) {
            sb.ensureCapacity(sb.length() + stringLength + 6);
            StringBuilderTools.convertToXmlElementCDATAContent(sb, string, stringLength);
        }
    }

    static void convertToXmlElementCDATAContent(StringBuilder sb, String string, int stringLength) {
        int i = 0;
        while (i < stringLength) {
            char c = string.charAt(i);
            sb.append(c);
            if (c == ']') {
                if (++i >= stringLength) break;
                c = string.charAt(i);
                sb.append(c);
                if (c == ']') {
                    if (++i >= stringLength) break;
                    c = string.charAt(i);
                    if (c == '>') {
                        sb.append("&gt;");
                    } else {
                        sb.append(c);
                    }
                }
            }
            ++i;
        }
    }

    public static void convertToXmlElementCDATA(StringBuilder sb, char[] string) {
        int stringLength = string.length;
        if (stringLength == 0) {
            sb.append("<![CDATA[]]>");
        } else {
            sb.ensureCapacity(sb.length() + stringLength + "<![CDATA[]]>".length() + 6);
            StringBuilderTools.convertToXmlElementCDATA(sb, string, stringLength);
        }
    }

    static void convertToXmlElementCDATA(StringBuilder sb, char[] string, int stringLength) {
        sb.append("<![CDATA[");
        StringBuilderTools.convertToXmlElementCDATAContent(sb, string, stringLength);
        sb.append("]]>");
    }

    public static void convertToXmlElementCDATAContent(StringBuilder sb, char[] string) {
        int stringLength = string.length;
        if (stringLength != 0) {
            sb.ensureCapacity(sb.length() + stringLength + 6);
            StringBuilderTools.convertToXmlElementCDATAContent(sb, string, stringLength);
        }
    }

    static void convertToXmlElementCDATAContent(StringBuilder sb, char[] string, int stringLength) {
        int i = 0;
        while (i < stringLength) {
            char c = string[i];
            sb.append(c);
            if (c == ']') {
                if (++i >= stringLength) break;
                c = string[i];
                sb.append(c);
                if (c == ']') {
                    if (++i >= stringLength) break;
                    c = string[i];
                    if (c == '>') {
                        sb.append("&gt;");
                    } else {
                        sb.append(c);
                    }
                }
            }
            ++i;
        }
    }

    public static void appendJSON(StringBuilder sb, Object object) {
        if (object == null) {
            StringBuilderTools.appendJSONNull(sb);
        } else {
            StringBuilderTools.appendJSON_(sb, object);
        }
    }

    private static void appendJSON_(StringBuilder sb, Object object) {
        if (object instanceof String) {
            StringBuilderTools.appendJSON_(sb, (String)object);
        } else if (object instanceof char[]) {
            StringBuilderTools.appendJSON_(sb, (char[])object);
        } else if (object instanceof Boolean) {
            StringBuilderTools.appendJSON_(sb, (Boolean)object);
        } else if (object instanceof Map) {
            StringBuilderTools.appendJSON_(sb, (Map)object);
        } else if (object instanceof Iterable) {
            StringBuilderTools.appendJSON_(sb, (Iterable)object);
        } else if (object instanceof Object[]) {
            StringBuilderTools.appendJSON_(sb, (Object[])object);
        } else if (object instanceof Number) {
            StringBuilderTools.appendJSON_(sb, (Number)object);
        } else if (object instanceof int[]) {
            StringBuilderTools.appendJSON_(sb, (int[])object);
        } else if (object instanceof double[]) {
            StringBuilderTools.appendJSON_(sb, (double[])object);
        } else if (object instanceof byte[]) {
            StringBuilderTools.appendJSON_(sb, (byte[])object);
        } else if (object instanceof short[]) {
            StringBuilderTools.appendJSON_(sb, (short[])object);
        } else if (object instanceof long[]) {
            StringBuilderTools.appendJSON_(sb, (long[])object);
        } else if (object instanceof float[]) {
            StringBuilderTools.appendJSON_(sb, (float[])object);
        } else if (object instanceof boolean[]) {
            StringBuilderTools.appendJSON_(sb, (boolean[])object);
        } else {
            StringBuilderTools.appendJSON__(sb, object);
        }
    }

    public static void appendJSON(StringBuilder sb, Map<?, ?> map) {
        if (map == null) {
            StringBuilderTools.appendJSONNull(sb);
        } else {
            StringBuilderTools.appendJSON_(sb, map);
        }
    }

    private static void appendJSON_(StringBuilder sb, Map<?, ?> map) {
        Set<?> keys = map.keySet();
        for (Object key : keys) {
            if (key instanceof String) continue;
            StringBuilderTools.appendJSON__(sb, map);
            return;
        }
        sb.append('{');
        if (!keys.isEmpty()) {
            TreeSet sortedKeys = new TreeSet(map.keySet());
            for (String key : sortedKeys) {
                StringBuilderTools.appendJSON(sb, key);
                sb.append(':');
                StringBuilderTools.appendJSON(sb, map.get(key));
                sb.append(',');
            }
            sb.setLength(sb.length() - 1);
        }
        sb.append('}');
    }

    private static void appendJSON__(StringBuilder sb, Object object) {
        sb.append('{');
        Iterator<Field> stream = IterableTools.sort(ClassTools.allInstanceFields(object.getClass()), FIELD_COMPARATOR).iterator();
        if (stream.hasNext()) {
            do {
                Object value;
                Field field = stream.next();
                StringBuilderTools.appendJSON(sb, field.getName());
                sb.append(':');
                field.setAccessible(true);
                try {
                    value = field.get(object);
                }
                catch (IllegalAccessException ex) {
                    throw new RuntimeException(ex);
                }
                StringBuilderTools.appendJSON(sb, value);
                sb.append(',');
            } while (stream.hasNext());
            sb.setLength(sb.length() - 1);
        }
        sb.append('}');
    }

    public static void appendJSONNull(StringBuilder sb) {
        sb.append(String.valueOf(null));
    }

    public static void appendJSON(StringBuilder sb, String string) {
        if (string == null) {
            StringBuilderTools.appendJSONNull(sb);
        } else {
            StringBuilderTools.appendJSON_(sb, string);
        }
    }

    private static void appendJSON_(StringBuilder sb, String string) {
        int stringLength = string.length();
        if (stringLength == 0) {
            sb.append(EMPTY_JSON_STRING_LITERAL);
        } else {
            sb.ensureCapacity(sb.length() + stringLength + 6);
            StringBuilderTools.appendJSON_(sb, string, stringLength);
        }
    }

    private static void appendJSON_(StringBuilder sb, String string, int stringLength) {
        sb.append('\"');
        StringBuilderTools.appendJSONContent_(sb, string, stringLength);
        sb.append('\"');
    }

    public static void appendJSONContent(StringBuilder sb, String string) {
        if (string == null) {
            StringBuilderTools.appendJSONNull(sb);
        } else {
            StringBuilderTools.appendJSONContent_(sb, string);
        }
    }

    private static void appendJSONContent_(StringBuilder sb, String string) {
        int stringLength = string.length();
        if (stringLength != 0) {
            sb.ensureCapacity(sb.length() + stringLength + 6);
            StringBuilderTools.appendJSONContent_(sb, string, stringLength);
        }
    }

    private static void appendJSONContent_(StringBuilder sb, String string, int stringLength) {
        int i = 0;
        while (i < stringLength) {
            StringBuilderTools.appendJSON(sb, string.charAt(i));
            ++i;
        }
    }

    public static void appendJSON(StringBuilder sb, char[] string) {
        if (string == null) {
            StringBuilderTools.appendJSONNull(sb);
        } else {
            StringBuilderTools.appendJSON_(sb, string);
        }
    }

    private static void appendJSON_(StringBuilder sb, char[] string) {
        int stringLength = string.length;
        if (stringLength == 0) {
            sb.append(EMPTY_JSON_STRING_LITERAL);
        } else {
            sb.ensureCapacity(sb.length() + stringLength + 6);
            StringBuilderTools.appendJSON_(sb, string, stringLength);
        }
    }

    private static void appendJSON_(StringBuilder sb, char[] string, int stringLength) {
        sb.append('\"');
        StringBuilderTools.appendJSONContent_(sb, string, stringLength);
        sb.append('\"');
    }

    public static void appendJSONContent(StringBuilder sb, char[] string) {
        if (string == null) {
            StringBuilderTools.appendJSONNull(sb);
        } else {
            StringBuilderTools.appendJSONContent_(sb, string);
        }
    }

    private static void appendJSONContent_(StringBuilder sb, char[] string) {
        int stringLength = string.length;
        if (stringLength != 0) {
            sb.ensureCapacity(sb.length() + stringLength + 6);
            StringBuilderTools.appendJSONContent_(sb, string, stringLength);
        }
    }

    private static void appendJSONContent_(StringBuilder sb, char[] string, int stringLength) {
        int i = 0;
        while (i < stringLength) {
            StringBuilderTools.appendJSON(sb, string[i]);
            ++i;
        }
    }

    private static void appendJSON(StringBuilder sb, char c) {
        switch (c) {
            case '\"': {
                sb.append("\\\"");
                break;
            }
            case '\\': {
                sb.append("\\\\");
                break;
            }
            case '\b': {
                sb.append("\\b");
                break;
            }
            case '\f': {
                sb.append("\\f");
                break;
            }
            case '\n': {
                sb.append("\\n");
                break;
            }
            case '\r': {
                sb.append("\\r");
                break;
            }
            case '\t': {
                sb.append("\\t");
                break;
            }
            default: {
                if (c < ' ') {
                    if (c < '\u0010') {
                        sb.append("\\u000");
                        sb.append(Integer.toHexString(c));
                        break;
                    }
                    sb.append("\\u00");
                    sb.append(Integer.toHexString(c));
                    break;
                }
                sb.append(c);
            }
        }
    }

    public static void appendJSON(StringBuilder sb, Iterable<?> objects) {
        if (objects == null) {
            StringBuilderTools.appendJSONNull(sb);
        } else {
            StringBuilderTools.appendJSON_(sb, objects);
        }
    }

    private static void appendJSON_(StringBuilder sb, Iterable<?> objects) {
        sb.append('[');
        Iterator<?> stream = objects.iterator();
        if (stream.hasNext()) {
            do {
                StringBuilderTools.appendJSON(sb, stream.next());
                sb.append(',');
            } while (stream.hasNext());
            sb.setLength(sb.length() - 1);
        }
        sb.append(']');
    }

    public static void appendJSON(StringBuilder sb, Object[] array) {
        if (array == null) {
            StringBuilderTools.appendJSONNull(sb);
        } else {
            StringBuilderTools.appendJSON_(sb, array);
        }
    }

    private static void appendJSON_(StringBuilder sb, Object[] array) {
        if (array instanceof Boolean[]) {
            StringBuilderTools.appendJSON_(sb, (Boolean[])array);
        } else if (array instanceof Number[]) {
            StringBuilderTools.appendJSON_(sb, (Number[])array);
        } else {
            StringBuilderTools.appendJSON__(sb, array);
        }
    }

    private static void appendJSON__(StringBuilder sb, Object[] array) {
        sb.append('[');
        if (array.length > 0) {
            Object[] objectArray = array;
            int n = array.length;
            int n2 = 0;
            while (n2 < n) {
                Object each = objectArray[n2];
                StringBuilderTools.appendJSON(sb, each);
                sb.append(',');
                ++n2;
            }
            sb.setLength(sb.length() - 1);
        }
        sb.append(']');
    }

    public static void appendJSON(StringBuilder sb, Boolean[] array) {
        if (array == null) {
            StringBuilderTools.appendJSONNull(sb);
        } else {
            StringBuilderTools.appendJSON_(sb, array);
        }
    }

    private static void appendJSON_(StringBuilder sb, Boolean[] array) {
        sb.append('[');
        if (array.length > 0) {
            Boolean[] booleanArray = array;
            int n = array.length;
            int n2 = 0;
            while (n2 < n) {
                Boolean each = booleanArray[n2];
                StringBuilderTools.appendJSON(sb, each);
                sb.append(',');
                ++n2;
            }
            sb.setLength(sb.length() - 1);
        }
        sb.append(']');
    }

    public static void appendJSON(StringBuilder sb, Boolean b) {
        if (b == null) {
            StringBuilderTools.appendJSONNull(sb);
        } else {
            StringBuilderTools.appendJSON_(sb, b);
        }
    }

    private static void appendJSON_(StringBuilder sb, Boolean b) {
        StringBuilderTools.appendJSON(sb, (boolean)b);
    }

    public static void appendJSON(StringBuilder sb, boolean[] array) {
        if (array == null) {
            StringBuilderTools.appendJSONNull(sb);
        } else {
            StringBuilderTools.appendJSON_(sb, array);
        }
    }

    private static void appendJSON_(StringBuilder sb, boolean[] array) {
        sb.append('[');
        if (array.length > 0) {
            boolean[] blArray = array;
            int n = array.length;
            int n2 = 0;
            while (n2 < n) {
                boolean each = blArray[n2];
                StringBuilderTools.appendJSON(sb, each);
                sb.append(',');
                ++n2;
            }
            sb.setLength(sb.length() - 1);
        }
        sb.append(']');
    }

    public static void appendJSON(StringBuilder sb, boolean b) {
        sb.append(b);
    }

    public static void appendJSON(StringBuilder sb, Number[] array) {
        if (array == null) {
            StringBuilderTools.appendJSONNull(sb);
        } else {
            StringBuilderTools.appendJSON_(sb, array);
        }
    }

    private static void appendJSON_(StringBuilder sb, Number[] array) {
        if (array instanceof Integer[]) {
            StringBuilderTools.appendJSON_(sb, (Integer[])array);
        } else if (array instanceof Double[]) {
            StringBuilderTools.appendJSON_(sb, (Double[])array);
        } else if (array instanceof Byte[]) {
            StringBuilderTools.appendJSON_(sb, (Byte[])array);
        } else if (array instanceof Float[]) {
            StringBuilderTools.appendJSON_(sb, (Float[])array);
        } else if (array instanceof Long[]) {
            StringBuilderTools.appendJSON_(sb, (Long[])array);
        } else if (array instanceof Short[]) {
            StringBuilderTools.appendJSON_(sb, (Short[])array);
        } else if (array instanceof BigDecimal[]) {
            StringBuilderTools.appendJSON_(sb, (BigDecimal[])array);
        } else if (array instanceof BigInteger[]) {
            StringBuilderTools.appendJSON_(sb, (BigInteger[])array);
        } else {
            StringBuilderTools.appendJSON__(sb, array);
        }
    }

    public static void appendJSON(StringBuilder sb, Number n) {
        if (n == null) {
            StringBuilderTools.appendJSONNull(sb);
        } else {
            StringBuilderTools.appendJSON_(sb, n);
        }
    }

    private static void appendJSON_(StringBuilder sb, Number n) {
        if (n instanceof Integer) {
            StringBuilderTools.appendJSON_(sb, (Integer)n);
        } else if (n instanceof Double) {
            StringBuilderTools.appendJSON_(sb, (Double)n);
        } else if (n instanceof Byte) {
            StringBuilderTools.appendJSON_(sb, (Byte)n);
        } else if (n instanceof Float) {
            StringBuilderTools.appendJSON_(sb, (Float)n);
        } else if (n instanceof Long) {
            StringBuilderTools.appendJSON_(sb, (Long)n);
        } else if (n instanceof Short) {
            StringBuilderTools.appendJSON_(sb, (Short)n);
        } else if (n instanceof BigDecimal) {
            StringBuilderTools.appendJSON_(sb, (BigDecimal)n);
        } else if (n instanceof BigInteger) {
            StringBuilderTools.appendJSON_(sb, (BigInteger)n);
        } else {
            StringBuilderTools.appendJSON__(sb, n);
        }
    }

    private static void appendJSON__(StringBuilder sb, Number n) {
        String s = n.toString();
        try {
            new BigDecimal(s);
            sb.append(s);
        }
        catch (NumberFormatException numberFormatException) {
            StringBuilderTools.appendJSON__(sb, (Object)n);
        }
    }

    public static void appendJSON(StringBuilder sb, Integer[] array) {
        if (array == null) {
            StringBuilderTools.appendJSONNull(sb);
        } else {
            StringBuilderTools.appendJSON_(sb, array);
        }
    }

    private static void appendJSON_(StringBuilder sb, Integer[] array) {
        sb.append('[');
        if (array.length > 0) {
            Integer[] integerArray = array;
            int n = array.length;
            int n2 = 0;
            while (n2 < n) {
                Integer each = integerArray[n2];
                StringBuilderTools.appendJSON(sb, each);
                sb.append(',');
                ++n2;
            }
            sb.setLength(sb.length() - 1);
        }
        sb.append(']');
    }

    public static void appendJSON(StringBuilder sb, Integer i) {
        if (i == null) {
            StringBuilderTools.appendJSONNull(sb);
        } else {
            StringBuilderTools.appendJSON_(sb, i);
        }
    }

    private static void appendJSON_(StringBuilder sb, Integer i) {
        StringBuilderTools.appendJSON(sb, (int)i);
    }

    public static void appendJSON(StringBuilder sb, int[] array) {
        if (array == null) {
            StringBuilderTools.appendJSONNull(sb);
        } else {
            StringBuilderTools.appendJSON_(sb, array);
        }
    }

    private static void appendJSON_(StringBuilder sb, int[] array) {
        sb.append('[');
        if (array.length > 0) {
            int[] nArray = array;
            int n = array.length;
            int n2 = 0;
            while (n2 < n) {
                int each = nArray[n2];
                StringBuilderTools.appendJSON(sb, each);
                sb.append(',');
                ++n2;
            }
            sb.setLength(sb.length() - 1);
        }
        sb.append(']');
    }

    public static void appendJSON(StringBuilder sb, int i) {
        sb.append(i);
    }

    public static void appendJSON(StringBuilder sb, Double[] array) {
        if (array == null) {
            StringBuilderTools.appendJSONNull(sb);
        } else {
            StringBuilderTools.appendJSON_(sb, array);
        }
    }

    private static void appendJSON_(StringBuilder sb, Double[] array) {
        sb.append('[');
        if (array.length > 0) {
            Double[] doubleArray = array;
            int n = array.length;
            int n2 = 0;
            while (n2 < n) {
                Double each = doubleArray[n2];
                StringBuilderTools.appendJSON(sb, each);
                sb.append(',');
                ++n2;
            }
            sb.setLength(sb.length() - 1);
        }
        sb.append(']');
    }

    public static void appendJSON(StringBuilder sb, Double d) {
        if (d == null) {
            StringBuilderTools.appendJSONNull(sb);
        } else {
            StringBuilderTools.appendJSON_(sb, d);
        }
    }

    private static void appendJSON_(StringBuilder sb, Double d) {
        StringBuilderTools.appendJSON(sb, (double)d);
    }

    public static void appendJSON(StringBuilder sb, double[] array) {
        if (array == null) {
            StringBuilderTools.appendJSONNull(sb);
        } else {
            StringBuilderTools.appendJSON_(sb, array);
        }
    }

    private static void appendJSON_(StringBuilder sb, double[] array) {
        sb.append('[');
        if (array.length > 0) {
            double[] dArray = array;
            int n = array.length;
            int n2 = 0;
            while (n2 < n) {
                double each = dArray[n2];
                StringBuilderTools.appendJSON(sb, each);
                sb.append(',');
                ++n2;
            }
            sb.setLength(sb.length() - 1);
        }
        sb.append(']');
    }

    public static void appendJSON(StringBuilder sb, double d) {
        sb.append(d);
    }

    public static void appendJSON(StringBuilder sb, Byte[] array) {
        if (array == null) {
            StringBuilderTools.appendJSONNull(sb);
        } else {
            StringBuilderTools.appendJSON_(sb, array);
        }
    }

    private static void appendJSON_(StringBuilder sb, Byte[] array) {
        sb.append('[');
        if (array.length > 0) {
            Byte[] byteArray = array;
            int n = array.length;
            int n2 = 0;
            while (n2 < n) {
                Byte each = byteArray[n2];
                StringBuilderTools.appendJSON(sb, each);
                sb.append(',');
                ++n2;
            }
            sb.setLength(sb.length() - 1);
        }
        sb.append(']');
    }

    public static void appendJSON(StringBuilder sb, Byte b) {
        if (b == null) {
            StringBuilderTools.appendJSONNull(sb);
        } else {
            StringBuilderTools.appendJSON_(sb, b);
        }
    }

    private static void appendJSON_(StringBuilder sb, Byte b) {
        StringBuilderTools.appendJSON(sb, (byte)b);
    }

    public static void appendJSON(StringBuilder sb, byte[] array) {
        if (array == null) {
            StringBuilderTools.appendJSONNull(sb);
        } else {
            StringBuilderTools.appendJSON_(sb, array);
        }
    }

    private static void appendJSON_(StringBuilder sb, byte[] array) {
        sb.append('[');
        if (array.length > 0) {
            byte[] byArray = array;
            int n = array.length;
            int n2 = 0;
            while (n2 < n) {
                byte each = byArray[n2];
                StringBuilderTools.appendJSON(sb, each);
                sb.append(',');
                ++n2;
            }
            sb.setLength(sb.length() - 1);
        }
        sb.append(']');
    }

    public static void appendJSON(StringBuilder sb, byte b) {
        sb.append(b);
    }

    public static void appendJSON(StringBuilder sb, Float[] array) {
        if (array == null) {
            StringBuilderTools.appendJSONNull(sb);
        } else {
            StringBuilderTools.appendJSON_(sb, array);
        }
    }

    private static void appendJSON_(StringBuilder sb, Float[] array) {
        sb.append('[');
        if (array.length > 0) {
            Float[] floatArray = array;
            int n = array.length;
            int n2 = 0;
            while (n2 < n) {
                Float each = floatArray[n2];
                StringBuilderTools.appendJSON(sb, each);
                sb.append(',');
                ++n2;
            }
            sb.setLength(sb.length() - 1);
        }
        sb.append(']');
    }

    public static void appendJSON(StringBuilder sb, Float f) {
        if (f == null) {
            StringBuilderTools.appendJSONNull(sb);
        } else {
            StringBuilderTools.appendJSON_(sb, f);
        }
    }

    private static void appendJSON_(StringBuilder sb, Float f) {
        StringBuilderTools.appendJSON(sb, f.floatValue());
    }

    public static void appendJSON(StringBuilder sb, float[] array) {
        if (array == null) {
            StringBuilderTools.appendJSONNull(sb);
        } else {
            StringBuilderTools.appendJSON_(sb, array);
        }
    }

    private static void appendJSON_(StringBuilder sb, float[] array) {
        sb.append('[');
        if (array.length > 0) {
            float[] fArray = array;
            int n = array.length;
            int n2 = 0;
            while (n2 < n) {
                float each = fArray[n2];
                StringBuilderTools.appendJSON(sb, each);
                sb.append(',');
                ++n2;
            }
            sb.setLength(sb.length() - 1);
        }
        sb.append(']');
    }

    public static void appendJSON(StringBuilder sb, float f) {
        sb.append(f);
    }

    public static void appendJSON(StringBuilder sb, Long[] array) {
        if (array == null) {
            StringBuilderTools.appendJSONNull(sb);
        } else {
            StringBuilderTools.appendJSON_(sb, array);
        }
    }

    private static void appendJSON_(StringBuilder sb, Long[] array) {
        sb.append('[');
        if (array.length > 0) {
            Long[] longArray = array;
            int n = array.length;
            int n2 = 0;
            while (n2 < n) {
                Long each = longArray[n2];
                StringBuilderTools.appendJSON(sb, each);
                sb.append(',');
                ++n2;
            }
            sb.setLength(sb.length() - 1);
        }
        sb.append(']');
    }

    public static void appendJSON(StringBuilder sb, Long l) {
        if (l == null) {
            StringBuilderTools.appendJSONNull(sb);
        } else {
            StringBuilderTools.appendJSON_(sb, l);
        }
    }

    private static void appendJSON_(StringBuilder sb, Long l) {
        StringBuilderTools.appendJSON(sb, (long)l);
    }

    public static void appendJSON(StringBuilder sb, long[] array) {
        if (array == null) {
            StringBuilderTools.appendJSONNull(sb);
        } else {
            StringBuilderTools.appendJSON_(sb, array);
        }
    }

    private static void appendJSON_(StringBuilder sb, long[] array) {
        sb.append('[');
        if (array.length > 0) {
            long[] lArray = array;
            int n = array.length;
            int n2 = 0;
            while (n2 < n) {
                long each = lArray[n2];
                StringBuilderTools.appendJSON(sb, each);
                sb.append(',');
                ++n2;
            }
            sb.setLength(sb.length() - 1);
        }
        sb.append(']');
    }

    public static void appendJSON(StringBuilder sb, long l) {
        sb.append(l);
    }

    public static void appendJSON(StringBuilder sb, Short[] array) {
        if (array == null) {
            StringBuilderTools.appendJSONNull(sb);
        } else {
            StringBuilderTools.appendJSON_(sb, array);
        }
    }

    private static void appendJSON_(StringBuilder sb, Short[] array) {
        sb.append('[');
        if (array.length > 0) {
            Short[] shortArray = array;
            int n = array.length;
            int n2 = 0;
            while (n2 < n) {
                Short each = shortArray[n2];
                StringBuilderTools.appendJSON(sb, each);
                sb.append(',');
                ++n2;
            }
            sb.setLength(sb.length() - 1);
        }
        sb.append(']');
    }

    public static void appendJSON(StringBuilder sb, Short s) {
        if (s == null) {
            StringBuilderTools.appendJSONNull(sb);
        } else {
            StringBuilderTools.appendJSON_(sb, s);
        }
    }

    private static void appendJSON_(StringBuilder sb, Short s) {
        StringBuilderTools.appendJSON(sb, (short)s);
    }

    public static void appendJSON(StringBuilder sb, short[] array) {
        if (array == null) {
            StringBuilderTools.appendJSONNull(sb);
        } else {
            StringBuilderTools.appendJSON_(sb, array);
        }
    }

    private static void appendJSON_(StringBuilder sb, short[] array) {
        sb.append('[');
        if (array.length > 0) {
            short[] sArray = array;
            int n = array.length;
            int n2 = 0;
            while (n2 < n) {
                short each = sArray[n2];
                StringBuilderTools.appendJSON(sb, each);
                sb.append(',');
                ++n2;
            }
            sb.setLength(sb.length() - 1);
        }
        sb.append(']');
    }

    public static void appendJSON(StringBuilder sb, short s) {
        sb.append(s);
    }

    public static void appendJSON(StringBuilder sb, BigDecimal[] array) {
        if (array == null) {
            StringBuilderTools.appendJSONNull(sb);
        } else {
            StringBuilderTools.appendJSON_(sb, array);
        }
    }

    private static void appendJSON_(StringBuilder sb, BigDecimal[] array) {
        sb.append('[');
        if (array.length > 0) {
            BigDecimal[] bigDecimalArray = array;
            int n = array.length;
            int n2 = 0;
            while (n2 < n) {
                BigDecimal each = bigDecimalArray[n2];
                StringBuilderTools.appendJSON(sb, each);
                sb.append(',');
                ++n2;
            }
            sb.setLength(sb.length() - 1);
        }
        sb.append(']');
    }

    public static void appendJSON(StringBuilder sb, BigDecimal bd) {
        if (bd == null) {
            StringBuilderTools.appendJSONNull(sb);
        } else {
            StringBuilderTools.appendJSON_(sb, bd);
        }
    }

    private static void appendJSON_(StringBuilder sb, BigDecimal bd) {
        sb.append(bd.toString());
    }

    public static void appendJSON(StringBuilder sb, BigInteger[] array) {
        if (array == null) {
            StringBuilderTools.appendJSONNull(sb);
        } else {
            StringBuilderTools.appendJSON_(sb, array);
        }
    }

    private static void appendJSON_(StringBuilder sb, BigInteger[] array) {
        sb.append('[');
        if (array.length > 0) {
            BigInteger[] bigIntegerArray = array;
            int n = array.length;
            int n2 = 0;
            while (n2 < n) {
                BigInteger each = bigIntegerArray[n2];
                StringBuilderTools.appendJSON(sb, each);
                sb.append(',');
                ++n2;
            }
            sb.setLength(sb.length() - 1);
        }
        sb.append(']');
    }

    public static void appendJSON(StringBuilder sb, BigInteger bi) {
        if (bi == null) {
            StringBuilderTools.appendJSONNull(sb);
        } else {
            StringBuilderTools.appendJSON_(sb, bi);
        }
    }

    private static void appendJSON_(StringBuilder sb, BigInteger bi) {
        sb.append(bi.toString());
    }

    private static void appendJSON__(StringBuilder sb, Number[] array) {
        sb.append('[');
        if (array.length > 0) {
            Number[] numberArray = array;
            int n = array.length;
            int n2 = 0;
            while (n2 < n) {
                Number number = numberArray[n2];
                StringBuilderTools.appendJSON(sb, number);
                sb.append(',');
                ++n2;
            }
            sb.setLength(sb.length() - 1);
        }
        sb.append(']');
    }

    public static void append(StringBuilder sb, Object[] array) {
        if (array == null) {
            sb.append(array);
        } else {
            StringBuilderTools.append_(sb, array);
        }
    }

    private static void append_(StringBuilder sb, Object[] array) {
        sb.append('[');
        if (array.length > 0) {
            Object[] objectArray = array;
            int n = array.length;
            int n2 = 0;
            while (n2 < n) {
                Object element = objectArray[n2];
                sb.append(element);
                sb.append(", ");
                ++n2;
            }
            sb.setLength(sb.length() - 2);
        }
        sb.append(']');
    }

    public static <T> void append(StringBuilder sb, Iterable<T> iterable) {
        StringBuilderTools.append(sb, iterable.iterator());
    }

    public static <T> void append(StringBuilder sb, Iterator<T> iterator) {
        sb.append('[');
        while (iterator.hasNext()) {
            sb.append(iterator.next());
            if (!iterator.hasNext()) continue;
            sb.append(", ");
        }
        sb.append(']');
    }

    public static void appendHashCodeToString(StringBuilder sb, Object object) {
        StringBuilderTools.appendToStringName(sb, object.getClass());
        sb.append('[');
        StringBuilderTools.separate(sb, StringBuilderTools.buildHashCode(object), '-', 2);
        sb.append(']');
    }

    private static String buildHashCode(Object object) {
        return StringTools.zeroPad(Integer.toHexString(System.identityHashCode(object)).toUpperCase(), 8);
    }

    public static void appendToStringName(StringBuilder sb, Class<?> javaClass) {
        ClassTools.appendToStringNameTo(javaClass, sb);
    }

    public static void appendIdentityToString(StringBuilder sb, Object object) {
        sb.append(object.getClass().getName());
        sb.append('@');
        sb.append(Integer.toHexString(object.hashCode()));
    }

    private StringBuilderTools() {
        throw new UnsupportedOperationException();
    }

    static class FieldComparator
    extends ComparatorAdapter<Field> {
        FieldComparator() {
        }

        @Override
        public int compare(Field field1, Field field2) {
            return field1.getName().compareTo(field2.getName());
        }
    }
}

