/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.web.ui.tests.contentassist;

import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.eclipse.wst.jsdt.web.ui.tests.contentassist.ContentAssistTestUtilities;
import org.eclipse.wst.jsdt.web.ui.tests.internal.TestProjectSetup;

public class GlobalFunctionTests
extends TestCase {
    private static final String TEST_NAME = "Test Global Functions JavaScript Content Assist";
    private static TestProjectSetup fTestProjectSetup;

    public GlobalFunctionTests() {
        super(TEST_NAME);
    }

    public GlobalFunctionTests(String name) {
        super(name);
    }

    public static Test suite() {
        TestSuite ts = new TestSuite(GlobalFunctionTests.class, TEST_NAME);
        fTestProjectSetup = new TestProjectSetup((Test)ts, "JSDTWebContentAssist", "WebContent", false);
        return fTestProjectSetup;
    }

    public void testFindFunctions_ExpressionStarted_0() throws Exception {
        String[][] expectedProposals = new String[][]{{"funcOne() - Global", "funcTwo() : String - Global", "funcThree(paramOne) - Global", "funcFour(paramOne, paramTwo) : Number - Global", "funcFive(Number paramOne, String paramTwo) : String - Global", "funcSix(paramOne, String paramTwo) : Number - Global", "funcSeven(String paramOne, paramTwo) : Number - Global", "funcEight(paramOne) : String - Global", "funcNine(paramOne) : Number - Global"}};
        ContentAssistTestUtilities.runProposalTest(fTestProjectSetup, "GlobalFunctions.html", 6, 0, expectedProposals);
    }

    public void testFindFunctions_ExpressionStarted_1() throws Exception {
        String[][] expectedProposals = new String[][]{{"funcOne() - Global", "funcTwo() : String - Global", "funcThree(paramOne) - Global", "funcFour(paramOne, paramTwo) : Number - Global", "funcFive(Number paramOne, String paramTwo) : String - Global", "funcSix(paramOne, String paramTwo) : Number - Global", "funcSeven(String paramOne, paramTwo) : Number - Global", "funcEight(paramOne) : String - Global", "funcNine(paramOne) : Number - Global"}};
        ContentAssistTestUtilities.runProposalTest(fTestProjectSetup, "GlobalFunctions.html", 8, 1, expectedProposals);
    }

    public void testFindFunctions_ExpressionStarted_2() throws Exception {
        String[][] expectedProposals = new String[][]{{"funcTwo() : String - Global", "funcThree(paramOne) - Global"}};
        ContentAssistTestUtilities.runProposalTest(fTestProjectSetup, "GlobalFunctions.html", 10, 5, expectedProposals);
    }

    public void testFindFunctions_ExpressionStarted_CamelCase() throws Exception {
        String[][] expectedProposals = new String[][]{{"funcTwo() : String - Global", "funcThree(paramOne) - Global"}};
        ContentAssistTestUtilities.runProposalTest(fTestProjectSetup, "GlobalFunctions.html", 12, 2, expectedProposals);
    }

    public void testNamedFunctionsAssignedToVariables_ExpressionNotStarted() throws Exception {
        String[][] expectedProposals = new String[][]{{"foo1 : Function - Global", "foo1(param2) - Global", "foo2 : Function - Global", "foo2(param3, param4) - Global"}};
        ContentAssistTestUtilities.runProposalTest(fTestProjectSetup, "NamedFunctionAssignedToVariables.html", 6, 0, expectedProposals);
    }

    public void testNamedFunctionsAssignedToVariables_ExpressionStarted1() throws Exception {
        String[][] expectedProposals = new String[][]{{"foo1 : Function - Global", "foo1(param2) - Global", "foo2 : Function - Global", "foo2(param3, param4) - Global"}};
        ContentAssistTestUtilities.runProposalTest(fTestProjectSetup, "NamedFunctionAssignedToVariables.html", 8, 1, expectedProposals);
    }

    public void testNamedFunctionsAssignedToVariables_ExpressionNotStarted_NegativeTest() throws Exception {
        String[][] expectedProposals = new String[][]{{"foo1Ignored", "foo2Ignored"}};
        ContentAssistTestUtilities.runProposalTest(fTestProjectSetup, "NamedFunctionAssignedToVariables.html", 6, 0, expectedProposals, true, false);
    }

    public void testNamedFunctionsAssignedToVariables_ExpressionStarted1_NegativeTest() throws Exception {
        String[][] expectedProposals = new String[][]{{"foo1Ignored", "foo2Ignored"}};
        ContentAssistTestUtilities.runProposalTest(fTestProjectSetup, "NamedFunctionAssignedToVariables.html", 8, 1, expectedProposals, true, false);
    }
}

