/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.json.ui.internal.preferences;

import org.eclipse.core.runtime.Preferences;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Spinner;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.dialogs.PreferenceLinkArea;
import org.eclipse.ui.preferences.IWorkbenchPreferenceContainer;
import org.eclipse.wst.json.core.JSONCorePlugin;
import org.eclipse.wst.json.ui.internal.JSONUIMessages;
import org.eclipse.wst.json.ui.internal.JSONUIPlugin;
import org.eclipse.wst.sse.ui.internal.preferences.ui.AbstractPreferencePage;

public class JSONSourcePreferencePage
extends AbstractPreferencePage {
    protected Button fSplitMultiAttrs;
    private final int MAX_INDENTATION_SIZE = 16;
    private final int MIN_INDENTATION_SIZE = 0;
    private Label fLineWidthLabel;
    private Text fLineWidthText;
    private Button fIndentUsingTabs;
    private Button fIndentUsingSpaces;
    private Spinner fIndentationSize;

    protected Control createContents(Composite parent) {
        Composite composite = super.createComposite(parent, 1);
        new PreferenceLinkArea(composite, 66, "org.eclipse.wst.sse.ui.preferences.editor", JSONUIMessages._UI_STRUCTURED_TEXT_EDITOR_PREFS_LINK, (IWorkbenchPreferenceContainer)this.getContainer(), null).getControl().setLayoutData((Object)GridDataFactory.fillDefaults().hint(150, -1).create());
        new Label(composite, 0).setLayoutData((Object)GridDataFactory.swtDefaults().create());
        this.createContentsForFormattingGroup(composite);
        this.setSize(composite);
        this.loadPreferences();
        return composite;
    }

    private void createContentsForFormattingGroup(Composite parent) {
        Group formattingGroup = this.createGroup(parent, 2);
        formattingGroup.setText(JSONUIMessages.Formatting_UI_);
        this.fLineWidthLabel = this.createLabel((Composite)formattingGroup, JSONUIMessages.Line_width__UI_);
        this.fLineWidthText = new Text((Composite)formattingGroup, 2052);
        GridData gData = new GridData(33);
        gData.widthHint = 25;
        this.fLineWidthText.setLayoutData((Object)gData);
        this.fLineWidthText.addModifyListener((ModifyListener)this);
        Composite indentComposite = this.createComposite((Composite)formattingGroup, 1);
        ((GridData)indentComposite.getLayoutData()).horizontalSpan = 2;
        ((GridLayout)indentComposite.getLayout()).marginWidth = 0;
        ((GridLayout)indentComposite.getLayout()).marginHeight = 0;
        this.fIndentUsingTabs = this.createRadioButton(indentComposite, JSONUIMessages.Indent_using_tabs_);
        ((GridData)this.fIndentUsingTabs.getLayoutData()).horizontalSpan = 1;
        this.fIndentUsingSpaces = this.createRadioButton(indentComposite, JSONUIMessages.Indent_using_spaces);
        ((GridData)this.fIndentUsingSpaces.getLayoutData()).horizontalSpan = 1;
        this.createLabel((Composite)formattingGroup, JSONUIMessages.Indentation_size);
        this.fIndentationSize = new Spinner((Composite)formattingGroup, 2048);
        GridData gd = new GridData(32);
        this.fIndentationSize.setLayoutData((Object)gd);
        this.fIndentationSize.setToolTipText(JSONUIMessages.Indentation_size_tip);
        this.fIndentationSize.setMinimum(0);
        this.fIndentationSize.setMaximum(16);
        this.fIndentationSize.setIncrement(1);
        this.fIndentationSize.setPageIncrement(4);
        this.fIndentationSize.addModifyListener((ModifyListener)this);
    }

    protected IPreferenceStore doGetPreferenceStore() {
        return JSONUIPlugin.getDefault().getPreferenceStore();
    }

    private void doSavePreferenceStore() {
        JSONUIPlugin.getDefault().savePluginPreferences();
        JSONCorePlugin.getDefault().savePluginPreferences();
    }

    protected Preferences getModelPreferences() {
        return JSONCorePlugin.getDefault().getPluginPreferences();
    }

    protected void initializeValues() {
        this.initializeValuesForFormattingGroup();
    }

    private void initializeValuesForFormattingGroup() {
        Preferences prefs = this.getModelPreferences();
        this.fLineWidthText.setText(prefs.getString("lineWidth"));
        if ("tab".equals(this.getModelPreferences().getString("indentationChar"))) {
            this.fIndentUsingTabs.setSelection(true);
            this.fIndentUsingSpaces.setSelection(false);
        } else {
            this.fIndentUsingSpaces.setSelection(true);
            this.fIndentUsingTabs.setSelection(false);
        }
        this.fIndentationSize.setSelection(this.getModelPreferences().getInt("indentationSize"));
    }

    protected void performDefaults() {
        this.performDefaultsForFormattingGroup();
        this.validateValues();
        this.enableValues();
        super.performDefaults();
    }

    private void performDefaultsForFormattingGroup() {
        Preferences prefs = this.getModelPreferences();
        this.fLineWidthText.setText(prefs.getDefaultString("lineWidth"));
        if ("tab".equals(this.getModelPreferences().getDefaultString("indentationChar"))) {
            this.fIndentUsingTabs.setSelection(true);
            this.fIndentUsingSpaces.setSelection(false);
        } else {
            this.fIndentUsingSpaces.setSelection(true);
            this.fIndentUsingTabs.setSelection(false);
        }
        this.fIndentationSize.setSelection(this.getModelPreferences().getDefaultInt("indentationSize"));
    }

    public boolean performOk() {
        boolean result = super.performOk();
        this.doSavePreferenceStore();
        return result;
    }

    protected void storeValues() {
        this.storeValuesForFormattingGroup();
    }

    private void storeValuesForFormattingGroup() {
        Preferences prefs = this.getModelPreferences();
        prefs.setValue("lineWidth", this.fLineWidthText.getText());
        if (this.fIndentUsingTabs.getSelection()) {
            this.getModelPreferences().setValue("indentationChar", "tab");
        } else {
            this.getModelPreferences().setValue("indentationChar", "space");
        }
        this.getModelPreferences().setValue("indentationSize", this.fIndentationSize.getSelection());
    }

    protected void validateValues() {
        boolean isError = false;
        String widthText = null;
        if (this.fLineWidthText != null) {
            try {
                widthText = this.fLineWidthText.getText();
                int formattingLineWidth = Integer.parseInt(widthText);
                if (formattingLineWidth < 0 || formattingLineWidth > 999) {
                    throw new NumberFormatException();
                }
            }
            catch (NumberFormatException numberFormatException) {
                this.setInvalidInputMessage(widthText);
                this.setValid(false);
                isError = true;
            }
        }
        if (!isError) {
            this.setErrorMessage(null);
            this.setValid(true);
        }
    }
}

