/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.debug.transport;

import org.eclipse.wst.jsdt.debug.transport.Connection;
import org.eclipse.wst.jsdt.debug.transport.exception.DisconnectedException;
import org.eclipse.wst.jsdt.debug.transport.exception.TimeoutException;
import org.eclipse.wst.jsdt.debug.transport.packet.Packet;
import org.eclipse.wst.jsdt.debug.transport.packet.PacketReceiveManager;
import org.eclipse.wst.jsdt.debug.transport.packet.PacketSendManager;
import org.eclipse.wst.jsdt.debug.transport.packet.Response;

public class DebugSession {
    private final PacketReceiveManager packetReceiveManager;
    private final PacketSendManager packetSendManager;

    public DebugSession(Connection connection) {
        this.packetReceiveManager = new PacketReceiveManager(connection);
        Thread receiveThread = new Thread((Runnable)this.packetReceiveManager, "Debug Session - Receive Manager");
        receiveThread.setDaemon(true);
        this.packetSendManager = new PacketSendManager(connection);
        Thread sendThread = new Thread((Runnable)this.packetSendManager, "Debug Session - Send Manager");
        sendThread.setDaemon(true);
        this.packetReceiveManager.setPartnerThread(sendThread);
        this.packetSendManager.setPartnerThread(receiveThread);
        receiveThread.start();
        sendThread.start();
    }

    public void dispose() {
        this.packetReceiveManager.disconnect();
        this.packetSendManager.disconnect();
    }

    public void send(Packet packet) throws DisconnectedException {
        if (packet == null) {
            throw new IllegalArgumentException("You cannot send a null request");
        }
        this.packetSendManager.sendPacket(packet);
    }

    public Response receiveResponse(int requestSequence, int timeout) throws TimeoutException, DisconnectedException {
        return this.packetReceiveManager.getResponse(requestSequence, timeout);
    }

    public Packet receive(String type, int timeout) throws TimeoutException, DisconnectedException {
        return this.packetReceiveManager.getCommand(type, timeout);
    }
}

