/*******************************************************************************
 * Copyright (c) 2003, 2005 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v2.0
 * which accompanies this distribution, and is available at
 * https://www.eclipse.org/legal/epl-2.0/
 *
 * Contributors:
 * IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.jst.j2ee.internal.application.provider;


import java.util.ArrayList;
import java.util.Collection;

import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.edit.provider.ChangeNotifier;
import org.eclipse.emf.edit.provider.ComposeableAdapterFactory;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.edit.provider.Disposable;
import org.eclipse.emf.edit.provider.IChangeNotifier;
import org.eclipse.emf.edit.provider.IDisposable;
import org.eclipse.emf.edit.provider.IEditingDomainItemProvider;
import org.eclipse.emf.edit.provider.IItemLabelProvider;
import org.eclipse.emf.edit.provider.IItemPropertySource;
import org.eclipse.emf.edit.provider.INotifyChangedListener;
import org.eclipse.emf.edit.provider.IStructuredItemContentProvider;
import org.eclipse.emf.edit.provider.ITableItemLabelProvider;
import org.eclipse.emf.edit.provider.ITreeItemContentProvider;
import org.eclipse.jst.j2ee.application.internal.util.ApplicationAdapterFactory;


/**
 * This is the factory that is used to provide the interfaces needed to support
 * { @link org.eclipse.jface.viewers.Viewer}s. The adapters generated by this factory convert EMF
 * adapter notifications into calls to {@link #fireNotifyChanged fireNotifyChanged}. The adapters
 * also support property sheets, see {@link org.eclipse.ui.views.properties}. Note that most of the
 * adapters are shared among multiple instances.
 */
public class ApplicationItemProviderAdapterFactory extends ApplicationAdapterFactory implements ComposeableAdapterFactory, IChangeNotifier, IDisposable {
	/**
	 * This keeps track of the root adapter factory that delegates to this adapter factory.
	 */
	protected ComposedAdapterFactory parentAdapterFactory;
	/**
	 * This is used to implement {@link org.eclipse.emf.edit.provider.IChangeNotifier}. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	protected IChangeNotifier changeNotifier = new ChangeNotifier();

	/**
	 * This keeps track of all the supported types checked by
	 * { @link #isFactoryForType isFactoryForType}.
	 */
	protected Collection supportedTypes = new ArrayList();
	/**
	 * This keeps track of the one adapter used for all
	 * { @link org.eclipse.jst.j2ee.internal.internal.application.Application}instances.
	 */
	protected ApplicationItemProvider applicationItemProvider;
	/**
	 * This keeps track of the one adapter used for all
	 * { @link org.eclipse.jst.j2ee.internal.internal.application.Module}instances.
	 */
	protected ModuleItemProvider moduleItemProvider;
	/**
	 * This keeps track of the one adapter used for all
	 * { @link org.eclipse.jst.j2ee.internal.internal.application.WebModule}instances.
	 */
	protected WebModuleItemProvider webModuleItemProvider;
	/**
	 * This keeps track of the one adapter used for all
	 * { @link org.eclipse.jst.j2ee.internal.internal.application.JavaClientModule}instances.
	 */
	protected JavaClientModuleItemProvider javaClientModuleItemProvider;
	/**
	 * This keeps track of the one adapter used for all
	 * { @link org.eclipse.jst.j2ee.internal.internal.application.JavaClientModule}instances.
	 */
	protected ConnectorModuleItemProvider connectorModuleItemProvider;
	/**
	 * This keeps track of the one adapter used for all
	 * { @link org.eclipse.jst.j2ee.internal.internal.application.EjbModule}instances.
	 */
	protected EjbModuleItemProvider ejbModuleItemProvider;
	protected Disposable disposable = new Disposable();

	/**
	 * This constructs an instance.
	 */
	public ApplicationItemProviderAdapterFactory() {
		supportedTypes.add(IStructuredItemContentProvider.class);
		supportedTypes.add(ITreeItemContentProvider.class);
		supportedTypes.add(IItemPropertySource.class);
		supportedTypes.add(IEditingDomainItemProvider.class);
		supportedTypes.add(IItemLabelProvider.class);
		supportedTypes.add(ITableItemLabelProvider.class);
	}

	@Override
	public Adapter adapt(Notifier target, Object adapterKey) {
		return super.adapt(target, this);
	}

	@Override
	public Object adapt(Object object, Object type) {
		if (isFactoryForType(type)) {
			Object adapter = super.adapt(object, type);
			if (!(type instanceof Class) || (((Class) type).isInstance(adapter))) {
				return adapter;
			}
		}

		return null;
	}

	@Override
	public Adapter adaptNew(Notifier target, Object adapterType) {
		Adapter adapter = super.adaptNew(target, adapterType);
		disposable.add(adapter);
		return adapter;
	}

	/**
	 * This adds a listener. <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public void addListener(INotifyChangedListener notifyChangedListener) {
		changeNotifier.addListener(notifyChangedListener);
	}

	/**
	 * This creates an adapter for a
	 * { @link org.eclipse.jst.j2ee.internal.internal.application.Application}.
	 */
	@Override
	public Adapter createApplicationAdapter() {
		if (applicationItemProvider == null) {
			applicationItemProvider = new ApplicationItemProvider(this);
		}

		return applicationItemProvider;
	}

	/**
	 * This creates an adapter for a
	 * { @link org.eclipse.jst.j2ee.internal.internal.application.EjbModule}.
	 */
	@Override
	public Adapter createEjbModuleAdapter() {
		if (ejbModuleItemProvider == null) {
			ejbModuleItemProvider = new EjbModuleItemProvider(this);
		}

		return ejbModuleItemProvider;
	}

	/**
	 * This creates an adapter for a
	 * { @link org.eclipse.jst.j2ee.internal.internal.application.JavaClientModule}.
	 */
	@Override
	public Adapter createJavaClientModuleAdapter() {
		if (javaClientModuleItemProvider == null) {
			javaClientModuleItemProvider = new JavaClientModuleItemProvider(this);
		}

		return javaClientModuleItemProvider;
	}

	/**
	 * This creates an adapter for a connector.
	 * 
	 * @return Adapter
	 */
	@Override
	public Adapter createConnectorModuleAdapter() {
		if (connectorModuleItemProvider == null) {
			connectorModuleItemProvider = new ConnectorModuleItemProvider(this);
		}// if

		return connectorModuleItemProvider;
	}// createConnectorModuleAdapter

	/**
	 * This creates an adapter for a
	 * { @link org.eclipse.jst.j2ee.internal.internal.application.Module}.
	 */
	@Override
	public Adapter createModuleAdapter() {
		if (moduleItemProvider == null) {
			moduleItemProvider = new ModuleItemProvider(this);
		}

		return moduleItemProvider;
	}

	/**
	 * This creates an adapter for a
	 * { @link org.eclipse.jst.j2ee.internal.internal.application.WebModule}.
	 */
	@Override
	public Adapter createWebModuleAdapter() {
		if (webModuleItemProvider == null) {
			webModuleItemProvider = new WebModuleItemProvider(this);
		}

		return webModuleItemProvider;
	}

	@Override
	public void dispose() {
		disposable.dispose();
	}

	/**
	 * This calls {@link INotifyChangedListener#fireNotifyChanged fireNotifyChanged}for each viewer
	 * in {@link #notifyChangedListeners}.
	 */
	/*
	 * public void fireNotifyChanged(Object object, int eventType, Object feature, Object oldValue,
	 * Object newValue, int index) { for (Iterator i = notifyChangedListeners.iterator();
	 * i.hasNext(); ) { INotifyChangedListener notifyChangedListener =
	 * (INotifyChangedListener)i.next(); notifyChangedListener.notifyChanged(new
	 * ENotificationImpl((InternalEObject)object, eventType,(EStructuralFeature) feature, oldValue,
	 * newValue, index)); }
	 * 
	 * if (parentAdapterFactory != null) { parentAdapterFactory.fireNotifyChanged(object, eventType,
	 * feature, oldValue, newValue, index); } }
	 */
	/**
	 * This returns the root adapter factory that contains this factory.
	 */
	@Override
	public ComposeableAdapterFactory getRootAdapterFactory() {
		return parentAdapterFactory == null ? this : parentAdapterFactory.getRootAdapterFactory();
	}

	@Override
	public boolean isFactoryForType(Object type) {
		return super.isFactoryForType(type) || supportedTypes.contains(type);
	}

	/**
	 * This removes a listener.
	 * 
	 * @generated
	 */
	@Override
	public void removeListener(INotifyChangedListener notifyChangedListener) {
		changeNotifier.removeListener(notifyChangedListener);
	}

	/**
	 * This delegates to {@link #changeNotifier}and to {@link #parentAdapterFactory}. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public void fireNotifyChanged(Notification notification) {
		changeNotifier.fireNotifyChanged(notification);

		if (parentAdapterFactory != null) {
			parentAdapterFactory.fireNotifyChanged(notification);
		}
	}

	/**
	 * This sets the composed adapter factory that contains this factory.
	 */
	@Override
	public void setParentAdapterFactory(ComposedAdapterFactory parentAdapterFactory) {
		this.parentAdapterFactory = parentAdapterFactory;
	}
}
