/*******************************************************************************
 * Copyright (c) 2003, 2005 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * https://www.eclipse.org/legal/epl-2.0/
 *
 * Contributors:
 * IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.jst.j2ee.application.internal.operations;

import org.eclipse.jst.j2ee.internal.archive.operations.JavaEEComponentExportOperation;
import org.eclipse.jst.j2ee.internal.earcreation.EARCreationResourceHandler;
import org.eclipse.jst.j2ee.internal.plugin.IJ2EEModuleConstants;
import org.eclipse.jst.j2ee.internal.project.J2EEProjectUtilities;
import org.eclipse.wst.common.frameworks.datamodel.IDataModelOperation;

public class EARComponentExportDataModelProvider extends J2EEArtifactExportDataModelProvider {

    public EARComponentExportDataModelProvider() {
        super();
    }
    
    @Override
	public IDataModelOperation getDefaultOperation() {
        return new JavaEEComponentExportOperation(model);
    }

    @Override
	protected String getModuleExtension() {
        return IJ2EEModuleConstants.EAR_EXT;
    }

    @Override
	protected String getWrongComponentTypeString(String projectName) {
        return EARCreationResourceHandler.getString(EARCreationResourceHandler.NOT_AN_EAR, new Object[]{projectName});
    }

    @Override
	protected String getProjectType() {
        return J2EEProjectUtilities.ENTERPRISE_APPLICATION;
    }
    /**
     * Exports the specified Enterprise Appliction project to the specified EAR file.
     * 
     * @param earProjectName
     *            The name of the Enterprise Application project to export.
     * @param earFileName
     *            The fully qualified EAR file location to export the specified Enterprise
     *            Application project.
     * @param overwriteExisting
     *            If this is <code>true</code> then an existing file at the location specified by
     *            <code>earFileName</code> will be overwritten.
     * @param exportSource
     *            If this is <code>true</code> then all source files in the specified Enterprise
     *            Application Project and all its modules will be included in the resulting EAR
     *            file.
     * @plannedfor WTP 1.0
     */
//TODO: can this be done in the new datamodel framework?
//    public static void exportProject(String earProjectName, String earFileName, boolean overwriteExisting, boolean exportSource) {
//        EnterpriseApplicationExportDataModel dataModel = new EnterpriseApplicationExportDataModel();
//        dataModel.setProperty(PROJECT_NAME, earProjectName);
//        dataModel.setBooleanProperty(OVERWRITE_EXISTING, overwriteExisting);
//        dataModel.setProperty(ARCHIVE_DESTINATION, earFileName);
//        dataModel.setBooleanProperty(EXPORT_SOURCE_FILES, exportSource);
//        try {
//            dataModel.getDefaultOperation().run(null);
//        } catch (InvocationTargetException e) {
//            Logger.getLogger().logError(e);
//        } catch (InterruptedException e) {
//            Logger.getLogger().logError(e);
//        }
//    }
}
