/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.common.utility.tests.internal.predicate;

import java.util.Arrays;
import junit.framework.TestCase;
import org.eclipse.jpt.common.utility.internal.predicate.PredicateTools;
import org.eclipse.jpt.common.utility.internal.predicate.UniquePredicate;
import org.eclipse.jpt.common.utility.tests.internal.TestTools;

public class UniqueIdentityPredicateTests
extends TestCase {
    private UniquePredicate<String> predicate;

    public UniqueIdentityPredicateTests(String name) {
        super(name);
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.predicate = PredicateTools.uniqueIdentityPredicate();
    }

    protected void tearDown() throws Exception {
        TestTools.clear(this);
        super.tearDown();
    }

    public void testEvaluate() {
        UniqueIdentityPredicateTests.assertTrue((boolean)this.predicate.evaluate((Object)"Fred"));
        UniqueIdentityPredicateTests.assertTrue((boolean)this.predicate.evaluate((Object)"Wilma"));
        UniqueIdentityPredicateTests.assertTrue((boolean)this.predicate.evaluate((Object)"Barney"));
        UniqueIdentityPredicateTests.assertTrue((boolean)this.predicate.evaluate(null));
        UniqueIdentityPredicateTests.assertFalse((boolean)this.predicate.evaluate(null));
        UniqueIdentityPredicateTests.assertTrue((boolean)this.predicate.evaluate((Object)new String("Fred")));
        UniqueIdentityPredicateTests.assertFalse((boolean)this.predicate.evaluate((Object)"Fred"));
        UniqueIdentityPredicateTests.assertFalse((boolean)this.predicate.evaluate((Object)"Barney"));
    }

    public void testAdd() {
        UniqueIdentityPredicateTests.assertTrue((boolean)this.predicate.evaluate((Object)"Fred"));
        UniqueIdentityPredicateTests.assertTrue((boolean)this.predicate.add((Object)"Wilma"));
        UniqueIdentityPredicateTests.assertTrue((boolean)this.predicate.add((Object)"Barney"));
        UniqueIdentityPredicateTests.assertTrue((boolean)this.predicate.evaluate(null));
        UniqueIdentityPredicateTests.assertFalse((boolean)this.predicate.evaluate(null));
        UniqueIdentityPredicateTests.assertTrue((boolean)this.predicate.evaluate((Object)new String("Fred")));
        UniqueIdentityPredicateTests.assertFalse((boolean)this.predicate.evaluate((Object)"Fred"));
        UniqueIdentityPredicateTests.assertFalse((boolean)this.predicate.evaluate((Object)"Barney"));
    }

    public void testAddAll() {
        UniqueIdentityPredicateTests.assertTrue((boolean)this.predicate.evaluate((Object)"Fred"));
        UniqueIdentityPredicateTests.assertTrue((boolean)this.predicate.addAll(Arrays.asList("Wilma", "Barney")));
        UniqueIdentityPredicateTests.assertTrue((boolean)this.predicate.evaluate(null));
        UniqueIdentityPredicateTests.assertFalse((boolean)this.predicate.evaluate(null));
        UniqueIdentityPredicateTests.assertTrue((boolean)this.predicate.evaluate((Object)new String("Fred")));
        UniqueIdentityPredicateTests.assertFalse((boolean)this.predicate.evaluate((Object)"Fred"));
        UniqueIdentityPredicateTests.assertFalse((boolean)this.predicate.evaluate((Object)"Barney"));
    }
}

