/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.ws.jaxws.dom.runtime.tests.dom.persistence;

import junit.framework.Assert;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IType;
import org.eclipse.jst.ws.jaxws.dom.runtime.api.IServiceEndpointInterface;
import org.eclipse.jst.ws.jaxws.dom.runtime.api.IWebMethod;
import org.eclipse.jst.ws.jaxws.dom.runtime.api.IWebParam;
import org.eclipse.jst.ws.jaxws.testutils.project.TestProjectsUtils;
import org.eclipse.jst.ws.jaxws.utils.resources.FileUtils;

public class DomTestUtils {
    public IMethod getExistingMethod(IType type, String methodName, String ... args) {
        IMethod m = type.getMethod(methodName, args);
        Assert.assertTrue((boolean)m.exists());
        return m;
    }

    public void setContents(final ICompilationUnit cu, String contents) throws CoreException {
        final String contentToSet = "package " + cu.getParent().getElementName() + ";\n" + contents;
        IWorkspaceRunnable setContentsRunnable = new IWorkspaceRunnable(){

            public void run(IProgressMonitor monitor) throws CoreException {
                FileUtils.getInstance().setCompilationUnitContent(cu, contentToSet, true, null);
            }
        };
        TestProjectsUtils.executeWorkspaceRunnable((IWorkspaceRunnable)setContentsRunnable);
    }

    public IWebParam findParam(IWebMethod method, String implName) {
        for (IWebParam param : method.getParameters()) {
            if (!param.getImplementation().equals(implName)) continue;
            return param;
        }
        return null;
    }

    public IWebMethod findWebMethodByName(IServiceEndpointInterface sei, String name) {
        for (IWebMethod webMethod : sei.getWebMethods()) {
            if (!webMethod.getName().equals(name)) continue;
            return webMethod;
        }
        return null;
    }
}

