/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.pagedesigner.editpolicies;

import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Locator;
import org.eclipse.draw2d.MouseEvent;
import org.eclipse.draw2d.MouseListener;
import org.eclipse.draw2d.MouseMotionListener;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.PrecisionRectangle;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw2d.geometry.Translatable;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jst.pagedesigner.PDPlugin;
import org.eclipse.jst.pagedesigner.editpolicies.ElementMenuBar;
import org.eclipse.jst.pagedesigner.editpolicies.NonVisualChildDecorator;
import org.eclipse.jst.pagedesigner.parts.ElementEditPart;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;

class MouseSelectableChildDecorator
extends NonVisualChildDecorator {
    private static final String PIN_UP_IMAGE_FILE = "pin_up.gif";
    private static final String PIN_DOWN_IMAGE_FILE = "pin_down.gif";
    private static final int STATE_START = 0;
    private static final int STATE_HOST_HOVER = 1;
    private static final int STATE_HOST_SELECTED = 2;
    private static final int STATE_HANDLE_HOVER = 3;
    private static final int STATE_HANDLE_MENU_BAR_SHOWING = 4;
    private static final int STATE_HANDLE_MENU_BAR_HOVER = 5;
    private static final int STATE_HANDLE_MENU_BAR_SELECTED = 6;
    public static final int EVENT_HOST_HOVER_RECEIVED = 31;
    public static final int EVENT_HOST_HOVER_LOST = 32;
    public static final int EVENT_HOST_SELECTION_RECEIVED = 33;
    public static final int EVENT_HOST_SELECTION_LOST = 34;
    private static final int EVENT_HANDLE_HOVER_RECEIVED = 35;
    private static final int EVENT_HANDLE_HOVER_LOST = 36;
    private static final int EVENT_HANDLE_SELECTED = 37;
    private static final int EVENT_ALL_SELECTION_LOST = 38;
    private static final int EVENT_MENU_BAR_SELECTION_RECEIVED = 39;
    private MouseMotionListener _motionListener;
    private MouseListener _mouseListener;
    private boolean _isMouseOver = false;
    private ElementMenuBar _elementMenuBar;
    private DisplayStateMachine _stateMachine;
    private VerticalMenuLocator _menuLocator;
    private AnimatedHideLocator _hideLocator;
    private IFigure _hoverParent;
    private IFigure _selectionParent;
    private ISelectionChangedListener _menuSelectionListener;

    MouseSelectableChildDecorator(GraphicalEditPart hostPart, int location, IFigure hoverParent, IFigure selectionParent) {
        super(hostPart, location);
        this._menuLocator = new VerticalMenuLocator(hostPart, (IFigure)this);
        this._hideLocator = new AnimatedHideLocator();
        this._elementMenuBar = ((ElementEditPart)hostPart).getElementMenuBar();
        this._stateMachine = new DisplayStateMachine();
        this._hoverParent = hoverParent;
        this._selectionParent = selectionParent;
        this._motionListener = new MouseMotionListener.Stub(){

            public void mouseEntered(MouseEvent me) {
                MouseSelectableChildDecorator.this._isMouseOver = true;
                MouseSelectableChildDecorator.this.updateState(35);
            }

            public void mouseExited(MouseEvent me) {
                MouseSelectableChildDecorator.this._isMouseOver = false;
                MouseSelectableChildDecorator.this.updateState(36);
            }
        };
        this.addMouseMotionListener(this._motionListener);
        this._mouseListener = new MouseListener.Stub(){

            public void mousePressed(MouseEvent me) {
                MouseSelectableChildDecorator.this.updateState(37);
            }
        };
        this.addMouseListener(this._mouseListener);
        this._menuSelectionListener = new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                IStructuredSelection selection = (IStructuredSelection)event.getSelection();
                if (selection.size() == 0) {
                    if (MouseSelectableChildDecorator.this.getOwner().getSelected() == 2) {
                        MouseSelectableChildDecorator.this.updateState(33);
                    } else {
                        MouseSelectableChildDecorator.this.updateState(38);
                    }
                } else {
                    MouseSelectableChildDecorator.this.updateState(39);
                }
            }
        };
        this._elementMenuBar.addSelectionChangedListener(this._menuSelectionListener);
    }

    @Override
    public void paintFigure(Graphics g) {
        Image arrowImage = null;
        arrowImage = this._stateMachine.isMenuShowing() ? PDPlugin.getDefault().getImage(PIN_DOWN_IMAGE_FILE) : PDPlugin.getDefault().getImage(PIN_UP_IMAGE_FILE);
        Rectangle r = this.getBounds();
        g.setAlpha(75);
        g.setBackgroundColor(this.getFillColor());
        g.fillRectangle(r.x, r.y, r.width, r.height);
        g.setAlpha(this.getAlpha());
        g.drawImage(arrowImage, r.x + 1, r.y + 1);
        g.setForegroundColor(this.getBorderColor());
        g.drawRectangle(r.x, r.y, r.width - 1, r.height - 1);
    }

    public void updateState(int event) {
        int oldState = this._stateMachine.doTransition(event);
        this.updateVisual(oldState);
    }

    protected void updateVisual(int oldState) {
        if (!this._elementMenuBar.hasChildParts()) {
            if (this.getParent() != null) {
                this.getParent().remove((IFigure)this);
            }
            return;
        }
        switch (this._stateMachine._curState) {
            case 0: {
                this.hide(this._elementMenuBar, false);
                IFigure parent = this.getParent();
                if (parent == null) break;
                parent.remove((IFigure)this);
                break;
            }
            case 1: {
                if (this._hoverParent != null) {
                    this._hoverParent.add((IFigure)this);
                    this.validate();
                }
                this.show(this._elementMenuBar, false);
                this.setVisible(false);
                break;
            }
            case 2: {
                if (this._selectionParent != null) {
                    this._selectionParent.add((IFigure)this);
                    this.validate();
                }
                this.setVisible(true);
                if (oldState != 2 && oldState != 3) {
                    this.show(this._elementMenuBar, true);
                    this.hide(this._elementMenuBar, true);
                } else if (!this._hideLocator._isAnimating) {
                    this.hide(this._elementMenuBar, false);
                }
                this.repaint();
                break;
            }
            case 3: {
                if (this._stateMachine.isMenuShowing(oldState)) {
                    this.hide(this._elementMenuBar, false);
                } else {
                    this.show(this._elementMenuBar, false);
                }
                this.repaint();
                break;
            }
            case 4: {
                this.show(this._elementMenuBar, true);
                this.repaint();
                break;
            }
        }
    }

    @Override
    protected void init() {
        this.setPreferredSize(new Dimension(12, 12));
    }

    public void dispose() {
        this.hide(this._elementMenuBar, false);
        if (this._motionListener != null) {
            this.removeMouseMotionListener(this._motionListener);
            this._motionListener = null;
        }
        if (this._mouseListener != null) {
            this.removeMouseListener(this._mouseListener);
            this._mouseListener = null;
        }
        if (this._menuSelectionListener != null) {
            this._elementMenuBar.removeSelectionChangedListener(this._menuSelectionListener);
            this._menuSelectionListener = null;
        }
    }

    private void hide(ElementMenuBar menuBar, boolean animate) {
        if (animate) {
            Point endPoint = this.getLocation().getCopy();
            endPoint.x += this.getBounds().width / 2;
            endPoint.y += this.getBounds().height / 2;
            this._hideLocator.setHideEndPoint(endPoint);
            this._hideLocator.relocate((IFigure)menuBar);
        } else if (menuBar.getParent() != null) {
            this.getParent().remove((IFigure)menuBar);
        }
    }

    private void show(ElementMenuBar menuBar, boolean enabled) {
        menuBar.setEnabled(enabled);
        this.getParent().add((IFigure)menuBar);
        this._menuLocator.relocate((IFigure)menuBar);
    }

    @Override
    protected int getAlpha() {
        return this._isMouseOver || this._stateMachine.isMenuShowing() ? 255 : 75;
    }

    private static class AnimatedHideLocator
    implements Locator {
        private Point _endPoint;
        private boolean _isAnimating;

        private AnimatedHideLocator() {
        }

        public void setHideEndPoint(Point endPoint) {
            this._endPoint = endPoint;
        }

        public void relocate(IFigure target) {
            Point newEndPoint = this._endPoint.getCopy();
            target.translateToRelative((Translatable)this._endPoint);
            Rectangle startBounds = target.getBounds().getCopy();
            this.animateBoundsChange(target, startBounds, newEndPoint);
        }

        private void animateBoundsChange(IFigure target, Rectangle startBounds, Point endPoint) {
            int xDelta = endPoint.x - startBounds.x;
            int yDelta = endPoint.y - startBounds.y;
            int widthIncrement = -1 * startBounds.width / 5;
            int heightIncrement = -1 * startBounds.height / 5;
            int xIncrement = xDelta / 5;
            int yIncrement = yDelta / 5;
            target.setBounds(startBounds);
            if (widthIncrement != 0 || heightIncrement != 0) {
                this._isAnimating = true;
                this.doAnimation(500, 100, widthIncrement, heightIncrement, xIncrement, yIncrement, endPoint, target);
            }
        }

        private void doAnimation(final int remainingTime, final int timeIncrement, final int widthIncrement, final int heightIncrement, final int xIncrement, final int yIncrement, final Point endPoint, final IFigure target) {
            Display.getCurrent().timerExec(timeIncrement, new Runnable(){

                @Override
                public void run() {
                    if (remainingTime <= 0) {
                        if (target.getParent() != null) {
                            target.getParent().remove(target);
                        }
                        _isAnimating = false;
                    } else {
                        Rectangle curBounds = target.getBounds().getCopy();
                        curBounds.width += widthIncrement;
                        curBounds.height += heightIncrement;
                        curBounds.x += xIncrement;
                        curBounds.y += yIncrement;
                        target.setBounds(curBounds);
                        target.revalidate();
                        this.doAnimation(remainingTime - timeIncrement, timeIncrement, widthIncrement, heightIncrement, xIncrement, yIncrement, endPoint, target);
                    }
                }
            });
        }
    }

    private class DisplayStateMachine {
        private int _curState = 0;

        private DisplayStateMachine() {
        }

        public int doTransition(int event) {
            int oldState = this._curState;
            switch (this._curState) {
                case 0: {
                    if (event == 31) {
                        this._curState = 1;
                        break;
                    }
                    if (event != 33) break;
                    this._curState = 2;
                    break;
                }
                case 1: {
                    if (event == 33) {
                        this._curState = 2;
                        break;
                    }
                    if (event != 34 && event != 32) break;
                    this._curState = 0;
                    break;
                }
                case 2: {
                    if (event == 34) {
                        this._curState = 0;
                        break;
                    }
                    if (event == 35) {
                        this._curState = 3;
                        break;
                    }
                    if (event == 37) {
                        this._curState = 4;
                        break;
                    }
                    if (event != 38) break;
                    this._curState = 0;
                    break;
                }
                case 3: {
                    if (event == 36) {
                        this._curState = 2;
                        break;
                    }
                    if (event == 37) {
                        this._curState = 4;
                        break;
                    }
                    if (event != 34) break;
                    this._curState = 0;
                    break;
                }
                case 4: {
                    if (event == 37) {
                        this._curState = 3;
                        break;
                    }
                    if (event == 39) {
                        this._curState = 6;
                        break;
                    }
                    if (event != 38) break;
                    this._curState = 0;
                    break;
                }
                case 5: {
                    break;
                }
                case 6: {
                    if (event == 38) {
                        this._curState = 0;
                        break;
                    }
                    if (event != 37) break;
                    this._curState = 3;
                }
            }
            return oldState;
        }

        public boolean isMenuShowing() {
            return this.isMenuShowing(this._curState);
        }

        public boolean isMenuShowing(int state) {
            return this._curState == 4 || this._curState == 5 || this._curState == 6;
        }
    }

    private static class VerticalMenuLocator
    implements Locator {
        private IFigure _referenceFigure;

        VerticalMenuLocator(GraphicalEditPart owner, IFigure reference) {
            this._referenceFigure = reference;
        }

        public void relocate(IFigure target) {
            Rectangle finalBounds = this.getFinalMenuBounds(target);
            target.setBounds(finalBounds);
        }

        private Rectangle getInitialMenuBounds(IFigure target) {
            PrecisionRectangle targetBounds = new PrecisionRectangle(this._referenceFigure.getBounds().getResized(-1, -1));
            this._referenceFigure.translateToAbsolute((Translatable)targetBounds);
            target.translateToRelative((Translatable)targetBounds);
            return targetBounds;
        }

        private Rectangle getFinalMenuBounds(IFigure target) {
            IFigure referenceFigure = this._referenceFigure;
            Rectangle targetBounds = this.getInitialMenuBounds(target);
            Dimension targetSize = target.getPreferredSize();
            targetBounds.x += targetBounds.width + 4;
            targetBounds.y -= targetSize.height / 2 - referenceFigure.getBounds().height / 2;
            targetBounds.setSize(targetSize);
            return targetBounds;
        }
    }
}

