/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.ui.workingsets;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.actions.ActionGroup;
import org.eclipse.wst.jsdt.internal.ui.workingsets.ConfigureWorkingSetAction;
import org.eclipse.wst.jsdt.internal.ui.workingsets.IWorkingSetActionGroup;
import org.eclipse.wst.jsdt.internal.ui.workingsets.WorkingSetModel;

public class WorkingSetShowActionGroup
extends ActionGroup
implements IWorkingSetActionGroup {
    private List fContributions = new ArrayList();
    private ConfigureWorkingSetAction fConfigureWorkingSetAction;
    private WorkingSetModel fWorkingSetModel;
    private final IWorkbenchPartSite fSite;

    public WorkingSetShowActionGroup(IWorkbenchPartSite site) {
        Assert.isNotNull((Object)site);
        this.fSite = site;
    }

    public void setWorkingSetMode(WorkingSetModel model) {
        Assert.isNotNull((Object)model);
        this.fWorkingSetModel = model;
        if (this.fConfigureWorkingSetAction != null) {
            this.fConfigureWorkingSetAction.setWorkingSetModel(this.fWorkingSetModel);
        }
    }

    public void fillActionBars(IActionBars actionBars) {
        super.fillActionBars(actionBars);
        IMenuManager menuManager = actionBars.getMenuManager();
        this.fillViewMenu(menuManager);
    }

    @Override
    public void fillViewMenu(IMenuManager menuManager) {
        this.fConfigureWorkingSetAction = new ConfigureWorkingSetAction(this.fSite);
        if (this.fWorkingSetModel != null) {
            this.fConfigureWorkingSetAction.setWorkingSetModel(this.fWorkingSetModel);
        }
        this.addAction(menuManager, this.fConfigureWorkingSetAction);
    }

    @Override
    public void cleanViewMenu(IMenuManager menuManager) {
        Iterator iter = this.fContributions.iterator();
        while (iter.hasNext()) {
            IContributionItem removed = menuManager.remove((IContributionItem)iter.next());
            if (removed == null) continue;
            removed.dispose();
        }
        this.fContributions.clear();
    }

    private void addAction(IMenuManager menuManager, Action action) {
        ActionContributionItem item = new ActionContributionItem((IAction)action);
        menuManager.appendToGroup("working_set_action_group", (IContributionItem)item);
        this.fContributions.add(item);
    }
}

