/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.common.componentcore.ui.internal.propertypage;

import java.util.ArrayList;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.viewers.DecoratingLabelProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.model.WorkbenchLabelProvider;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;
import org.eclipse.wst.common.componentcore.resources.IVirtualReference;
import org.eclipse.wst.common.componentcore.ui.ModuleCoreUIPlugin;
import org.eclipse.wst.common.componentcore.ui.internal.propertypage.DependencyPageExtensionManager;
import org.eclipse.wst.common.componentcore.ui.internal.propertypage.IVirtualComponentLabelProvider;
import org.eclipse.wst.common.componentcore.ui.propertypage.AddModuleDependenciesPropertiesPage;

public class ComponentDependencyContentProvider
extends LabelProvider
implements IStructuredContentProvider,
ITableLabelProvider,
ITreeContentProvider {
    static final String PATH_SEPARATOR = String.valueOf('/');
    private IVirtualComponent component;
    private ArrayList<IVirtualReference> runtimePaths;
    private ArrayList<AddModuleDependenciesPropertiesPage.ComponentResourceProxy> resourceMappings;
    private DecoratingLabelProvider decProvider = new DecoratingLabelProvider((ILabelProvider)new WorkbenchLabelProvider(), PlatformUI.getWorkbench().getDecoratorManager().getLabelDecorator());
    private IVirtualComponentLabelProvider[] delegates;

    public ComponentDependencyContentProvider(AddModuleDependenciesPropertiesPage addModuleDependenciesPropertiesPage) {
        this.decProvider.addListener((ILabelProviderListener)addModuleDependenciesPropertiesPage);
        this.delegates = DependencyPageExtensionManager.loadDelegates();
    }

    public void setRuntimePaths(ArrayList<IVirtualReference> runtimePaths) {
        this.runtimePaths = runtimePaths;
    }

    public void setResourceMappings(ArrayList<AddModuleDependenciesPropertiesPage.ComponentResourceProxy> mappings) {
        this.resourceMappings = mappings;
    }

    public Object[] getElements(Object inputElement) {
        Object[] empty = new Object[]{};
        if (!(inputElement instanceof IWorkspaceRoot)) {
            return empty;
        }
        ArrayList<AddModuleDependenciesPropertiesPage.ComponentResourceProxy> list = new ArrayList<AddModuleDependenciesPropertiesPage.ComponentResourceProxy>();
        list.addAll(this.resourceMappings);
        list.addAll(this.runtimePaths);
        return list.toArray();
    }

    public Image getColumnImage(Object element, int columnIndex) {
        if (element instanceof AddModuleDependenciesPropertiesPage.ComponentResourceProxy) {
            return ModuleCoreUIPlugin.getInstance().getImage("folder");
        }
        if (element instanceof IVirtualReference) {
            if (columnIndex == 0) {
                return this.handleSourceImage(((IVirtualReference)element).getReferencedComponent());
            }
            if (columnIndex == 1) {
                return ModuleCoreUIPlugin.getInstance().getImage("jar_obj");
            }
        }
        if (element instanceof IProject) {
            return this.decProvider.getImage(element);
        }
        return null;
    }

    public String getColumnText(Object element, int columnIndex) {
        if (element instanceof AddModuleDependenciesPropertiesPage.ComponentResourceProxy) {
            if (columnIndex == 0) {
                return ((AddModuleDependenciesPropertiesPage.ComponentResourceProxy)element).source.toString();
            }
            if (columnIndex == 1) {
                if (((AddModuleDependenciesPropertiesPage.ComponentResourceProxy)element).runtimePath.isRoot()) {
                    return ((AddModuleDependenciesPropertiesPage.ComponentResourceProxy)element).runtimePath.toString();
                }
                return ((AddModuleDependenciesPropertiesPage.ComponentResourceProxy)element).runtimePath.makeRelative().toString();
            }
        }
        if (element instanceof IVirtualReference) {
            if (columnIndex == 0) {
                return this.handleSourceText(((IVirtualReference)element).getReferencedComponent());
            }
            if (columnIndex == 1) {
                return new Path(AddModuleDependenciesPropertiesPage.getSafeRuntimePath((IVirtualReference)element)).makeRelative().toString();
            }
        }
        return null;
    }

    private String handleSourceText(IVirtualComponent component) {
        if (this.delegates != null) {
            int i = 0;
            while (i < this.delegates.length) {
                if (this.delegates[i].canHandle(component)) {
                    return this.delegates[i].getSourceText(component);
                }
                ++i;
            }
        }
        if (component.isBinary()) {
            IPath p = (IPath)component.getAdapter(IPath.class);
            return p == null ? component.getName() : p.toString();
        }
        return component.getProject().getName();
    }

    private Image handleSourceImage(IVirtualComponent component) {
        if (this.delegates != null) {
            int i = 0;
            while (i < this.delegates.length) {
                if (this.delegates[i].canHandle(component)) {
                    return this.delegates[i].getSourceImage(component);
                }
                ++i;
            }
        }
        if (component.isBinary()) {
            return ModuleCoreUIPlugin.getInstance().getImage("jar_obj");
        }
        return this.decProvider.getImage((Object)component.getProject());
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
    }

    public void setComponent(IVirtualComponent component) {
        this.component = component;
    }

    public IVirtualComponent getComponent() {
        return this.component;
    }

    public Object[] getChildren(Object parentElement) {
        return null;
    }

    public Object getParent(Object element) {
        return null;
    }

    public boolean hasChildren(Object element) {
        return false;
    }
}

