/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xml.xpath2.processor.internal.function;

import java.util.Collection;
import java.util.Iterator;
import org.eclipse.wst.xml.xpath2.api.EvaluationContext;
import org.eclipse.wst.xml.xpath2.api.Item;
import org.eclipse.wst.xml.xpath2.api.ResultBuffer;
import org.eclipse.wst.xml.xpath2.api.ResultSequence;
import org.eclipse.wst.xml.xpath2.processor.DynamicError;
import org.eclipse.wst.xml.xpath2.processor.internal.function.Function;
import org.eclipse.wst.xml.xpath2.processor.internal.types.AnyAtomicType;
import org.eclipse.wst.xml.xpath2.processor.internal.types.AnyType;
import org.eclipse.wst.xml.xpath2.processor.internal.types.CtrType;
import org.eclipse.wst.xml.xpath2.processor.internal.types.NumericType;
import org.eclipse.wst.xml.xpath2.processor.internal.types.QName;
import org.eclipse.wst.xml.xpath2.processor.internal.types.XSDouble;
import org.eclipse.wst.xml.xpath2.processor.internal.types.XSString;
import org.eclipse.wst.xml.xpath2.processor.internal.types.XSUntypedAtomic;

public class FsConvertOperand
extends Function {
    public FsConvertOperand() {
        super(new QName("convert-operand"), 2);
    }

    @Override
    public ResultSequence evaluate(Collection args, EvaluationContext ec) throws DynamicError {
        return FsConvertOperand.convert_operand(args);
    }

    public static ResultSequence convert_operand(Collection args) throws DynamicError {
        Item at;
        assert (args.size() == 2);
        Iterator iter = args.iterator();
        ResultSequence actual = (ResultSequence)iter.next();
        ResultSequence expected = (ResultSequence)iter.next();
        if (expected.size() != 1) {
            DynamicError.throw_type_error();
        }
        if (!((at = expected.first()) instanceof AnyAtomicType)) {
            DynamicError.throw_type_error();
        }
        AnyAtomicType exp_aat = (AnyAtomicType)at;
        ResultBuffer result = new ResultBuffer();
        if (actual.empty()) {
            return result.getSequence();
        }
        Iterator<Item> i = actual.iterator();
        while (i.hasNext()) {
            AnyType item = (AnyType)i.next();
            if (item instanceof XSUntypedAtomic) {
                if (exp_aat instanceof XSUntypedAtomic) {
                    result.add(new XSString(item.getStringValue()));
                    continue;
                }
                if (exp_aat instanceof NumericType) {
                    result.add(new XSDouble(item.getStringValue()));
                    continue;
                }
                assert (exp_aat instanceof CtrType);
                CtrType cons = (CtrType)exp_aat;
                result.concat(cons.constructor(new XSString(item.getStringValue())));
                continue;
            }
            result.add(item);
        }
        return result.getSequence();
    }
}

