/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.pagedesigner.jsf.ui.attributegroup;

import org.eclipse.core.resources.IProject;
import org.eclipse.jst.jsf.common.metadata.Entity;
import org.eclipse.jst.jsf.common.metadata.Trait;
import org.eclipse.jst.jsf.common.metadata.internal.TraitValueHelper;
import org.eclipse.jst.jsf.common.metadata.query.ITaglibDomainMetaDataModelContext;
import org.eclipse.jst.jsf.common.metadata.query.TaglibDomainMetaDataQueryHelper;
import org.eclipse.jst.jsf.common.ui.internal.dialogfield.ClassButtonDialogField;
import org.eclipse.jst.jsf.common.ui.internal.dialogfield.ComboDialogField;
import org.eclipse.jst.jsf.common.ui.internal.dialogfield.DialogField;
import org.eclipse.jst.jsf.common.ui.internal.dialogfield.RadiosDialogField;
import org.eclipse.jst.jsf.common.ui.internal.dialogfield.StringDialogField;
import org.eclipse.jst.pagedesigner.jsf.ui.attributegroup.AttributeData;

public class DialogFieldFactory {
    public static DialogField getDialogField(AttributeData data) {
        Trait t;
        String type;
        Object project = data.getParamMap().get("project");
        Entity attrEntity = null;
        if (project instanceof IProject) {
            attrEntity = TaglibDomainMetaDataQueryHelper.getEntity((ITaglibDomainMetaDataModelContext)TaglibDomainMetaDataQueryHelper.createMetaDataModelContext((IProject)((IProject)project), (String)data.getUri()), (String)(data.getElementName() + "/" + data.getAttributeName()));
        }
        if (attrEntity != null && "org.eclipse.jst.jsf.core.attributevalues.JavaClassType".equals(type = TraitValueHelper.getValueAsString((Trait)(t = TaglibDomainMetaDataQueryHelper.getTrait(attrEntity, (String)"attribute-value-runtime-type"))))) {
            ClassButtonDialogField field = new ClassButtonDialogField(null);
            if (project instanceof IProject) {
                field.setProject((IProject)project);
            }
            Object superType = data.getParamMap().get("superTyle");
            field.setSuperClassName((String)superType);
            return field;
        }
        return new StringDialogField();
    }

    public static void setDialogFieldValue(DialogField field, Object value) {
        if (field instanceof StringDialogField) {
            ((StringDialogField)field).setTextWithoutUpdate(value == null ? "" : value.toString());
        } else if (field instanceof ComboDialogField) {
            ((ComboDialogField)field).setTextWithoutUpdate(value == null ? "" : value.toString());
        } else if (field instanceof RadiosDialogField && value instanceof Integer) {
            ((RadiosDialogField)field).setSelectedIndex(((Integer)value).intValue());
        }
    }

    public static void setDialogFiledValue(DialogField field, Object value) {
        DialogFieldFactory.setDialogFieldValue(field, value);
    }

    public static void prepareDialogFieldValue(DialogField field, AttributeData pair) {
        if (field instanceof StringDialogField) {
            pair.setValue(((StringDialogField)field).getText());
        }
    }

    public static void prepareDialogFiledValue(DialogField field, AttributeData pair) {
        DialogFieldFactory.prepareDialogFieldValue(field, pair);
    }

    public static String getDialogFieldLabel(AttributeData data) {
        String name = data.getAttributeName();
        int gap = 32;
        if (name != null) {
            char[] chars = name.toCharArray();
            char[] newChars = new char[chars.length * 2];
            if (chars.length > 0) {
                newChars[0] = chars[0] >= 'a' ? (char)(chars[0] - gap) : chars[0];
            }
            int newPos = 1;
            int i = 1;
            while (i < chars.length) {
                if (chars[i] >= 'A' && chars[i] <= 'Z') {
                    newChars[newPos++] = 32;
                }
                newChars[newPos] = chars[i];
                ++i;
                ++newPos;
            }
            char[] labelChars = new char[newPos + 1];
            System.arraycopy(newChars, 0, labelChars, 0, newPos);
            labelChars[newPos] = 58;
            return new String(labelChars);
        }
        return "";
    }
}

