/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.wsi.internal.core.profile.validator.impl.envelope;

import org.eclipse.wst.wsi.internal.core.WSIException;
import org.eclipse.wst.wsi.internal.core.analyzer.AssertionFailException;
import org.eclipse.wst.wsi.internal.core.profile.TestAssertion;
import org.eclipse.wst.wsi.internal.core.profile.validator.EntryContext;
import org.eclipse.wst.wsi.internal.core.profile.validator.impl.AssertionProcess;
import org.eclipse.wst.wsi.internal.core.profile.validator.impl.BaseMessageValidator;
import org.eclipse.wst.wsi.internal.core.report.AssertionResult;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class BP1307
extends AssertionProcess {
    private final BaseMessageValidator validator;

    public BP1307(BaseMessageValidator impl) {
        super(impl);
        this.validator = impl;
    }

    @Override
    public AssertionResult validate(TestAssertion testAssertion, EntryContext entryContext) throws WSIException {
        Document doc;
        if (this.validator.isOneWayResponse(entryContext) || (doc = entryContext.getMessageEntryDocument()) == null) {
            this.result = "notApplicable";
        } else {
            NodeList soapList = doc.getElementsByTagNameNS("http://schemas.xmlsoap.org/soap/envelope/", "*");
            if (soapList == null || soapList.getLength() == 0) {
                this.result = "notApplicable";
            } else {
                try {
                    int n = 0;
                    while (n < soapList.getLength()) {
                        Element nextElem = (Element)soapList.item(n);
                        if (nextElem.getAttributeNodeNS("http://schemas.xmlsoap.org/soap/envelope/", "encodingStyle") != null) {
                            throw new AssertionFailException(entryContext.getMessageEntry().getMessage());
                        }
                        ++n;
                    }
                }
                catch (AssertionFailException e) {
                    this.result = "failed";
                    this.failureDetail = this.validator.createFailureDetail(e.getMessage(), entryContext);
                }
            }
        }
        return this.validator.createAssertionResult(testAssertion, this.result, this.failureDetail);
    }
}

