/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.common.core.internal.utility;

import java.util.ArrayList;
import org.eclipse.core.resources.IResource;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jpt.common.core.internal.plugin.JptCommonCorePlugin;
import org.eclipse.jpt.common.core.internal.utility.JavaElementTools;
import org.eclipse.jpt.common.core.internal.utility.PackageFragmentRootTools;
import org.eclipse.jpt.common.core.internal.utility.TypeTools;
import org.eclipse.jpt.common.utility.internal.collection.CollectionTools;
import org.eclipse.jpt.common.utility.internal.iterable.EmptyIterable;
import org.eclipse.jpt.common.utility.internal.iterable.IterableTools;
import org.eclipse.jpt.common.utility.internal.predicate.CriterionPredicate;
import org.eclipse.jpt.common.utility.transformer.Transformer;

public final class JavaProjectTools {
    public static IType findType(IJavaProject javaProject, String fullyQualifiedName) {
        try {
            return javaProject.findType(fullyQualifiedName);
        }
        catch (JavaModelException ex) {
            JptCommonCorePlugin.instance().logError(ex);
            return null;
        }
    }

    public static Iterable<IPackageFragment> getPackageFragments(IJavaProject javaProject, String packageName) {
        return IterableTools.filter((Iterable)IterableTools.transform(JavaProjectTools.getPackageFragmentRoots(javaProject), (Transformer)new PackageFragmentRootTools.PackageFragmentTransformer(packageName)), JavaElementTools.EXISTS);
    }

    public static Iterable<IPackageFragmentRoot> getSourceFolders(IJavaProject javaProject) {
        return IterableTools.filter(JavaProjectTools.getPackageFragmentRoots(javaProject), PackageFragmentRootTools.IS_SOURCE_FOLDER);
    }

    private static Iterable<IPackageFragmentRoot> getPackageFragmentRoots(IJavaProject javaProject) {
        try {
            return JavaProjectTools.getPackageFragmentRoots_(javaProject);
        }
        catch (JavaModelException ex) {
            JptCommonCorePlugin.instance().logError(ex);
            return EmptyIterable.instance();
        }
    }

    private static Iterable<IPackageFragmentRoot> getPackageFragmentRoots_(IJavaProject javaProject) throws JavaModelException {
        return IterableTools.iterable((Object[])javaProject.getPackageFragmentRoots());
    }

    public static Iterable<String> getJavaClassNames(IJavaProject javaProject) {
        return IterableTools.sort(JavaProjectTools.getClassNames(javaProject));
    }

    public static Iterable<String> getClassNames(IJavaProject javaProject) {
        return IterableTools.transform(JavaProjectTools.getClasses(javaProject), TypeTools.NAME_TRANSFORMER);
    }

    public static Iterable<IType> getClasses(IJavaProject javaProject) {
        return IterableTools.filter(JavaProjectTools.getTypes(javaProject), TypeTools.IS_CLASS);
    }

    public static Iterable<String> getSortedInterfaceNames(IJavaProject javaProject) {
        return IterableTools.sort(JavaProjectTools.getInterfaceNames(javaProject));
    }

    public static Iterable<String> getInterfaceNames(IJavaProject javaProject) {
        return IterableTools.transform(JavaProjectTools.getInterfaces(javaProject), TypeTools.NAME_TRANSFORMER);
    }

    public static Iterable<IType> getInterfaces(IJavaProject javaProject) {
        return IterableTools.filter(JavaProjectTools.getTypes(javaProject), TypeTools.IS_INTERFACE);
    }

    public static Iterable<String> getSortedEnumNames(IJavaProject javaProject) {
        return IterableTools.sort(JavaProjectTools.getEnumNames(javaProject));
    }

    public static Iterable<String> getEnumNames(IJavaProject javaProject) {
        return IterableTools.transform(JavaProjectTools.getEnums(javaProject), TypeTools.NAME_TRANSFORMER);
    }

    public static Iterable<IType> getEnums(IJavaProject javaProject) {
        return IterableTools.filter(JavaProjectTools.getTypes(javaProject), TypeTools.IS_ENUM);
    }

    public static Iterable<IType> getTypes(IJavaProject javaProject) {
        try {
            return JavaProjectTools.getTypes_(javaProject);
        }
        catch (JavaModelException e) {
            JptCommonCorePlugin.instance().logError(e);
            return IterableTools.emptyIterable();
        }
    }

    private static Iterable<IType> getTypes_(IJavaProject javaProject) throws JavaModelException {
        IPackageFragmentRoot[] pkgRoots;
        ArrayList<IType> typesList = new ArrayList<IType>();
        IPackageFragmentRoot[] iPackageFragmentRootArray = pkgRoots = javaProject.getAllPackageFragmentRoots();
        int n = pkgRoots.length;
        int n2 = 0;
        while (n2 < n) {
            IJavaElement[] jElements;
            IPackageFragmentRoot root = iPackageFragmentRootArray[n2];
            IJavaElement[] iJavaElementArray = jElements = root.getChildren();
            int n3 = jElements.length;
            int n4 = 0;
            while (n4 < n3) {
                IJavaElement jElement = iJavaElementArray[n4];
                if (jElement.getElementType() == 4) {
                    ICompilationUnit[] units;
                    ICompilationUnit[] iCompilationUnitArray = units = ((IPackageFragment)jElement).getCompilationUnits();
                    int n5 = units.length;
                    int n6 = 0;
                    while (n6 < n5) {
                        ICompilationUnit unit = iCompilationUnitArray[n6];
                        CollectionTools.addAll(typesList, (Object[])unit.getTypes());
                        ++n6;
                    }
                }
                ++n4;
            }
            ++n2;
        }
        return typesList;
    }

    private JavaProjectTools() {
        throw new UnsupportedOperationException();
    }

    public static class JavaElementIsOnClasspath
    extends CriterionPredicate<IJavaElement, IJavaProject> {
        public JavaElementIsOnClasspath(IJavaProject javaProject) {
            super((Object)javaProject);
        }

        public boolean evaluate(IJavaElement javaElement) {
            return ((IJavaProject)this.criterion).isOnClasspath(javaElement);
        }
    }

    public static class ResourceIsOnClasspath
    extends CriterionPredicate<IResource, IJavaProject> {
        public ResourceIsOnClasspath(IJavaProject javaProject) {
            super((Object)javaProject);
        }

        public boolean evaluate(IResource resource) {
            return ((IJavaProject)this.criterion).isOnClasspath(resource);
        }
    }
}

