/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.chromium.internal.wip;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import org.eclipse.wst.jsdt.chromium.RelayOk;
import org.eclipse.wst.jsdt.chromium.Script;
import org.eclipse.wst.jsdt.chromium.SyncCallback;
import org.eclipse.wst.jsdt.chromium.internal.ScriptBase;
import org.eclipse.wst.jsdt.chromium.internal.wip.WipScriptImpl;
import org.eclipse.wst.jsdt.chromium.internal.wip.WipTabImpl;
import org.eclipse.wst.jsdt.chromium.internal.wip.protocol.input.debugger.GetScriptSourceData;
import org.eclipse.wst.jsdt.chromium.internal.wip.protocol.input.debugger.ScriptParsedEventData;
import org.eclipse.wst.jsdt.chromium.internal.wip.protocol.output.debugger.GetScriptSourceParams;
import org.eclipse.wst.jsdt.chromium.util.AsyncFuture;
import org.eclipse.wst.jsdt.chromium.util.AsyncFutureMerger;
import org.eclipse.wst.jsdt.chromium.util.AsyncFutureRef;
import org.eclipse.wst.jsdt.chromium.util.BasicUtil;
import org.eclipse.wst.jsdt.chromium.util.GenericCallback;
import org.eclipse.wst.jsdt.chromium.util.RelaySyncCallback;

class WipScriptManager {
    private final WipTabImpl tabImpl;
    private final Map<String, ScriptData> scriptIdToData = new HashMap<String, ScriptData>();
    private final AsyncFutureRef<Void> scriptsPreloaded;
    private ScriptPopulateMode populateMode = new ScriptPopulateMode();

    WipScriptManager(WipTabImpl tabImpl) {
        this.tabImpl = tabImpl;
        this.scriptsPreloaded = this.populateMode.createAndInitMasterFuture();
    }

    WipTabImpl getTabImpl() {
        return this.tabImpl;
    }

    RelayOk getScripts(final GenericCallback<Collection<Script>> callback, SyncCallback syncCallback) {
        RelaySyncCallback relay = new RelaySyncCallback(syncCallback);
        RelaySyncCallback.Guard guardOne = relay.newGuard();
        AsyncFuture.Callback<Void> futureCallback = new AsyncFuture.Callback<Void>(){

            public void done(Void res) {
                if (callback != null) {
                    callback.success((Object)WipScriptManager.this.getCurrentScripts());
                }
            }
        };
        Runnable mainRunnable = new Runnable((AsyncFuture.Callback)futureCallback, guardOne){
            private final /* synthetic */ AsyncFuture.Callback val$futureCallback;
            private final /* synthetic */ RelaySyncCallback.Guard val$guardOne;
            {
                this.val$futureCallback = callback;
                this.val$guardOne = guard;
            }

            @Override
            public void run() {
                RelayOk relayOk = WipScriptManager.this.scriptsPreloaded.getAsync(this.val$futureCallback, this.val$guardOne.getRelay().getUserSyncCallback());
                this.val$guardOne.discharge(relayOk);
            }
        };
        return this.tabImpl.getCommandProcessor().runInDispatchThread(mainRunnable, guardOne.asSyncCallback());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Script getScript(String scriptId) {
        ScriptData data;
        Map<String, ScriptData> map = this.scriptIdToData;
        synchronized (map) {
            data = (ScriptData)BasicUtil.getSafe(this.scriptIdToData, (Object)scriptId);
        }
        if (data == null) {
            return null;
        }
        if (!data.sourceLoadedFuture.isDone()) {
            return null;
        }
        return data.scriptImpl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Collection<Script> getCurrentScripts() {
        Map<String, ScriptData> map = this.scriptIdToData;
        synchronized (map) {
            ArrayList<Script> list = new ArrayList<Script>(this.scriptIdToData.size());
            for (ScriptData data : this.scriptIdToData.values()) {
                if (!data.sourceLoadedFuture.isDone()) continue;
                list.add((Script)data.scriptImpl);
            }
            return list;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void scriptIsReportedParsed(ScriptParsedEventData data) {
        SyncCallback syncCallback;
        Object callback;
        String sourceID = data.scriptId();
        String url = data.url();
        if (url.isEmpty()) {
            url = null;
        }
        ScriptBase.Descriptor descriptor = new ScriptBase.Descriptor(Script.Type.NORMAL, (Object)sourceID, url, (int)data.startLine(), (int)data.startColumn(), -1);
        final WipScriptImpl script = new WipScriptImpl(this, (ScriptBase.Descriptor<String>)descriptor);
        ScriptData scriptData = new ScriptData(script);
        Map<String, ScriptData> map = this.scriptIdToData;
        synchronized (map) {
            if (BasicUtil.containsKeySafe(this.scriptIdToData, (Object)sourceID)) {
                throw new IllegalStateException("Already has script with id " + sourceID);
            }
            this.scriptIdToData.put(sourceID, scriptData);
        }
        scriptData.sourceLoadedFuture.initializeRunning((AsyncFuture.Operation)new SourceLoadOperation(script, sourceID));
        final ScriptPopulateMode populateModeSaved = this.populateMode;
        if (populateModeSaved == null) {
            callback = new AsyncFuture.Callback<Boolean>(){

                public void done(Boolean res) {
                    WipScriptManager.this.tabImpl.getTabListener().getDebugEventListener().scriptLoaded((Script)script);
                }
            };
            syncCallback = null;
        } else {
            populateModeSaved.anotherSourceToWait();
            callback = new AsyncFuture.Callback<Boolean>(){

                public void done(Boolean res) {
                    populateModeSaved.sourceLoaded(res);
                }
            };
            syncCallback = new SyncCallback(){

                public void callbackDone(RuntimeException e) {
                    populateModeSaved.sourceLoadedSync(e);
                }
            };
        }
        scriptData.sourceLoadedFuture.getAsync((AsyncFuture.Callback)callback, syncCallback);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    RelayOk loadScriptSourcesAsync(Set<String> ids, ScriptSourceLoadCallback callback, SyncCallback syncCallback) {
        ArrayDeque<ScriptData> scripts = new ArrayDeque<ScriptData>(ids.size());
        HashMap<String, WipScriptImpl> result = new HashMap<String, WipScriptImpl>(ids.size());
        Map<String, ScriptData> map = this.scriptIdToData;
        synchronized (map) {
            for (String id : ids) {
                ScriptData data = (ScriptData)BasicUtil.getSafe(this.scriptIdToData, (Object)id);
                if (data == null) {
                    result.put(id, null);
                    continue;
                }
                result.put(id, data.scriptImpl);
                if (data.sourceLoadedFuture.isDone()) continue;
                scripts.add(data);
            }
        }
        RelaySyncCallback relay = new RelaySyncCallback(syncCallback);
        return this.loadNextScript(scripts, result, callback, relay);
    }

    static String convertAlienSourceId(Object sourceIdObj) {
        if (!(sourceIdObj instanceof String)) {
            throw new IllegalArgumentException("Script id must be string");
        }
        return (String)sourceIdObj;
    }

    private RelayOk loadNextScript(final Queue<ScriptData> scripts, final Map<String, WipScriptImpl> result, final ScriptSourceLoadCallback callback, final RelaySyncCallback relay) {
        ScriptData data = scripts.poll();
        if (data == null) {
            if (callback != null) {
                callback.done(result);
            }
            return relay.finish();
        }
        final RelaySyncCallback.Guard guard = relay.newGuard();
        AsyncFuture.Callback<Boolean> futureCallback = new AsyncFuture.Callback<Boolean>(){

            public void done(Boolean res) {
                RelayOk relayOk = WipScriptManager.this.loadNextScript(scripts, result, callback, relay);
                guard.discharge(relayOk);
            }
        };
        return data.sourceLoadedFuture.getAsync((AsyncFuture.Callback)futureCallback, guard.asSyncCallback());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void pageReloaded() {
        Map<String, ScriptData> map = this.scriptIdToData;
        synchronized (map) {
            this.scriptIdToData.clear();
        }
    }

    void endPopulateScriptMode() {
        this.populateMode.endMode();
        this.populateMode = null;
    }

    private class ScriptData {
        final WipScriptImpl scriptImpl;
        final AsyncFutureRef<Boolean> sourceLoadedFuture = new AsyncFutureRef();

        ScriptData(WipScriptImpl scriptImpl) {
            this.scriptImpl = scriptImpl;
        }
    }

    private static class ScriptPopulateMode {
        private final AsyncFutureMerger<Boolean> populateAndLoadSourcesFuture = new AsyncFutureMerger();

        private ScriptPopulateMode() {
        }

        void endMode() {
            this.populateAndLoadSourcesFuture.subOperationDone(null);
            this.populateAndLoadSourcesFuture.subOperationDoneSync(null);
        }

        void anotherSourceToWait() {
            this.populateAndLoadSourcesFuture.addSubOperation();
        }

        void sourceLoaded(Boolean result) {
            this.populateAndLoadSourcesFuture.subOperationDone((Object)result);
        }

        void sourceLoadedSync(RuntimeException e) {
            this.populateAndLoadSourcesFuture.subOperationDoneSync(e);
        }

        AsyncFutureRef<Void> createAndInitMasterFuture() {
            AsyncFutureRef asyncFutureRef = new AsyncFutureRef();
            asyncFutureRef.initializeRunning((AsyncFuture.Operation)new AsyncFuture.Operation<Void>(){

                public RelayOk start(final AsyncFuture.Callback<Void> callback, SyncCallback syncCallback) {
                    AsyncFuture innerFuture = populateAndLoadSourcesFuture.getFuture();
                    return innerFuture.getAsync((AsyncFuture.Callback)new AsyncFuture.Callback<Object>(){

                        public void done(Object res) {
                            callback.done(null);
                        }
                    }, syncCallback);
                }
            });
            return asyncFutureRef;
        }
    }

    static interface ScriptSourceLoadCallback {
        public void done(Map<String, WipScriptImpl> var1);
    }

    private final class SourceLoadOperation
    implements AsyncFuture.Operation<Boolean> {
        private final WipScriptImpl script;
        private final String sourceID;

        private SourceLoadOperation(WipScriptImpl script, String sourceID) {
            this.script = script;
            this.sourceID = sourceID;
        }

        public RelayOk start(final AsyncFuture.Callback<Boolean> operationCallback, SyncCallback syncCallback) {
            GenericCallback<GetScriptSourceData> commandCallback = new GenericCallback<GetScriptSourceData>(){

                public void success(GetScriptSourceData data) {
                    String source = data.scriptSource();
                    SourceLoadOperation.this.script.setSource(source);
                    operationCallback.done((Object)true);
                }

                public void failure(Exception exception) {
                    throw new RuntimeException(exception);
                }
            };
            GetScriptSourceParams params = new GetScriptSourceParams(this.sourceID);
            return WipScriptManager.this.tabImpl.getCommandProcessor().send(params, commandCallback, syncCallback);
        }
    }
}

