/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.common.project.facet.ui.internal;

import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.ui.plugin.AbstractUIPlugin;

public final class FacetUiPlugin
extends AbstractUIPlugin {
    public static final String PLUGIN_ID = "org.eclipse.wst.common.project.facet.ui";
    private static final String TRACING_PROP_PAGE_ACTION_CONFIG_VALIDATION = "org.eclipse.wst.common.project.facet.ui/propPage/actionConfigValidation";
    private static FacetUiPlugin plugin;
    private static final Set<String> messagesLogged;

    static {
        messagesLogged = new HashSet<String>();
    }

    public FacetUiPlugin() {
        plugin = this;
    }

    public static FacetUiPlugin getInstance() {
        return plugin;
    }

    public static ImageDescriptor getImageDescriptor(String path) {
        return FacetUiPlugin.imageDescriptorFromPlugin((String)PLUGIN_ID, (String)path);
    }

    public static void log(Exception e) {
        String msg = e.getMessage();
        FacetUiPlugin.log((IStatus)new Status(4, PLUGIN_ID, 0, msg, (Throwable)e));
    }

    public static void log(IStatus status) {
        FacetUiPlugin.getInstance().getLog().log(status);
    }

    public static void log(String msg) {
        FacetUiPlugin.log((IStatus)new Status(4, PLUGIN_ID, 0, msg, null));
    }

    public static void logError(String msg) {
        FacetUiPlugin.logError(msg, false);
    }

    public static void logError(String msg, boolean suppressDuplicates) {
        if (suppressDuplicates && messagesLogged.contains(msg)) {
            return;
        }
        messagesLogged.add(msg);
        FacetUiPlugin.log((IStatus)new Status(4, PLUGIN_ID, 0, msg, null));
    }

    public static void logWarning(String msg) {
        FacetUiPlugin.logWarning(msg, false);
    }

    public static void logWarning(String msg, boolean suppressDuplicates) {
        if (suppressDuplicates && messagesLogged.contains(msg)) {
            return;
        }
        messagesLogged.add(msg);
        FacetUiPlugin.log((IStatus)new Status(2, PLUGIN_ID, 0, msg, null));
    }

    public static IStatus createErrorStatus(String msg, Exception e) {
        return new Status(4, PLUGIN_ID, 0, msg, (Throwable)e);
    }

    public static boolean isTracingPropPageActionConfigValidation() {
        return FacetUiPlugin.checkDebugOption(TRACING_PROP_PAGE_ACTION_CONFIG_VALIDATION);
    }

    private static boolean checkDebugOption(String debugOption) {
        String optionValue = Platform.getDebugOption((String)debugOption);
        return optionValue == null ? false : Boolean.valueOf(optionValue).equals(Boolean.TRUE);
    }
}

