/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsf.facesconfig.tests.read;

import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.jst.jsf.facesconfig.emf.DescriptionType;
import org.eclipse.jst.jsf.facesconfig.emf.DisplayNameType;
import org.eclipse.jst.jsf.facesconfig.emf.FacesConfigType;
import org.eclipse.jst.jsf.facesconfig.emf.IconType;
import org.eclipse.jst.jsf.facesconfig.emf.RenderKitType;
import org.eclipse.jst.jsf.facesconfig.emf.RendererType;
import org.eclipse.jst.jsf.facesconfig.tests.read.BaseReadTestCase;
import org.eclipse.jst.jsf.facesconfig.tests.util.FacesConfigModelUtil;
import org.eclipse.jst.jsf.facesconfig.util.FacesConfigArtifactEdit;

public class ReadRendererTestCase
extends BaseReadTestCase {
    public ReadRendererTestCase(String name) {
        super(name);
    }

    public void testSingleRenderer() {
        FacesConfigArtifactEdit edit = null;
        try {
            edit = this.getArtifactEditForRead();
            ReadRendererTestCase.assertNotNull((Object)edit.getFacesConfig());
            ReadRendererTestCase.assertNotNull((Object)this.getRenderer1(edit.getFacesConfig()));
        }
        finally {
            if (edit != null) {
                edit.dispose();
            }
        }
    }

    private RendererType getRenderer1(FacesConfigType facesConfig) {
        RenderKitType renderKitType = (RenderKitType)FacesConfigModelUtil.findEObjectElementById((List)facesConfig.getRenderKit(), "renderKit1");
        ReadRendererTestCase.assertNotNull((Object)renderKitType);
        return (RendererType)FacesConfigModelUtil.findEObjectElementById((List)renderKitType.getRenderer(), "renderKit1Renderer");
    }

    public void testDescriptionGroup() {
        FacesConfigArtifactEdit edit = null;
        try {
            edit = this.getArtifactEditForRead();
            ReadRendererTestCase.assertNotNull((Object)edit.getFacesConfig());
            RendererType renderKit = this.getRenderer1(edit.getFacesConfig());
            ReadRendererTestCase.assertNotNull((Object)renderKit);
            DescriptionType descType = (DescriptionType)FacesConfigModelUtil.findEObjectElementById((List)renderKit.getDescription(), "renderKit1RendererDescription");
            ReadRendererTestCase.assertNotNull((Object)descType);
            ReadRendererTestCase.assertEquals((String)"my renderer description", (String)descType.getTextContent());
            DisplayNameType displayName = (DisplayNameType)FacesConfigModelUtil.findEObjectElementById((List)renderKit.getDisplayName(), "renderKit1RendererDisplayName");
            ReadRendererTestCase.assertNotNull((Object)displayName);
            ReadRendererTestCase.assertEquals((String)"my renderer display name", (String)displayName.getTextContent());
            IconType iconType = (IconType)FacesConfigModelUtil.findEObjectElementById((List)renderKit.getIcon(), "renderKit1RendererIcon");
            ReadRendererTestCase.assertNotNull((Object)iconType);
            ReadRendererTestCase.assertEquals((String)"renderer-small-icon", (String)iconType.getSmallIcon().getTextContent());
            ReadRendererTestCase.assertEquals((String)"renderer-large-icon", (String)iconType.getLargeIcon().getTextContent());
        }
        finally {
            if (edit != null) {
                edit.dispose();
            }
        }
    }

    public void testStringForRequiredEntries() {
        FacesConfigArtifactEdit edit = null;
        try {
            edit = this.getArtifactEditForRead();
            ReadRendererTestCase.assertNotNull((Object)edit.getFacesConfig());
            RendererType renderer = this.getRenderer1(edit.getFacesConfig());
            ReadRendererTestCase.assertNotNull((Object)renderer);
            ReadRendererTestCase.assertEquals((String)"renderer-type", (String)renderer.getRendererType().getTextContent());
            ReadRendererTestCase.assertEquals((String)"renderer-class", (String)renderer.getRendererClass().getTextContent());
            ReadRendererTestCase.assertEquals((String)"component-family", (String)renderer.getComponentFamily().getTextContent());
        }
        finally {
            if (edit != null) {
                edit.dispose();
            }
        }
    }

    public void testAttribute() {
        FacesConfigArtifactEdit edit = null;
        try {
            edit = this.getArtifactEditForRead();
            ReadRendererTestCase.assertNotNull((Object)edit.getFacesConfig());
            RendererType renderer = this.getRenderer1(edit.getFacesConfig());
            ReadRendererTestCase.assertNotNull((Object)renderer);
            ReadRendererTestCase.assertEquals((int)1, (int)renderer.getAttribute().size());
        }
        finally {
            if (edit != null) {
                edit.dispose();
            }
        }
    }

    public void testFacet() {
        FacesConfigArtifactEdit edit = null;
        try {
            edit = this.getArtifactEditForRead();
            ReadRendererTestCase.assertNotNull((Object)edit.getFacesConfig());
            RendererType renderer = this.getRenderer1(edit.getFacesConfig());
            ReadRendererTestCase.assertNotNull((Object)renderer);
            ReadRendererTestCase.assertEquals((int)1, (int)renderer.getFacet().size());
        }
        finally {
            if (edit != null) {
                edit.dispose();
            }
        }
    }

    public void testRendererExtension() {
        FacesConfigArtifactEdit edit = null;
        try {
            edit = this.getArtifactEditForRead();
            if (edit.getFacesConfig() != null) {
                EList renderKit = edit.getFacesConfig().getRenderKit();
                ReadRendererTestCase.assertTrue((!renderKit.isEmpty() ? 1 : 0) != 0);
                int i = 0;
                while (i < renderKit.size()) {
                    RenderKitType rendererType = (RenderKitType)renderKit.get(i);
                    ReadRendererTestCase.assertTrue((!rendererType.getRenderer().isEmpty() ? 1 : 0) != 0);
                    EList rend = rendererType.getRenderer();
                    int k = 0;
                    while (k < rend.size()) {
                        RendererType rendType = (RendererType)rend.get(k);
                        EList ext = rendType.getRendererExtension();
                        ReadRendererTestCase.assertTrue((ext.size() != 0 ? 1 : 0) != 0);
                        ++k;
                    }
                    ++i;
                }
            }
        }
        finally {
            if (edit != null) {
                edit.dispose();
            }
        }
    }
}

