/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsf.facesconfig.tests.read;

import java.util.List;
import org.eclipse.jst.jsf.facesconfig.emf.AttributeType;
import org.eclipse.jst.jsf.facesconfig.emf.ComponentExtensionType;
import org.eclipse.jst.jsf.facesconfig.emf.ComponentType;
import org.eclipse.jst.jsf.facesconfig.emf.DescriptionType;
import org.eclipse.jst.jsf.facesconfig.emf.DisplayNameType;
import org.eclipse.jst.jsf.facesconfig.emf.FacesConfigType;
import org.eclipse.jst.jsf.facesconfig.emf.FacetType;
import org.eclipse.jst.jsf.facesconfig.emf.IconType;
import org.eclipse.jst.jsf.facesconfig.emf.PropertyType;
import org.eclipse.jst.jsf.facesconfig.tests.read.BaseReadTestCase;
import org.eclipse.jst.jsf.facesconfig.tests.util.FacesConfigModelUtil;
import org.eclipse.jst.jsf.facesconfig.util.FacesConfigArtifactEdit;

public class ReadComponentTestCase
extends BaseReadTestCase {
    public ReadComponentTestCase(String name) {
        super(name);
    }

    public void testSingleComponent() {
        FacesConfigArtifactEdit edit = null;
        try {
            edit = this.getArtifactEditForRead();
            ReadComponentTestCase.assertNotNull((Object)edit.getFacesConfig());
            ReadComponentTestCase.assertNotNull((Object)this.getComponent1(edit.getFacesConfig()));
        }
        finally {
            if (edit != null) {
                edit.dispose();
            }
        }
    }

    private ComponentType getComponent1(FacesConfigType facesConfig) {
        return (ComponentType)FacesConfigModelUtil.findEObjectElementById((List)facesConfig.getComponent(), "component1");
    }

    public void testNonEmptyDescription() {
        FacesConfigArtifactEdit edit = null;
        try {
            edit = this.getArtifactEditForRead();
            ReadComponentTestCase.assertNotNull((Object)edit.getFacesConfig());
            ComponentType component1 = this.getComponent1(edit.getFacesConfig());
            ReadComponentTestCase.assertNotNull((Object)component1);
            DescriptionType descriptionType = (DescriptionType)FacesConfigModelUtil.findEObjectElementById((List)component1.getDescription(), "componentDescription1");
            ReadComponentTestCase.assertNotNull((Object)descriptionType);
            ReadComponentTestCase.assertEquals((String)"my component", (String)descriptionType.getTextContent().trim());
        }
        finally {
            if (edit != null) {
                edit.dispose();
            }
        }
    }

    public void testDisplayName() {
        FacesConfigArtifactEdit edit = null;
        try {
            edit = this.getArtifactEditForRead();
            ReadComponentTestCase.assertNotNull((Object)edit.getFacesConfig());
            ComponentType component1 = this.getComponent1(edit.getFacesConfig());
            ReadComponentTestCase.assertNotNull((Object)component1);
            DisplayNameType displayNameType = (DisplayNameType)FacesConfigModelUtil.findEObjectElementById((List)component1.getDisplayName(), "componentDisplayName1");
            ReadComponentTestCase.assertNotNull((Object)displayNameType);
            ReadComponentTestCase.assertEquals((String)"My component", (String)displayNameType.getTextContent().trim());
        }
        finally {
            if (edit != null) {
                edit.dispose();
            }
        }
    }

    public void testNonEmptyIcon() {
        FacesConfigArtifactEdit edit = null;
        try {
            edit = this.getArtifactEditForRead();
            ReadComponentTestCase.assertNotNull((Object)edit.getFacesConfig());
            ComponentType component1 = this.getComponent1(edit.getFacesConfig());
            ReadComponentTestCase.assertNotNull((Object)component1);
            IconType iconType = (IconType)FacesConfigModelUtil.findEObjectElementById((List)component1.getIcon(), "componentIcon1");
            ReadComponentTestCase.assertNotNull((Object)iconType);
            ReadComponentTestCase.assertEquals((String)"small-icon", (String)iconType.getSmallIcon().getTextContent().trim());
            ReadComponentTestCase.assertEquals((String)"large-icon", (String)iconType.getLargeIcon().getTextContent().trim());
        }
        finally {
            if (edit != null) {
                edit.dispose();
            }
        }
    }

    public void testNonEmptyComponentTypeAndClass() {
        FacesConfigArtifactEdit edit = null;
        try {
            edit = this.getArtifactEditForRead();
            ReadComponentTestCase.assertNotNull((Object)edit.getFacesConfig());
            ComponentType component1 = this.getComponent1(edit.getFacesConfig());
            ReadComponentTestCase.assertNotNull((Object)component1);
            ReadComponentTestCase.assertEquals((String)"component-type", (String)component1.getComponentType().getTextContent());
            ReadComponentTestCase.assertEquals((String)"ComponentClass", (String)component1.getComponentClass().getTextContent());
        }
        finally {
            if (edit != null) {
                edit.dispose();
            }
        }
    }

    public void testAttribute() {
        FacesConfigArtifactEdit edit = null;
        try {
            edit = this.getArtifactEditForRead();
            ReadComponentTestCase.assertNotNull((Object)edit.getFacesConfig());
            ComponentType component1 = this.getComponent1(edit.getFacesConfig());
            ReadComponentTestCase.assertEquals((int)1, (int)component1.getAttribute().size());
            ReadComponentTestCase.assertEquals((String)"componentAttribute1", (String)((AttributeType)component1.getAttribute().get(0)).getId());
        }
        finally {
            if (edit != null) {
                edit.dispose();
            }
        }
    }

    public void testProperty() {
        FacesConfigArtifactEdit edit = null;
        try {
            edit = this.getArtifactEditForRead();
            ReadComponentTestCase.assertNotNull((Object)edit.getFacesConfig());
            ComponentType component1 = this.getComponent1(edit.getFacesConfig());
            ReadComponentTestCase.assertNotNull((Object)component1);
            ReadComponentTestCase.assertEquals((int)1, (int)component1.getProperty().size());
            ReadComponentTestCase.assertEquals((String)"componentProperty1", (String)((PropertyType)component1.getProperty().get(0)).getId());
        }
        finally {
            if (edit != null) {
                edit.dispose();
            }
        }
    }

    public void testFacet() {
        FacesConfigArtifactEdit edit = null;
        try {
            edit = this.getArtifactEditForRead();
            ReadComponentTestCase.assertNotNull((Object)edit.getFacesConfig());
            ComponentType component1 = this.getComponent1(edit.getFacesConfig());
            ReadComponentTestCase.assertNotNull((Object)component1);
            ReadComponentTestCase.assertEquals((int)1, (int)component1.getFacet().size());
            ReadComponentTestCase.assertEquals((String)"componentFacet1", (String)((FacetType)component1.getFacet().get(0)).getId());
        }
        finally {
            if (edit != null) {
                edit.dispose();
            }
        }
    }

    public void testComponentExtension() {
        FacesConfigArtifactEdit edit = null;
        try {
            edit = this.getArtifactEditForRead();
            ReadComponentTestCase.assertNotNull((Object)edit.getFacesConfig());
            ComponentType component1 = this.getComponent1(edit.getFacesConfig());
            ReadComponentTestCase.assertNotNull((Object)component1);
            ComponentExtensionType extType = (ComponentExtensionType)FacesConfigModelUtil.findEObjectElementById((List)component1.getComponentExtension(), "componentExtension1");
            ReadComponentTestCase.assertNotNull((Object)extType);
        }
        finally {
            if (edit != null) {
                edit.dispose();
            }
        }
    }
}

