/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xsd.ui.internal.adt.design.editparts;

import java.util.List;
import org.eclipse.core.runtime.Assert;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.gef.AccessibleEditPart;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPartFactory;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.GraphicalViewer;
import org.eclipse.gef.editparts.AbstractGraphicalEditPart;
import org.eclipse.gef.editparts.ScalableRootEditPart;
import org.eclipse.gef.editparts.ZoomListener;
import org.eclipse.gef.editparts.ZoomManager;
import org.eclipse.jface.action.IAction;
import org.eclipse.swt.accessibility.AccessibleEvent;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ide.FileStoreEditorInput;
import org.eclipse.wst.xsd.ui.internal.adt.design.editparts.model.IActionProvider;
import org.eclipse.wst.xsd.ui.internal.adt.design.editparts.model.IFeedbackHandler;
import org.eclipse.wst.xsd.ui.internal.adt.design.editpolicies.KeyBoardAccessibilityEditPolicy;
import org.eclipse.wst.xsd.ui.internal.adt.design.figures.IFigureFactory;
import org.eclipse.wst.xsd.ui.internal.adt.editor.CommonMultiPageEditor;
import org.eclipse.wst.xsd.ui.internal.adt.facade.IADTObject;
import org.eclipse.wst.xsd.ui.internal.adt.facade.IADTObjectListener;

public abstract class BaseEditPart
extends AbstractGraphicalEditPart
implements IActionProvider,
IADTObjectListener,
IFeedbackHandler {
    protected static final String[] EMPTY_ACTION_ARRAY = new String[0];
    protected boolean isSelected = false;
    protected boolean hasFocus = false;
    protected static boolean isHighContrast = Display.getDefault().getHighContrast();
    protected AccessibleEditPart accessiblePart;
    private ZoomListener zoomListener = new ZoomListener(){

        public void zoomChanged(double zoom) {
            BaseEditPart.this.handleZoomChanged();
        }
    };
    static /* synthetic */ Class class$0;

    public IFigureFactory getFigureFactory() {
        EditPartFactory factory = this.getViewer().getEditPartFactory();
        Assert.isTrue((boolean)(factory instanceof IFigureFactory), (String)"EditPartFactory must be an instanceof of IFigureFactory");
        return (IFigureFactory)factory;
    }

    public String[] getActions(Object object) {
        Object model = this.getModel();
        if (model instanceof IActionProvider) {
            return ((IActionProvider)model).getActions(object);
        }
        return EMPTY_ACTION_ARRAY;
    }

    protected void addActionsToList(List list, IAction[] actions) {
        int i = 0;
        while (i < actions.length) {
            list.add(actions[i]);
            ++i;
        }
    }

    public void activate() {
        super.activate();
        Object model = this.getModel();
        if (model instanceof IADTObject) {
            IADTObject object = (IADTObject)model;
            object.registerListener(this);
        }
        if (this.getZoomManager() != null) {
            this.getZoomManager().addZoomListener(this.zoomListener);
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void deactivate() {
        try {
            Object model = this.getModel();
            if (model instanceof IADTObject) {
                IADTObject object = (IADTObject)model;
                object.unregisterListener(this);
            }
            if (this.getZoomManager() != null) {
                this.getZoomManager().removeZoomListener(this.zoomListener);
            }
        }
        catch (Throwable throwable) {
            Object var3_4 = null;
            super.deactivate();
            throw throwable;
        }
        {
            Object var3_5 = null;
        }
        super.deactivate();
    }

    public void propertyChanged(Object object, String property) {
        this.refresh();
    }

    public void refresh() {
        boolean doUpdateDesign = this.doUpdateDesign();
        if (doUpdateDesign) {
            super.refresh();
        }
    }

    public void addFeedback() {
        this.isSelected = true;
        this.refreshVisuals();
    }

    public void removeFeedback() {
        this.isSelected = false;
        this.refreshVisuals();
    }

    public ZoomManager getZoomManager() {
        return ((ScalableRootEditPart)this.getRoot()).getZoomManager();
    }

    public Rectangle getZoomedBounds(Rectangle r) {
        double factor = this.getZoomManager().getZoom();
        int x = (int)Math.round((double)r.x * factor);
        int y = (int)Math.round((double)r.y * factor);
        int width = (int)Math.round((double)r.width * factor);
        int height = (int)Math.round((double)r.height * factor);
        return new Rectangle(x, y, width, height);
    }

    protected void handleZoomChanged() {
        this.refreshVisuals();
    }

    public IEditorPart getEditorPart() {
        IWorkbenchWindow workbenchWindow;
        IEditorPart editorPart = null;
        IWorkbench workbench = PlatformUI.getWorkbench();
        if (workbench != null && (workbenchWindow = workbench.getActiveWorkbenchWindow()) != null && workbenchWindow.getActivePage() != null) {
            editorPart = workbenchWindow.getActivePage().getActiveEditor();
        }
        return editorPart;
    }

    protected void createEditPolicies() {
        this.installEditPolicy(KeyBoardAccessibilityEditPolicy.KEY, (EditPolicy)new KeyBoardAccessibilityEditPolicy(){

            public EditPart getRelativeEditPart(EditPart editPart, int direction) {
                return BaseEditPart.this.doGetRelativeEditPart(editPart, direction);
            }
        });
    }

    public EditPart doGetRelativeEditPart(EditPart editPart, int direction) {
        return null;
    }

    protected boolean isFileReadOnly() {
        IEditorInput editorInput;
        IEditorPart editor;
        IWorkbenchPage page;
        IWorkbenchWindow workbenchWindow;
        IWorkbench workbench = PlatformUI.getWorkbench();
        return workbench != null && (workbenchWindow = workbench.getActiveWorkbenchWindow()) != null && (page = workbenchWindow.getActivePage()) != null && (editor = page.getActiveEditor()) != null && !((editorInput = editor.getEditorInput()) instanceof IFileEditorInput) && !(editorInput instanceof FileStoreEditorInput);
    }

    protected boolean doUpdateDesign() {
        IEditorPart editorPart;
        IWorkbenchPage page;
        IWorkbenchWindow workbenchWindow;
        IWorkbench workbench = PlatformUI.getWorkbench();
        if (workbench != null && (workbenchWindow = workbench.getActiveWorkbenchWindow()) != null && (page = workbenchWindow.getActivePage()) != null && (editorPart = page.getActiveEditor()) instanceof CommonMultiPageEditor) {
            CommonMultiPageEditor editor = (CommonMultiPageEditor)editorPart;
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.gef.GraphicalViewer");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            GraphicalViewer viewer = (GraphicalViewer)editor.getAdapter(clazz);
            if (this.getViewer() == viewer) {
                return !editor.isSourcePageActive();
            }
        }
        return true;
    }

    protected Font getItalicFont(Font font) {
        FontData[] fd;
        if (font != null && !font.isDisposed() && (fd = font.getFontData()).length > 0) {
            fd[0].setStyle(fd[0].getStyle() | 2);
            return new Font(font.getDevice(), fd);
        }
        return font;
    }

    protected AccessibleEditPart getAccessibleEditPart() {
        if (this.accessiblePart == null) {
            this.accessiblePart = new AbstractGraphicalEditPart.AccessibleGraphicalEditPart(this){

                public void getName(AccessibleEvent e) {
                    e.result = BaseEditPart.this.getReaderText();
                }
            };
        }
        return this.accessiblePart;
    }

    public String getReaderText() {
        return "";
    }
}

