/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.common.ui.tests.internal.jface;

import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.BaseLabelProvider;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.window.ApplicationWindow;
import org.eclipse.jpt.common.ui.internal.jface.EmptySelection;
import org.eclipse.jpt.common.ui.internal.jface.ItemTreeStateProviderManager;
import org.eclipse.jpt.common.ui.internal.jface.ModelItemExtendedLabelProvider;
import org.eclipse.jpt.common.ui.internal.jface.NullItemExtendedLabelProvider;
import org.eclipse.jpt.common.ui.internal.jface.StaticItemStructuredContentProvider;
import org.eclipse.jpt.common.ui.internal.jface.StaticItemTreeContentProvider;
import org.eclipse.jpt.common.ui.jface.ItemExtendedLabelProvider;
import org.eclipse.jpt.common.ui.jface.ItemStructuredContentProvider;
import org.eclipse.jpt.common.ui.jface.ItemTreeContentProvider;
import org.eclipse.jpt.common.utility.internal.model.AbstractModel;
import org.eclipse.jpt.common.utility.internal.model.value.PropertyAspectAdapter;
import org.eclipse.jpt.common.utility.internal.model.value.SimplePropertyValueModel;
import org.eclipse.jpt.common.utility.model.event.PropertyChangeEvent;
import org.eclipse.jpt.common.utility.model.listener.PropertyChangeListener;
import org.eclipse.jpt.common.utility.model.value.ModifiablePropertyValueModel;
import org.eclipse.jpt.common.utility.model.value.PropertyValueModel;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.PaletteData;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public class TreeLabelProviderUiTest
extends ApplicationWindow {
    private TreeViewer treeViewer;
    ModifiablePropertyValueModel<Vehicle> selectedVehicleModel = new SimplePropertyValueModel();
    private static final String[] IMAGE_ASPECT_NAMES = new String[]{"color", "grayed", "translucent"};
    private static final String[] TEXT_ASPECT_NAMES = new String[]{"vehicleType", "color"};

    public static void main(String[] args) {
        TreeLabelProviderUiTest window = new TreeLabelProviderUiTest();
        window.setBlockOnOpen(true);
        window.open();
        Display.getCurrent().dispose();
        System.exit(0);
    }

    private TreeLabelProviderUiTest() {
        super(null);
    }

    protected Control createContents(Composite parent) {
        ((Shell)parent).setText(((Object)((Object)this)).getClass().getSimpleName());
        parent.setSize(400, 400);
        parent.setLayout((Layout)new GridLayout());
        Composite mainPanel = new Composite(parent, 0);
        mainPanel.setLayoutData((Object)new GridData(1808));
        mainPanel.setLayout((Layout)new GridLayout());
        this.buildTreePanel(mainPanel);
        this.buildControlPanel(mainPanel);
        return mainPanel;
    }

    private void buildTreePanel(Composite parent) {
        Composite panel = new Composite(parent, 0);
        panel.setLayoutData((Object)new GridData(1808));
        panel.setLayout((Layout)new GridLayout());
        Label label = new Label(panel, 0);
        label.setLayoutData((Object)new GridData(1, 2, false, false));
        label.setText("My Vehicles");
        this.treeViewer = new TreeViewer(panel, 2820);
        this.treeViewer.getTree().setLayoutData((Object)new GridData(4, 4, true, true));
        ItemTreeStateProviderManager contentAndLabelProvider = new ItemTreeStateProviderManager((ItemTreeContentProvider.Factory)new VehicleContentProviderFactory(), (ItemExtendedLabelProvider.Factory)new VehicleLabelProviderFactory(), JFaceResources.getResources());
        this.treeViewer.setContentProvider((IContentProvider)contentAndLabelProvider);
        this.treeViewer.setLabelProvider((IBaseLabelProvider)contentAndLabelProvider);
        this.treeViewer.setInput((Object)new Root());
        this.treeViewer.addSelectionChangedListener(this.buildTreeSelectionChangedListener());
    }

    private ISelectionChangedListener buildTreeSelectionChangedListener() {
        return new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                TreeLabelProviderUiTest.this.selectedVehicleModel.setValue((Object)((Vehicle)((Object)((IStructuredSelection)event.getSelection()).getFirstElement())));
            }
        };
    }

    private void buildControlPanel(Composite parent) {
        Composite panel = new Composite(parent, 0);
        panel.setLayoutData((Object)new GridData(4, 2, true, false));
        panel.setLayout((Layout)new GridLayout());
        this.buildUpperControlPanel(panel);
        this.buildLowerControlPanel(panel);
    }

    private void buildUpperControlPanel(Composite parent) {
        Composite panel = new Composite(parent, 0);
        panel.setLayoutData((Object)new GridData(4, 2, true, false));
        panel.setLayout((Layout)new GridLayout(2, true));
        this.buildVehicleCombo(panel);
        this.buildColorCombo(panel);
    }

    private void buildVehicleCombo(Composite parent) {
        final ComboViewer combo = new ComboViewer(parent, 8);
        combo.getCombo().setLayoutData((Object)new GridData(4, 2, true, false));
        combo.setContentProvider((IContentProvider)new ArrayContentProvider());
        combo.setLabelProvider((IBaseLabelProvider)new VehicleTypeLabelProvider());
        combo.setInput((Object)new VehicleType[]{VehicleType.BICYCLE, VehicleType.CAR, VehicleType.TRUCK, VehicleType.BOAT});
        combo.getCombo().setEnabled(false);
        combo.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                Vehicle vehicle = TreeLabelProviderUiTest.this.getSelectedVehicle();
                if (vehicle != null) {
                    vehicle.setVehicleType((VehicleType)((Object)((StructuredSelection)event.getSelection()).getFirstElement()));
                }
            }
        });
        this.selectedVehicleModel.addPropertyChangeListener("value", new PropertyChangeListener(){

            public void propertyChanged(PropertyChangeEvent event) {
                Vehicle vehicle = TreeLabelProviderUiTest.this.getSelectedVehicle();
                combo.getCombo().setEnabled(vehicle != null);
                combo.setSelection((ISelection)(vehicle == null ? EmptySelection.instance() : new StructuredSelection((Object)vehicle.getVehicleType())));
            }
        });
    }

    private void buildColorCombo(Composite parent) {
        final ComboViewer combo = new ComboViewer(parent, 8);
        combo.getCombo().setLayoutData((Object)new GridData(4, 2, true, false));
        combo.setContentProvider((IContentProvider)new ArrayContentProvider());
        combo.setLabelProvider((IBaseLabelProvider)new ColorLabelProvider());
        combo.setInput((Object)new VehicleColor[]{VehicleColor.RED, VehicleColor.BLUE, VehicleColor.YELLOW, VehicleColor.GREEN});
        combo.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                Vehicle vehicle = TreeLabelProviderUiTest.this.getSelectedVehicle();
                if (vehicle != null) {
                    vehicle.setColor((VehicleColor)((Object)((StructuredSelection)event.getSelection()).getFirstElement()));
                }
            }
        });
        this.selectedVehicleModel.addPropertyChangeListener("value", new PropertyChangeListener(){

            public void propertyChanged(PropertyChangeEvent event) {
                Vehicle vehicle = TreeLabelProviderUiTest.this.getSelectedVehicle();
                combo.getCombo().setEnabled(vehicle != null);
                combo.setSelection((ISelection)(vehicle == null ? EmptySelection.instance() : new StructuredSelection((Object)vehicle.getColor())));
            }
        });
    }

    private void buildLowerControlPanel(Composite parent) {
        Composite panel = new Composite(parent, 0);
        panel.setLayoutData((Object)new GridData(4, 2, true, false));
        panel.setLayout((Layout)new GridLayout(3, false));
        this.buildEffectsLabel(panel);
        this.buildGrayedCheckBox(panel);
        this.buildTranslucentCheckBox(panel);
        this.buildActionPanel(panel);
    }

    private void buildEffectsLabel(Composite parent) {
        Label label = new Label(parent, 16384);
        label.setText("Color effects: ");
        label.setLayoutData((Object)new GridData(1, 2, false, false, 3, 1));
    }

    private void buildGrayedCheckBox(Composite parent) {
        final Button button = new Button(parent, 32);
        button.setLayoutData((Object)new GridData(1, 2, false, false));
        button.setText("grayed");
        button.setEnabled(false);
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TreeLabelProviderUiTest.this.getSelectedVehicle().setGrayed(button.getSelection());
            }
        });
        this.selectedVehicleModel.addPropertyChangeListener("value", new PropertyChangeListener(){

            public void propertyChanged(PropertyChangeEvent event) {
                Vehicle vehicle = TreeLabelProviderUiTest.this.getSelectedVehicle();
                button.setEnabled(vehicle != null);
                button.setSelection(vehicle != null && vehicle.isGrayed());
            }
        });
    }

    private void buildTranslucentCheckBox(Composite parent) {
        final Button button = new Button(parent, 32);
        button.setLayoutData((Object)new GridData(1, 2, true, false));
        button.setText("translucent");
        button.setEnabled(false);
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TreeLabelProviderUiTest.this.getSelectedVehicle().setTranslucent(button.getSelection());
            }
        });
        this.selectedVehicleModel.addPropertyChangeListener("value", new PropertyChangeListener(){

            public void propertyChanged(PropertyChangeEvent event) {
                Vehicle vehicle = TreeLabelProviderUiTest.this.getSelectedVehicle();
                button.setEnabled(vehicle != null);
                button.setSelection(vehicle != null && vehicle.isTranslucent());
            }
        });
    }

    private void buildActionPanel(Composite parent) {
        Composite panel = new Composite(parent, 0);
        panel.setLayoutData((Object)new GridData(3, 4, false, false));
        panel.setLayout((Layout)new GridLayout());
        this.buildRefreshTreeACI().fill(panel);
    }

    private ActionContributionItem buildRefreshTreeACI() {
        Action action = new Action("Restore tree", 1){

            public void run() {
                TreeLabelProviderUiTest.this.refreshTree();
            }
        };
        action.setToolTipText("Restore the tree's labels");
        return new ActionContributionItem((IAction)action);
    }

    void refreshTree() {
        this.treeViewer.setInput((Object)new Root());
    }

    Vehicle getSelectedVehicle() {
        return (Vehicle)((Object)this.selectedVehicleModel.getValue());
    }

    static PropertyValueModel<ImageDescriptor> buildImageDescriptorModel(Vehicle vehicle) {
        return new PropertyAspectAdapter<Vehicle, ImageDescriptor>(IMAGE_ASPECT_NAMES, vehicle){

            protected ImageDescriptor buildValue_() {
                return ((Vehicle)((Object)this.subject)).getImageDescriptor();
            }
        };
    }

    static PropertyValueModel<String> buildTextModel(Vehicle vehicle) {
        return new PropertyAspectAdapter<Vehicle, String>(TEXT_ASPECT_NAMES, vehicle){

            protected String buildValue_() {
                return String.valueOf(((Vehicle)((Object)this.subject)).getColor().getDescription()) + ' ' + ((Vehicle)((Object)this.subject)).getVehicleType().getDescription();
            }
        };
    }

    static PropertyValueModel<String> buildDescriptionModel(Vehicle vehicle) {
        return TreeLabelProviderUiTest.buildTextModel(vehicle);
    }

    static class ColorLabelProvider
    extends BaseLabelProvider
    implements ILabelProvider {
        ColorLabelProvider() {
        }

        public Image getImage(Object element) {
            return null;
        }

        public String getText(Object element) {
            return ((VehicleColor)((Object)element)).getDescription();
        }
    }

    private static class Root
    extends TreeNode {
        protected final Vehicle[] vehicles = this.buildVehicles();

        public Root() {
            super(null);
        }

        private Vehicle[] buildVehicles() {
            return new Vehicle[]{new Vehicle(this, VehicleType.BICYCLE, VehicleColor.BLUE), new Vehicle(this, VehicleType.CAR, VehicleColor.YELLOW), new Vehicle(this, VehicleType.TRUCK, VehicleColor.RED), new Vehicle(this, VehicleType.BOAT, VehicleColor.GREEN)};
        }

        public Vehicle[] getVehicles() {
            return this.vehicles;
        }
    }

    private static abstract class TreeNode
    extends AbstractModel {
        private TreeNode parent;

        public TreeNode(TreeNode parent) {
            this.parent = parent;
        }

        public TreeNode parent() {
            return this.parent;
        }
    }

    static class Vehicle
    extends TreeNode {
        private VehicleType vehicleType;
        public static final String VEHICLE_TYPE_PROPERTY = "vehicleType";
        private VehicleColor color;
        public static final String COLOR_PROPERTY = "color";
        private boolean grayed = false;
        public static final String GRAYED_PROPERTY = "grayed";
        private boolean translucent = false;
        public static final String TRANSLUCENT_PROPERTY = "translucent";

        Vehicle(TreeNode parent, VehicleType vehicleType, VehicleColor color) {
            super(parent);
            this.vehicleType = vehicleType;
            this.color = color;
        }

        public VehicleType getVehicleType() {
            return this.vehicleType;
        }

        public void setVehicleType(VehicleType vehicleType) {
            VehicleType old = this.vehicleType;
            this.vehicleType = vehicleType;
            this.firePropertyChanged(VEHICLE_TYPE_PROPERTY, (Object)old, (Object)vehicleType);
        }

        public VehicleColor getColor() {
            return this.color;
        }

        public void setColor(VehicleColor color) {
            VehicleColor old = this.color;
            this.color = color;
            this.firePropertyChanged(COLOR_PROPERTY, (Object)old, (Object)color);
        }

        public boolean isGrayed() {
            return this.grayed;
        }

        public void setGrayed(boolean grayed) {
            boolean old = this.grayed;
            this.grayed = grayed;
            this.firePropertyChanged(GRAYED_PROPERTY, old, grayed);
        }

        public boolean isTranslucent() {
            return this.translucent;
        }

        public void setTranslucent(boolean translucent) {
            boolean old = this.translucent;
            this.translucent = translucent;
            this.firePropertyChanged(TRANSLUCENT_PROPERTY, old, translucent);
        }

        public ImageDescriptor getImageDescriptor() {
            return VehicleImageDescriptorFactory.buildImageDescriptor(this.color, this.grayed, this.translucent);
        }

        public void toString(StringBuilder sb) {
            sb.append(this.color.getDescription());
            sb.append(' ');
            sb.append(this.vehicleType.getDescription());
        }
    }

    static enum VehicleColor {
        RED("red", new RGB(255, 0, 0)),
        BLUE("blue", new RGB(0, 0, 255)),
        YELLOW("yellow", new RGB(255, 255, 0)),
        GREEN("green", new RGB(0, 255, 0));

        private final String description;
        private final RGB rgb;

        private VehicleColor(String description, RGB rgb) {
            this.description = description;
            this.rgb = rgb;
        }

        public String getDescription() {
            return this.description;
        }

        public RGB rgb() {
            return this.rgb;
        }

        public String toString() {
            return this.description;
        }
    }

    static class VehicleContentProviderFactory
    implements ItemTreeContentProvider.Factory {
        VehicleContentProviderFactory() {
        }

        public ItemStructuredContentProvider buildProvider(Object inputElement, ItemStructuredContentProvider.Manager manager) {
            return new StaticItemStructuredContentProvider(inputElement, (Object[])((Root)((Object)inputElement)).getVehicles(), manager);
        }

        public ItemTreeContentProvider buildProvider(Object item, Object parent, ItemTreeContentProvider.Manager manager) {
            return new StaticItemTreeContentProvider(item, parent, manager);
        }
    }

    static class VehicleImageDescriptorFactory {
        private static final RGB GRAY = new RGB(127, 127, 127);

        VehicleImageDescriptorFactory() {
        }

        static ImageDescriptor buildImageDescriptor(VehicleColor color, boolean grayed, boolean translucent) {
            PaletteData pd = new PaletteData(new RGB[]{VehicleImageDescriptorFactory.buildRGB(color, grayed, translucent)});
            ImageData imageData = new ImageData(20, 20, 1, pd);
            int x = 0;
            while (x < 20) {
                int y = 0;
                while (y < 20) {
                    imageData.setPixel(x, y, 0);
                    ++y;
                }
                ++x;
            }
            return ImageDescriptor.createFromImageData((ImageData)imageData);
        }

        private static RGB buildRGB(VehicleColor color, boolean grayed, boolean translucent) {
            RGB rgb;
            RGB rGB = rgb = grayed ? GRAY : color.rgb();
            if (translucent) {
                rgb = new RGB(VehicleImageDescriptorFactory.translucify(rgb.red), VehicleImageDescriptorFactory.translucify(rgb.green), VehicleImageDescriptorFactory.translucify(rgb.blue));
            }
            return rgb;
        }

        private static int translucify(int colorComponent) {
            return 255 - (int)((double)(255 - colorComponent) * 0.3);
        }
    }

    static class VehicleLabelProviderFactory
    implements ItemExtendedLabelProvider.Factory {
        VehicleLabelProviderFactory() {
        }

        public ItemExtendedLabelProvider buildProvider(Object item, ItemExtendedLabelProvider.Manager manager) {
            return item instanceof Vehicle ? this.buildProvider((Vehicle)((Object)item), manager) : NullItemExtendedLabelProvider.instance();
        }

        private ItemExtendedLabelProvider buildProvider(Vehicle vehicle, ItemExtendedLabelProvider.Manager manager) {
            return new ModelItemExtendedLabelProvider((Object)vehicle, manager, TreeLabelProviderUiTest.buildImageDescriptorModel(vehicle), TreeLabelProviderUiTest.buildTextModel(vehicle), TreeLabelProviderUiTest.buildDescriptionModel(vehicle));
        }
    }

    static enum VehicleType {
        BICYCLE("bicycle"),
        CAR("car"),
        TRUCK("truck"),
        BOAT("boat");

        private final String description;

        private VehicleType(String description) {
            this.description = description;
        }

        public String getDescription() {
            return this.description;
        }

        public String toString() {
            return this.description;
        }
    }

    static class VehicleTypeLabelProvider
    extends BaseLabelProvider
    implements ILabelProvider {
        VehicleTypeLabelProvider() {
        }

        public Image getImage(Object element) {
            return null;
        }

        public String getText(Object element) {
            return ((VehicleType)((Object)element)).getDescription();
        }
    }
}

