/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsf.common.internal.resource;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jst.jsf.common.JSFCommonPlugin;
import org.eclipse.jst.jsf.common.internal.finder.AbstractMatcher;
import org.eclipse.jst.jsf.common.internal.finder.VisitorMatcher;
import org.eclipse.jst.jsf.common.internal.finder.acceptor.ClasspathEntryJarMatchingAcceptor;
import org.eclipse.jst.jsf.common.internal.finder.acceptor.JarMatchingAcceptor;
import org.eclipse.jst.jsf.common.internal.resource.AbstractJarLocator;
import org.eclipse.jst.jsf.common.internal.resource.ClasspathEntryLifecycleListener;
import org.eclipse.jst.jsf.common.internal.resource.ClasspathJarFile;
import org.eclipse.jst.jsf.common.internal.resource.EventResult;
import org.eclipse.jst.jsf.common.internal.resource.IClasspathLifecycleListener;
import org.eclipse.jst.jsf.common.internal.resource.IJarLocator;
import org.eclipse.jst.jsf.common.internal.resource.JavaCoreMediator;

public class DefaultJarLocator
extends AbstractJarLocator {
    private static final String DISPLAY_NAME = "Default Jar Provider";
    private static final String ID = DefaultJarLocator.class.getCanonicalName();
    private final VisitorMatcher<IProject, ClasspathJarFile, String> _matcher;
    private ClasspathEntryLifecycleListener _classpathEntryListener;
    private final JavaCoreMediator _javaCoreMediator;

    public DefaultJarLocator(JavaCoreMediator javaCoreMediator) {
        this(Collections.singletonList(new AbstractMatcher.AlwaysMatcher()), javaCoreMediator);
    }

    public DefaultJarLocator(List<? extends AbstractMatcher.IMatcher> matchers, JavaCoreMediator javaCoreMediator) {
        super(ID, DISPLAY_NAME);
        this._matcher = new VisitorMatcher<IProject, ClasspathJarFile, String>(ID, DISPLAY_NAME, new JarMatchingAcceptor(javaCoreMediator), (List<AbstractMatcher.IMatcher>)matchers);
        this._javaCoreMediator = javaCoreMediator;
        this._classpathEntryListener = new ClasspathEntryLifecycleListener(this._javaCoreMediator);
    }

    @Override
    public void start(final IProject project) {
        this._classpathEntryListener.addLifecycleObject(project);
        this._classpathEntryListener.addListener(new IClasspathLifecycleListener(){

            @Override
            public EventResult acceptEvent(IClasspathLifecycleListener.ClasspathLifecycleEvent event) {
                IJavaElement affectedElement = event.getAffectedElement();
                ArrayList<ClasspathJarFile> affectedJarFiles = new ArrayList<ClasspathJarFile>();
                if (DefaultJarLocator.this.isInteresting(project, affectedElement, event)) {
                    IJarLocator.JarChangeEvent.Type jarEventType = null;
                    switch (event.getType()) {
                        case ADDED: {
                            jarEventType = IJarLocator.JarChangeEvent.Type.JAR_ADDED;
                            affectedJarFiles.addAll(this.getChangedJars((IPackageFragmentRoot)affectedElement));
                            break;
                        }
                        case REMOVED: {
                            jarEventType = IJarLocator.JarChangeEvent.Type.JAR_REMOVED;
                            affectedJarFiles.addAll(this.getChangedJars((IPackageFragmentRoot)affectedElement));
                            break;
                        }
                        case REMOVED_DELTA: {
                            IPath path;
                            jarEventType = IJarLocator.JarChangeEvent.Type.JAR_REMOVED;
                            IResource res = event.getAffectedResource();
                            if (res.getType() != 1 || !"jar".equals(res.getFileExtension()) || (path = res.getLocation()) == null) break;
                            affectedJarFiles.add(new ClasspathJarFile(project, path));
                        }
                    }
                    if (jarEventType != null && !affectedJarFiles.isEmpty()) {
                        for (ClasspathJarFile changedJar : affectedJarFiles) {
                            DefaultJarLocator.this.fireChangeEvent(new IJarLocator.JarChangeEvent(DefaultJarLocator.this, jarEventType, changedJar));
                        }
                    }
                }
                return EventResult.getDefaultEventResult();
            }

            private Collection<? extends ClasspathJarFile> getChangedJars(IPackageFragmentRoot affectedElement) {
                try {
                    return (Collection)new VisitorMatcher<IPackageFragmentRoot, ClasspathJarFile, String>("", "", new ClasspathEntryJarMatchingAcceptor(project), (List<AbstractMatcher.IMatcher>)Collections.singletonList(new AbstractMatcher.AlwaysMatcher())).find(affectedElement);
                }
                catch (JavaModelException javaModelException) {
                    return Collections.EMPTY_LIST;
                }
                catch (Exception exception) {
                    return Collections.EMPTY_LIST;
                }
            }
        });
        super.start(project);
    }

    private boolean isInteresting(IProject project, IJavaElement affectedElement, IClasspathLifecycleListener.ClasspathLifecycleEvent event) {
        return affectedElement != null && affectedElement.getJavaProject() != null && project.equals((Object)affectedElement.getJavaProject().getProject()) && (affectedElement.getElementType() == 3 || affectedElement.getElementType() == 2 && event.getAffectedResource() != null && event.getType() == IClasspathLifecycleListener.ClasspathLifecycleEvent.Type.REMOVED_DELTA);
    }

    @Override
    public void stop() {
        this._classpathEntryListener.dispose();
        super.stop();
    }

    @Override
    protected Collection<? extends ClasspathJarFile> doLocate(IProject project) {
        try {
            return (Collection)this._matcher.find(project);
        }
        catch (Exception e) {
            JSFCommonPlugin.log(e, "While getting jars for project: " + String.valueOf(project));
            return (Collection)this.getNoResult();
        }
    }
}

