/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.ws.jaxb.core.tests;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IPackageDeclaration;
import org.eclipse.jdt.core.dom.AST;
import org.eclipse.jdt.core.dom.Annotation;
import org.eclipse.jst.ws.annotations.core.AnnotationsCore;
import org.eclipse.jst.ws.annotations.core.utils.AnnotationUtils;
import org.eclipse.jst.ws.jaxb.core.tests.AbstractAnnotationTest;
import org.eclipse.ltk.core.refactoring.Change;

public class RemoveAnnotationFromPackageTest
extends AbstractAnnotationTest {
    private static final String XML_SCHEMA_CANONICAL_NAME = "javax.xml.bind.annotation.XmlSchema";
    private static final String XML_SCHEMA_SIMPLE_NAME = "XmlSchema";

    @Override
    public String getPackageName() {
        return "com.example";
    }

    @Override
    public String getClassName() {
        return "package-info.java";
    }

    @Override
    public String getClassContents() {
        StringBuilder classContents = new StringBuilder("@XmlSchema\n\n");
        classContents.append("package com.example;\n\n");
        classContents.append("import javax.xml.bind.annotation.XmlSchema;\n\n");
        return classContents.toString();
    }

    @Override
    public Annotation getAnnotation() {
        return AnnotationsCore.createNormalAnnotation((AST)this.ast, (String)XML_SCHEMA_SIMPLE_NAME, null);
    }

    public void testRemoveAnnotationFromPackage() {
        try {
            RemoveAnnotationFromPackageTest.assertNotNull((Object)this.annotation);
            RemoveAnnotationFromPackageTest.assertEquals((String)XML_SCHEMA_SIMPLE_NAME, (String)AnnotationUtils.getAnnotationName((Annotation)this.annotation));
            IPackageDeclaration myPackage = this.source.getPackageDeclaration(this.getPackageName());
            RemoveAnnotationFromPackageTest.assertNotNull((Object)myPackage);
            RemoveAnnotationFromPackageTest.assertTrue((boolean)AnnotationUtils.isAnnotationPresent((IJavaElement)myPackage, (String)AnnotationUtils.getAnnotationName((Annotation)this.annotation)));
            this.textFileChange.addEdit(AnnotationUtils.createRemoveAnnotationTextEdit((IJavaElement)myPackage, (Annotation)this.annotation));
            this.textFileChange.addEdit(AnnotationUtils.createRemoveImportTextEdit((IJavaElement)myPackage, (String)XML_SCHEMA_CANONICAL_NAME));
            RemoveAnnotationFromPackageTest.assertTrue((boolean)this.executeChange((IProgressMonitor)new NullProgressMonitor(), (Change)this.textFileChange));
            RemoveAnnotationFromPackageTest.assertFalse((boolean)AnnotationUtils.isAnnotationPresent((IJavaElement)myPackage, (String)AnnotationUtils.getAnnotationName((Annotation)this.annotation)));
            RemoveAnnotationFromPackageTest.assertFalse((boolean)this.source.getImport(XML_SCHEMA_CANONICAL_NAME).exists());
        }
        catch (CoreException ce) {
            RemoveAnnotationFromPackageTest.fail((String)ce.getLocalizedMessage());
        }
    }
}

