/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xml.core.tests.contentmodel;

import java.io.File;
import junit.framework.TestCase;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.osgi.service.datalocation.Location;
import org.eclipse.wst.sse.core.StructuredModelManager;
import org.eclipse.wst.sse.core.internal.provisional.IModelManager;
import org.eclipse.wst.sse.core.internal.provisional.IStructuredModel;
import org.eclipse.wst.xml.core.internal.contentmodel.CMElementDeclaration;
import org.eclipse.wst.xml.core.internal.contentmodel.modelquery.ModelQuery;
import org.eclipse.wst.xml.core.internal.modelquery.ModelQueryUtil;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMDocument;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMModel;
import org.eclipse.wst.xml.core.tests.util.FileUtil;
import org.eclipse.wst.xml.core.tests.util.ProjectUnzipUtility;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class XSITypeTest
extends TestCase {
    private static final String ZIP_FILE_NAME = "xsiTestProject.zip";
    private static final String PROJECT_NAME = "TestProject";

    protected void setUp() throws Exception {
        super.setUp();
        Location platformLocation = Platform.getInstanceLocation();
        ProjectUnzipUtility unzipUtil = new ProjectUnzipUtility();
        File zipFile = FileUtil.makeFileFor("projecttestfiles", ZIP_FILE_NAME, "projecttestfiles");
        unzipUtil.unzipAndImport(zipFile, platformLocation.getURL().getFile());
        unzipUtil.initJavaProject(PROJECT_NAME);
    }

    public void testXSIType() {
        IStructuredModel structuredModel = null;
        try {
            try {
                IFile file = ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)new Path("TestProject/test.xml"));
                IModelManager modelManager = StructuredModelManager.getModelManager();
                structuredModel = modelManager.getModelForRead(file);
                IDOMDocument document = ((IDOMModel)structuredModel).getDocument();
                ModelQuery modelQuery = ModelQueryUtil.getModelQuery((Document)document);
                NodeList nodeList = null;
                CMElementDeclaration cmElementDeclaration = null;
                nodeList = document.getElementsByTagName("a");
                cmElementDeclaration = modelQuery.getCMElementDeclaration((Element)nodeList.item(0));
                XSITypeTest.assertNotNull((String)"Local XSI type failed to be resolved", (Object)cmElementDeclaration);
                nodeList = document.getElementsByTagName("b");
                cmElementDeclaration = modelQuery.getCMElementDeclaration((Element)nodeList.item(0));
                XSITypeTest.assertNotNull((String)"External XSI type failed to be resolved", (Object)cmElementDeclaration);
            }
            catch (Exception exception) {
                exception.printStackTrace();
                if (structuredModel != null) {
                    structuredModel.releaseFromRead();
                }
            }
        }
        finally {
            if (structuredModel != null) {
                structuredModel.releaseFromRead();
            }
        }
    }
}

