/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.core.tests.compiler.parser;

import org.eclipse.wst.jsdt.core.tests.compiler.parser.AbstractCompletionTest;

public class MethodInvocationCompletionTest
extends AbstractCompletionTest {
    public MethodInvocationCompletionTest(String testName) {
        super(testName);
    }

    public void test1FVVWS8_1() {
        this.runTestCheckMethodParse("function foo() {\t\t\t\t\t\t\t\n\tfor (var i = 10; i > 0; --i)\t\t\n\t\tfred(\t\t\t\t\t\t\t\n}\t\t\t\t\t\t\t\t\t\t\n", "fred(", "<CompleteOnMessageSend:fred()>", "function foo() {\n  var i;\n  <CompleteOnMessageSend:fred()>;\n}\n", "", "fred(", "<1FVVWS8_1>");
    }

    public void test1FVVWS8_2() {
        this.runTestCheckMethodParse("function foo() {\t\t\t\t\t\t\t\n\tif (true)\t\t\t\t\t\t\t\n\t\tfred(\t\t\t\t\t\t\t\n}\t\t\t\t\t\t\t\t\t\t\n", "fred(", "<CompleteOnMessageSend:fred()>", "function foo() {\n  <CompleteOnMessageSend:fred()>;\n}\n", "", "fred(", "<1FVVWS8_2>");
    }

    public void test1FW2ZTB_1() {
        this.runTestCheckMethodParse("var array = [];\t\t\t\t\t\t\t\t\t\nfunction foo() {\t\t\t\t\t\t\t\t\t\n\tfor (var i = this.array.length; i > 0; --i)\t\n\t\tfred(\t\t\t\t\t\t\t\t\t\n}\t\t\t\t\t\t\t\t\t\t\t\t\n", "fred(", "<CompleteOnMessageSend:fred()>", "var array = [];\nvoid foo() {\n  var i;\n  <CompleteOnMessageSend:fred()>;\n}\n", "", "fred(", "<1FW2ZTB_1");
    }

    public void test1FW35YZ_1() {
        this.runTestCheckMethodParse("function foo() {\t\t\t\t\t\t\t\n\tbar(primary().fred(\t\t\t\t\t\n}\t\t\t\t\t\t\t\t\t\t\n", "fred(", "<CompleteOnMessageSend:primary().fred()>", "function foo() {\n  <CompleteOnMessageSend:primary().fred()>;\n}\n", "", "fred(", "<1FW35YZ_1>");
    }

    public void test1FWYBKF() {
        this.runTestCheckMethodParse("function foo() {\t\t\t\t\t\t\t\n\t\tthis.x.bar(\t\t\t\t\t\t\n}\t\t\t\t\t\t\t\t\t\t\n", "bar(", "<CompleteOnMessageSend:this.x.bar()>", "function foo() {\n  <CompleteOnMessageSend:this.x.bar()>;\n}\n", "", "bar(", "<1FWYBKF>");
    }

    public void test1GAJBUQ() {
        this.runTestCheckMethodParse("function foo() {\t\t\t\t\t\t\t\n\tx.y.Z.fred(buzz());\t\t\t\t\t\n}\t\t\t\t\t\t\t\t\t\t\n", "fred(buzz()", "<CompleteOnMessageSend:x.y.Z.fred(buzz())>", "function foo() {\n  <CompleteOnMessageSend:x.y.Z.fred(buzz())>;\n}\n", "", "fred(buzz()", "<1GAJBUQ>");
    }

    public void testAfterFirstParameter() {
        this.runTestCheckMethodParse("function foo() {\t\t\t\t\t\t\t\n\tthis.fred(\"abc\" , 2, i);\t\t\n}\t\t\t\t\t\t\t\t\t\t\n", "fred(\"abc\" ", "<CompleteOnMessageSend:this.fred(\"abc\")>", "function foo() {\n  <CompleteOnMessageSend:this.fred(\"abc\")>;\n}\n", "", "fred(\"abc\" ", "<completion just after first parameter>");
    }

    public void testBeforeFirstParameter() {
        this.runTestCheckMethodParse("function foo() {\t\t\t\t\t\t\t\n\tthis.fred(1, 2, i);\t\t\t\t\t\n}\t\t\t\t\t\t\t\t\t\t\n", "fred(", "<CompleteOnMessageSend:this.fred()>", "function foo() {\n  <CompleteOnMessageSend:this.fred()>;\n}\n", "", "fred(", "<completion just before first parameter>");
    }

    public void testBeforeLastParameter() {
        this.runTestCheckMethodParse("function foo() {\t\t\t\t\t\t\t\n\tthis.fred(1, 2, i);\t\t\t\t\t\n}\t\t\t\t\t\t\t\t\t\t\n", "fred(1, 2,", "<CompleteOnMessageSend:this.fred(1, 2)>", "function foo() {\n  <CompleteOnMessageSend:this.fred(1, 2)>;\n}\n", "", "fred(1, 2,", "<completion just before last parameter>");
    }

    public void testBeforeSecondParameter() {
        this.runTestCheckMethodParse("function foo() {\t\t\t\t\t\t\t\n\tthis.fred(1, 2, i);\t\t\t\t\t\n}\t\t\t\t\t\t\t\t\t\t\n", "fred(1, ", "<CompleteOnMessageSend:this.fred(1)>", "function foo() {\n  <CompleteOnMessageSend:this.fred(1)>;\n}\n", "", "fred(1, ", "<completion just before second parameter>");
    }

    public void testEmptyInFirstParameter() {
        this.runTestCheckMethodParse("function foo() {\t\t\t\t\t\t\t\n\tthis.fred(\"abc\" + , 2, i);\t\t\n}\t\t\t\t\t\t\t\t\t\t\n", "fred(\"abc\" +", "<CompleteOnName:>", "function foo() {\n  (\"abc\" + <CompleteOnName:>);\n}\n", "", "", "<completion empty in first parameter>");
    }

    public void testInFirstParameter() {
        this.runTestCheckMethodParse("function foo() {\t\t\t\t\t\t\t\n\tthis.fred(\"abc\" + bizz, 2, i);\t\n}\t\t\t\t\t\t\t\t\t\t\n", "fred(\"abc\" + bi", "<CompleteOnName:bi>", "function foo() {\n  (\"abc\" + <CompleteOnName:bi>);\n}\n", "bi", "bizz", "<completion inside first parameter>");
    }

    public void testInIfStatement() {
        this.runTestCheckMethodParse("function foo() {\t\t\t\t\t\t\t\n\tif (true) {\t\t\t\t\t\t\t\n\t\tbar.fred();\t\t\t\t\t\t\n\t}\t\t\t\t\t\t\t\t\t\n}\t\t\t\t\t\t\t\t\t\t\n", "fred(", "<CompleteOnMessageSend:bar.fred()>", "function foo() {\n  {\n    <CompleteOnMessageSend:bar.fred()>;\n  }\n}\n", "", "fred(", "<completion inside a if statement>");
    }

    public void testLabeledWithExpressionReceiver() {
        this.runTestCheckMethodParse("function foo() {\t\t\t\t\t\t\t\n\tlabel1: bar().fred(1, 2, o);\t\t\n}\t\t\t\t\t\t\t\t\t\t\n", "fred(1, 2,", "<CompleteOnMessageSend:bar().fred(1, 2)>", "function foo() {\n  <CompleteOnMessageSend:bar().fred(1, 2)>;\n}\n", "", "fred(1, 2,", new String[]{"label1"}, "<completion in labeled method invocation with expression receiver>");
    }

    public void testLabeledWithoutReceiver() {
        this.runTestCheckMethodParse("function foo() {\t\t\t\t\t\t\t\n\tlabel1: fred(1, 2, o);\t\t\t\t\n}\t\t\t\t\t\t\t\t\t\t\n", "fred(1, 2,", "<CompleteOnMessageSend:fred(1, 2)>", "function foo() {\n  <CompleteOnMessageSend:fred(1, 2)>;\n}\n", "", "fred(1, 2,", new String[]{"label1"}, "<completion in labeled method invocation without receiver>");
    }

    public void testNoReceiver() {
        this.runTestCheckMethodParse("function foo() {\t\t\t\t\t\t\t\n\tfred();\t\t\t\t\t\t\t\t\n}\t\t\t\t\t\t\t\t\t\t\n", "fred(", "<CompleteOnMessageSend:fred()>", "function foo() {\n  <CompleteOnMessageSend:fred()>;\n}\n", "", "fred(", "<completion on method invocation with no receiver>");
    }

    public void testSpaceThenFirstParameter() {
        this.runTestCheckMethodParse("function foo() {\t\t\t\t\t\t\t\n\tthis.fred( 1, 2, i);\t\t\t\t\n}\t\t\t\t\t\t\t\t\t\t\n", "fred( ", "<CompleteOnMessageSend:this.fred()>", "function foo() {\n  <CompleteOnMessageSend:this.fred()>;\n}\n", "", "fred( ", "<completion just before first parameter with a space after open parenthesis>");
    }

    public void testWithExpressionReceiver() {
        this.runTestCheckMethodParse("function foo() {\t\t\t\t\t\t\t\n\tbar().fred();\t\t\t\t\t\t\n}\t\t\t\t\t\t\t\t\t\t\n", "fred(", "<CompleteOnMessageSend:bar().fred()>", "function foo() {\n  <CompleteOnMessageSend:bar().fred()>;\n}\n", "", "fred(", "<completion on method invocation with expression receiver>");
    }

    public void testWithNameReceiver() {
        this.runTestCheckMethodParse("function foo() {\t\t\t\t\t\t\t\n\tvar v = new Vector();\t\t\t\n\tv.addElement(\"1\");\t\t\t\t\n}\t\t\t\t\t\t\t\t\t\t\n", "addElement(", "<CompleteOnMessageSend:v.addElement()>", "function foo() {\n  var v = new Vector();\n  <CompleteOnMessageSend:v.addElement()>;\n}\n", "", "addElement(", "<completion with name receiver>");
    }

    public void testWithNameReceiverAfterConditionalExpression() {
        this.runTestCheckMethodParse("function foo() {\t\t\t\t\t\t\t\n\tbuzz.test(cond ? max : min);\t\t\n\tbar.fred();\t\t\t\t\t\t\t\n}\t\t\t\t\t\t\t\t\t\t\n", "fred(", "<CompleteOnMessageSend:bar.fred()>", "function foo() {\n  <CompleteOnMessageSend:bar.fred()>;\n}\n", "", "fred(", new String[0], "<completion with name receiver after conditional expression>");
    }

    public void testWithNameReceiverAndTwoArgs() {
        this.runTestCheckMethodParse("function foo() {\t\t\t\t\t\t\t\n\tvar x = new X();\t\t\t\t\t\t\n\tx.fred(1, 2, o);\t\t\t\t\t\n}\t\t\t\t\t\t\t\t\t\t\n", "x.fred(1, 2,", "<CompleteOnMessageSend:x.fred(1, 2)>", "function foo() {\n  var x = new X();\n  <CompleteOnMessageSend:x.fred(1, 2)>;\n}\n", "", "fred(1, 2,", "<completion with name receiver and 2 arguments>");
    }

    public void testWithQualifiedNameReceiver() {
        this.runTestCheckMethodParse("function foo() {\t\t\t\t\t\t\t\n\tvar x = new X();\t\t\t\t\t\t\n\ty.x.fred(1, 2, o);\t\t\t\t\t\n}\t\t\t\t\t\t\t\t\t\t\n", "x.fred(1, 2,", "<CompleteOnMessageSend:y.x.fred(1, 2)>", "function foo() {\n  var x = new X();\n  <CompleteOnMessageSend:y.x.fred(1, 2)>;\n}\n", "", "fred(1, 2,", "<completion with qualified name receiver>");
    }
}

