/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.ui;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.mapping.ResourceMapping;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IAdapterFactory;
import org.eclipse.search.ui.ISearchPageScoreComputer;
import org.eclipse.team.ui.history.IHistoryPageSource;
import org.eclipse.ui.IContainmentAdapter;
import org.eclipse.ui.IContributorResourceAdapter;
import org.eclipse.ui.IPersistableElement;
import org.eclipse.ui.ide.IContributorResourceAdapter2;
import org.eclipse.ui.model.IWorkbenchAdapter;
import org.eclipse.ui.views.properties.FilePropertySource;
import org.eclipse.ui.views.properties.IPropertySource;
import org.eclipse.ui.views.properties.ResourcePropertySource;
import org.eclipse.ui.views.tasklist.ITaskListResourceAdapter;
import org.eclipse.wst.jsdt.core.IJavaScriptElement;
import org.eclipse.wst.jsdt.core.IJavaScriptUnit;
import org.eclipse.wst.jsdt.core.IPackageFragmentRoot;
import org.eclipse.wst.jsdt.internal.corext.util.JavaElementResourceMapping;
import org.eclipse.wst.jsdt.internal.ui.IResourceLocator;
import org.eclipse.wst.jsdt.internal.ui.JavaElementContainmentAdapter;
import org.eclipse.wst.jsdt.internal.ui.JavaElementProperties;
import org.eclipse.wst.jsdt.internal.ui.JavaTaskListAdapter;
import org.eclipse.wst.jsdt.internal.ui.JavaWorkbenchAdapter;
import org.eclipse.wst.jsdt.internal.ui.PersistableJavaElementFactory;
import org.eclipse.wst.jsdt.internal.ui.ResourceLocator;
import org.eclipse.wst.jsdt.internal.ui.compare.JavaElementHistoryPageSource;
import org.eclipse.wst.jsdt.internal.ui.javaeditor.IClassFileEditorInput;
import org.eclipse.wst.jsdt.internal.ui.search.JavaSearchPageScoreComputer;
import org.eclipse.wst.jsdt.internal.ui.search.SearchUtil;

public class JavaElementAdapterFactory
implements IAdapterFactory,
IContributorResourceAdapter,
IContributorResourceAdapter2 {
    private static Class[] PROPERTIES = new Class[]{IPropertySource.class, IResource.class, IWorkbenchAdapter.class, IResourceLocator.class, IPersistableElement.class, IContributorResourceAdapter.class, IContributorResourceAdapter2.class, ITaskListResourceAdapter.class, IContainmentAdapter.class, IHistoryPageSource.class};
    private Object fSearchPageScoreComputer;
    private static IResourceLocator fgResourceLocator;
    private static JavaWorkbenchAdapter fgJavaWorkbenchAdapter;
    private static ITaskListResourceAdapter fgTaskListAdapter;
    private static JavaElementContainmentAdapter fgJavaElementContainmentAdapter;

    public Class[] getAdapterList() {
        this.updateLazyLoadedAdapters();
        return PROPERTIES;
    }

    public Object getAdapter(Object element, Class key) {
        this.updateLazyLoadedAdapters();
        IJavaScriptElement java = this.getJavaElement(element);
        if (IPropertySource.class.equals((Object)key)) {
            return this.getProperties(java);
        }
        if (IResource.class.equals((Object)key)) {
            return this.getResource(java);
        }
        if (this.fSearchPageScoreComputer != null && ISearchPageScoreComputer.class.equals((Object)key)) {
            return this.fSearchPageScoreComputer;
        }
        if (IWorkbenchAdapter.class.equals((Object)key)) {
            return JavaElementAdapterFactory.getJavaWorkbenchAdapter();
        }
        if (IResourceLocator.class.equals((Object)key)) {
            return JavaElementAdapterFactory.getResourceLocator();
        }
        if (IPersistableElement.class.equals((Object)key)) {
            return new PersistableJavaElementFactory(java);
        }
        if (IContributorResourceAdapter.class.equals((Object)key) && this.getResource(java) != null) {
            return this;
        }
        if (IContributorResourceAdapter2.class.equals((Object)key)) {
            return this;
        }
        if (ITaskListResourceAdapter.class.equals((Object)key)) {
            return JavaElementAdapterFactory.getTaskListAdapter();
        }
        if (IContainmentAdapter.class.equals((Object)key)) {
            return JavaElementAdapterFactory.getJavaElementContainmentAdapter();
        }
        if (IHistoryPageSource.class.equals((Object)key) && JavaElementHistoryPageSource.hasEdition(java)) {
            return JavaElementHistoryPageSource.getInstance();
        }
        return null;
    }

    private IResource getResource(IJavaScriptElement element) {
        switch (element.getElementType()) {
            case 7: {
                IJavaScriptElement parent = element.getParent();
                if (parent instanceof IJavaScriptUnit) {
                    return ((IJavaScriptUnit)parent).getPrimary().getResource();
                }
                return null;
            }
            case 5: {
                return ((IJavaScriptUnit)element).getPrimary().getResource();
            }
            case 4: 
            case 6: {
                IPackageFragmentRoot root = (IPackageFragmentRoot)element.getAncestor(3);
                if (!root.isArchive()) {
                    return element.getResource();
                }
                return null;
            }
            case 1: 
            case 2: 
            case 3: {
                return element.getResource();
            }
        }
        return null;
    }

    public IResource getAdaptedResource(IAdaptable adaptable) {
        IJavaScriptElement je = this.getJavaElement(adaptable);
        if (je != null) {
            return this.getResource(je);
        }
        return null;
    }

    public ResourceMapping getAdaptedResourceMapping(IAdaptable adaptable) {
        IJavaScriptElement je = this.getJavaElement(adaptable);
        if (je != null) {
            return JavaElementResourceMapping.create(je);
        }
        return null;
    }

    private IJavaScriptElement getJavaElement(Object element) {
        if (element instanceof IJavaScriptElement) {
            return (IJavaScriptElement)element;
        }
        if (element instanceof IClassFileEditorInput) {
            return ((IClassFileEditorInput)element).getClassFile().getPrimaryElement();
        }
        return null;
    }

    private IPropertySource getProperties(IJavaScriptElement element) {
        IResource resource = this.getResource(element);
        if (resource == null) {
            return new JavaElementProperties(element);
        }
        if (resource.getType() == 1) {
            return new FilePropertySource((IFile)resource);
        }
        return new ResourcePropertySource(resource);
    }

    private void updateLazyLoadedAdapters() {
        if (this.fSearchPageScoreComputer == null && SearchUtil.isSearchPlugInActivated()) {
            this.createSearchPageScoreComputer();
        }
    }

    private void createSearchPageScoreComputer() {
        this.fSearchPageScoreComputer = new JavaSearchPageScoreComputer();
        PROPERTIES = new Class[]{IPropertySource.class, IResource.class, ISearchPageScoreComputer.class, IWorkbenchAdapter.class, IResourceLocator.class, IPersistableElement.class, IProject.class, IContributorResourceAdapter.class, IContributorResourceAdapter2.class, ITaskListResourceAdapter.class, IContainmentAdapter.class};
    }

    private static IResourceLocator getResourceLocator() {
        if (fgResourceLocator == null) {
            fgResourceLocator = new ResourceLocator();
        }
        return fgResourceLocator;
    }

    private static JavaWorkbenchAdapter getJavaWorkbenchAdapter() {
        if (fgJavaWorkbenchAdapter == null) {
            fgJavaWorkbenchAdapter = new JavaWorkbenchAdapter();
        }
        return fgJavaWorkbenchAdapter;
    }

    private static ITaskListResourceAdapter getTaskListAdapter() {
        if (fgTaskListAdapter == null) {
            fgTaskListAdapter = new JavaTaskListAdapter();
        }
        return fgTaskListAdapter;
    }

    private static JavaElementContainmentAdapter getJavaElementContainmentAdapter() {
        if (fgJavaElementContainmentAdapter == null) {
            fgJavaElementContainmentAdapter = new JavaElementContainmentAdapter();
        }
        return fgJavaElementContainmentAdapter;
    }
}

