/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.core.internal.jpa2.resource.java.source;

import org.eclipse.jdt.core.dom.Annotation;
import org.eclipse.jpt.common.core.resource.java.JavaResourceModel;
import org.eclipse.jpt.common.core.utility.TextRange;
import org.eclipse.jpt.common.core.utility.jdt.AnnotatedElement;
import org.eclipse.jpt.common.core.utility.jdt.AnnotationElementAdapter;
import org.eclipse.jpt.common.core.utility.jdt.DeclarationAnnotationElementAdapter;
import org.eclipse.jpt.common.utility.internal.ObjectTools;
import org.eclipse.jpt.jpa.core.internal.resource.java.source.SourceSequenceGeneratorAnnotation;
import org.eclipse.jpt.jpa.core.jpa2.resource.java.SequenceGeneratorAnnotation2_0;

public final class SourceSequenceGeneratorAnnotation2_0
extends SourceSequenceGeneratorAnnotation
implements SequenceGeneratorAnnotation2_0 {
    private static final DeclarationAnnotationElementAdapter<String> CATALOG_ADAPTER = SourceSequenceGeneratorAnnotation2_0.buildAdapter("catalog");
    private final AnnotationElementAdapter<String> catalogAdapter = this.buildAdapter(CATALOG_ADAPTER);
    private String catalog;
    private TextRange catalogTextRange;
    private static final DeclarationAnnotationElementAdapter<String> SCHEMA_ADAPTER = SourceSequenceGeneratorAnnotation2_0.buildAdapter("schema");
    private final AnnotationElementAdapter<String> schemaAdapter = this.buildAdapter(SCHEMA_ADAPTER);
    private String schema;
    private TextRange schemaTextRange;

    public SourceSequenceGeneratorAnnotation2_0(JavaResourceModel parent, AnnotatedElement element) {
        super(parent, element);
    }

    @Override
    public void initialize(Annotation astAnnotation) {
        super.initialize(astAnnotation);
        this.catalog = this.buildCatalog(astAnnotation);
        this.catalogTextRange = this.buildCatalogTextRange(astAnnotation);
        this.schema = this.buildSchema(astAnnotation);
        this.schemaTextRange = this.buildSchemaTextRange(astAnnotation);
    }

    @Override
    public void synchronizeWith(Annotation astAnnotation) {
        super.synchronizeWith(astAnnotation);
        this.syncCatalog(this.buildCatalog(astAnnotation));
        this.catalogTextRange = this.buildCatalogTextRange(astAnnotation);
        this.syncSchema(this.buildSchema(astAnnotation));
        this.schemaTextRange = this.buildSchemaTextRange(astAnnotation);
    }

    @Override
    public boolean isUnset() {
        return super.isUnset() && this.catalog == null && this.schema == null;
    }

    @Override
    public String getCatalog() {
        return this.catalog;
    }

    @Override
    public void setCatalog(String catalog) {
        if (ObjectTools.notEquals((Object)this.catalog, (Object)catalog)) {
            this.catalog = catalog;
            this.catalogAdapter.setValue((Object)catalog);
        }
    }

    private void syncCatalog(String astCatalog) {
        String old = this.catalog;
        this.catalog = astCatalog;
        this.firePropertyChanged("catalog", old, astCatalog);
    }

    private String buildCatalog(Annotation astAnnotation) {
        return (String)this.catalogAdapter.getValue(astAnnotation);
    }

    @Override
    public TextRange getCatalogTextRange() {
        return this.catalogTextRange;
    }

    private TextRange buildCatalogTextRange(Annotation astAnnotation) {
        return this.getElementTextRange(CATALOG_ADAPTER, astAnnotation);
    }

    @Override
    public boolean catalogTouches(int pos) {
        return this.textRangeTouches(this.catalogTextRange, pos);
    }

    @Override
    public String getSchema() {
        return this.schema;
    }

    @Override
    public void setSchema(String schema) {
        if (ObjectTools.notEquals((Object)this.schema, (Object)schema)) {
            this.schema = schema;
            this.schemaAdapter.setValue((Object)schema);
        }
    }

    private void syncSchema(String astSchema) {
        String old = this.schema;
        this.schema = astSchema;
        this.firePropertyChanged("schema", old, astSchema);
    }

    private String buildSchema(Annotation astAnnotation) {
        return (String)this.schemaAdapter.getValue(astAnnotation);
    }

    @Override
    public TextRange getSchemaTextRange() {
        return this.schemaTextRange;
    }

    private TextRange buildSchemaTextRange(Annotation astAnnotation) {
        return this.getElementTextRange(SCHEMA_ADAPTER, astAnnotation);
    }

    @Override
    public boolean schemaTouches(int pos) {
        return this.textRangeTouches(this.schemaTextRange, pos);
    }
}

