/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xml.xpath2.processor.internal.types;

import java.math.BigInteger;
import org.eclipse.wst.xml.xpath2.api.Item;
import org.eclipse.wst.xml.xpath2.api.ResultBuffer;
import org.eclipse.wst.xml.xpath2.api.ResultSequence;
import org.eclipse.wst.xml.xpath2.api.typesystem.TypeDefinition;
import org.eclipse.wst.xml.xpath2.processor.DynamicError;
import org.eclipse.wst.xml.xpath2.processor.internal.types.XSNonPositiveInteger;
import org.eclipse.wst.xml.xpath2.processor.internal.types.builtin.BuiltinTypeLibrary;

public class XSNegativeInteger
extends XSNonPositiveInteger {
    private static final String XS_NEGATIVE_INTEGER = "xs:negativeInteger";

    public XSNegativeInteger() {
        this(BigInteger.valueOf(-1L));
    }

    public XSNegativeInteger(BigInteger x) {
        super(x);
    }

    @Override
    public String string_type() {
        return XS_NEGATIVE_INTEGER;
    }

    @Override
    public String type_name() {
        return "negativeInteger";
    }

    @Override
    public ResultSequence constructor(ResultSequence arg) throws DynamicError {
        if (arg.empty()) {
            return ResultBuffer.EMPTY;
        }
        Item aat = arg.first();
        try {
            BigInteger bigInt = new BigInteger(aat.getStringValue());
            BigInteger max = BigInteger.valueOf(-1L);
            if (bigInt.compareTo(max) > 0) {
                throw DynamicError.cant_cast(null);
            }
            return new XSNegativeInteger(bigInt);
        }
        catch (NumberFormatException numberFormatException) {
            throw DynamicError.cant_cast(null);
        }
    }

    @Override
    public TypeDefinition getTypeDefinition() {
        return BuiltinTypeLibrary.XS_NEGATIVEINTEGER;
    }
}

