/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.chromium.debug.js.launch;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.model.ILaunchConfigurationDelegate;
import org.eclipse.debug.core.model.IProcess;
import org.eclipse.osgi.util.NLS;
import org.eclipse.wst.jsdt.chromium.debug.js.Messages;
import org.eclipse.wst.jsdt.chromium.debug.js.launchers.WIPLauncher;
import org.eclipse.wst.jsdt.chromium.debug.js.util.ChromiumUtil;
import org.eclipse.wst.jsdt.chromium.debug.js.util.LaunchConfigurationUtil;
import org.eclipse.wst.jsdt.chromium.debug.js.util.WorbenchResourceUtil;
import org.eclipse.wst.jsdt.core.runtime.IJSRunner;
import org.eclipse.wst.jsdt.core.runtime.JSRunnerConfiguration;
import org.eclipse.wst.jsdt.launching.ExecutionArguments;

public class ChromiumLaunchConfigurationDelegate
implements ILaunchConfigurationDelegate {
    public void launch(ILaunchConfiguration configuration, String mode, ILaunch launch, IProgressMonitor monitor) throws CoreException {
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        monitor.beginTask(NLS.bind((String)"{0}...", (Object[])new String[]{configuration.getName()}), 3);
        if (monitor.isCanceled()) {
            return;
        }
        String projectName = configuration.getAttribute("attr_app_project", null);
        String resourceRelativePath = configuration.getAttribute("attr_app_project_relative_path", null);
        String url = configuration.getAttribute("attr_chromium_url", null);
        String debugContainerUrl = configuration.getAttribute("attr_base_url", null);
        int port = Integer.parseInt(configuration.getAttribute("debug_port", String.valueOf(9222)));
        try {
            IProject project = WorbenchResourceUtil.getProject(projectName);
            IJSRunner runner = LaunchConfigurationUtil.getJSRunner(configuration, mode);
            if (runner == null) {
                throw new CoreException((IStatus)new Status(4, "org.eclipse.wst.jsdt.chromium.debug.js", Messages.LAUNCH_CONFIGURATION_NO_RUNNER_FOUND_ERROR));
            }
            String[] envp = LaunchConfigurationUtil.getEnvironment(configuration);
            String pgmArgs = LaunchConfigurationUtil.getProgramArguments(configuration);
            String chromiumArgs = LaunchConfigurationUtil.getChromiumArguments(configuration);
            if (mode.equals("debug")) {
                chromiumArgs = String.valueOf(chromiumArgs) + "--remote-debugging-port=" + port + " ";
                chromiumArgs = String.valueOf(chromiumArgs) + "--user-data-dir=" + ChromiumUtil.getChromiumUserDataDir() + " ";
                chromiumArgs = String.valueOf(chromiumArgs) + "--disable-component-extensions-with-background-pages ";
                chromiumArgs = String.valueOf(chromiumArgs) + url;
            }
            ExecutionArguments execArgs = new ExecutionArguments(chromiumArgs, pgmArgs);
            JSRunnerConfiguration runConfig = new JSRunnerConfiguration(project.getLocation().toOSString());
            runConfig.setProgramArguments(execArgs.getProgramArgumentsArray());
            runConfig.setEnvironment(envp);
            runConfig.setJSRuntimeArguments(execArgs.getVMArgumentsArray());
            runConfig.setWorkingDirectory(project.getLocation().toOSString());
            if (monitor.isCanceled()) {
                return;
            }
            monitor.worked(1);
            IProcess chromiumProcess = runner.run(runConfig, launch, monitor);
            if (chromiumProcess == null) {
                return;
            }
            WIPLauncher.launch(project, resourceRelativePath, debugContainerUrl, port);
        }
        finally {
            monitor.done();
        }
    }
}

