/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.pagedesigner.dnd.internal;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.RectangleFigure;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw2d.geometry.Translatable;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.editpolicies.GraphicalEditPolicy;
import org.eclipse.jst.pagedesigner.dnd.FeedBackInfo;
import org.eclipse.jst.pagedesigner.dnd.ILocalDropHandler;
import org.eclipse.jst.pagedesigner.dnd.LocalDropRequest;
import org.eclipse.jst.pagedesigner.dnd.internal.LocalDropCommand;
import org.eclipse.jst.pagedesigner.dnd.internal.RegistryReader;
import org.eclipse.jst.pagedesigner.dom.DOMPositionHelper;
import org.eclipse.jst.pagedesigner.dom.IDOMPosition;
import org.eclipse.jst.pagedesigner.editpolicies.LocationHelper;
import org.eclipse.jst.pagedesigner.parts.ElementEditPart;
import org.eclipse.jst.pagedesigner.parts.NodeEditPart;
import org.eclipse.jst.pagedesigner.tools.ExposeHelper;
import org.eclipse.jst.pagedesigner.validation.caret.ActionData;
import org.eclipse.jst.pagedesigner.validation.caret.DnDPositionValidator;
import org.eclipse.jst.pagedesigner.viewer.DesignPosition;
import org.eclipse.jst.pagedesigner.viewer.EditPartPositionHelper;
import org.eclipse.jst.pagedesigner.viewer.IHTMLGraphicalViewer;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMNode;
import org.w3c.dom.Node;

public class LocalDropEditPolicy
extends GraphicalEditPolicy {
    private RectangleFigure _feedbackFigure;
    private static boolean _checkUpdate = true;

    public boolean checkUpdateWidget(EditPart widgetEditPart, LocalDropRequest request, Map results) {
        if (!(widgetEditPart instanceof ElementEditPart)) {
            return false;
        }
        IDOMNode widget = ((ElementEditPart)widgetEditPart).getIDOMNode();
        ILocalDropHandler[] handlers = RegistryReader.getAllHandlers();
        Object localData = request.getLocalObject();
        int i = 0;
        while (i < handlers.length) {
            FeedBackInfo feedback = handlers[i].supportUpdateWidget(localData, (Node)widget);
            if (feedback != null) {
                results.put(feedback, handlers[i]);
            }
            ++i;
        }
        return !results.isEmpty();
    }

    public boolean checkInsertElement(LocalDropRequest request, EditPart[] host, Map results, DesignPosition[] dpHolder, IDOMPosition[] position) {
        DesignPosition designPosition;
        dpHolder[0] = designPosition = EditPartPositionHelper.findEditPartPosition(host[0], request.getLocation(), new DnDPositionValidator(new ActionData(2, (Object)request)));
        if (designPosition == null) {
            return false;
        }
        host[0] = designPosition.getContainerPart();
        position[0] = DOMPositionHelper.toDOMPosition(designPosition);
        ILocalDropHandler[] handlers = RegistryReader.getAllHandlers();
        Object localData = request.getLocalObject();
        int i = 0;
        while (i < handlers.length) {
            FeedBackInfo feedback = handlers[i].supportInsertElements(localData, position[0]);
            if (feedback != null) {
                results.put(feedback, handlers[i]);
            }
            ++i;
        }
        return !results.isEmpty();
    }

    public EditPart getTargetEditPart(Request request) {
        if (request instanceof LocalDropRequest) {
            LocalDropRequest r = (LocalDropRequest)request;
            GraphicalEditPart host = this.getHost();
            if (_checkUpdate && this.checkUpdateWidget((EditPart)host, r, new HashMap())) {
                return host;
            }
            EditPart[] hostHolder = new EditPart[]{host};
            if (this.checkInsertElement(r, hostHolder, new HashMap(), new DesignPosition[1], new IDOMPosition[1])) {
                return hostHolder[0];
            }
        }
        return null;
    }

    public Command getCommand(Request request) {
        if (request instanceof LocalDropRequest) {
            LocalDropRequest r = (LocalDropRequest)request;
            GraphicalEditPart host = this.getHost();
            HashMap result = new HashMap();
            if (_checkUpdate && this.checkUpdateWidget((EditPart)host, r, result)) {
                LocalDropCommand command = new LocalDropCommand(this.getViewer((EditPart)host), r.getLocalObject(), result);
                command.setWidget((Node)((NodeEditPart)host).getIDOMNode());
                return command;
            }
            result.clear();
            EditPart[] hostHolder = new EditPart[]{host};
            IDOMPosition[] positionHolder = new IDOMPosition[1];
            if (this.checkInsertElement(r, hostHolder, result, new DesignPosition[1], positionHolder)) {
                LocalDropCommand command = new LocalDropCommand(this.getViewer((EditPart)host), r.getLocalObject(), result);
                command.setDOMPosition(positionHolder[0]);
                return command;
            }
        }
        return null;
    }

    private IHTMLGraphicalViewer getViewer(EditPart host) {
        return (IHTMLGraphicalViewer)((GraphicalEditPart)host).getViewer();
    }

    public void eraseTargetFeedback(Request request) {
        if (this._feedbackFigure != null) {
            this.removeFeedback((IFigure)this._feedbackFigure);
            this._feedbackFigure = null;
        }
    }

    public void showTargetFeedback(Request request) {
        if (request instanceof LocalDropRequest) {
            LocalDropRequest r = (LocalDropRequest)request;
            GraphicalEditPart host = this.getHost();
            if (_checkUpdate && this.checkUpdateWidget((EditPart)host, r, new HashMap())) {
                Rectangle rect = LocationHelper.getAbsoluteBounds(host);
                this.showFeedbackRect(rect);
                return;
            }
            EditPart[] hostHolder = new EditPart[]{host};
            DesignPosition[] holder = new DesignPosition[1];
            if (this.checkInsertElement(r, hostHolder, new HashMap(), holder, new IDOMPosition[1])) {
                Rectangle rect = EditPartPositionHelper.convertToAbsoluteCaretRect(holder[0]);
                this.showFeedbackRect(rect);
                if (this.getHost() instanceof GraphicalEditPart) {
                    ExposeHelper exposeHelper = new ExposeHelper(this.getViewer((EditPart)this.getHost()));
                    exposeHelper.adjustVertical(r.getLocation());
                }
                return;
            }
        }
    }

    protected RectangleFigure getFeedbackFigure() {
        if (this._feedbackFigure == null) {
            this._feedbackFigure = new RectangleFigure();
            this._feedbackFigure.setFill(true);
            this._feedbackFigure.setOutline(true);
            this._feedbackFigure.setLineWidth(1);
            this._feedbackFigure.setForegroundColor(ColorConstants.red);
            this._feedbackFigure.setBounds(new Rectangle(0, 0, 0, 0));
            this._feedbackFigure.setXOR(true);
            this.addFeedback((IFigure)this._feedbackFigure);
        }
        return this._feedbackFigure;
    }

    protected void showFeedbackRect(Rectangle rect) {
        RectangleFigure pf = this.getFeedbackFigure();
        pf.translateToRelative((Translatable)rect);
        pf.setBounds(rect);
    }

    public static boolean isCheckUpdate() {
        return _checkUpdate;
    }

    public static void setCheckUpdate(boolean update) {
        _checkUpdate = update;
    }
}

