/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.common.project.facet.ui.libprov.internal;

import java.util.ArrayList;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jst.common.project.facet.core.libprov.ILibraryProvider;
import org.eclipse.jst.common.project.facet.core.libprov.LibraryInstallDelegate;
import org.eclipse.jst.common.project.facet.core.libprov.LibraryProviderActionType;
import org.eclipse.jst.common.project.facet.core.libprov.LibraryProviderFramework;
import org.eclipse.jst.common.project.facet.core.libprov.internal.LibraryProviderFrameworkImpl;
import org.eclipse.jst.common.project.facet.ui.libprov.LibraryProviderOperationPanel;
import org.eclipse.jst.common.project.facet.ui.libprov.internal.LibraryInstallPanel;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.wst.common.project.facet.core.util.internal.PluginUtil;

public final class LibraryProviderFrameworkUiImpl {
    private static final String EXTENSION_POINT_ID = "libraryProviderActionPanels";
    private static final String EL_PANEL = "panel";
    private static final String ATTR_CLASS = "class";
    private static final String ATTR_PROVIDER = "provider";
    private static LibraryProviderFrameworkUiImpl instance = null;
    private final Map<ILibraryProvider, Map<LibraryProviderActionType, PanelDef>> panels = new HashMap<ILibraryProvider, Map<LibraryProviderActionType, PanelDef>>();

    public LibraryProviderFrameworkUiImpl() {
        this.readExtensions();
    }

    public static synchronized LibraryProviderFrameworkUiImpl get() {
        if (instance == null) {
            instance = new LibraryProviderFrameworkUiImpl();
        }
        return instance;
    }

    public Control createInstallLibraryPanel(Composite parent, LibraryInstallDelegate delegate, String label) {
        return new LibraryInstallPanel(parent, delegate, label);
    }

    public LibraryProviderOperationPanel getOperationPanel(ILibraryProvider provider, LibraryProviderActionType actionType) {
        ILibraryProvider prov = provider;
        PanelDef panelDef = null;
        while (prov != null && panelDef == null) {
            Map<LibraryProviderActionType, PanelDef> providerPanelDefs = this.panels.get(prov);
            if (providerPanelDefs != null) {
                panelDef = providerPanelDefs.get(actionType);
            }
            prov = prov.getBaseProvider();
        }
        if (panelDef == null) {
            return null;
        }
        Class<LibraryProviderOperationPanel> panelClass = panelDef.getPanelClass();
        if (panelClass == null) {
            return null;
        }
        return (LibraryProviderOperationPanel)PluginUtil.instantiate((String)panelDef.getPluginId(), panelClass);
    }

    private void readExtensions() {
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IExtensionPoint point = registry.getExtensionPoint("org.eclipse.jst.common.project.facet.ui", EXTENSION_POINT_ID);
        if (point == null) {
            throw new IllegalStateException();
        }
        ArrayList<IConfigurationElement> cfgels = new ArrayList<IConfigurationElement>();
        IExtension[] iExtensionArray = point.getExtensions();
        int n = iExtensionArray.length;
        int n2 = 0;
        while (n2 < n) {
            IExtension extension = iExtensionArray[n2];
            IConfigurationElement[] iConfigurationElementArray = extension.getConfigurationElements();
            int n3 = iConfigurationElementArray.length;
            int n4 = 0;
            while (n4 < n3) {
                IConfigurationElement element = iConfigurationElementArray[n4];
                cfgels.add(element);
                ++n4;
            }
            ++n2;
        }
        for (IConfigurationElement element : cfgels) {
            if (!element.getName().equals(EL_PANEL)) continue;
            try {
                String pluginId = element.getContributor().getName();
                String providerId = PluginUtil.findRequiredAttribute((IConfigurationElement)element, (String)ATTR_PROVIDER);
                if (!LibraryProviderFramework.isProviderDefined((String)providerId)) {
                    LibraryProviderFrameworkImpl.reportProviderNotDefined((String)providerId, (String)pluginId);
                    throw new PluginUtil.InvalidExtensionException();
                }
                ILibraryProvider provider = LibraryProviderFramework.getProvider((String)providerId);
                String panelClassName = PluginUtil.findRequiredAttribute((IConfigurationElement)element, (String)ATTR_CLASS);
                PanelDef panelDef = new PanelDef(pluginId, panelClassName);
                Map<LibraryProviderActionType, PanelDef> providerPanelDefs = this.panels.get(provider);
                if (providerPanelDefs == null) {
                    providerPanelDefs = new EnumMap<LibraryProviderActionType, PanelDef>(LibraryProviderActionType.class);
                    this.panels.put(provider, providerPanelDefs);
                }
                providerPanelDefs.put(LibraryProviderActionType.INSTALL, panelDef);
            }
            catch (PluginUtil.InvalidExtensionException invalidExtensionException) {}
        }
    }

    private static final class PanelDef {
        private final String pluginId;
        private final String className;
        private Class<LibraryProviderOperationPanel> panelClass;

        public PanelDef(String pluginId, String className) {
            this.pluginId = pluginId;
            this.className = className;
            this.panelClass = null;
        }

        public String getPluginId() {
            return this.pluginId;
        }

        public synchronized Class<LibraryProviderOperationPanel> getPanelClass() {
            if (this.panelClass == null) {
                this.panelClass = PluginUtil.loadClass((String)this.pluginId, (String)this.className);
            }
            return this.panelClass;
        }
    }
}

