/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.pagedesigner.editors.palette.impl;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.util.ArrayList;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.eclipse.jst.jsf.common.ui.internal.logging.Logger;
import org.eclipse.jst.pagedesigner.PDPlugin;
import org.eclipse.jst.pagedesigner.editors.palette.MetadataTagDropSourceData;
import org.eclipse.jst.pagedesigner.utils.JSPUtil;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMModel;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMText;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;
import org.xml.sax.SAXException;

public class PaletteElementTemplateHelper {
    private static final String PREFIX_ATTRIBUTE = "_uri_";

    public static void applyTemplate(IDOMModel model, Element element, MetadataTagDropSourceData creationProvider) {
        if (element == null || element.getLocalName() == null) {
            return;
        }
        Node[] templateNodes = PaletteElementTemplateHelper.getTemplateNodes(model, creationProvider);
        if (templateNodes != null) {
            int i = 0;
            while (i < templateNodes.length) {
                Node anode = templateNodes[i];
                element.appendChild(anode);
                ++i;
            }
        }
    }

    private static Node[] getTemplateNodes(IDOMModel model, MetadataTagDropSourceData creationProvider) {
        if (creationProvider == null) {
            return null;
        }
        String template = creationProvider.getTemplate();
        if (template != null) {
            String nodeStr = PaletteElementTemplateHelper.prepareNode(template);
            Logger logger = PDPlugin.getLogger(PaletteElementTemplateHelper.class);
            try {
                DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
                factory.setNamespaceAware(true);
                factory.setValidating(false);
                DocumentBuilder builder = factory.newDocumentBuilder();
                Document doc = builder.parse(new ByteArrayInputStream(nodeStr.getBytes()));
                Node beginNode = doc.getFirstChild();
                Node templateNode = beginNode.cloneNode(true);
                Node[] templateNodes = PaletteElementTemplateHelper.applyPrefixes(model, templateNode.getChildNodes(), (Document)model.getDocument());
                return templateNodes;
            }
            catch (ParserConfigurationException e) {
                logger.error((Throwable)e);
            }
            catch (SAXException e) {
                logger.error((Throwable)e);
            }
            catch (IOException e) {
                logger.error((Throwable)e);
            }
            catch (Exception e) {
                logger.error((Throwable)e);
            }
        }
        return null;
    }

    private static String prepareNode(String template) {
        StringBuffer buf = new StringBuffer("<begin>");
        buf.append(template);
        buf.append("</begin>");
        return buf.toString();
    }

    public static Node[] applyPrefixes(IDOMModel model, NodeList templateNodes, Document document) {
        ArrayList<Node> result = new ArrayList<Node>();
        int i = 0;
        int n = templateNodes.getLength();
        while (i < n) {
            Node node = PaletteElementTemplateHelper.cloneNodeDeep(model, document, templateNodes.item(i));
            if (node instanceof Element) {
                result.add(node);
            }
            ++i;
        }
        return result.toArray(new Node[result.size()]);
    }

    private static void internalApplyPrefixes(IDOMModel model, Element refNode, Element node) {
        String uri;
        if (node != null && refNode != null && (uri = refNode.getAttribute(PREFIX_ATTRIBUTE)) != null) {
            String prefix = JSPUtil.getOrCreatePrefix(model, uri, null);
            node.setPrefix(prefix);
        }
    }

    public static Node cloneNodeDeep(IDOMModel model, Document destDoc, Node sourceNode) {
        switch (sourceNode.getNodeType()) {
            case 1: {
                Element sourceEle = (Element)sourceNode;
                Element resultEle = destDoc.createElement(sourceEle.getTagName());
                PaletteElementTemplateHelper.internalApplyPrefixes(model, sourceEle, resultEle);
                NamedNodeMap attrs = sourceEle.getAttributes();
                int i = 0;
                int size = attrs.getLength();
                while (i < size) {
                    Attr a = (Attr)attrs.item(i);
                    if (!PREFIX_ATTRIBUTE.equalsIgnoreCase(a.getNodeName())) {
                        resultEle.setAttribute(a.getName(), a.getValue());
                    }
                    ++i;
                }
                NodeList children = sourceEle.getChildNodes();
                int i2 = 0;
                int size2 = children.getLength();
                while (i2 < size2) {
                    Node n = children.item(i2);
                    Node d = PaletteElementTemplateHelper.cloneNodeDeep(model, destDoc, n);
                    if (d != null) {
                        resultEle.appendChild(d);
                    }
                    ++i2;
                }
                return resultEle;
            }
            case 3: {
                Text txt = destDoc.createTextNode(sourceNode.getNodeValue());
                if (txt instanceof IDOMText && sourceNode instanceof IDOMText) {
                    try {
                        ((IDOMText)txt).setSource(((IDOMText)sourceNode).getSource());
                    }
                    catch (Exception exception) {}
                }
                return txt;
            }
            case 4: {
                return destDoc.createCDATASection(sourceNode.getNodeValue());
            }
        }
        return null;
    }
}

