/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.j2ee.internal.ejb.provider;

import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.jst.j2ee.ejb.AssemblyDescriptor;
import org.eclipse.jst.j2ee.ejb.CMPAttribute;
import org.eclipse.jst.j2ee.ejb.EJBJar;
import org.eclipse.jst.j2ee.ejb.EnterpriseBean;
import org.eclipse.jst.j2ee.ejb.MethodPermission;
import org.eclipse.jst.j2ee.ejb.internal.impl.EjbFactoryImpl;
import org.eclipse.jst.j2ee.internal.ejb.provider.AbstractMethodsContentProvider;

public class MethodPermissionsContentProvider
extends AbstractMethodsContentProvider {
    private static final EStructuralFeature PERMISSION_MES_SF = EjbFactoryImpl.getPackage().getMethodPermission_MethodElements();
    private static final EStructuralFeature PERMISSION_MES_UNCHECKED_SF = EjbFactoryImpl.getPackage().getMethodPermission_Unchecked();
    private static final EStructuralFeature PERMISSION_MES_ROLES_SF = EjbFactoryImpl.getPackage().getMethodPermission_Roles();
    private static final EStructuralFeature AD_MP_SF = EjbFactoryImpl.getPackage().getAssemblyDescriptor_MethodPermissions();

    public MethodPermissionsContentProvider(AdapterFactory adapterFactory, boolean root) {
        super(adapterFactory, root);
    }

    public MethodPermissionsContentProvider(AdapterFactory adapterFactory) {
        super(adapterFactory);
    }

    @Override
    public Object[] getChildren(Object parentElement) {
        if (parentElement instanceof MethodPermission) {
            return this.getEnterpriseBeans((MethodPermission)parentElement);
        }
        return super.getChildren(parentElement);
    }

    protected Object[] getEnterpriseBeans(MethodPermission mp) {
        EList mes = mp.getMethodElements();
        return this.getEnterpriseBeans((EObject)mp, (List)mes);
    }

    @Override
    protected List getMethodElements(EObject aRefObject, EnterpriseBean anEJB) {
        if (aRefObject == null || !(aRefObject instanceof MethodPermission)) {
            return Collections.EMPTY_LIST;
        }
        MethodPermission parentMP = (MethodPermission)aRefObject;
        return parentMP.getMethodElements(anEJB);
    }

    public Object[] getElements(Object inputElement) {
        EJBJar jar;
        super.getElements(inputElement);
        if (inputElement instanceof EJBJar && (jar = (EJBJar)inputElement).getAssemblyDescriptor() != null) {
            return jar.getAssemblyDescriptor().getMethodPermissions().toArray();
        }
        if (inputElement instanceof AssemblyDescriptor) {
            return ((AssemblyDescriptor)inputElement).getMethodPermissions().toArray();
        }
        return new Object[0];
    }

    @Override
    public boolean hasChildren(Object element) {
        if (element instanceof MethodPermission) {
            return !((MethodPermission)element).getMethodElements().isEmpty();
        }
        return super.hasChildren(element);
    }

    @Override
    protected EStructuralFeature getMethodElementsReference() {
        return PERMISSION_MES_SF;
    }

    @Override
    protected EStructuralFeature getMethodElementsContainerReference() {
        return AD_MP_SF;
    }

    @Override
    public void notifyChanged(Notification notification) {
        if (notification.getFeature() == PERMISSION_MES_SF || notification.getFeature() == AD_MP_SF) {
            this.refreshTreeViewer();
        } else if (notification.getOldValue() instanceof CMPAttribute && notification.getNewValue() == null) {
            return;
        }
        if (notification.getFeature() == PERMISSION_MES_UNCHECKED_SF || notification.getFeature() == PERMISSION_MES_ROLES_SF || notification.getFeature() == this.getMethodElementsReference() || notification.getFeature() == this.getMethodElementsContainerReference()) {
            super.notifyChanged(notification);
        }
    }
}

