/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.chromium.debug.core.internal.sourcemap;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.wst.jsdt.chromium.debug.core.internal.sourcemap.SourceMapInfo;
import org.eclipse.wst.jsdt.chromium.debug.core.internal.sourcemap.SourceMapInfoEntry;
import org.eclipse.wst.jsdt.chromium.debug.core.internal.sourcemap.VlqDecoder;

class SourceMapDecoder {
    private String[] sources;
    private String[] names;
    private List<SourceMapInfoEntry> entries;
    int originalFileIndex = 0;
    int originalLine = 0;
    int originalColumn = 0;
    int nameIndex = 0;

    public static List<SourceMapInfoEntry> decode(String[] sources, String[] names, String mappings) {
        return new SourceMapDecoder(sources, names).decodeLines(mappings);
    }

    private SourceMapDecoder(String[] sources, String[] names) {
        this.sources = sources;
        this.names = names;
    }

    List<SourceMapInfoEntry> decodeLines(String mapStr) {
        this.entries = new ArrayList<SourceMapInfoEntry>();
        int lineNumber = 0;
        String[] stringArray = mapStr.split(";");
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String line = stringArray[n2];
            if (line.length() > 0) {
                this.decodeLine(line.split(","), lineNumber);
            }
            ++lineNumber;
            ++n2;
        }
        return this.entries;
    }

    private void decodeLine(String[] mappings, int line) {
        int generatedColumn = 0;
        SourceMapInfoEntry previousEntry = null;
        String[] stringArray = mappings;
        int n = mappings.length;
        int n2 = 0;
        while (n2 < n) {
            String mapping = stringArray[n2];
            int[] indexes = VlqDecoder.decode(mapping);
            if (indexes.length == 1 || indexes.length == 4 || indexes.length == 5) {
                generatedColumn += indexes[0];
                if (previousEntry != null) {
                    previousEntry.setEndColumn(generatedColumn);
                }
                if (indexes.length >= 4) {
                    this.originalFileIndex += indexes[1];
                    this.originalLine += indexes[2];
                    this.originalColumn += indexes[3];
                    String originalFile = this.getString(this.sources, this.originalFileIndex);
                    SourceMapInfo info = new SourceMapInfo(originalFile, this.originalLine, this.originalColumn);
                    if (indexes.length > 4) {
                        this.nameIndex += indexes[4];
                        info.setName(this.getString(this.names, this.nameIndex));
                    }
                    previousEntry = new SourceMapInfoEntry(line, generatedColumn, info);
                    this.entries.add(previousEntry);
                }
            }
            ++n2;
        }
    }

    private String getString(String[] strs, int index) {
        if (index >= 0 && index < strs.length) {
            return strs[index];
        }
        return null;
    }
}

