/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.core.dom.flatten;

import java.util.List;
import org.eclipse.wst.jsdt.core.dom.flatten.IJsCodeElementFactory;
import org.eclipse.wst.jsdt.core.dom.flatten.JsCodeIRGenerator;
import org.eclipse.wst.jsdt.core.dom.flatten.JsCodeOutputStream;

public class JsCodeElementFactory
implements IJsCodeElementFactory {
    private static JsCodeIRGenerator.JsCodeElement[] EMPTY_SEQ = new JsCodeIRGenerator.JsCodeElement[0];
    private static Semi semicolon = new Semi();
    private static SemiOpt optionalSemicolon = new SemiOpt();

    @Override
    public JsCodeIRGenerator.JsCodeElement token(String token) {
        return new Token(token);
    }

    @Override
    public JsCodeIRGenerator.JsCodeElement semi() {
        return semicolon;
    }

    @Override
    public JsCodeIRGenerator.JsCodeElement semiOpt() {
        return optionalSemicolon;
    }

    @Override
    public JsCodeIRGenerator.JsCodeElement wrap(String start, JsCodeIRGenerator.JsCodeElement element, String end) {
        return new Wrapper(start, element, end);
    }

    @Override
    public JsCodeIRGenerator.JsCodeElement paren(JsCodeIRGenerator.JsCodeElement element) {
        return new Parens(element);
    }

    @Override
    public JsCodeIRGenerator.JsCodeElement brack(JsCodeIRGenerator.JsCodeElement element) {
        return new Brackets(element);
    }

    @Override
    public JsCodeIRGenerator.JsCodeElement braces(JsCodeIRGenerator.JsCodeElement element) {
        return new Braces(element);
    }

    @Override
    public JsCodeIRGenerator.JsCodeElement seq(JsCodeIRGenerator.JsCodeElement[] elements) {
        return new Sequence(elements);
    }

    @Override
    public JsCodeIRGenerator.JsCodeElement seq(List<JsCodeIRGenerator.JsCodeElement> elements) {
        return new Sequence(elements.toArray(EMPTY_SEQ));
    }

    @Override
    public JsCodeIRGenerator.JsCodeElement seqCs(JsCodeIRGenerator.JsCodeElement[] elements) {
        return new SequenceCs(elements);
    }

    @Override
    public JsCodeIRGenerator.JsCodeElement seqCs(List<JsCodeIRGenerator.JsCodeElement> elements) {
        return new SequenceCs(elements.toArray(EMPTY_SEQ));
    }

    @Override
    public JsCodeIRGenerator.JsCodeElement seqRaw(List<JsCodeIRGenerator.JsCodeElement> elements) {
        return new SequenceRaw(elements.toArray(EMPTY_SEQ));
    }

    public static class Braces
    extends Wrapper {
        public Braces(JsCodeIRGenerator.JsCodeElement element) {
            super("{", element, "}");
        }
    }

    public class Brackets
    extends Wrapper {
        public Brackets(JsCodeIRGenerator.JsCodeElement element) {
            super("[", element, "]");
        }
    }

    public static class Parens
    extends Wrapper {
        public Parens(JsCodeIRGenerator.JsCodeElement element) {
            super("(", element, ")");
        }
    }

    public static class Semi
    extends JsCodeIRGenerator.JsCodeElement {
        @Override
        public void emit(JsCodeOutputStream out) {
            out.writeSemicolon();
        }
    }

    public static class SemiOpt
    extends JsCodeIRGenerator.JsCodeElement {
        @Override
        public void emit(JsCodeOutputStream out) {
            out.writeOptionalSemicolon();
        }
    }

    public class Sequence
    extends JsCodeIRGenerator.JsCodeElement {
        public final JsCodeIRGenerator.JsCodeElement[] elements;

        public Sequence(JsCodeIRGenerator.JsCodeElement[] elements) {
            this.elements = elements;
        }

        @Override
        public void emit(JsCodeOutputStream out) {
            JsCodeIRGenerator.JsCodeElement[] jsCodeElementArray = this.elements;
            int n = this.elements.length;
            int n2 = 0;
            while (n2 < n) {
                JsCodeIRGenerator.JsCodeElement element = jsCodeElementArray[n2];
                if (element != null) {
                    element.emit(out);
                }
                ++n2;
            }
        }
    }

    public class SequenceCs
    extends Sequence {
        public SequenceCs(JsCodeIRGenerator.JsCodeElement[] elements) {
            super(elements);
        }

        @Override
        public void emit(JsCodeOutputStream out) {
            int i = 0;
            int e = this.elements.length;
            while (i < e && this.elements[i] == null) {
                ++i;
            }
            if (i < e) {
                this.elements[i++].emit(out);
                while (i < e) {
                    if (this.elements[i] != null) {
                        out.write(",");
                        this.elements[i].emit(out);
                    }
                    ++i;
                }
            }
        }
    }

    public class SequenceRaw
    extends Sequence {
        public SequenceRaw(JsCodeIRGenerator.JsCodeElement[] elements) {
            super(elements);
        }

        @Override
        public void emit(JsCodeOutputStream out) {
            out.setRawMode();
            super.emit(out);
            out.unsetRawMode();
        }
    }

    public static class Token
    extends JsCodeIRGenerator.JsCodeElement {
        private final String token;

        public Token(String token) {
            this.token = token;
        }

        @Override
        public void emit(JsCodeOutputStream out) {
            out.write(this.token);
        }
    }

    public static class Wrapper
    extends JsCodeIRGenerator.JsCodeElement {
        private final JsCodeIRGenerator.JsCodeElement element;
        private final String start;
        private final String end;

        public Wrapper(String start, JsCodeIRGenerator.JsCodeElement element, String end) {
            this.start = start;
            this.element = element;
            this.end = end;
        }

        @Override
        public void emit(JsCodeOutputStream out) {
            out.write(this.start);
            this.element.emit(out);
            out.write(this.end);
        }
    }
}

