/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsf.facesconfig.ui.test;

import junit.framework.TestCase;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jst.jsf.facesconfig.ui.FacesConfigEditor;
import org.eclipse.jst.jsf.facesconfig.ui.test.util.TestUtil;
import org.eclipse.jst.jsf.test.util.JSFTestUtil;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.FileEditorInput;

public class OpenADFDemoFacesConfigTest
extends TestCase {
    IProject project;
    FacesConfigEditor editor;

    protected void setUp() throws Exception {
        super.setUp();
        JSFTestUtil.setInternetProxyPreferences((boolean)true, (String)"www-proxy.us.oracle.com", (String)"80");
        this.project = TestUtil.createProjectFromZip("adfDemoProject", "adfDemoProject.zip");
    }

    protected void tearDown() throws Exception {
        super.tearDown();
        PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().closeEditor((IEditorPart)this.editor, false);
        this.project.close(null);
    }

    public void testOpenFacesConfigFile() throws CoreException, InterruptedException {
        Path filePath = new Path("WebContent/WEB-INF/faces-config.xml");
        IFile facesConfigFile = this.project.getFile((IPath)filePath);
        OpenADFDemoFacesConfigTest.assertNotNull((Object)facesConfigFile);
        OpenADFDemoFacesConfigTest.assertTrue((String)"The facesconfig file doesn't exists.", (boolean)facesConfigFile.exists());
        FileEditorInput fileInput = new FileEditorInput(facesConfigFile);
        this.editor = (FacesConfigEditor)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().openEditor((IEditorInput)fileInput, "org.eclipse.jst.jsf.facesconfig.ui.FacesConfigEditor");
        OpenADFDemoFacesConfigTest.assertNotNull((Object)this.editor);
        this.editor.doPageLoad(60000L);
    }
}

