/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.pagedesigner.dnd.internal;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.ListViewer;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.IWizardNode;
import org.eclipse.jface.wizard.WizardSelectionPage;
import org.eclipse.jst.pagedesigner.dnd.FeedBackInfo;
import org.eclipse.jst.pagedesigner.dnd.ILocalDropHandler;
import org.eclipse.jst.pagedesigner.dnd.internal.Messages;
import org.eclipse.jst.pagedesigner.dom.IDOMPosition;
import org.eclipse.jst.pagedesigner.viewer.IHTMLGraphicalViewer;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.w3c.dom.Node;

public class SimpleWizardSelectionPage
extends WizardSelectionPage
implements ISelectionChangedListener {
    private Object _localData;
    private IHTMLGraphicalViewer _viewer;
    private boolean _updateWidget;
    private Node _widget;
    private IDOMPosition _position;
    private Map _objToWizardNodeOrHandler = new HashMap();
    private Map _feedbackToHandlers;
    private Object _currentHandler = null;

    public SimpleWizardSelectionPage(IHTMLGraphicalViewer viewer, Object localData, Map handlers) {
        super(Messages.getString("SimpleWizardSelectionPage.PageName"));
        this.setTitle(Messages.getString("SimpleWizardSelectionPage.Title"));
        this.setDescription(Messages.getString("SimpleWizardSelectionPage.Description"));
        this.setMessage(Messages.getString("SimpleWizardSelectionPage.Message"));
        this._viewer = viewer;
        this._localData = localData;
        this._feedbackToHandlers = handlers;
    }

    public void createControl(Composite parent) {
        Composite container = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.verticalSpacing = 10;
        container.setLayout((Layout)layout);
        container.setLayoutData((Object)new GridData(1808));
        Label label = new Label(container, 0);
        label.setText(Messages.getString("SimpleWizardSelectionPage.Operation"));
        GridData gd = new GridData();
        label.setLayoutData((Object)gd);
        final ListViewer listViewer = new ListViewer(container);
        listViewer.getControl().setLayoutData((Object)new GridData(1808));
        listViewer.setContentProvider((IContentProvider)new IStructuredContentProvider(){

            public Object[] getElements(Object inputElement) {
                return ((List)inputElement).toArray();
            }

            public void dispose() {
            }

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            }
        });
        listViewer.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

            public String getText(Object element) {
                return SimpleWizardSelectionPage.this.getText(element);
            }
        });
        listViewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                SimpleWizardSelectionPage.this.selectionChanged(new SelectionChangedEvent((ISelectionProvider)listViewer, listViewer.getSelection()));
                SimpleWizardSelectionPage.this.advanceToNextPage();
            }
        });
        listViewer.setSorter(new ViewerSorter());
        listViewer.setInput((Object)this.getElements());
        listViewer.addSelectionChangedListener((ISelectionChangedListener)this);
        Dialog.applyDialogFont((Control)container);
        this.setControl((Control)container);
    }

    public void selectionChanged(SelectionChangedEvent event) {
        Object obj;
        ISelection sel = event.getSelection();
        if (sel instanceof IStructuredSelection && (obj = ((IStructuredSelection)sel).getFirstElement()) != null) {
            this._currentHandler = this._objToWizardNodeOrHandler.get(obj);
            if (this._currentHandler == null) {
                this._currentHandler = this.getWizardNodeOrHandler(obj);
                this._objToWizardNodeOrHandler.put(obj, this._currentHandler);
            }
            if (this._currentHandler instanceof IWizardNode) {
                this.setSelectedNode((IWizardNode)this._currentHandler);
            } else {
                this.getWizard().getContainer().updateButtons();
            }
        }
    }

    private Object getWizardNodeOrHandler(Object obj) {
        final ILocalDropHandler dropHandler = (ILocalDropHandler)this._feedbackToHandlers.get(obj);
        if (dropHandler.useWizard(this._localData, this._viewer)) {
            return new IWizardNode(){
                IWizard _wizard = null;

                public void dispose() {
                }

                public Point getExtent() {
                    return null;
                }

                public IWizard getWizard() {
                    if (this._wizard == null) {
                        this._wizard = SimpleWizardSelectionPage.this._updateWidget ? dropHandler.getWizard(SimpleWizardSelectionPage.this._localData, SimpleWizardSelectionPage.this._widget, SimpleWizardSelectionPage.this._viewer) : dropHandler.getWizard(SimpleWizardSelectionPage.this._localData, SimpleWizardSelectionPage.this._position, SimpleWizardSelectionPage.this._viewer);
                    }
                    return this._wizard;
                }

                public boolean isContentCreated() {
                    return this._wizard != null;
                }
            };
        }
        return dropHandler;
    }

    public void advanceToNextPage() {
        this.getContainer().showPage(this.getNextPage());
    }

    protected String getText(Object element) {
        return ((FeedBackInfo)element).getDescription();
    }

    protected List getElements() {
        return new ArrayList(this._feedbackToHandlers.keySet());
    }

    public void setWidget(Node widget) {
        this._updateWidget = true;
        this._widget = widget;
    }

    public void setPosition(IDOMPosition position) {
        this._updateWidget = false;
        this._position = position;
    }

    public Object getCurrentHandler() {
        return this._currentHandler;
    }

    public boolean canFlipToNextPage() {
        return this.getCurrentHandler() instanceof IWizardNode && super.canFlipToNextPage();
    }
}

